/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.common.BotEntityUtils;
import com.kingdee.bos.bot.engine.sql.BotSqlBuilder;
import com.kingdee.bos.bot.engine.sql.JoinTableInfo;
import com.kingdee.bos.bot.engine.sql.SQLTableAliasManager;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLSrcTableManager {
    private Context ctx = null;
    private Map joinMap = new HashMap();
    private Map entityPathMap = new HashMap();
    private Map aliasMap = new HashMap();
    private Map entitysMap = new HashMap();
    private Map processedSrcFieldMap = new HashMap();
    private EntityObjectInfo mainEntity = null;
    private SQLTableAliasManager aliasManager = new SQLTableAliasManager();
    private String mainTableName = "";

    public SQLSrcTableManager(Context ctx, EntityObjectInfo mainEntity) {
        this.ctx = ctx;
        this.initMainTable(mainEntity);
    }

    protected void initMainTable(EntityObjectInfo mainEntity) {
        this.mainEntity = mainEntity;
        this.mainTableName = mainEntity.getTable().getName();
        String mainEntityName = "__src";
        String mainAlias = this.aliasManager.getNewAlias();
        this.aliasMap.put(mainEntityName, mainAlias);
        this.entitysMap.put(mainAlias, mainEntity);
        this.entityPathMap.put(mainAlias, mainEntityName);
        this.addNewJoinTableInfo(mainAlias, null, null);
    }

    public String processJoinTable(EntityObjectInfo parentEntity, EntityObjectInfo subEntity, LinkPropertyInfo parentLinkProp, String entityPath, boolean isEntry) throws BOSException {
        String parentTableName = parentEntity.getTable().getName();
        String subTableName = subEntity.getTable().getName();
        String parentTableAlias = (String)this.aliasMap.get(entityPath);
        if (StringUtils.isEmpty((String)parentTableAlias)) {
            throw new BOSException("Join table <" + subTableName + "> error!  ParentTable <" + parentTableName + "> isn't exist!   entityPath=" + entityPath);
        }
        List tableList = (List)this.joinMap.get(parentTableAlias);
        if (tableList == null) {
            throw new BOSException("Join table <" + subTableName + "> error!  ParentTable <" + parentTableName + "> isn't exist!");
        }
        for (int i = 0; i < tableList.size(); ++i) {
            JoinTableInfo tableInfo = (JoinTableInfo)tableList.get(i);
            if (!parentTableName.equalsIgnoreCase(tableInfo.getParentTableName()) || !subTableName.equalsIgnoreCase(tableInfo.getSubTableName())) continue;
            return tableInfo.getSubTableAlias();
        }
        String subTableAlias = this.aliasManager.getNewAlias();
        RelationshipInfo parentRelation = parentLinkProp.getRelationship();
        JoinTableInfo joinTable = new JoinTableInfo();
        if (isEntry) {
            LinkPropertyInfo subLinkProp = this.getLinkPropByRelationShipInfo(subEntity, parentRelation);
            RelationshipInfo subRelation = subLinkProp.getRelationship();
            if (!parentRelation.equals((Object)subRelation)) {
                throw new BOSException("Join table <" + subTableName + "> error!  relation=" + parentRelation + ", subRelation=" + subRelation + "!");
            }
            joinTable.setParentTableName(parentTableName);
            joinTable.setSubTableName(subTableName);
            joinTable.setParentTableAlias(parentTableAlias);
            joinTable.setSubTableAlias(subTableAlias);
            joinTable.setParentTableField(parentRelation.getClientProperty().getMappingField().getName());
            joinTable.setSubTableField(parentRelation.getSupplierProperty().getMappingField().getName());
            joinTable.setJoinType(JoinType.INNERJOIN.toString());
        } else {
            joinTable.setParentTableName(parentTableName);
            joinTable.setSubTableName(subTableName);
            joinTable.setParentTableAlias(parentTableAlias);
            joinTable.setSubTableAlias(subTableAlias);
            joinTable.setParentTableField(parentLinkProp.getMappingField().getName());
            joinTable.setSubTableField(subEntity.getPropertyByNameRuntime("id").getMappingField().getName());
            joinTable.setJoinType(JoinType.LEFTJOIN.toString());
        }
        this.aliasMap.put(entityPath + "." + parentLinkProp.getName(), subTableAlias);
        this.entityPathMap.put(subTableAlias, entityPath + "." + parentLinkProp.getName());
        this.entitysMap.put(subTableAlias, subEntity);
        this.addNewJoinTableInfo(parentTableAlias, subTableAlias, joinTable);
        return subTableAlias;
    }

    public EntityObjectInfo getMainEntity() {
        return this.mainEntity;
    }

    public String getMainTableName() {
        return this.mainTableName;
    }

    protected void addNewJoinTableInfo(String parentTableAlias, String subTableAlias, JoinTableInfo joinTable) {
        ArrayList subTableList;
        if (StringUtils.isEmpty((String)parentTableAlias)) {
            return;
        }
        ArrayList<JoinTableInfo> tableList = (ArrayList<JoinTableInfo>)this.joinMap.get(parentTableAlias);
        if (tableList == null) {
            tableList = new ArrayList<JoinTableInfo>();
            this.joinMap.put(parentTableAlias, tableList);
        }
        if (joinTable != null) {
            tableList.add(joinTable);
        }
        if (subTableAlias != null && (subTableList = (ArrayList)this.joinMap.get(subTableAlias)) == null) {
            subTableList = new ArrayList();
            this.joinMap.put(subTableAlias, subTableList);
        }
    }

    protected LinkPropertyInfo getLinkPropByRelationShipInfo(EntityObjectInfo entity, RelationshipInfo relation) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (int i = 0; i < props.size(); ++i) {
            RelationshipInfo tempRelation;
            PropertyInfo prop = props.get(i);
            if (!(prop instanceof LinkPropertyInfo) || !(tempRelation = ((LinkPropertyInfo)prop).getRelationship()).equals((Object)relation)) continue;
            return (LinkPropertyInfo)prop;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(" FROM ").append(this.mainTableName).append(" T0 ");
        this.innerOutput(sb, "T0");
        return sb.toString();
    }

    protected void innerOutput(StringBuffer sb, String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        List subTableList = (List)this.joinMap.get(tableName);
        if (subTableList == null || subTableList.size() <= 0) {
            return;
        }
        for (int i = 0; i < subTableList.size(); ++i) {
            JoinTableInfo subTableInfo = (JoinTableInfo)subTableList.get(i);
            sb.append(" ").append(subTableInfo.getJoinType());
            sb.append(" ").append(subTableInfo.getSubTableName());
            sb.append(" ").append(subTableInfo.getSubTableAlias());
            sb.append(" ON ");
            sb.append(subTableInfo.getParentTableAlias()).append(".").append(subTableInfo.getParentTableField());
            sb.append(" = ");
            sb.append(subTableInfo.getSubTableAlias()).append(".").append(subTableInfo.getSubTableField());
            this.innerOutput(sb, subTableInfo.getSubTableAlias());
        }
    }

    public String getColumnNameByPropName(String tableAlias, String propName) throws BOSException {
        String name = "";
        if (!StringUtils.isEmpty((String)tableAlias) && !StringUtils.isEmpty((String)propName)) {
            EntityObjectInfo entity = (EntityObjectInfo)this.entitysMap.get(tableAlias);
            String columnName = BotEntityUtils.getColumnNameByOwnerPropName(this.ctx, entity, propName);
            name = tableAlias + "." + columnName;
        }
        return name;
    }

    public String getColumnNameByFullPropName(String fullPropName) throws BOSException {
        if (StringUtils.isEmpty((String)fullPropName)) {
            return null;
        }
        int index = fullPropName.lastIndexOf(".");
        if (index <= 0) {
            return null;
        }
        String entityPath = fullPropName.substring(0, index);
        String propName = fullPropName.substring(index + 1);
        String tableAlias = this.getTableAliasByEntityPath(entityPath);
        String columnName = this.getColumnNameByPropName(tableAlias, propName);
        return columnName;
    }

    public String getTableAliasByEntityPath(String entityPath) throws BOSException {
        String alias = "";
        if (!StringUtils.isEmpty((String)entityPath)) {
            alias = (String)this.aliasMap.get(entityPath);
        }
        if (alias == null) {
            this.dynAddRefEntityObject(entityPath);
            alias = (String)this.aliasMap.get(entityPath);
        }
        return alias;
    }

    public String getMainTableAlias() throws BOSException {
        return (String)this.aliasMap.get("__src");
    }

    public String getEntryTableAlias(String entrysPath) throws BOSException {
        return (String)this.aliasMap.get(entrysPath);
    }

    public void setResult(String srcPropertyName, String value) {
        this.processedSrcFieldMap.put(srcPropertyName, value);
    }

    public String getColumnNameFromCache(String srcPropertyName) {
        return (String)this.processedSrcFieldMap.get(srcPropertyName);
    }

    private void dynAddRefEntityObject(String entityPath) throws BOSException {
        String[] names;
        if (StringUtils.isEmpty((String)entityPath)) {
            return;
        }
        if (!entityPath.startsWith("__src")) {
            entityPath = "__src." + entityPath;
        }
        if ((names = StringUtils.split((String)entityPath, (String)".")).length < 2) {
            return;
        }
        int max = names.length;
        StringBuffer parentPathBuff = new StringBuffer();
        for (int i = 0; i < max - 1; ++i) {
            PropertyInfo prop;
            String parentName = names[i];
            String subName = names[i + 1];
            if (i > 0) {
                parentPathBuff.append(".");
            }
            parentPathBuff.append(parentName);
            String parentAlias = (String)this.aliasMap.get(parentName);
            if (StringUtils.isEmpty((String)parentAlias)) {
                return;
            }
            EntityObjectInfo parentEntity = (EntityObjectInfo)this.entitysMap.get(parentAlias);
            if (parentEntity == null) {
                return;
            }
            String subAlias = (String)this.aliasMap.get(subName);
            if (!StringUtils.isEmpty((String)subAlias)) {
                return;
            }
            EntityObjectInfo subEntity = (EntityObjectInfo)this.entitysMap.get(subAlias);
            if (subEntity != null || (prop = (PropertyInfo)parentEntity.getInheritedPropertiesRuntime().getObject((Object)subName)) == null || !(prop instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkProp = (LinkPropertyInfo)prop;
            RelationshipInfo relationShip = linkProp.getRelationship();
            EntityObjectInfo clientObj = relationShip.getClientObject();
            EntityObjectInfo supplierObj = relationShip.getSupplierObject();
            boolean isEntry = BotSqlBuilder.checkIsEntryLink(linkProp, parentEntity);
            String string = this.processJoinTable(parentEntity, supplierObj, linkProp, parentPathBuff.toString(), isEntry);
        }
    }
}

