/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.AbstractBOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTAggregateCollection;
import com.kingdee.bos.metadata.bot.BOTAggregateInfo;
import com.kingdee.bos.metadata.bot.BOTDelRevRuleInfo;
import com.kingdee.bos.metadata.bot.BOTDelRevRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTExtMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMergeCharsCollection;
import com.kingdee.bos.metadata.bot.BOTMergeCharsInfo;
import com.kingdee.bos.metadata.bot.BOTRevRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRevRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.I18nTransform;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.dom4j.DocumentException;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BOTMappingInfo
extends AbstractBOTMappingInfo
implements Serializable {
    public static final String ISFORMAPPING = "isForMapping";
    public static final String ISBOTPMUSTINPUT = "isBOTPMustInput";
    public static final String ISFORGROUPING = "isForGrouping";
    public static final String ISFORWRITTENBACK = "isForWrittenBack";
    public static final int SHOW_NONE = 0;
    public static final int SHOW_EDITDUI = 1;
    public static final int SHOW_LISTUI = 2;
    public static final int SUBMIT = 0;
    public static final int TEMPSAVE = 1;
    public static final int NOTSAVE = 2;
    private static final String[] fieldArray = new String[]{"id", "name", "alias", "description", "srcEntityName", "destEntityName", "defineSys", "srcEntityAlias", "destEntityAlias", "srcEntityFullName", "destEntityFullName", "isTempSave", "isShowEditUI", "extConfig", "mappingType", "UIDisable", "preMerge"};
    private static final Comparator botRuleInfoComparator = new BOTRuleInfoComparator();
    private static final String[] i18nProp = new String[]{"alias", "description", "srcEntityAlias", "destEntityAlias"};
    private BotpExtConfigHelper.ExtConfigInfo extConfigInfo = null;

    public BOTMappingInfo() {
    }

    protected BOTMappingInfo(String pkField) {
        super(pkField);
    }

    public EntityObjectInfo getSrcEntity() {
        return (EntityObjectInfo)this.get("srcEntity");
    }

    public void setSrcEntity(EntityObjectInfo srcEntity) {
        this.put("srcEntity", srcEntity);
    }

    public EntityObjectInfo getDestEntity() {
        return (EntityObjectInfo)this.get("destEntity");
    }

    public void setDestEntity(EntityObjectInfo destEntity) {
        this.put("destEntity", destEntity);
    }

    public String getPackage() {
        return "";
    }

    private void setAttribute(Element root) {
        for (int i = 0; i < fieldArray.length; ++i) {
            String attributeName = fieldArray[i];
            String attributeValue = root.getAttributeValue(attributeName);
            if (attributeValue == null || attributeValue.length() <= 0) continue;
            if (attributeName.equalsIgnoreCase("id")) {
                this.setId(BOSUuid.read((String)attributeValue));
                continue;
            }
            if (attributeName.startsWith("is")) {
                Boolean boolValue = Boolean.valueOf(attributeValue);
                this.put(attributeName, boolValue);
                continue;
            }
            this.put(attributeName, attributeValue);
        }
    }

    public Element toElement() {
        BOTExtMappingInfo extMappingInfo;
        BOTDelRevRuleInfo delRevRule;
        Element element = new Element("BOTMappingInfo");
        for (int i = 0; i < fieldArray.length; ++i) {
            Object obj = this.get(fieldArray[i]);
            if ((fieldArray[i].equals("UIDisable") || fieldArray[i].equals("preMerge")) && obj != null) {
                if (obj.toString().equals("true")) {
                    obj = new Integer(1);
                } else if (obj.toString().equals("false")) {
                    obj = new Integer(0);
                }
            }
            if (obj == null) continue;
            element.setAttribute(fieldArray[i], obj.toString());
        }
        I18nTransform.toElement(element, (IObjectValue)this, i18nProp);
        Element rulesElem = new Element("rules");
        element.addContent((Content)rulesElem);
        BOTRuleCollection rules = this.getRules();
        int size = rules.size();
        for (int i = 0; i < size; ++i) {
            rulesElem.addContent((Content)rules.get(i).toElement());
        }
        BOTRevRuleInfo revRule = this.getRevRule();
        if (revRule != null) {
            element.addContent((Content)revRule.toElement());
        }
        if ((delRevRule = this.getDelRevRule()) != null) {
            element.addContent((Content)delRevRule.toElement());
        }
        if ((extMappingInfo = this.getExtRule()) != null) {
            element.addContent((Content)extMappingInfo.toElement());
        }
        Element aggregateElement = new Element("aggregates");
        element.addContent((Content)aggregateElement);
        BOTAggregateCollection aggregateCols = this.getAggregateCollection();
        int count = aggregateCols.size();
        for (int i = 0; i < count; ++i) {
            aggregateElement.addContent((Content)aggregateCols.get(i).toElement());
        }
        Element mergeCharsElement = new Element("mergeChars");
        element.addContent((Content)mergeCharsElement);
        BOTMergeCharsCollection mergeCharsCols = this.getMergeCharsCollection();
        int count2 = mergeCharsCols.size();
        for (int i = 0; i < count2; ++i) {
            mergeCharsElement.addContent((Content)mergeCharsCols.get(i).toElement());
        }
        Element cuElement = new Element("controlunit");
        if (this.getCU() != null && this.getCU().getId() != null) {
            cuElement.setAttribute("id", this.getCU().getId().toString());
        }
        element.addContent((Content)cuElement);
        return element;
    }

    public String toXml() {
        Element processElement = this.toElement();
        if (processElement != null) {
            Document XMLDoc = new Document(processElement);
            Format format = Format.getRawFormat();
            format.setIndent(format.getLineSeparator() + "\t  ");
            XMLOutputter xml = new XMLOutputter(format);
            return xml.outputString(XMLDoc);
        }
        return "";
    }

    public static BOTMappingInfo readFromXml(Element element) {
        AbstractObjectValue delRule;
        int i;
        BOTMappingInfo mappingInfo = new BOTMappingInfo();
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            String key = fieldArray[i2];
            String attr = element.getAttributeValue(key);
            mappingInfo.put(key, attr);
        }
        I18nTransform.readFromElement(element, (IObjectValue)mappingInfo, i18nProp);
        Element rulesElem = element.getChild("rules");
        List list = rulesElem.getChildren();
        int size = list.size();
        for (i = 0; i < size; ++i) {
            Element subElem = (Element)list.get(i);
            BOTRuleInfo rule = BOTRuleInfo.readFromXml(subElem);
            rule.setMapping(mappingInfo);
            mappingInfo.getRules().add(rule);
        }
        Element ruleElem = element.getChild("BOTRevRuleInfo");
        if (ruleElem != null) {
            BOTRevRuleInfo revRule = BOTRevRuleInfo.readFromXml(ruleElem);
            mappingInfo.setRevRule(revRule);
        }
        if ((ruleElem = element.getChild("BOTDelRevRuleInfo")) != null) {
            delRule = BOTDelRevRuleInfo.readFromXml(ruleElem);
            mappingInfo.setDelRevRule((BOTDelRevRuleInfo)delRule);
        }
        if ((ruleElem = element.getChild("BOTExtMappingInfo")) != null) {
            delRule = BOTExtMappingInfo.readFromXml(ruleElem);
            mappingInfo.setExtRule((BOTExtMappingInfo)delRule);
        }
        Element aggregatesElement = element.getChild("aggregates");
        List aggregateCols = aggregatesElement.getChildren();
        int count = aggregateCols.size();
        for (i = 0; i < count; ++i) {
            Element aggregateInfoElement = (Element)aggregateCols.get(i);
            BOTAggregateInfo aggregateInfo = BOTAggregateInfo.readFromXml(aggregateInfoElement);
            aggregateInfo.setMapping(mappingInfo);
            mappingInfo.getAggregateCollection().add(aggregateInfo);
        }
        Element mergeCharsElement = element.getChild("mergeChars");
        if (mergeCharsElement != null) {
            List mergeCharsCols = mergeCharsElement.getChildren();
            count = mergeCharsCols.size();
            for (i = 0; i < count; ++i) {
                Element mergeCharsInfoElement = (Element)mergeCharsCols.get(i);
                BOTMergeCharsInfo mergeCharsInfo = BOTMergeCharsInfo.readFromXml(mergeCharsInfoElement);
                mergeCharsInfo.setMergeMapping(mappingInfo);
                mappingInfo.getMergeCharsCollection().add(mergeCharsInfo);
            }
        }
        Element cuElement = element.getChild("controlunit");
        CtrlUnitInfo cu = new CtrlUnitInfo();
        String id = cuElement.getAttributeValue("id");
        if (id != null && id.length() > 0) {
            cu.setId(BOSUuid.read((String)id));
        }
        mappingInfo.setCU(cu);
        BOTMappingInfo.checkMappingDefaultValue(mappingInfo);
        return mappingInfo;
    }

    public static void checkMappingDefaultValue(BOTMappingInfo mappingInfo) {
        BOTMappingInfo.setDefault(mappingInfo, "mappingType", "0");
        BOTMappingInfo.setDefault(mappingInfo, "uidisable", "0");
        BOTMappingInfo.setDefault(mappingInfo, "preMerge", "0");
        String[] keys = new String[]{"uidisable", "preMerge"};
        for (int i = 0; i < keys.length; ++i) {
            String value = (String)mappingInfo.get(keys[i]);
            if ("false".equalsIgnoreCase(value)) {
                mappingInfo.put(keys[i], "0");
                continue;
            }
            if (!"true".equalsIgnoreCase(value)) continue;
            mappingInfo.put(keys[i], "1");
        }
    }

    protected static void setDefault(BOTMappingInfo mappingInfo, String key, Object defaultValue) {
        Object value = mappingInfo.get(key);
        if (value == null || value instanceof String && value.equals("")) {
            mappingInfo.put(key, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOTMappingInfo readFromFile(String fileName) throws JDOMException, IOException {
        try (InputStream fileIn = null;){
            StringBuffer refinedFileName = new StringBuffer(fileName);
            fileIn = new FileInputStream(refinedFileName.toString());
            SAXBuilder builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(false);
            Document doc = builder.build(fileIn);
            Element root = doc.getRootElement();
            List botMappingElement = root.getChildren("BOTMappingInfo");
            Element firstChild = null;
            if (botMappingElement != null && botMappingElement.size() > 0) {
                firstChild = (Element)botMappingElement.get(0);
            }
            BOTMappingInfo botMappingInfo = null;
            if (firstChild != null) {
                botMappingInfo = BOTMappingInfo.readFromXml(firstChild);
            }
            BOTMappingInfo bOTMappingInfo = botMappingInfo;
            return bOTMappingInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOTMappingCollection readBOTMappingColsFromFile(String fileName) throws JDOMException, IOException {
        try (InputStream fileIn = null;){
            BOTMappingCollection botMappingCols = new BOTMappingCollection();
            StringBuffer refinedFileName = new StringBuffer(fileName);
            fileIn = new FileInputStream(refinedFileName.toString());
            SAXBuilder builder = new SAXBuilder();
            builder.setIgnoringElementContentWhitespace(false);
            Document doc = builder.build(fileIn);
            Element root = doc.getRootElement();
            List botMappingElement = root.getChildren("BOTMappingInfo");
            if (botMappingElement != null) {
                int count = botMappingElement.size();
                for (int i = 0; i < count; ++i) {
                    Element child = (Element)botMappingElement.get(i);
                    BOTMappingInfo botMappingInfo = BOTMappingInfo.readFromXml(child);
                    botMappingCols.add(botMappingInfo);
                }
            }
            BOTMappingCollection bOTMappingCollection = botMappingCols;
            return bOTMappingCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BOTMappingCollection readBOTMappingColsFromFile(File[] files) throws JDOMException, IOException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        File file = null;
        Document doc = null;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            Element root;
            List botMappingElement;
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder.setIgnoringElementContentWhitespace(false);
            file = files[i];
            String sFileName = file.getAbsolutePath();
            String fileType = sFileName.substring(sFileName.length() - 3, sFileName.length());
            if (fileType.equalsIgnoreCase("jar")) {
                try (ZipFile jarFile = null;){
                    jarFile = new JarFile(file);
                    Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().startsWith(file.getName().substring(0, file.getName().lastIndexOf(".")))) continue;
                        doc = builder.build(((JarFile)jarFile).getInputStream(entry));
                    }
                }
            } else {
                doc = builder.build(file);
            }
            if ((botMappingElement = (root = doc.getRootElement()).getChildren("BOTMappingInfo")) == null) continue;
            int count = botMappingElement.size();
            for (int j = 0; j < count; ++j) {
                Element child = (Element)botMappingElement.get(j);
                BOTMappingInfo botMappingInfo = BOTMappingInfo.readFromXml(child);
                botMappingCols.add(botMappingInfo);
            }
        }
        return botMappingCols;
    }

    private static void resetRevRule(BOTMappingInfo botMappingInfo) {
        BOTDelRevRuleInfo botDelRevRuleInfo;
        BOTExtMappingInfo botExtMappingInfo = botMappingInfo.getExtRule();
        botExtMappingInfo.remove("id");
        BOTRevRuleInfo botRevRuleInfo = botMappingInfo.getRevRule();
        if (botRevRuleInfo == null) {
            botRevRuleInfo = new BOTRevRuleInfo();
            botMappingInfo.setRevRule(botRevRuleInfo);
        }
        botRevRuleInfo.remove("id");
        BOTRevRuleSegmentCollection botRevRuleSegCols = botRevRuleInfo.getRevRuleSegments();
        if (botRevRuleSegCols != null) {
            int count = botRevRuleSegCols.size();
            for (int i = 0; i < count; ++i) {
                botRevRuleSegCols.get(i).remove("id");
            }
        }
        if ((botDelRevRuleInfo = botMappingInfo.getDelRevRule()) == null) {
            botDelRevRuleInfo = new BOTDelRevRuleInfo();
            botMappingInfo.setDelRevRule(botDelRevRuleInfo);
        }
        botDelRevRuleInfo.remove("id");
        BOTDelRevRuleSegmentCollection botDelRevRuleSegCols = botDelRevRuleInfo.getDelRevRuleSegments();
        if (botDelRevRuleSegCols != null) {
            int count = botDelRevRuleSegCols.size();
            for (int i = 0; i < count; ++i) {
                botDelRevRuleSegCols.get(i).remove("id");
            }
        }
    }

    public void writerToFile(String fileName) throws IOException {
        if (fileName.endsWith(".jar")) {
            String fileNamexml = fileName.substring(0, fileName.lastIndexOf(".")) + ".xml";
            StringBuffer refinedFileName = new StringBuffer(fileNamexml);
            FileOutputStream fileOut = new FileOutputStream(refinedFileName.toString());
            XMLOutputter xmlOut = new XMLOutputter();
            Element root = new Element("BOTMappingInfos");
            Element child = this.toElement();
            root.addContent((Content)child);
            Document doc = new Document();
            doc.setRootElement(root);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setLineSeparator("\r\n");
            format.setEncoding("UTF-8");
            format.setTextMode(Format.TextMode.PRESERVE);
            xmlOut.setFormat(format);
            xmlOut.output(doc, (OutputStream)fileOut);
            ((OutputStream)fileOut).close();
            File file = new File(fileNamexml);
            File[] files = new File[]{file};
            BOTMappingInfo.makeFilesToZip(files, file.getParent() + File.separatorChar, fileName, 7);
            file.delete();
        } else {
            StringBuffer refinedFileName = new StringBuffer(fileName);
            FileOutputStream fileOut = new FileOutputStream(refinedFileName.toString());
            XMLOutputter xmlOut = new XMLOutputter();
            Element root = new Element("BOTMappingInfos");
            Element child = this.toElement();
            root.addContent((Content)child);
            Document doc = new Document();
            doc.setRootElement(root);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.PRESERVE);
            format.setLineSeparator("\r\n");
            format.setEncoding("UTF-8");
            xmlOut.setFormat(format);
            xmlOut.output(doc, (OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
    }

    public static void writerBOTMappingInfoToFile(BOTMappingInfo botMappingInfo, String fileName) throws IOException {
        botMappingInfo.writerToFile(fileName);
    }

    public static void writerBOTMappingCollectionToFile(BOTMappingCollection botMappingCols, String fileName) throws IOException {
        if (fileName.endsWith(".jar")) {
            String fileNamexml = fileName.substring(0, fileName.lastIndexOf(".")) + ".xml";
            StringBuffer refinedFileName = new StringBuffer(fileNamexml);
            FileOutputStream fileOut = new FileOutputStream(refinedFileName.toString());
            XMLOutputter xmlOut = new XMLOutputter();
            Element root = new Element("BOTMappingInfos");
            int count = botMappingCols.size();
            for (int i = 0; i < count; ++i) {
                BOTMappingInfo botMappingInfo = botMappingCols.get(i);
                Element child = botMappingInfo.toElement();
                root.addContent((Content)child);
            }
            Document doc = new Document();
            doc.setRootElement(root);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.PRESERVE);
            format.setLineSeparator("\r\n");
            format.setEncoding("UTF-8");
            xmlOut.setFormat(format);
            xmlOut.output(doc, (OutputStream)fileOut);
            ((OutputStream)fileOut).close();
            File file = new File(fileNamexml);
            File[] files = new File[]{file};
            String sBasePath = file.getParent();
            if (!file.getParent().endsWith("\\")) {
                sBasePath = sBasePath + File.separatorChar;
            }
            BOTMappingInfo.makeFilesToZip(files, sBasePath, fileName, 7);
            file.delete();
        } else {
            StringBuffer refinedFileName = new StringBuffer(fileName);
            FileOutputStream fileOut = new FileOutputStream(refinedFileName.toString());
            XMLOutputter xmlOut = new XMLOutputter();
            Element root = new Element("BOTMappingInfos");
            int count = botMappingCols.size();
            for (int i = 0; i < count; ++i) {
                BOTMappingInfo botMappingInfo = botMappingCols.get(i);
                Element child = botMappingInfo.toElement();
                root.addContent((Content)child);
            }
            Document doc = new Document();
            doc.setRootElement(root);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.PRESERVE);
            format.setLineSeparator("\r\n");
            format.setEncoding("UTF-8");
            xmlOut.setFormat(format);
            xmlOut.output(doc, (OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
    }

    public static void appendInfoToXml(BOTMappingCollection botMappingCols, String fileName) throws IOException {
        Document document;
        File xmlFile = new File(fileName);
        SAXBuilder builder = new SAXBuilder();
        try {
            document = builder.build(xmlFile);
        }
        catch (Exception e) {
            Element root = new Element("BOTMappingInfos");
            document = new Document();
            document.setRootElement(root);
        }
        Element rootElement = document.getRootElement();
        int count = botMappingCols.size();
        for (int i = 0; i < count; ++i) {
            BOTMappingInfo botMappingInfo = botMappingCols.get(i);
            Element child = botMappingInfo.toElement();
            rootElement.addContent((Content)child);
        }
        XMLOutputter outputter = new XMLOutputter();
        FileOutputStream fileOutputStream = new FileOutputStream(xmlFile);
        outputter.output(document, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    public static void writerBOTMappingCollectionToFile(List botMappingColsList, String fileName) throws IOException {
        BOTMappingCollection botMappingCols = new BOTMappingCollection();
        int count = botMappingColsList.size();
        for (int i = 0; i < count; ++i) {
            BOTMappingCollection current = (BOTMappingCollection)((Object)botMappingColsList.get(i));
            botMappingCols.addCollection(current);
        }
        BOTMappingInfo.writerBOTMappingCollectionToFile(botMappingCols, fileName);
    }

    public List getBillPropertiesCannotModify() {
        ArrayList<String> propertiesList = new ArrayList<String>();
        BOTRuleCollection botRuleCols = super.getRules();
        int count = botRuleCols.size();
        for (int i = 0; i < count; ++i) {
            BOTRuleSegmentCollection botRuleSegCols = botRuleCols.get(i).getRuleSegments();
            int size = botRuleSegCols.size();
            for (int j = 0; j < size; ++j) {
                BOTRuleSegmentInfo botRuleSegmentInfo = botRuleSegCols.get(j);
                if (botRuleSegmentInfo.isCanModify() || propertiesList.contains(botRuleSegmentInfo.getDestPropertyName())) continue;
                propertiesList.add(botRuleSegmentInfo.getDestPropertyName());
            }
        }
        return propertiesList;
    }

    public List getBillSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        Pattern pattern = Pattern.compile("__src\\.([\\w\\.]+)");
        BOTRuleCollection botRules = (BOTRuleCollection)((Object)this.get("rules"));
        if (botRules != null) {
            int size = botRules.size();
            for (int i = 0; i < size; ++i) {
                BOTRuleSegmentCollection botRuleSegCols = botRules.get(i).getRuleSegments();
                if (botRuleSegCols == null) continue;
                int count = botRuleSegCols.size();
                for (int j = 0; j < count; ++j) {
                    BOTRuleSegmentInfo botRuleSegInfo = botRuleSegCols.get(j);
                    String expression = botRuleSegInfo.getSrcPropertyName();
                    if (expression == null || expression.trim().length() == 0) {
                        expression = botRuleSegInfo.getExpression();
                        if (expression == null || expression.trim().length() <= 0) continue;
                        Matcher match = pattern.matcher(expression);
                        while (match.find()) {
                            int kc = match.groupCount();
                            for (int k = 1; k <= kc; ++k) {
                                String prop = match.group(k);
                                if (sic.contains(prop)) continue;
                                sic.add(prop);
                            }
                        }
                        continue;
                    }
                    String prop = expression.startsWith("__src.") ? expression.substring(6) : expression;
                    if (sic.contains(prop)) continue;
                    sic.add(prop);
                }
            }
        }
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recurseFiles(JarOutputStream jos, File file, String basePath) throws IOException, FileNotFoundException {
        JarEntry jarEntry = null;
        FileInputStream fin = null;
        BufferedInputStream in = null;
        try {
            if (file.getAbsolutePath().indexOf(basePath) != -1) {
                int len;
                String parentPath = file.getParent();
                if (basePath.endsWith(Character.toString(File.separatorChar))) {
                    parentPath = parentPath + File.separatorChar;
                }
                String curPath = parentPath.substring(basePath.length());
                jarEntry = new JarEntry(curPath + file.getName());
                fin = new FileInputStream(file);
                in = new BufferedInputStream(fin);
                jos.putNextEntry(jarEntry);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) >= 0) {
                    jos.write(buf, 0, len);
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                jos.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeFilesToZip(File[] files, String basePath, String zipFileName, int level) throws IOException, FileNotFoundException {
        FileOutputStream zipFile = null;
        ZipOutputStream jos = null;
        try {
            level = BOTMappingInfo.checkZipLevel(level);
            zipFile = new FileOutputStream(zipFileName);
            jos = new JarOutputStream((OutputStream)zipFile, new Manifest());
            jos.setLevel(level);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    BOTMappingInfo.recurseFiles((JarOutputStream)jos, files[i], basePath);
                }
            }
        }
        finally {
            if (jos != null) {
                try {
                    jos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static int checkZipLevel(int level) {
        if (level < 0 || level > 9) {
            level = 7;
        }
        return level;
    }

    public BotpExtConfigHelper.ExtConfigInfo getExtConfigInfo() {
        if (this.extConfigInfo != null) {
            return this.extConfigInfo;
        }
        String extconfig = this.getExtConfig();
        if (extconfig != null && !extconfig.equals("")) {
            try {
                this.extConfigInfo = new BotpExtConfigHelper.XMLProcessor(new BotpExtConfigHelper()).marshallingExtConfig(extconfig);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
        return this.extConfigInfo;
    }

    static class BOTRuleInfoComparator
    implements Comparator {
        BOTRuleInfoComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.compare((BOTRuleInfo)o1, (BOTRuleInfo)o2);
        }

        public int compare(BOTRuleInfo botRule1, BOTRuleInfo botRule2) {
            if (botRule1 == null || botRule2 == null) {
                throw new IllegalArgumentException();
            }
            if (botRule1.getSeq() > botRule2.getSeq()) {
                return 1;
            }
            return -1;
        }
    }
}

