/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.kscript.IFunctionProvider;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.TypeUtils;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.DoStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.ForStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.dom.stmt.ReturnStmt;
import com.kingdee.bos.kscript.dom.stmt.WhileStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.kscript.runtime.CaseInSensitiveMap;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTAggregateDetailInfo;
import com.kingdee.bos.metadata.bot.BOTAggregatePropertyInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.BOTSQLFormater;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.bot.runtime.BotEngine;
import com.kingdee.bos.metadata.bot.runtime.BotEngineNew;
import com.kingdee.bos.metadata.bot.runtime.BotEngineNew2;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.util.Assert;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTTransform {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.bot.BOTTransform");
    private static final char pointChars = '.';
    private static final String noGrouping = "noGrouping";
    private Map objectGroupingInfoMap = null;
    private Map relationInfoMap = null;
    private BOTRelationCollection relationCollection = null;
    private IObjectCollection destObjectCollection = null;
    private BOTMappingInfo botMapping = null;
    private Map aggregateInfoMap = null;
    private final Context ctx;
    protected SolutionInfo solution;
    private List funcProviderList = new ArrayList();
    private Map idRelation;

    public BOTTransform(Context ctx) throws DataAccessException, IOException {
        this.ctx = ctx;
        this.solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
    }

    public void addFunctionProvider(IFunctionProvider funcProvider) throws KScriptException {
        this.funcProviderList.add(funcProvider);
    }

    public List getFunctionProviderList() {
        return this.funcProviderList;
    }

    public BOTRelationCollection getBOTRelationCollection() {
        return this.relationCollection;
    }

    public Map getIdRelation() {
        return this.idRelation;
    }

    public IObjectCollection businessObjectTransform(IObjectCollection sourceObjectCollection, BOTMappingInfo botMapping) throws Exception {
        boolean user_new_botengine = true;
        if (user_new_botengine) {
            BOTMappingCollection mappingCol = new BOTMappingCollection();
            mappingCol.add(botMapping);
            IObjectCollection destObjCol = this.businessObjectTransform(sourceObjectCollection, mappingCol);
            return destObjCol;
        }
        return this.oldBotEngineTransform(sourceObjectCollection);
    }

    public IObjectCollection businessObjectTransform(IObjectCollection sourceObjectCollection, BOTMappingCollection mappingCol) throws Exception {
        boolean user_new_botengine = true;
        if (user_new_botengine) {
            BotEngine botEngine = new BotEngine(this.ctx);
            for (int i = 0; i < this.funcProviderList.size(); ++i) {
                botEngine.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
            }
            BOTRelationCollection relationCol = new BOTRelationCollection();
            IObjectCollection destObjCol = botEngine.transform(sourceObjectCollection, relationCol, mappingCol);
            this.relationCollection = relationCol;
            return destObjCol;
        }
        return this.oldBotEngineTransform(sourceObjectCollection);
    }

    public IObjectCollection businessObjectTransform(List sourceObjectList, BOTMappingCollection mappingCol) throws Exception {
        IObjectCollection destObjCols;
        int i;
        boolean isUseOldBotEngine = false;
        LowTimer time = new LowTimer();
        int count = mappingCol.size();
        for (int i2 = 0; i2 < count; ++i2) {
            BOTMappingInfo botMappingInfo = mappingCol.get(i2);
            if (BOTMappingHelper.isMappingEnabled(botMappingInfo)) continue;
            throw new BTPException(BTPException.MAPPINGENABLEERROR, new Object[]{botMappingInfo.getName() + "(" + botMappingInfo.getAlias() + ")"});
        }
        if (mappingCol.size() == 0) {
            throw new BTPException(BTPException.NOMAPPING);
        }
        if (isUseOldBotEngine) {
            BotEngine botEngine = new BotEngine(this.ctx);
            for (i = 0; i < this.funcProviderList.size(); ++i) {
                botEngine.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
            }
            BOTRelationCollection relationCol = new BOTRelationCollection();
            destObjCols = botEngine.transform(sourceObjectList, relationCol, mappingCol);
            this.relationCollection = relationCol;
        } else if (BOTPTools.isEnableBOTEngineNew2(this.ctx)) {
            BotEngineNew2 botEngineNew = new BotEngineNew2(this.ctx);
            for (i = 0; i < this.funcProviderList.size(); ++i) {
                botEngineNew.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
            }
            destObjCols = botEngineNew.transform(sourceObjectList, mappingCol);
            this.relationCollection = botEngineNew.getBotRelationCols();
            this.idRelation = botEngineNew.getIdRelation();
        } else {
            BotEngineNew botEngineNew = new BotEngineNew(this.ctx);
            for (i = 0; i < this.funcProviderList.size(); ++i) {
                botEngineNew.addFunctionProvider((IFunctionProvider)this.funcProviderList.get(i));
            }
            destObjCols = botEngineNew.transform(sourceObjectList, mappingCol);
            this.relationCollection = botEngineNew.getBotRelationCols();
            this.idRelation = botEngineNew.getIdRelation();
        }
        long timeValue = time.msValue();
        return destObjCols;
    }

    private IObjectCollection oldBotEngineTransform(IObjectCollection sourceObjectCollection) throws InvalidDAOMetaDataException, Exception, FormaterException, ParserException, InterpreterException, com.kingdee.bos.kscript.ParserException {
        int i;
        if (!this.preCheckData(sourceObjectCollection, this.botMapping)) {
            return null;
        }
        this.destObjectCollection = Utils.newObjectCollectionInstance((EntityObjectInfo)this.botMapping.getDestEntity());
        this.relationCollection = new BOTRelationCollection();
        this.objectGroupingInfoMap = new HashMap();
        this.aggregateInfoMap = new HashMap();
        this.relationInfoMap = new HashMap();
        for (i = 0; i < sourceObjectCollection.size(); ++i) {
            this.transferObject(sourceObjectCollection.getObject(i), this.botMapping);
        }
        this.setAggregatePropertyFinalValue();
        this.destObjectCollection.updateIndex();
        for (i = this.relationCollection.size() - 1; i >= 0; --i) {
            String destObjIdStr = this.relationCollection.get(i).getDestObjectID();
            BOSUuid destObjId = BOSUuid.read((String)destObjIdStr);
            if (this.destObjectCollection.containsKey((Object)destObjId)) continue;
            this.relationCollection.removeObject(i);
        }
        return this.destObjectCollection;
    }

    private boolean preCheckData(IObjectCollection sourceDataCollection, BOTMappingInfo botMapping) {
        return true;
    }

    private void transferObject(IObjectValue srcObject, BOTMappingInfo botMapping) throws Exception {
        for (int i = 0; i < botMapping.getRules().size(); ++i) {
            this.transferObject("", srcObject, botMapping.getSrcEntity(), botMapping.getDestEntity(), "", botMapping.getRules().get(i));
        }
    }

    private void transferObject(String prefixName, IObjectValue srcObject, EntityObjectInfo srcEntity, EntityObjectInfo destEntity, String srcEntryID, BOTRuleInfo botRule) throws Exception {
        LinkPropertyInfo srcEntryProperty = this.getSrcEntryProperty(prefixName, srcEntity, botRule);
        if (srcEntryProperty == null) {
            this.transferDetailObject(srcObject, srcEntity, destEntity, prefixName, srcEntryID, botRule);
        } else {
            IObjectCollection srcEntryObjectCol = (IObjectCollection)srcObject.get((prefixName = prefixName == null ? "" : (prefixName.equals("") ? "" : prefixName + '.')) + srcEntryProperty.getName());
            if (srcEntryObjectCol.size() == 0) {
                this.transferDetailObject(srcObject, srcEntity, destEntity, prefixName + srcEntryProperty.getName(), srcEntryID, botRule);
            } else {
                IObjectValue original_srcObject = srcObject;
                for (int i = 0; i < srcEntryObjectCol.size(); ++i) {
                    String newEntryPKField;
                    IObjectValue srcEntryObject;
                    srcObject = BotUtil.cloneObject(original_srcObject, this.botMapping.getSrcEntity());
                    IObjectValue newEntryObject = this.rebuildEntryObject(prefixName, srcObject, srcEntryObject = srcEntryObjectCol.getObject(i), srcEntryProperty.getName());
                    Object pkValue = newEntryObject.get(newEntryPKField = prefixName + srcEntryProperty.getName() + '.' + srcEntryObject.getPKField());
                    String curEntryID = pkValue == null ? "" : pkValue.toString();
                    this.transferObject(prefixName + srcEntryProperty.getName(), newEntryObject, srcEntity, destEntity, srcEntryID.equals("") ? curEntryID : srcEntryID + '.' + curEntryID, botRule);
                }
            }
        }
    }

    private LinkPropertyInfo getSrcEntryProperty(String prefixName, EntityObjectInfo srcEntity, BOTRuleInfo botRule) {
        String srcDetailEntryName = botRule.getSrcDetailEntryName();
        if (srcDetailEntryName == null || srcDetailEntryName.trim().equals("")) {
            return null;
        }
        String[] detailEntryNames = StringUtils.split((String)srcDetailEntryName, (int)46);
        if (prefixName == null || prefixName.trim().equals("")) {
            return (LinkPropertyInfo)srcEntity.getPropertyByName(detailEntryNames[0]);
        }
        String[] prefixNames = StringUtils.split((String)prefixName, (int)46);
        if (prefixNames.length == detailEntryNames.length) {
            if (prefixNames.length == 1) {
                int i;
                LinkPropertyInfo entryPropInfo = (LinkPropertyInfo)srcEntity.getPropertyByName(srcDetailEntryName);
                EntityObjectInfo entryEntity = entryPropInfo.getRelationship().getChildObject(srcEntity);
                PropertyCollection properties = entryEntity.getPropertiesRuntime();
                ArrayList<LinkPropertyInfo> manyLinkPropList = new ArrayList<LinkPropertyInfo>();
                int size = properties.size();
                for (i = 0; i < size; ++i) {
                    PropertyInfo propInfo = properties.get(i);
                    if (!(propInfo instanceof LinkPropertyInfo)) continue;
                    LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)propInfo;
                    boolean manyLink = false;
                    RelationshipInfo relation = linkPropInfo.getRelationship();
                    if (!relation.getChildCardinality(entryEntity).equals((Object)CardinalityType.ONE_TO_UNBOUNDED) && !relation.getChildCardinality(entryEntity).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) continue;
                    manyLinkPropList.add(linkPropInfo);
                }
                if (manyLinkPropList.size() == 1) {
                    return (LinkPropertyInfo)manyLinkPropList.get(0);
                }
                if (manyLinkPropList.size() > 1) {
                    size = manyLinkPropList.size();
                    for (i = 0; i < size; ++i) {
                        LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)manyLinkPropList.get(i);
                        if (linkPropInfo.getName().toLowerCase().indexOf("entr") == -1) continue;
                        return linkPropInfo;
                    }
                    return (LinkPropertyInfo)manyLinkPropList.get(0);
                }
            }
            return null;
        }
        if (prefixNames.length > detailEntryNames.length) {
            return null;
        }
        EntityObjectInfo childEntity = srcEntity;
        for (int i = 0; i < prefixNames.length; ++i) {
            childEntity = ((LinkPropertyInfo)childEntity.getPropertyByName(detailEntryNames[i])).getRelationship().getChildObject(childEntity);
        }
        LinkPropertyInfo rtnVal = (LinkPropertyInfo)childEntity.getPropertyByName(detailEntryNames[prefixNames.length - 1]);
        boolean manyLink = false;
        RelationshipInfo relation = rtnVal.getRelationship();
        if (relation.getChildCardinality(childEntity).equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || relation.getChildCardinality(childEntity).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
            manyLink = true;
        }
        if (!manyLink) {
            return null;
        }
        return rtnVal;
    }

    private IObjectValue rebuildEntryObject(String prefixName, IObjectValue srcObject, IObjectValue srcEntryObject, String entryPropertyName) throws InvalidDAOMetaDataException {
        prefixName = prefixName == null ? "" : (prefixName.equals("") ? "" : prefixName + '.');
        IObjectValue objectValue = srcObject;
        this.setObjectDetailProperty(prefixName, objectValue, srcObject);
        this.setObjectDetailProperty(prefixName + entryPropertyName, objectValue, srcEntryObject);
        return objectValue;
    }

    private void setObjectDetailProperty(String prefixName, IObjectValue parentObject, IObjectValue childObject) {
        String string = prefixName == null ? "" : (prefixName = prefixName.equals("") ? "" : prefixName + '.');
        if (parentObject.equals(childObject)) {
            if (prefixName == null || prefixName.length() == 0) {
                ArrayList<String> childObjectKeys = new ArrayList<String>();
                Enumeration e = childObject.keys();
                while (e.hasMoreElements()) {
                    childObjectKeys.add((String)e.nextElement());
                }
                for (int i = 0; i < childObjectKeys.size(); ++i) {
                    String propertyName = (String)childObjectKeys.get(i);
                    String fullPropertyName = prefixName + propertyName;
                    Object dataValue = childObject.get(propertyName);
                    if (!(dataValue instanceof IObjectValue)) continue;
                    this.setObjectDetailProperty(fullPropertyName, parentObject, (IObjectValue)dataValue);
                }
            } else {
                log.warn((Object)"skip");
            }
        } else {
            Enumeration e = childObject.keys();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                String fullPropertyName = prefixName + propertyName;
                Object dataValue = childObject.get(propertyName);
                while (fullPropertyName.indexOf("..") != -1) {
                    fullPropertyName = fullPropertyName.replaceAll("\\.\\.", ".");
                }
                parentObject.put(fullPropertyName, dataValue);
                if (!(dataValue instanceof IObjectValue)) continue;
                this.setObjectDetailProperty(fullPropertyName, parentObject, (IObjectValue)dataValue);
            }
        }
    }

    private void transferDetailObject(IObjectValue srcObject, EntityObjectInfo srcEntity, EntityObjectInfo destEntity, String srcEntryPropName, String srcEntryID, BOTRuleInfo botRule) throws Exception {
        HashMap aggregateProperties = new HashMap();
        Map ruleData = this.getRuleData(srcObject, srcEntity, destEntity, botRule, aggregateProperties);
        this.fillDestObject(srcObject, ruleData, destEntity, srcEntryPropName, srcEntryID, botRule, aggregateProperties);
    }

    private Map getRuleData(IObjectValue srcObject, EntityObjectInfo srcEntity, EntityObjectInfo destEntity, BOTRuleInfo rule, Map aggregateProperties) throws InvalidDAOMetaDataException, FormaterException, ParserException, InterpreterException, com.kingdee.bos.kscript.ParserException, BOSException {
        HashMap<String, Object> ruleData = new HashMap<String, Object>();
        for (int ruleIndex = 0; ruleIndex < rule.getRuleSegments().size(); ++ruleIndex) {
            BOTRuleSegmentInfo ruleseg = rule.getRuleSegments().get(ruleIndex);
            String expression = ruleseg.getExpression();
            if (expression != null && expression.trim().length() != 0) {
                if (!this.hasAggregateExpr(expression)) {
                    Object dataValue;
                    String destPropName = ruleseg.getDestPropertyName();
                    Interpreter interpreter = new Interpreter(this.ctx);
                    for (int i = 0; i < this.funcProviderList.size(); ++i) {
                        interpreter.funcProviderList.add((IFunctionProvider)this.funcProviderList.get(i));
                    }
                    interpreter.setForBot(true);
                    CaseInSensitiveMap exprContext = new CaseInSensitiveMap();
                    Enumeration e = srcObject.keys();
                    while (e.hasMoreElements()) {
                        String propertyFullName = (String)e.nextElement();
                        exprContext.put(propertyFullName, srcObject.get(propertyFullName));
                        exprContext.put("src." + propertyFullName, srcObject.get(propertyFullName));
                        exprContext.put("__src." + propertyFullName, srcObject.get(propertyFullName));
                    }
                    if (srcEntity != null) {
                        // empty if block
                    }
                    exprContext.put("src", srcObject);
                    exprContext.put("__src", srcObject);
                    try {
                        dataValue = interpreter.eval(expression, (Map)exprContext);
                    }
                    catch (KScriptException ex) {
                        log.error((Object)("eval expression error. script is : \n" + expression), (Throwable)ex);
                        throw ex;
                    }
                    Assert.that((ruleseg.getDestPropertyName() != null ? 1 : 0) != 0, (String)"ruleseg.getDestPropertyName() is null");
                    ruleData.put(ruleseg.getDestPropertyName(), dataValue);
                    continue;
                }
                IObjectValue treeObject = this.getTreeObject(srcObject, srcEntity);
                String expression2 = expression;
                BOTAggregatePropertyInfo info = new BOTAggregatePropertyInfo();
                info.setDestPropertyName(ruleseg.getDestPropertyName());
                info.setExpression(expression2);
                info.setSrcObject(treeObject);
                HashMap detail = new HashMap();
                this.getAggregateDetail(expression2, treeObject, detail);
                info.setAggregateDetail(detail);
                aggregateProperties.put(ruleseg.getDestPropertyName(), info);
                Object dataValue = this.getAggregatePropertyValue(info);
                Assert.that((ruleseg.getDestPropertyName() != null ? 1 : 0) != 0, (String)"ruleseg.getDestPropertyName() is null");
                ruleData.put(ruleseg.getDestPropertyName(), dataValue);
                continue;
            }
            String srcPropertyName = ruleseg.getSrcPropertyName();
            String destPropertyName = ruleseg.getDestPropertyName();
            if (srcPropertyName == null || srcPropertyName.trim().equals("")) continue;
            Object value = srcObject.get(srcPropertyName);
            if (value != null) {
                ruleData.put(destPropertyName, value);
            } else {
                Interpreter interpreter = new Interpreter(this.ctx);
                for (int i = 0; i < this.funcProviderList.size(); ++i) {
                    interpreter.funcProviderList.add((IFunctionProvider)this.funcProviderList.get(i));
                }
                interpreter.setForBot(true);
                CaseInSensitiveMap exprContext = new CaseInSensitiveMap();
                Enumeration e = srcObject.keys();
                while (e.hasMoreElements()) {
                    String propertyFullName = (String)e.nextElement();
                    exprContext.put(propertyFullName, srcObject.get(propertyFullName));
                }
                value = interpreter.eval(srcPropertyName, (Map)exprContext);
                ruleData.put(destPropertyName, value);
            }
            if (!this.isMultilingualProperty(srcEntity, srcPropertyName) || !this.isMultilingualProperty(destEntity, destPropertyName)) continue;
            for (int j = 0; j < this.solution.getLanguages().size(); ++j) {
                LanguageInfo lang = this.solution.getLanguages().get(j);
                value = srcObject.get(srcPropertyName + "_" + lang.getPostfix());
                if (value == null) continue;
                ruleData.put(destPropertyName + "_" + lang.getPostfix(), value);
            }
        }
        return ruleData;
    }

    private void replaceExpr(String script, IObjectValue treeObj, Map exprContext) throws com.kingdee.bos.kscript.ParserException {
        try {
            ArrayList list = new ArrayList();
            KScriptParser parser = new KScriptParser(script);
            parser.parse();
            List stmtList = parser.stmtList;
            for (int i = 0; i < stmtList.size(); ++i) {
                this.replaceExpr((CodeStmt)stmtList.get(i), treeObj, exprContext);
            }
        }
        catch (com.kingdee.bos.kscript.ParserException e) {
            log.error((Object)("parse error. script is : " + script), (Throwable)e);
            throw e;
        }
    }

    private void replaceExpr(CodeStmt stmt, IObjectValue treeObj, Map exprContext) {
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            ((ExprStmt)stmt).expr = expr = this.replaceExpr(expr, treeObj, exprContext);
        } else if (stmt instanceof ReturnStmt) {
            CodeExpr expr = ((ReturnStmt)stmt).expr;
            ((ReturnStmt)stmt).expr = expr = this.replaceExpr(expr, treeObj, exprContext);
        } else {
            throw new UnsupportedOperationException("not support operation: " + stmt.toString());
        }
    }

    private CodeExpr replaceExpr(CodeExpr expr, IObjectValue treeObj, Map exprContext) {
        return expr;
    }

    private boolean isMultilingualProperty(EntityObjectInfo entity, String propertyName) {
        String[] names = StringUtils.split((String)propertyName, (int)46);
        EntityObjectInfo childEntity = entity;
        for (int i = 0; i < names.length - 1; ++i) {
            childEntity = ((LinkPropertyInfo)childEntity.getPropertyByName(names[i])).getRelationship().getChildObject(childEntity);
        }
        PropertyInfo prop = childEntity.getPropertyByName(names[names.length - 1]);
        return prop instanceof OwnPropertyInfo && ((OwnPropertyInfo)prop).isMultilingual();
    }

    private boolean hasAggregateExpr(String expression) throws com.kingdee.bos.kscript.ParserException {
        try {
            ArrayList list = new ArrayList();
            KScriptParser parser = new KScriptParser(expression);
            parser.parse();
            List stmtList = parser.stmtList;
            return this.hasAggregateExpr(stmtList);
        }
        catch (com.kingdee.bos.kscript.ParserException e) {
            log.error((Object)("parse error. expression is : " + expression), (Throwable)e);
            throw e;
        }
    }

    private boolean hasAggregateExpr(List stmtList) {
        if (stmtList.size() == 0 || stmtList.size() > 1) {
            return false;
        }
        CodeStmt stmt = (CodeStmt)stmtList.get(0);
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            return this.hasAggregateExpr(expr);
        }
        return false;
    }

    private boolean hasAggregateExpr(CodeExpr expr) {
        if (expr instanceof BinaryOpExpr) {
            if (this.hasAggregateExpr((BinaryOpExpr)expr)) {
                return true;
            }
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokExpr = (MethodInvokeExpr)expr;
            if (methodInvokExpr.methodName != null && (methodInvokExpr.methodName.equalsIgnoreCase("sum") || methodInvokExpr.methodName.equalsIgnoreCase("avg") || methodInvokExpr.methodName.equalsIgnoreCase("max") || methodInvokExpr.methodName.equalsIgnoreCase("min"))) {
                return true;
            }
            for (int i = 0; i < methodInvokExpr.paramList.size(); ++i) {
                CodeExpr pramExpr = (CodeExpr)methodInvokExpr.paramList.get(i);
                if (!this.hasAggregateExpr(pramExpr)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAggregateExpr(BinaryOpExpr expr) {
        if (this.hasAggregateExpr(expr.left)) {
            return true;
        }
        return this.hasAggregateExpr(expr.right);
    }

    private boolean hasAggregateExpr(SqlBinaryOpExpr expr) throws ParserException {
        if (expr.left instanceof SqlAggregateExpr || expr.right instanceof SqlAggregateExpr) {
            return true;
        }
        if (expr.left instanceof SqlBinaryOpExpr && this.hasAggregateExpr((SqlBinaryOpExpr)expr.left)) {
            return true;
        }
        return expr.right instanceof SqlBinaryOpExpr && this.hasAggregateExpr((SqlBinaryOpExpr)expr.right);
    }

    private void getAggregateDetail(String expression, IObjectValue srcData, Map aggregateDetail) throws ParserException, FormaterException, InterpreterException, com.kingdee.bos.kscript.ParserException {
        ArrayList list = new ArrayList();
        SqlExprParser parser = new SqlExprParser(expression);
        parser.exprList(list);
        SqlExpr expr = (SqlExpr)list.get(0);
        if (expr instanceof SqlAggregateExpr) {
            this.getAggregateDetail((SqlAggregateExpr)expr, srcData, aggregateDetail);
        } else if (expr instanceof SqlBinaryOpExpr) {
            this.getAggregateDetail((SqlBinaryOpExpr)expr, srcData, aggregateDetail);
        }
    }

    private void getAggregateDetail(SqlBinaryOpExpr expr, IObjectValue srcData, Map aggregateDetail) throws FormaterException, InterpreterException, com.kingdee.bos.kscript.ParserException {
        if (expr.left instanceof SqlAggregateExpr) {
            this.getAggregateDetail((SqlAggregateExpr)expr.left, srcData, aggregateDetail);
        } else if (expr.left instanceof SqlBinaryOpExpr) {
            this.getAggregateDetail((SqlBinaryOpExpr)expr.left, srcData, aggregateDetail);
        }
        if (expr.right instanceof SqlAggregateExpr) {
            this.getAggregateDetail((SqlAggregateExpr)expr.right, srcData, aggregateDetail);
        } else if (expr.right instanceof SqlBinaryOpExpr) {
            this.getAggregateDetail((SqlBinaryOpExpr)expr.right, srcData, aggregateDetail);
        }
    }

    private void getAggregateDetail(SqlAggregateExpr expr, IObjectValue srcData, Map aggregateDetail) throws FormaterException, InterpreterException, com.kingdee.bos.kscript.ParserException {
        String expression = this.getExpression(expr);
        String key = this.getAggregateDetailKey(expr.methodName, expression);
        if (!aggregateDetail.containsKey(key)) {
            BOTAggregateDetailInfo info = new BOTAggregateDetailInfo();
            info.setAggregateExpression(expression);
            info.setAggregateFunctionName(expr.methodName);
            Interpreter interpreter = new Interpreter(this.ctx);
            for (int i = 0; i < this.funcProviderList.size(); ++i) {
                interpreter.funcProviderList.add((IFunctionProvider)this.funcProviderList.get(i));
            }
            CaseInSensitiveMap exprContext = new CaseInSensitiveMap();
            Enumeration e = srcData.keys();
            while (e.hasMoreElements()) {
                String propertyFullName = (String)e.nextElement();
                exprContext.put(propertyFullName, srcData.get(propertyFullName));
            }
            Object dataValue = interpreter.evalExpr(expression, (Map)exprContext);
            info.setAggregateValue(new BigDecimal(dataValue != null ? dataValue.toString() : "0"));
            info.setAggregateCount(1);
            aggregateDetail.put(key, info);
        }
    }

    private String getAggregateDetailKey(String functionName, String expression) {
        return functionName + "(" + expression + ")";
    }

    private String getExpression(SqlAggregateExpr expr) throws FormaterException {
        BOTSQLFormater formater = new BOTSQLFormater();
        StringBuffer buffer = new StringBuffer();
        Iterator iter = expr.paramList.iterator();
        boolean flag = false;
        while (iter.hasNext()) {
            SqlExpr pramExpr = (SqlExpr)iter.next();
            formater.setBuffer(buffer);
            formater.formatExpr(pramExpr);
            if (flag) {
                buffer.append(", ");
            }
            flag = true;
        }
        return buffer.toString();
    }

    private IObjectValue getTreeObject(IObjectValue srcObject, EntityObjectInfo srcEntity) throws InvalidDAOMetaDataException, BOSException {
        IObjectValue treeObject = Utils.newObjectValueInstance((EntityObjectInfo)srcEntity);
        Enumeration e = srcObject.keys();
        while (e.hasMoreElements()) {
            String temp;
            String propertyFullName = temp = (String)e.nextElement();
            while (propertyFullName.indexOf("..") != -1) {
                propertyFullName = propertyFullName.replaceAll("\\.\\.", ".");
            }
            String[] names = StringUtils.split((String)propertyFullName, (int)46);
            IObjectValue curObject = treeObject;
            EntityObjectInfo curEntity = srcEntity;
            for (int i = 0; i < names.length - 1; ++i) {
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)curEntity.getPropertyByNameRuntime(names[i]);
                if (linkPropertyInfo == null) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)("linkPropertyInfo is null. name is '" + names[i] + "'"));
                    }
                    throw new BOSException("BOTTransform error, can not get LinkProperty.");
                }
                RelationshipInfo relation = linkPropertyInfo.getRelationship();
                boolean manyLink = false;
                if (relation.getChildCardinality(curEntity).equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || relation.getChildCardinality(curEntity).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)) {
                    manyLink = true;
                }
                curEntity = relation.getChildObject(curEntity);
                if (manyLink) {
                    IObjectCollection col = (IObjectCollection)curObject.get(names[i]);
                    if (col.size() == 0) {
                        IObjectValue newObject = Utils.newObjectValueInstance((EntityObjectInfo)curEntity);
                        col.addObject(newObject);
                        curObject = newObject;
                        continue;
                    }
                    curObject = col.getObject(0);
                    continue;
                }
                if (curObject.containsKey(names[i])) {
                    if ((curObject = (IObjectValue)curObject.get(names[i])) != null) continue;
                    if (!log.isDebugEnabled()) break;
                    log.info((Object)("curObject is null. name is '" + names[i] + "'"));
                    break;
                }
                IObjectValue newObject = Utils.newObjectValueInstance((EntityObjectInfo)curEntity);
                curObject.put(names[i], (Object)newObject);
                curObject = newObject;
            }
            Object dataValue = srcObject.get(propertyFullName);
            if (curObject != null) {
                if (dataValue instanceof IObjectCollection) continue;
                curObject.put(names[names.length - 1], dataValue);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.info((Object)("curObject is null. propertyFullName is '" + propertyFullName + "', dataValue is '" + dataValue + "'"));
        }
        return treeObject;
    }

    private void sortGroupingRule(BOTGroupingCollection groupingCollection) {
        ArrayList<BOTGroupingInfo> list = new ArrayList<BOTGroupingInfo>(groupingCollection.size());
        for (int i = 0; i < groupingCollection.size(); ++i) {
            list.add(groupingCollection.get(i));
        }
        GroupingComparator c = new GroupingComparator();
        Collections.sort(list, c);
        groupingCollection.clear();
        for (int i = 0; i < list.size(); ++i) {
            groupingCollection.add((BOTGroupingInfo)list.get(i));
        }
    }

    private void fillDestObject(IObjectValue srcObject, Map ruleData, EntityObjectInfo destEntity, String srcEntryPropName, String srcEntryID, BOTRuleInfo botRule, Map aggregateProperties) throws Exception {
        HashMap<String, IObjectValue> entryObjects = new HashMap<String, IObjectValue>();
        int groupMaxLevel = this.getBOTGroupingMaxLevel(botRule.getGroups());
        for (String destPropertyName : ruleData.keySet()) {
            String srcPropertyName = null;
            for (int i = 0; i < botRule.getRuleSegments().size(); ++i) {
                BOTRuleSegmentInfo ruleSegment = botRule.getRuleSegments().get(i);
                String botRulePropName = ruleSegment.getDestPropertyName();
                if (!botRulePropName.equalsIgnoreCase(destPropertyName)) continue;
                srcPropertyName = ruleSegment.getSrcPropertyName();
                break;
            }
            String key = "";
            String destEntryPropName = "";
            String destEntryID = "";
            IObjectValue dataObject = null;
            IObjectValue destObject = null;
            boolean isPkField = false;
            String[] destNames = StringUtils.split((String)destPropertyName, (int)46);
            EntityObjectInfo childEntity = destEntity;
            if (groupMaxLevel == 0) {
                key = noGrouping;
            } else {
                boolean hasGrouping = false;
                BOTGroupingCollection groupingCollection = botRule.getGroups();
                this.sortGroupingRule(groupingCollection);
                for (int index = 0; index < groupingCollection.size(); ++index) {
                    BOTGroupingInfo botGrouping = groupingCollection.get(index);
                    if (botGrouping.getGroupingLevel() != 1) continue;
                    hasGrouping = true;
                    key = key + this.getGroupingKey(destEntity, botGrouping.getGroupingProperty(), ruleData);
                }
                if (!hasGrouping) {
                    throw new Exception("invalid BOTGroupingInfo. don't have Level 1. BOTRule:" + botRule.getName());
                }
            }
            if (this.objectGroupingInfoMap.containsKey(key)) {
                dataObject = (IObjectValue)this.objectGroupingInfoMap.get(key);
            } else {
                dataObject = Utils.newObjectValueInstance((EntityObjectInfo)destEntity);
                this.objectGroupingInfoMap.put(key, dataObject);
                this.setObjectID("", dataObject, childEntity, ruleData);
                this.destObjectCollection.addObject(dataObject);
            }
            destObject = dataObject;
            for (int i = 2; i <= groupMaxLevel && destNames.length >= i; ++i) {
                String name = destNames[i - 2];
                childEntity = ((LinkPropertyInfo)childEntity.getPropertyByName(name)).getRelationship().getChildObject(childEntity);
                destEntryPropName = destEntryPropName.equals("") ? name : destEntryPropName + '.' + name;
                boolean hasGrouping = false;
                for (int index = 0; index < botRule.getGroups().size(); ++index) {
                    BOTGroupingInfo botGrouping = botRule.getGroups().get(index);
                    if (botGrouping.getGroupingLevel() != i) continue;
                    hasGrouping = true;
                    key = key + this.getGroupingKey(destEntity, botGrouping.getGroupingProperty(), ruleData);
                }
                if (!hasGrouping) {
                    throw new Exception("invalid BOTGroupingInfo. don't have Level " + i + ". BOTRule:" + botRule.getName());
                }
                if (this.objectGroupingInfoMap.containsKey(key)) {
                    dataObject = (IObjectValue)this.objectGroupingInfoMap.get(key);
                } else {
                    IObjectValue childObject = Utils.newObjectValueInstance((EntityObjectInfo)childEntity);
                    this.objectGroupingInfoMap.put(key, childObject);
                    ((IObjectCollection)dataObject.get(destNames[i - 2])).addObject(childObject);
                    dataObject = childObject;
                    this.setObjectID(destEntryPropName, dataObject, childEntity, ruleData);
                }
                destEntryID = destEntryID.equals("") ? dataObject.get(dataObject.getPKField()).toString() : destEntryID + '.' + dataObject.get(dataObject.getPKField()).toString();
            }
            if (groupMaxLevel == 0) {
                groupMaxLevel = 1;
            }
            String curPropName = destEntryPropName;
            for (int i = groupMaxLevel - 1; i < destNames.length - 1; ++i) {
                IObjectValue dataValue;
                String name = destNames[i];
                curPropName = curPropName.equals("") ? name : curPropName + '.' + name;
                RelationshipInfo relation = ((LinkPropertyInfo)childEntity.getPropertyByName(name)).getRelationship();
                if (relation.getChildCardinality(childEntity).equals((Object)CardinalityType.ONE) || relation.getChildCardinality(childEntity).equals((Object)CardinalityType.ZERO_TO_ONE)) {
                    dataValue = (IObjectValue)dataObject.get(name);
                    if (dataValue == null) {
                        dataValue = ruleData.containsKey(curPropName) ? (IObjectValue)ruleData.get(curPropName) : Utils.newObjectValueInstance((EntityObjectInfo)relation.getChildObject(childEntity));
                        dataObject.put(name, (Object)dataValue);
                    }
                    dataObject = dataValue;
                } else {
                    destEntryPropName = destEntryPropName.equals("") ? name : destEntryPropName + '.' + name;
                    if (entryObjects.containsKey(curPropName)) {
                        dataObject = (IObjectValue)entryObjects.get(curPropName);
                    } else {
                        dataValue = Utils.newObjectValueInstance((EntityObjectInfo)relation.getChildObject(childEntity));
                        entryObjects.put(curPropName, dataValue);
                        ((IObjectCollection)dataObject.get(name)).addObject(dataValue);
                        dataObject = dataValue;
                        this.setObjectID(destEntryPropName, dataObject, relation.getChildObject(childEntity), ruleData);
                    }
                    destEntryID = destEntryID.equals("") ? dataObject.get(dataObject.getPKField()).toString() : destEntryID + '.' + dataObject.get(dataObject.getPKField()).toString();
                }
                childEntity = relation.getChildObject(childEntity);
            }
            if (destPropertyName != null && destPropertyName.equals(destObject.getPKField())) {
                isPkField = true;
            }
            if (isPkField && destObject.get(destPropertyName) != null) {
                log.info((Object)"skip pkfield multi assign.");
            } else {
                dataObject.put(destNames[destNames.length - 1], ruleData.get(destPropertyName));
            }
            this.setAggregateInfo(dataObject, destPropertyName, aggregateProperties);
            BOTRelationInfo relation = this.getBOTRelation(this.botMapping, srcObject, destObject);
            for (int i = 0; i < botRule.getRuleSegments().size(); ++i) {
                BOTRuleSegmentInfo ruleSegment = botRule.getRuleSegments().get(i);
                String ruleSegmentDestPropName = ruleSegment.getDestPropertyName();
                if (!ruleSegmentDestPropName.equalsIgnoreCase(destPropertyName) || !ruleSegment.isRegInRelation()) continue;
                this.addRelationEntry(relation, srcObject, destObject, srcEntryPropName, destEntryPropName, srcEntryID, destEntryID, srcPropertyName, destPropertyName, ruleData.get(destPropertyName));
            }
        }
    }

    private String getGroupingKey(EntityObjectInfo destEntity, String groupingProperty, Map ruleData) throws Exception {
        String[] names = StringUtils.split((String)groupingProperty, (int)46);
        EntityObjectInfo childEntity = destEntity;
        String args = "";
        for (int i = 0; i < names.length - 1; ++i) {
            childEntity = ((LinkPropertyInfo)childEntity.getPropertyByName(names[i])).getRelationship().getChildObject(childEntity);
        }
        PropertyInfo prop = childEntity.getPropertyByName(names[names.length - 1]);
        if (prop instanceof OwnPropertyInfo) {
            args = "&" + groupingProperty + ":" + ruleData.get(groupingProperty);
        } else {
            RelationshipInfo relation = ((LinkPropertyInfo)prop).getRelationship();
            if (relation.getChildCardinality(childEntity).equals((Object)CardinalityType.ONE) || relation.getChildCardinality(childEntity).equals((Object)CardinalityType.ZERO_TO_ONE)) {
                IObjectValue groupingValue = (IObjectValue)ruleData.get(groupingProperty);
                if (groupingValue == null) {
                    args = "&" + groupingProperty + ":null";
                } else {
                    args = "&" + groupingProperty + ":";
                    childEntity = relation.getChildObject(childEntity);
                    PropertyCollection keyprops = childEntity.getLogicalKey().getKeyPropertys();
                    for (int i = 0; i < keyprops.size(); ++i) {
                        args = args + groupingValue.get(keyprops.get(i).getName());
                        if (i >= keyprops.size() - 1) continue;
                        args = args + "|";
                    }
                }
            } else {
                throw new Exception("collection link property can not be grouping property.groupingProperty:" + groupingProperty);
            }
        }
        return args;
    }

    private void setAggregateInfo(IObjectValue dataObject, String destPropertyName, Map aggregateProperties) {
        BOTAggregatePropertyInfo curInfo = (BOTAggregatePropertyInfo)aggregateProperties.get(destPropertyName);
        if (curInfo != null) {
            String aggKey = dataObject.getBOSType().toString() + ":" + dataObject.getString(dataObject.getPKField()) + "|" + destPropertyName;
            String[] destNames = StringUtils.split((String)curInfo.getDestPropertyName(), (int)46);
            dataObject.put(destNames[destNames.length - 1], (Object)new Integer(0));
            if (this.aggregateInfoMap.containsKey(aggKey)) {
                BOTAggregatePropertyInfo info = (BOTAggregatePropertyInfo)this.aggregateInfoMap.get(aggKey);
                Map detail = info.getAggregateDetail();
                Map curDetail = curInfo.getAggregateDetail();
                for (String detailKey : curDetail.keySet()) {
                    BOTAggregateDetailInfo curdi = (BOTAggregateDetailInfo)curDetail.get(detailKey);
                    if (detail.containsKey(detailKey)) {
                        BOTAggregateDetailInfo di = (BOTAggregateDetailInfo)detail.get(detailKey);
                        if (curdi.getAggregateFunctionName().equalsIgnoreCase("sum")) {
                            di.setAggregateValue(di.getAggregateValue().add(curdi.getAggregateValue()));
                        } else if (curdi.getAggregateFunctionName().equalsIgnoreCase("avg")) {
                            di.setAggregateValue(di.getAggregateValue().add(curdi.getAggregateValue()));
                        } else if (curdi.getAggregateFunctionName().equalsIgnoreCase("max")) {
                            if (curdi.getAggregateValue().compareTo(di.getAggregateValue()) > 0) {
                                di.setAggregateValue(curdi.getAggregateValue());
                            }
                        } else if (curdi.getAggregateFunctionName().equalsIgnoreCase("min")) {
                            if (curdi.getAggregateValue().compareTo(di.getAggregateValue()) < 0) {
                                di.setAggregateValue(curdi.getAggregateValue());
                            }
                        } else if (curdi.getAggregateFunctionName().equalsIgnoreCase("count")) {
                            di.setAggregateValue(di.getAggregateValue().add(new BigDecimal("1")));
                        }
                        di.setAggregateCount(di.getAggregateCount() + 1);
                        continue;
                    }
                    detail.put(detailKey, curdi);
                }
            } else {
                BOTAggregatePropertyInfo info = new BOTAggregatePropertyInfo();
                info.setDestObject(dataObject);
                info.setSrcObject(curInfo.getSrcObject());
                info.setExpression(curInfo.getExpression());
                info.setDestPropertyName(curInfo.getDestPropertyName());
                info.setAggregateDetail(curInfo.getAggregateDetail());
                this.aggregateInfoMap.put(aggKey, info);
            }
        }
    }

    private void setAggregatePropertyFinalValue() throws FormaterException, ParserException, InterpreterException, com.kingdee.bos.kscript.ParserException {
        for (String key : this.aggregateInfoMap.keySet()) {
            BOTAggregatePropertyInfo info = (BOTAggregatePropertyInfo)this.aggregateInfoMap.get(key);
            Object dataValue = this.getAggregatePropertyValue(info);
            int i = info.getDestPropertyName().lastIndexOf(46);
            String propName = info.getDestPropertyName().substring(i == 0 ? i : i + 1);
            IObjectValue destObj = info.getDestObject();
            if (destObj.containsKey(propName)) {
                Object originalVal = destObj.get(propName);
                if (originalVal instanceof Number || originalVal instanceof BigInteger || originalVal instanceof BigDecimal) {
                    Object resultVal = TypeUtils.add((Object)originalVal, (Object)dataValue);
                    destObj.put(propName, resultVal);
                    continue;
                }
                destObj.put(propName, dataValue);
                continue;
            }
            destObj.put(propName, dataValue);
        }
    }

    private Object getAggregatePropertyValue(BOTAggregatePropertyInfo info) throws FormaterException, ParserException, InterpreterException, com.kingdee.bos.kscript.ParserException {
        String expression = info.getExpression();
        String resultExpr = this.repleaceAggregateExpr_1(expression, info);
        Interpreter interpreter = new Interpreter(this.ctx);
        for (int i = 0; i < this.funcProviderList.size(); ++i) {
            interpreter.funcProviderList.add((IFunctionProvider)this.funcProviderList.get(i));
        }
        CaseInSensitiveMap exprContext = new CaseInSensitiveMap();
        Enumeration e = info.getSrcObject().keys();
        while (e.hasMoreElements()) {
            String propertyFullName = (String)e.nextElement();
            exprContext.put(propertyFullName, info.getSrcObject().get(propertyFullName));
        }
        Object dataValue = interpreter.evalExpr(resultExpr, (Map)exprContext);
        return dataValue;
    }

    private String repleaceAggregateExpr_1(String expression, BOTAggregatePropertyInfo aggInfo) throws ParserException, com.kingdee.bos.kscript.ParserException {
        KScriptParser parser = new KScriptParser(expression);
        parser.parse();
        List stmtList = parser.stmtList;
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(0);
            this.replaceAggregateExpr(stmt, aggInfo);
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(0);
            stmt.output(buff, "");
        }
        return buff.toString();
    }

    private CodeStmt replaceAggregateExpr(CodeStmt stmt, BOTAggregatePropertyInfo aggInfo) {
        if (stmt instanceof ExprStmt) {
            ExprStmt exprStm = (ExprStmt)stmt;
            exprStm.expr = this.replaceAggregateExpr(exprStm.expr, aggInfo);
        } else if (stmt instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)stmt;
            this.replaceAggregateExpr(ifStmt.trueStmtList, aggInfo);
            for (ElseIfItem elseIf : ifStmt.elseIfList) {
                elseIf.testExpr = this.replaceAggregateExpr(elseIf.testExpr, aggInfo);
                this.replaceAggregateExpr(elseIf.stmtList, aggInfo);
            }
            this.replaceAggregateExpr(ifStmt.elseStmtList, aggInfo);
        } else if (stmt instanceof WhileStmt) {
            WhileStmt whileStm = (WhileStmt)stmt;
            this.replaceAggregateExpr(whileStm.stmtList, aggInfo);
        } else if (stmt instanceof DoStmt) {
            DoStmt doStm = (DoStmt)stmt;
            this.replaceAggregateExpr(doStm.stmtList, aggInfo);
        } else if (stmt instanceof ForStmt) {
            ForStmt forStm = (ForStmt)stmt;
            forStm.initStmt = this.replaceAggregateExpr(forStm.initStmt, aggInfo);
            forStm.testExpr = this.replaceAggregateExpr(forStm.testExpr, aggInfo);
            forStm.incrementStmt = this.replaceAggregateExpr(forStm.incrementStmt, aggInfo);
            this.replaceAggregateExpr(forStm.stmtList, aggInfo);
        } else {
            throw new UnsupportedOperationException();
        }
        return stmt;
    }

    private void replaceAggregateExpr(List stmtList, BOTAggregatePropertyInfo aggInfo) {
        for (int i = 0; i < stmtList.size(); ++i) {
            CodeStmt stmt = this.replaceAggregateExpr((CodeStmt)stmtList.get(i), aggInfo);
            stmtList.set(i, stmt);
        }
    }

    private CodeExpr replaceAggregateExpr(CodeExpr expr, BOTAggregatePropertyInfo aggInfo) {
        if (expr instanceof BinaryOpExpr) {
            return this.replaceAggregateExpr((BinaryOpExpr)expr, aggInfo);
        }
        if (expr instanceof MethodInvokeExpr) {
            return this.replaceAggregateExpr((MethodInvokeExpr)expr, aggInfo);
        }
        return expr;
    }

    private BinaryOpExpr replaceAggregateExpr(BinaryOpExpr expr, BOTAggregatePropertyInfo aggInfo) {
        expr.left = this.replaceAggregateExpr(expr.left, aggInfo);
        expr.right = this.replaceAggregateExpr(expr.right, aggInfo);
        return expr;
    }

    private CodeExpr replaceAggregateExpr(MethodInvokeExpr expr, BOTAggregatePropertyInfo aggInfo) {
        if (expr.methodName.equalsIgnoreCase("sum") || expr.methodName.equalsIgnoreCase("max") || expr.methodName.equalsIgnoreCase("min") || expr.methodName.equalsIgnoreCase("avg")) {
            String key = expr.toString();
            BOTAggregateDetailInfo detail = (BOTAggregateDetailInfo)aggInfo.getAggregateDetail().get(key);
            String text = this.getAggregateFuncValue(detail).toString();
            return new DoubleExpr(text);
        }
        return expr;
    }

    private BigDecimal getAggregateFuncValue(BOTAggregateDetailInfo info) {
        if (info.getAggregateFunctionName().equalsIgnoreCase("avg")) {
            return info.getAggregateValue().divide(new BigDecimal(info.getAggregateCount() + ""), 4);
        }
        return info.getAggregateValue();
    }

    private void setObjectID(String entryPropName, IObjectValue dataObject, EntityObjectInfo entity, Map ruleData) {
        entryPropName = entryPropName == null ? "" : (entryPropName.equals("") ? "" : entryPropName + '.');
        String pkField = dataObject.getPKField();
        if (ruleData.containsKey(entryPropName + pkField)) {
            dataObject.put(pkField, ruleData.get(entryPropName + pkField));
        } else {
            OwnPropertyInfo property = (OwnPropertyInfo)entity.getPropertyByName(pkField);
            if (property.getDataType().equals((Object)DataType.BOSUUID)) {
                BOSUuid uuid = BOSUuid.create((BOSObjectType)dataObject.getBOSType());
                dataObject.put(pkField, (Object)uuid);
            }
        }
    }

    private int getPropertyInEntryLevel(String destPropertyName, EntityObjectInfo destEntity) {
        LinkPropertyInfo prop;
        String[] names = StringUtils.split((String)destPropertyName, (int)46);
        EntityObjectInfo childEntity = destEntity;
        int level = 0;
        for (int i = 0; i < names.length - 1 && ((prop = (LinkPropertyInfo)destEntity.getPropertyByName(names[i])).getRelationship().getChildCardinality(childEntity).equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || prop.getRelationship().getChildCardinality(childEntity).equals((Object)CardinalityType.ZERO_TO_UNBOUNDED)); ++i) {
            ++level;
        }
        return level;
    }

    private int getBOTGroupingMaxLevel(BOTGroupingCollection botGroupingCollection) {
        int level = 0;
        for (int i = 0; i < botGroupingCollection.size(); ++i) {
            if (botGroupingCollection.get(i).getGroupingLevel() <= level) continue;
            level = botGroupingCollection.get(i).getGroupingLevel();
        }
        return level;
    }

    private BOTGroupingInfo getBOTGroupingByLevel(BOTGroupingCollection botGroupingCollection, int level) {
        for (int i = 0; i < botGroupingCollection.size(); ++i) {
            if (botGroupingCollection.get(i).getGroupingLevel() != level) continue;
            return botGroupingCollection.get(i);
        }
        return null;
    }

    private BOTRelationInfo getBOTRelation(BOTMappingInfo botMapping, IObjectValue srcObject, IObjectValue destObject) {
        Object objkey = srcObject.get(srcObject.getPKField());
        String srcObjectID = objkey == null ? "" : objkey.toString();
        objkey = destObject.get(destObject.getPKField());
        String destObjectID = objkey == null ? "" : objkey.toString();
        String key = "SrcObjectID:" + srcObjectID + "|DestObjectID:" + destObjectID;
        if (this.relationInfoMap.containsKey(key)) {
            return (BOTRelationInfo)this.relationInfoMap.get(key);
        }
        BOTRelationInfo relation = new BOTRelationInfo();
        relation.setId(BOSUuid.create((BOSObjectType)relation.getBOSType()));
        EntityObjectInfo srcEntity = botMapping.getSrcEntity();
        relation.setSrcEntityID(srcEntity.getType().toString());
        relation.setSrcObjectID(srcObjectID);
        relation.setDestEntityID(botMapping.getDestEntity().getType().toString());
        relation.setDestObjectID(destObjectID);
        relation.setDate(new Date());
        relation.setOperatorID("unknown");
        relation.setBOTMappingID(botMapping.get(botMapping.getPKField()).toString());
        relation.setType(0);
        this.relationCollection.add(relation);
        this.relationInfoMap.put(key, relation);
        return relation;
    }

    private void addRelationEntry(BOTRelationInfo relation, IObjectValue srcObject, IObjectValue destObject, String srcEntryPropName, String destEntryPropName, String srcEntryID, String destEntryID, String srcPropertyName, String destPropertyName, Object destFieldValue) {
        Object objkey = srcObject.get(srcObject.getPKField());
        String srcObjectID = objkey == null ? "" : objkey.toString();
        objkey = destObject.get(destObject.getPKField());
        String destObjectID = objkey == null ? "" : objkey.toString();
        BOTRelationEntryInfo re = new BOTRelationEntryInfo();
        re.setSrcObjectID(srcObjectID);
        re.setDestObjectID(destObjectID);
        re.setSrcEntryPropName(srcEntryPropName);
        re.setDestEntryPropName(destEntryPropName);
        re.setSrcEntryID(srcEntryID);
        re.setDestEntryID(destEntryID);
        re.setSrcPropertyName(srcPropertyName);
        re.setDestPropertyName(destPropertyName);
        re.setValue(destFieldValue.toString());
        relation.getRelationEntries().add(re);
    }

    static class Pair {
        public Object first;
        public Object second;

        public Pair() {
        }

        public Pair(Object first, Object second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            long val = (this.first != null ? this.first.hashCode() : 0) + (this.second != null ? this.second.hashCode() : 0);
            return (int)(val ^ val >>> 32);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Pair) {
                Pair dest = (Pair)o;
                if (this.first.equals(dest.first) && this.second.equals(dest.second)) {
                    return true;
                }
            }
            return false;
        }
    }

    private class GroupingComparator
    implements Comparator {
        private GroupingComparator() {
        }

        public int compare(Object o1, Object o2) {
            BOTGroupingInfo groupInfo1 = (BOTGroupingInfo)o1;
            BOTGroupingInfo groupInfo2 = (BOTGroupingInfo)o2;
            String prop1 = groupInfo1.getGroupingProperty();
            String prop2 = groupInfo2.getGroupingProperty();
            return prop1.compareTo(prop2);
        }
    }
}

