/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.bot.trace.impl;

import com.kingdee.bos.bot.engine.common.LogUtils;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.bot.trace.core.ITrace;
import com.kingdee.eas.base.bot.trace.core.ITraceObject;
import com.kingdee.eas.base.bot.trace.core.ITraceSubObject;
import com.kingdee.eas.base.bot.trace.impl.BotpTraceBaseObject;
import com.kingdee.eas.base.bot.trace.impl.BotpTraceSubObject;
import com.kingdee.eas.base.bot.trace.util.TraceLevel;
import com.kingdee.eas.base.botp.util.BotpUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class BotpTraceObject
extends BotpTraceBaseObject
implements ITraceObject {
    private Stack traceStack = new Stack();
    private Throwable error = null;
    private boolean inited = false;
    private Map timeMap = new HashMap();
    private List callNameList = new ArrayList();
    private static final ThreadLocal<String> loggerLocal = new ThreadLocal();
    protected Map<String, Long> scriptTimeMap = new HashMap<String, Long>();
    private ITraceSubObject subObject = null;
    public static final String APPENDER_NAME = "BOTP_TRACE_LOGGER";

    BotpTraceObject(TraceLevel traceLevel) {
        this.traceLevel = traceLevel;
        if (loggerLocal.get() == null) {
            Thread thread = Thread.currentThread();
            String name = thread.getId() + "_" + thread.getName();
            LogUtils.getLogger(name);
            loggerLocal.set(name);
        }
    }

    private void clear() {
        this.traceStack.clear();
        this.clearCallTime();
    }

    @Override
    public void start(String name) {
        this.clear();
        this.inited = this.traceLevel != null && this.traceLevel != TraceLevel.LEVEL_NO;
        super.start(name);
        this.logInfoHead();
    }

    @Override
    public void end() {
        if (!this.inited) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.get(i) instanceof ITrace)) continue;
            ((ITrace)this.children.get(i)).end();
        }
        this.outputCallMethodTime();
        super.end();
        this.logInfoFoot();
        this.inited = false;
        this.clear();
    }

    private void outputCallMethodTime() {
        int i;
        if (!this.inited) {
            return;
        }
        List callNameList = this.getCallNameList();
        Object[] callNameArray = callNameList.toArray();
        for (i = 0; i < callNameArray.length - 1; ++i) {
            for (int j = i + 1; j < callNameArray.length; ++j) {
                String name = (String)callNameArray[i];
                String name2 = (String)callNameArray[j];
                if (name.compareTo(name2) <= 0) continue;
                String tmpStr = (String)callNameArray[i];
                callNameArray[i] = callNameArray[j];
                callNameArray[j] = tmpStr;
            }
        }
        if (callNameArray != null && callNameArray.length > 0) {
            for (i = 0; i < callNameArray.length; ++i) {
                String name = (String)callNameArray[i];
                long timeVal = this.getCallTime(name);
                this.log("Time :" + BotpUtils.formatStrLength(String.valueOf(timeVal), 8, " ") + " ms,  BOTPMethod Name : " + name, true);
            }
        }
    }

    @Override
    public void newSub(String name) {
        this.newSub(name, "");
    }

    @Override
    public void newSub(String name, String msg) {
        BotpTraceSubObject subInfo;
        if (!this.inited) {
            return;
        }
        if (this.subObject != null) {
            subInfo = new BotpTraceSubObject(this, this.subObject.getLevel() + 1);
            this.traceStack.push(this.subObject);
            this.subObject.add(subInfo);
        } else {
            subInfo = new BotpTraceSubObject(this, this.getLevel() + 1);
            this.add(subInfo);
        }
        subInfo.setTraceLevel(this.traceLevel);
        subInfo.setMsg(msg);
        subInfo.start(name);
        this.subObject = subInfo;
        if (this.traceLevel == TraceLevel.LEVEL_ALL) {
            this.subObject.logInfoHead();
        }
    }

    @Override
    public void endSub() {
        if (!this.inited) {
            return;
        }
        if (this.subObject == null) {
            return;
        }
        this.subObject.end();
        this.setCallTime(this.subObject.getName(), this.subObject.getExecTime());
        if (this.traceLevel == TraceLevel.LEVEL_DETAIL) {
            this.subObject.logInfoFoot();
        }
        if (!this.traceStack.empty()) {
            ITraceSubObject subInfo = (ITraceSubObject)this.traceStack.pop();
            subInfo.remove(this.subObject);
            this.subObject = subInfo;
        } else {
            this.subObject = null;
        }
    }

    @Override
    public void log(String msg) {
        this.log(msg, null);
    }

    @Override
    public void log(String msg, Object obj) {
        if (!this.inited) {
            return;
        }
        if (this.traceLevel == null || this.traceLevel == TraceLevel.LEVEL_NO) {
            return;
        }
        if (this.subObject == null) {
            this.innerOutputMsg(msg, obj);
        } else {
            this.subObject.log(msg, obj);
        }
    }

    @Override
    public void log(String msg, Object object, String script, long time) {
        if (!this.inited) {
            return;
        }
        if (this.traceLevel == null || this.traceLevel == TraceLevel.LEVEL_NO) {
            return;
        }
        this.innerOutputMsg(msg, object);
        if (this.scriptTimeMap.containsKey(script)) {
            Long long1 = this.scriptTimeMap.get(script);
            long1 = long1 + time;
            this.scriptTimeMap.put(script, long1);
        } else {
            this.scriptTimeMap.put(script, time);
        }
    }

    @Override
    public void logScritpTime() {
        if (!this.inited) {
            return;
        }
        if (this.traceLevel == null || this.traceLevel == TraceLevel.LEVEL_NO) {
            return;
        }
        this.logScritpTime(3);
    }

    /*
     * WARNING - void declaration
     */
    public void logScritpTime(int scripteSize) {
        void var7_8;
        if (this.scriptTimeMap == null || this.scriptTimeMap.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        LinkedHashMap sortedMap = new LinkedHashMap();
        ArrayList<Map.Entry<String, Long>> entryList = new ArrayList<Map.Entry<String, Long>>(this.scriptTimeMap.entrySet());
        Collections.sort(entryList, (Comparator)new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue() < o2.getValue() ? 1 : (o1.getValue() == o2.getValue() ? 0 : -1);
            }
        });
        for (Map.Entry entry : entryList) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        boolean bl = false;
        Iterator iterator2 = sortedMap.keySet().iterator();
        while (iterator2.hasNext() && var7_8 <= 2) {
            String key = (String)iterator2.next();
            Long time = (Long)sortedMap.get(key);
            this.innerOutputMsg(key + " --> ", time);
            ++var7_8;
        }
        this.innerOutputMsg("sroted script consume time --> ", System.currentTimeMillis() - start);
    }

    @Override
    public void logInfoHead() {
        if (!this.inited) {
            return;
        }
        if (this.getLogger() == null || !this.inited) {
            return;
        }
        if (this.traceLevel == null || this.traceLevel.equals(TraceLevel.LEVEL_NO)) {
            return;
        }
        this.log("", true);
        this.log("*********************************************************************************", true);
        this.log(this.name + " start ", true);
        this.log("*********************************************************************************", true);
    }

    @Override
    public void logInfoFoot() {
        if (!this.inited) {
            return;
        }
        if (this.getLogger() == null || !this.inited) {
            return;
        }
        if (this.traceLevel == null || this.traceLevel.equals(TraceLevel.LEVEL_NO)) {
            return;
        }
        String sResult = "";
        sResult = this.error == null ? "succ" : "faild";
        this.log("*********************************************************************************", true);
        this.log(this.name + " end, time=" + this.getExecTime() + " ms,  result=" + sResult, true);
        this.log("*********************************************************************************", true);
        if (this.error != null) {
            this.log("", true);
            this.realOutputMsg(this.name + " faild.", this.error);
        }
        this.log("", true);
    }

    @Override
    public void error(Throwable e) {
        if (!this.inited) {
            return;
        }
        this.log("### process faild -" + e.getMessage() + " ###", true);
        this.error = e;
        this.endSub();
    }

    public String toString() {
        return super.toString() + "-" + this.name;
    }

    void clearCallTime() {
        this.timeMap.clear();
        this.callNameList.clear();
    }

    public void setCallTime(String name, long time) {
        if (!this.inited) {
            return;
        }
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        long val = 0L;
        if (this.timeMap.containsKey(name)) {
            Long longVal = (Long)this.timeMap.get(name);
            val = longVal;
        } else {
            this.callNameList.add(name);
        }
        this.timeMap.put(name, new Long(val += time));
    }

    @Override
    public long getCallTime(String name) {
        if (!this.inited) {
            return 0L;
        }
        if (StringUtils.isEmpty((String)name) || !this.timeMap.containsKey(name)) {
            return 0L;
        }
        Long longVal = (Long)this.timeMap.get(name);
        return longVal;
    }

    @Override
    public List getCallNameList() {
        return this.callNameList;
    }

    public static ThreadLocal<String> getLoggerLocal() {
        return loggerLocal;
    }
}

