/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.MappingUtil;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpExtConfigHelper;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BotpHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.botp.BotpHelper");

    public static IObjectValue getObjectById(Context ctx, String id) throws BOSException, BOTPException {
        BOSUuid uuid = BOSUuid.read((String)id);
        BOSObjectType bosType = uuid.getType();
        return BotpHelper.getObjectByIdWithBosType(ctx, id, bosType);
    }

    private static IObjectValue getObjectByIdWithBosType(Context ctx, String id, BOSObjectType bosType) throws BOSException, ObjectNotFoundException, BOTPException {
        try {
            IObjectValue ov;
            if (ctx != null) {
                ov = BOTObjectCache.getInstance(ctx).get(bosType, id);
            } else {
                IDynamicObject ido = DynamicObjectFactory.getRemoteInstance();
                ov = ido.getValue(bosType, (IObjectPK)new ObjectUuidPK(id));
            }
            if (!ov.getBOSType().equals((Object)bosType)) {
                Connection cn = null;
                BOSUuid uuid = BOSUuid.read((String)id);
                ObjectUuidPK pk = new ObjectUuidPK(uuid);
                try {
                    cn = EJBFactory.getConnection((Context)ctx);
                    IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)bosType, (Context)ctx, (Connection)cn);
                    ov = dao.getValue((IObjectPK)pk);
                }
                catch (SQLException sqle) {
                    throw new SQLAccessException(sqle);
                }
                catch (ObjectNotFoundException da) {
                    throw da;
                }
                finally {
                    SQLUtils.cleanup((Connection)cn);
                }
            }
            return ov;
        }
        catch (ObjectNotFoundException e) {
            String entityAlias;
            try {
                IBTPManager iBtpMgr = ctx != null ? BTPManagerFactory.getLocalInstance(ctx) : BTPManagerFactory.getRemoteInstance();
                entityAlias = iBtpMgr.getEntityObjectInfoDisplayName(bosType.toString());
            }
            catch (Exception extraEx) {
                throw e;
            }
            BOTPException botpEx = new BOTPException(BOTPException.DATABASEIDNOTEXIST, new Object[]{entityAlias, id});
            botpEx.setStackTrace(e.getStackTrace());
            throw botpEx;
        }
    }

    public static IObjectValue getObjectByIdWithBosType(Context ctx, String id, String orgType) throws BOTPException, ObjectNotFoundException, BOSException {
        BOSObjectType bosType = BOSObjectType.create((String)orgType);
        return BotpHelper.getObjectByIdWithBosType(ctx, id, bosType);
    }

    public static BOSObjectType getSrcBillBosType(Context ctx, String id) throws BOSException {
        BOSObjectType bosType = null;
        String sqlToGetSrcBosType = "SELECT M.FSRCENTITYNAME FROM T_BOT_MAPPING M JOIN T_BOT_RELATION R ON M.FID=R.FBOTMAPPINGID WHERE R.FSRCOBJECTID = ?";
        IRowSet rsToGetSrcBosType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetSrcBosType, (Object[])new Object[]{id});
        try {
            String srcBosType;
            if (rsToGetSrcBosType.next() && (srcBosType = rsToGetSrcBosType.getString("FSRCENTITYNAME")) != null && srcBosType.length() > 0) {
                bosType = BOSObjectType.create((String)srcBosType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bosType == null) {
            BOSUuid uuid = BOSUuid.read((String)id);
            bosType = uuid.getType();
        }
        return bosType;
    }

    public static BOSObjectType getDestBillBosType(Context ctx, String id) throws BOSException {
        BOSObjectType bosType = null;
        String sqlToGetSrcBosType = "SELECT M.FDESTENTITYNAME FROM T_BOT_MAPPING M JOIN T_BOT_RELATION R ON M.FID=R.FBOTMAPPINGID WHERE R.FSRCOBJECTID = ?";
        IRowSet rsToGetSrcBosType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetSrcBosType, (Object[])new Object[]{id});
        try {
            String srcBosType;
            if (rsToGetSrcBosType.next() && (srcBosType = rsToGetSrcBosType.getString("FSRCENTITYNAME")) != null && srcBosType.length() > 0) {
                bosType = BOSObjectType.create((String)srcBosType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bosType == null) {
            BOSUuid uuid = BOSUuid.read((String)id);
            bosType = uuid.getType();
        }
        return bosType;
    }

    public static IObjectValue getSrcObjectById(Context ctx, String id) throws BOSException {
        IObjectValue ov;
        BOSObjectType bosType = null;
        String sqlToGetSrcBosType = "SELECT M.FSRCENTITYNAME FROM T_BOT_MAPPING M JOIN T_BOT_RELATION R ON M.FID=R.FBOTMAPPINGID WHERE R.FSRCOBJECTID = ?";
        IRowSet rsToGetSrcBosType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetSrcBosType, (Object[])new Object[]{id});
        try {
            String srcBosType;
            if (rsToGetSrcBosType.next() && (srcBosType = rsToGetSrcBosType.getString("FSRCENTITYNAME")) != null && srcBosType.length() > 0) {
                bosType = BOSObjectType.create((String)srcBosType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bosType == null) {
            BOSUuid uuid = BOSUuid.read((String)id);
            bosType = uuid.getType();
        }
        if (ctx != null) {
            ov = BOTObjectCache.getInstance(ctx).get(bosType, id);
        } else {
            IDynamicObject ido = DynamicObjectFactory.getRemoteInstance();
            ov = ido.getValue(bosType, (IObjectPK)new ObjectUuidPK(id));
        }
        return ov;
    }

    public static IObjectValue getDestObjectById(Context ctx, String id) throws BOSException {
        IObjectValue ov;
        BOSObjectType bosType = null;
        String sqlToGetSrcBosType = "SELECT M.FDESTENTITYNAME FROM T_BOT_MAPPING M JOIN T_BOT_RELATION R ON M.FID=R.FBOTMAPPINGID WHERE R.FSRCOBJECTID = ?";
        IRowSet rsToGetSrcBosType = DbUtil.executeQuery((Context)ctx, (String)sqlToGetSrcBosType, (Object[])new Object[]{id});
        try {
            String srcBosType;
            if (rsToGetSrcBosType.next() && (srcBosType = rsToGetSrcBosType.getString("FSRCENTITYNAME")) != null && srcBosType.length() > 0) {
                bosType = BOSObjectType.create((String)srcBosType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (bosType == null) {
            BOSUuid uuid = BOSUuid.read((String)id);
            bosType = uuid.getType();
        }
        if (ctx != null) {
            ov = BOTObjectCache.getInstance(ctx).get(bosType, id);
        } else {
            IDynamicObject ido = null;
            ido = DynamicObjectFactory.getRemoteInstance();
            ov = ido.getValue(bosType, (IObjectPK)new ObjectUuidPK(id));
        }
        return ov;
    }

    public static IObjectValue getObjectById(Context ctx, String id, SelectorItemCollection selectors) throws BOSException {
        IObjectValue ov;
        if (ctx != null) {
            ov = BOTObjectCache.getInstance(ctx).get(id);
        } else {
            BOSUuid uuid = BOSUuid.read((String)id);
            BOSObjectType bosType = uuid.getType();
            IDynamicObject ido = DynamicObjectFactory.getRemoteInstance();
            ov = ido.getValue(bosType, (IObjectPK)new ObjectUuidPK(id), selectors);
        }
        return ov;
    }

    public static QueryFilterInfo getCurrentCUFilterForQuery(Context ctx) {
        QueryFilterInfo filterInfo = new QueryFilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filterInfo;
        }
        filterInfo.getFilterItems().add(new QueryFilterItemInfo(filterInfo, "CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));
        return filterInfo;
    }

    public static QueryFilterInfo MergeCommonQuery(Context ctx, QueryFilterInfo queryFilter) throws BOSException {
        QueryFilterInfo filterCU = BotpHelper.getCurrentCUFilterForQuery(ctx);
        if (queryFilter != null) {
            if (filterCU != null) {
                if (queryFilter != null && queryFilter.getFilterItems().size() > 0) {
                    queryFilter.mergeFilter(filterCU, "AND");
                } else {
                    queryFilter.addFilterItem(filterCU);
                }
            }
        } else {
            return filterCU;
        }
        return queryFilter;
    }

    public static SelectorItemCollection getBOTPSelectors(BOTMappingInfo mappingInfo) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (mappingInfo == null) {
            return sic;
        }
        List autoSelectors = new ArrayList();
        ArrayList<String> sysSelectors = new ArrayList<String>();
        ArrayList<String> userSelectors = new ArrayList<String>();
        HashSet<String> goodSelectors = new HashSet<String>();
        String extconfig = mappingInfo.getExtConfig();
        BotpExtConfigHelper.ExtConfigInfo info = mappingInfo.getExtConfigInfo();
        autoSelectors = BotUtil.getSrcBillPropList(mappingInfo);
        if (info != null) {
            String selectorsString = info.getSelectors();
            String userSelectorsString = info.getUserSelectors();
            if (selectorsString == null || selectorsString.equals("")) {
                Collections.sort(autoSelectors);
                if (autoSelectors != null && autoSelectors.size() > 0) {
                    for (int i = 0; i < autoSelectors.size(); ++i) {
                        sic.add(autoSelectors.get(i).toString());
                    }
                }
                return sic;
            }
            String[] selectorsArray = selectorsString.split(",");
            for (int j = 0; j < selectorsArray.length; ++j) {
                sysSelectors.add(selectorsArray[j]);
            }
            if (userSelectorsString != null && !userSelectorsString.equals("")) {
                String[] userSelectorsArray = userSelectorsString.split(",");
                for (int j = 0; j < userSelectorsArray.length; ++j) {
                    userSelectors.add(userSelectorsArray[j]);
                }
            }
            goodSelectors.addAll(sysSelectors);
            goodSelectors.addAll(userSelectors);
            goodSelectors.addAll(autoSelectors);
            for (String property : goodSelectors) {
                sic.add(property);
            }
        } else {
            Collections.sort(autoSelectors);
            if (autoSelectors != null && autoSelectors.size() > 0) {
                for (int i = 0; i < autoSelectors.size(); ++i) {
                    sic.add(autoSelectors.get(i).toString());
                }
            }
            return sic;
        }
        return sic;
    }

    public static SelectorItemCollection getBOTPSelectors(Context ctx, BOTMappingInfo mappingInfo) throws Exception {
        SelectorItemCollection sic = BotpHelper.getBOTPSelectors(mappingInfo);
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo srcEntity = MappingUtil.getSrcEntity(mappingInfo, loader);
            String propertyName = "";
            SelectorItemInfo selector = null;
            PropertyInfo propertyInfo = null;
            PropertyInfo entryProperty = null;
            PropertyInfo fieldProperty = null;
            EntityObjectInfo entryEntity = null;
            String[] propertyArray = null;
            LinkPropertyInfo linkProperty = null;
            RelationshipInfo relationship = null;
            for (int i = 0; i < sic.size(); ++i) {
                selector = sic.get(i);
                propertyName = selector.getPropertyName();
                if (propertyName.indexOf(".") > -1 && propertyName.indexOf(".") == propertyName.lastIndexOf(".")) {
                    propertyArray = propertyName.split("\\.");
                    entryProperty = srcEntity.getPropertyByNameRuntime(propertyArray[0]);
                    linkProperty = (LinkPropertyInfo)entryProperty;
                    relationship = linkProperty.getRelationship();
                    if (relationship.isReverseLink(srcEntity) || !Boolean.TRUE.toString().equalsIgnoreCase(entryProperty.getExtendedProperty("isEntries")) && (relationship == null || relationship.getClientObject() == null || !RelationshipType.COMPOSITION.equals((Object)relationship.getType()) || !CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality()) || !CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) && !CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality())) || (fieldProperty = (entryEntity = ((LinkPropertyInfo)entryProperty).getRelationship().getSupplierObject()).getPropertyByNameRuntime(propertyArray[1])) == null || !(fieldProperty instanceof LinkPropertyInfo)) continue;
                    linkProperty = (LinkPropertyInfo)fieldProperty;
                    relationship = linkProperty.getRelationship();
                    if (!fieldProperty.isConfigured() || (!RelationshipType.COMPOSITION.equals((Object)relationship.getType()) || !CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getSupplierCardinality())) continue;
                    propertyName = propertyName + ".*";
                    selector.setPropertyName(propertyName);
                    logger.info((Object)("[BOTP]change dep f7 selectors:" + propertyName));
                    continue;
                }
                if (propertyName.indexOf(".") != -1 || (propertyInfo = srcEntity.getPropertyByNameRuntime(propertyName)) == null || !(propertyInfo instanceof LinkPropertyInfo)) continue;
                linkProperty = (LinkPropertyInfo)propertyInfo;
                relationship = linkProperty.getRelationship();
                if (!propertyInfo.isConfigured() || (!RelationshipType.COMPOSITION.equals((Object)relationship.getType()) || !CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && !CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getSupplierCardinality())) continue;
                propertyName = propertyName + ".*";
                selector.setPropertyName(propertyName);
                logger.info((Object)("[BOTP]change dep f7 selectors:" + propertyName));
            }
        }
        catch (Exception e) {
            logger.error((Object)("[BOTP]fail to add dep f7 selectors. mappingID:" + mappingInfo.getId()), (Throwable)e);
        }
        return sic;
    }
}

