/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class BOTPDBlockTools {
    private static volatile BOTPDBlockTools instance;
    private static Logger logger;
    private static int TIME_INTERVAL;
    private static boolean hasRelease;
    public static String EAS_INSTANCE_NAME;
    public static String EAS_INSTANCE_HOME;

    private BOTPDBlockTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BOTPDBlockTools getInstance() {
        if (instance != null) return instance;
        Class<BOTPDBlockTools> clazz = BOTPDBlockTools.class;
        synchronized (BOTPDBlockTools.class) {
            if (instance != null) return instance;
            instance = new BOTPDBlockTools();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void releaseOvertimeDBLock() {
        this.releaseOvertimeDBLock(null);
    }

    public void releaseOvertimeDBLock(Context ctx) {
        try {
            Object params;
            if (ctx == null && (ctx = ContextUtils.getContextFromSessionNoException()) == null) {
                logger.error((Object)"[BOTPDBlockTools] unable to init BOTPDBlockTools");
                return;
            }
            if (hasRelease) {
                return;
            }
            if (ctx == null) {
                logger.error((Object)"[BOTPDBlockTools] unable to init BOTPDBlockTools,ctx is null!");
                return;
            }
            hasRelease = true;
            SimpleDateFormat dateFormatTemp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.error((Object)("------------selectAndClear overtime DBLock----------" + dateFormatTemp.format(new Date()) + "; " + System.getProperty(EAS_INSTANCE_NAME)));
            String sql = "SELECT FID,FDATE FROM T_BOT_DBLock WHERE FSERVER = ?";
            ArrayList<String> lockList = null;
            try {
                lockList = new ArrayList<String>();
                params = new Object[]{System.getProperty(EAS_INSTANCE_NAME)};
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                String str = null;
                while (rowSet.next()) {
                    str = rowSet.getString("FID");
                    lockList.add(str);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"[BOTPDBlockTools] fail to get DBLock!", (Throwable)e);
            }
            catch (SQLException e) {
                logger.error((Object)"[BOTPDBlockTools] fail to get DBLock!", (Throwable)e);
            }
            if (lockList == null || lockList.size() == 0) {
                return;
            }
            params = new ArrayList();
            for (int i = 0; i < lockList.size(); ++i) {
                String lockId = (String)lockList.get(i);
                params.add(lockId);
            }
            String deleteSql = "DELETE FROM T_BOT_DBLOCK WHERE FID = ?";
            try {
                DbUtil.executeBatch((Context)ctx, (String)deleteSql, (List)params);
            }
            catch (SQLDataException e) {
                logger.error((Object)"[BOTPDBlockTools] fail to delete Overtime lock!", (Throwable)e);
            }
            logger.error((Object)"------------have done! Clear overtime DBLock----------");
        }
        catch (Exception e) {
            logger.error((Object)"[BOTPDBlockTools]fail to initialize BTPManager/DAPTransformer! failt to release overtime DBLock!", (Throwable)e);
        }
    }

    public boolean requestDBLockOnSrcTable(Context ctx, IMetaDataLoader loader, String srcID) {
        String srcID2 = "";
        if (!StringUtils.isEmpty((String)srcID) && srcID.endsWith("/BOTP")) {
            srcID2 = srcID.substring(0, srcID.lastIndexOf("/BOTP"));
        } else if (!StringUtils.isEmpty((String)srcID) && srcID.endsWith("/DAP")) {
            srcID2 = srcID.substring(0, srcID.lastIndexOf("/DAP"));
        }
        String sql = "";
        ArrayList<String> params = new ArrayList<String>();
        try {
            EntityObjectInfo entity = loader.getEntity(BOSUuid.read((String)srcID2).getType());
            String tableName = entity.getTable().getName();
            sql = "UPDATE " + tableName + " SET FID = FID where FID = ?";
            params.add(srcID2);
        }
        catch (UuidException e1) {
            logger.error((Object)"fail to get srcEntity and Table.", (Throwable)e1);
            return false;
        }
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params.toArray());
        }
        catch (Exception e) {
            logger.error((Object)("fail to get DBLock on SrcTable. SQL:" + sql + "; SrdId:" + srcID2), (Throwable)e);
            return false;
        }
        return true;
    }

    static {
        logger = Logger.getLogger(BOTPDBlockTools.class);
        TIME_INTERVAL = 10800000;
        hasRelease = false;
        EAS_INSTANCE_NAME = "EAS_INSTANCE_NAME";
        EAS_INSTANCE_HOME = "EAS_INSTANCE_HOME";
    }
}

