/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BotpScriptUtils {
    private static Logger logger = Logger.getLogger(BotpScriptUtils.class);

    public List getPropertyValueByScript(IObjectCollection srcObjCols, EntityObjectInfo srcEntity, List names) throws BOSException {
        ArrayList list = new ArrayList();
        if (names == null || names.size() <= 0) {
            return list;
        }
        List entryNameList = this.getEntryNameListByEntity(srcEntity, names);
        int n = srcObjCols.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue srcObj = srcObjCols.getObject(i);
            List val = this.getPropertyValueByScript(srcObj, names, entryNameList);
            if (val == null || val.size() <= 0) continue;
            list.addAll(val);
        }
        return list;
    }

    private List getEntryNameListByEntity(EntityObjectInfo srcEntity, List arrNameList) throws BOSException {
        EntityEntryStructure srcEntryStructure = new EntityEntryStructure(1, srcEntity, null);
        Map srcEntryStructureMap = srcEntryStructure.buildHorizontalStructure("__src");
        ArrayList<String> srcEntryNameList = new ArrayList<String>();
        for (String entryName : srcEntryStructureMap.keySet()) {
            if (!this.checkEntryNameExist(entryName = entryName.replaceAll("__src.", ""), arrNameList)) continue;
            srcEntryNameList.add(entryName);
        }
        return srcEntryNameList;
    }

    private boolean checkEntryNameExist(String entryName, List arrNameList) {
        if (StringUtils.isEmpty((String)entryName)) {
            return false;
        }
        for (int i = 0; i < arrNameList.size(); ++i) {
            String[] arrName;
            String nameStr = (String)arrNameList.get(i);
            if (StringUtils.isEmpty((String)nameStr) || (arrName = nameStr.split("\\.")).length <= 1) continue;
            for (int j = 1; j < arrName.length - 1; ++j) {
                String name = arrName[j];
                if (!entryName.equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    private List getPropertyValueByScript(IObjectValue srcObj, List arrNameList, List entryNameList) throws BOSException {
        ArrayList valList = new ArrayList();
        if (arrNameList == null || arrNameList.size() <= 0) {
            return valList;
        }
        HashMap<String, IObjectValue> srcMap = new HashMap<String, IObjectValue>();
        HashMap valMap = new HashMap();
        srcMap.put("__src", srcObj);
        this.iteratorEntryGetPropertyValue(srcObj, valList, srcMap, valMap, arrNameList, entryNameList, 0);
        return valList;
    }

    private void iteratorEntryGetPropertyValue(IObjectValue srcObj, List valueList, Map srcMap, Map valMap, List arrNameList, List entryNameList, int nIndex) throws BOSException {
        if (valueList == null) {
            return;
        }
        if (nIndex == entryNameList.size()) {
            List val = this.realGetEntityPropertyValue(srcObj, srcMap, valMap, arrNameList, entryNameList);
            if (val != null && val.size() > 0) {
                valueList.add(val);
            }
        } else {
            String entryName = (String)entryNameList.get(nIndex);
            Object entryObjCols = null;
            String[] levels = entryName.split("\\.");
            if (levels.length >= 3 && srcMap.size() > 1) {
                HashMap temp = new HashMap();
                String srcKey = levels[0] + "." + levels[levels.length - 2];
                String entryKey = levels[0] + "." + levels[levels.length - 1];
                if (srcMap.get(srcKey) != null && srcMap.get(srcKey) instanceof IObjectValue) {
                    IObjectValue tmpSrcObj = (IObjectValue)srcMap.get(srcKey);
                    entryObjCols = tmpSrcObj.get(entryKey);
                }
            } else {
                entryObjCols = srcObj.get(entryName);
            }
            if (entryObjCols != null && entryObjCols instanceof IObjectCollection) {
                IObjectCollection objColl = (IObjectCollection)entryObjCols;
                if (objColl.size() > 0) {
                    for (int i = 0; i < objColl.size(); ++i) {
                        IObjectValue entryObj = objColl.getObject(i);
                        srcMap.put(entryName, entryObj);
                        this.iteratorEntryGetPropertyValue(srcObj, valueList, srcMap, valMap, arrNameList, entryNameList, nIndex + 1);
                    }
                } else {
                    this.iteratorEntryGetPropertyValue(srcObj, valueList, srcMap, valMap, arrNameList, entryNameList, nIndex + 1);
                }
            }
        }
    }

    private List realGetEntityPropertyValue(IObjectValue srcObj, Map srcMap, Map valMap, List arrNameList, List entryNameList) throws BOSException {
        ArrayList<Object> valList = new ArrayList<Object>();
        try {
            for (int i = 0; i < arrNameList.size(); ++i) {
                String propName;
                String entryName;
                String name = (String)arrNameList.get(i);
                if (name.indexOf("__src") == -1) {
                    valList.add(name);
                    continue;
                }
                String[] arrName = name.split("\\.");
                Object val = null;
                IObjectValue currObj = srcObj;
                for (int j = 0; j < arrName.length - 1 && ("__src".equalsIgnoreCase(entryName = arrName[j]) || (currObj = (IObjectValue)srcMap.get(entryName) == null ? (IObjectValue)currObj.get(entryName) : (IObjectValue)srcMap.get(entryName)) != null); ++j) {
                }
                if (currObj == null || (val = currObj.get(propName = arrName[arrName.length - 1])) == null) continue;
                valList.add(val);
            }
            if (valList.size() == arrNameList.size()) {
                return valList;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private List innerGetPropertyValueByScript(int nLevel, IObjectValue srcObj, List arrNameList, Object[] arrVal) throws BOSException {
        ArrayList valList = new ArrayList();
        try {
            List currLevelNameList = BotpScriptUtils.getSpecLevelNamesList(nLevel, arrNameList);
            List nextLevelNameList = BotpScriptUtils.getSpecLevelNamesList(nLevel + 1, arrNameList);
            for (int i = 0; i < currLevelNameList.size(); ++i) {
                if (currLevelNameList.get(i) == null || arrVal[i] != null) continue;
                String currName = (String)currLevelNameList.get(i);
                Object val = srcObj.get(currName);
                if (nextLevelNameList.get(i) == null) {
                    arrVal[i] = val;
                    continue;
                }
                if (!(val instanceof IObjectValue)) {
                    throw new IllegalArgumentException("arrNameList[" + i + "] = " + arrNameList.get(i) + ",  currName=" + currName + ", val=" + val);
                }
                IObjectValue nextObj = (IObjectValue)val;
                List list = this.innerGetPropertyValueByScript(nLevel++, nextObj, arrNameList, arrVal);
            }
            ArrayList<Object> valList2 = new ArrayList<Object>();
            for (int i = 0; i < arrNameList.size(); ++i) {
                valList2.add(arrVal[i]);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return valList;
    }

    private static List getSpecLevelNamesList(int nLevel, List arrNameList) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        if (arrNameList == null || arrNameList.size() <= 0) {
            return list;
        }
        for (int i = 0; i < arrNameList.size(); ++i) {
            String[] arrName = (String[])arrNameList.get(i);
            if (nLevel < arrName.length) {
                String nameStr = arrName[nLevel];
                list.add(nameStr);
                continue;
            }
            list.add(null);
        }
        return list;
    }

    private class EntityEntryStructure {
        private static final String ISENTRIES = "isEntries";
        private int level;
        private EntityObjectInfo entryEntity;
        private EntityEntryStructure owner;
        private Map entryVerticalMap;

        public EntityEntryStructure(int level, EntityObjectInfo entity, EntityEntryStructure owner) {
            this.level = level;
            this.entryEntity = entity;
            this.owner = owner;
            this.buildVerticalStructure();
        }

        public Map buildHorizontalStructure(String prefix) {
            HashMap entryHorizontalMap = new HashMap();
            this.transformVerticalToHorizonStructure(prefix, this.entryVerticalMap, entryHorizontalMap);
            return entryHorizontalMap;
        }

        private void transformVerticalToHorizonStructure(String prefix, Map entryVerticalMap, Map entryHorizontalMap) {
            Set key = entryVerticalMap.keySet();
            for (String propName : key) {
                EntityEntryStructure entry = (EntityEntryStructure)entryVerticalMap.get(propName);
                String entryPrefix = prefix == null ? propName : prefix + "." + propName;
                entryHorizontalMap.put(entryPrefix, entry);
                this.transformVerticalToHorizonStructure(entryPrefix, entry.entryVerticalMap, entryHorizontalMap);
            }
        }

        private void buildVerticalStructure() {
            this.entryVerticalMap = new HashMap();
            PropertyCollection props = this.entryEntity.getInheritedNoDuplicatedProperties();
            for (PropertyInfo propInfo : props) {
                RelationshipInfo relation;
                if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty(ISENTRIES))) continue;
                EntityObjectInfo relateEntity = null;
                if (relation.getClientObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getSupplierObject();
                } else if (relation.getSupplierObject().getFullName().equals(this.entryEntity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                    relateEntity = relation.getClientObject();
                }
                if (relateEntity == null) continue;
                EntityEntryStructure entryInfo = new EntityEntryStructure(this.level + 1, relateEntity, this);
                this.entryVerticalMap.put(propInfo.getName(), entryInfo);
            }
        }
    }
}

