/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgInfo;
import com.kingdee.eas.base.codingrule.DirectionType;
import com.kingdee.eas.base.codingrule.SegmentStateEnum;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryCollection;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryInfo;
import com.kingdee.eas.base.codingrule.SeqSegmentInfo;
import com.kingdee.eas.base.codingrule.app.CodingRuleDAO;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class CodingRuleAppUtils {
    private static Logger logger = Logger.getLogger(CodingRuleAppUtils.class);
    public static final String strResource = "com.kingdee.eas.base.codingrule.CodingRuleResource.";
    public static final String defaultSortItemValue = "codingrule_maxserial";
    public static final String codingrule_ex = "isBindingProperty";

    private CodingRuleAppUtils() {
    }

    public static int getCheckNumber(String num) throws CodingRuleException {
        int i;
        num = num + "0";
        int numSect1 = 1;
        int numSect2 = 2;
        int length = num.length();
        try {
            numSect1 = Integer.parseInt(num.substring(length - 6, length));
            numSect2 = Integer.parseInt(num.substring(0, length - 6));
        }
        catch (NumberFormatException e) {
            throw new CodingRuleException(CodingRuleException.ERROR_CK_INVALIDCHAR);
        }
        int sum1 = 0;
        int sum2 = 0;
        for (i = 1; i <= 6; ++i) {
            if (i % 2 == 0) {
                sum2 += numSect1 % 10;
            } else {
                sum1 += numSect1 % 10;
            }
            numSect1 /= 10;
        }
        for (i = 7; i <= length; ++i) {
            if (i % 2 == 0) {
                sum2 += numSect2 % 10;
            } else {
                sum1 += numSect2 % 10;
            }
            numSect2 /= 10;
        }
        int sum = sum2 * 3 + sum1;
        return (10 - sum % 10) % 10;
    }

    public static SeqSegmentEntryInfo getSegmentEntry(String attrValue, CodingRuleInfo cr) throws CodingRuleException, EASBizException, BOSException {
        SeqSegmentInfo segInfo = cr.getSeqSegment();
        if (attrValue == null || attrValue.trim().length() == 0) {
            return null;
        }
        SeqSegmentEntryCollection segInfos = segInfo.getEntries();
        SeqSegmentEntryInfo entryInfo = null;
        for (int index = 0; index < segInfos.size(); ++index) {
            entryInfo = segInfos.get(index);
            if (attrValue.equalsIgnoreCase(entryInfo.getAttrValue()) && entryInfo.getUsedNum() < entryInfo.getEndNum()) continue;
            entryInfo = null;
        }
        return entryInfo;
    }

    public static String getPropertyValue(String propertyName, IObjectValue caller) throws BOSException, CodingRuleException, EASBizException {
        logger.debug((Object)"checkProperty : ");
        logger.debug((Object)("   propertyName : " + propertyName));
        String returnStr = null;
        String[] properties = propertyName.split("\\.");
        if (properties.length == 1) {
            if (!caller.containsKey(properties[0])) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_PROPERTY_NOTEXIST, new Object[]{properties[0]});
            }
            logger.debug((Object)("   propertyValue : " + caller.get(properties[0]).toString().trim()));
            returnStr = caller.get(propertyName).toString();
        } else if (properties.length == 2) {
            logger.debug((Object)("   property[0] : " + properties[0]));
            logger.debug((Object)("   property[1] : " + properties[1].toString().trim()));
            logger.debug((Object)("   caller.getClass().getName() : " + caller.getClass().getName()));
            if (!caller.containsKey(properties[0])) {
                logger.error((Object)("\u503c\u5bf9\u8c61\u4e2d\u6ca1\u6709\u6b64\u5206\u6bb5\u5c5e\u6027:" + properties[0]));
                Object[] params = new String[]{properties[0]};
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_PROPERTY_NOTEXIST, params);
            }
            Object obj = caller.get(properties[0]);
            logger.debug((Object)("properties[0]: " + properties[0]));
            if (!(obj instanceof IObjectValue)) {
                logger.debug((Object)("obj.getClass().getName(): " + obj.getClass().getName()));
                throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_INVALID);
            }
            IObjectValue propertyObj = (IObjectValue)obj;
            if (!propertyObj.containsKey(properties[1])) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_PROPERTY_NOTEXIST, new Object[]{properties[1]});
            }
            if (propertyObj.get(properties[1]) instanceof IObjectValue) {
                throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_INVALID);
            }
            returnStr = propertyObj.get(properties[1]).toString();
        } else {
            if (properties.length > 2) {
                throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_INVALID);
            }
            if (properties.length == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_NULL);
            }
        }
        return returnStr;
    }

    public static CodingRuleInfo createCodingRuleInfo(Context ctx, RowSet rowset) throws BOSException {
        boolean first = true;
        CodingRuleInfo info = null;
        BindingPropertyInfo bindingproperty = null;
        Object ec = null;
        CodingRuleEntryInfo entry = null;
        Object orgUnit = null;
        FullOrgUnitInfo fOrgUnit = null;
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                if (first) {
                    RowSet tmpRowset;
                    String sst;
                    info = new CodingRuleInfo();
                    info.setId(BOSUuid.read((String)rowset.getString("FID")));
                    info.setName(rowset.getString("FName_" + ctx.getLocale().toString()));
                    info.setNumber(rowset.getString("FNumber"));
                    info.setBusinessObject(rowset.getString("FBusinessObject"));
                    info.setBusinessObjectID(rowset.getString("FBusinessObjectID"));
                    info.setOrg(rowset.getString("FOrgType"));
                    info.setSplitSign(rowset.getString("FSplitSign"));
                    info.setRuleType(rowset.getInt("FRuleType"));
                    info.setIsEnabled(rowset.getBoolean("FIsEnabled"));
                    info.setEnabledDate(rowset.getDate("FEnabledDate"));
                    info.setDisabledDate(rowset.getDate("FDisabledDate"));
                    info.setGroupFirst(rowset.getBoolean("FGroupFirst"));
                    info.setOrgFirst(rowset.getBoolean("FOrgFirst"));
                    info.setMultiOrgFirst(rowset.getBoolean("FMultiOrgFirst"));
                    info.setIsModifiable(rowset.getBoolean("FisModifiable"));
                    info.setIsAddView(rowset.getBoolean("FisAddView"));
                    info.setIsUserSelect(rowset.getBoolean("FisUserSelect"));
                    if (rowset.getInt("FIsMainRule") == 1) {
                        info.setIsMainRule(true);
                    } else {
                        info.setIsMainRule(false);
                    }
                    if (rowset.getString("FBPID") != null) {
                        bindingproperty = new BindingPropertyInfo();
                        bindingproperty.setId(BOSUuid.read((String)rowset.getString("FBPID")));
                        bindingproperty.setPropertyName(rowset.getString("FPropertyName"));
                        bindingproperty.setPropertyValue(rowset.getString("FPropertyValue"));
                        bindingproperty.setUserValue(rowset.getString("FUserValue"));
                        info.setBindingProperty(bindingproperty);
                    }
                    if ((sst = rowset.getString("FSeqSegmentID")) != null && sst.trim().length() > 0) {
                        tmpRowset = CodingRuleDAO.getCodingRuleSegmentInfoValueByID(ctx, sst);
                        SeqSegmentInfo sInfo = CodingRuleAppUtils.createCodingRuleSegmentInfo(ctx, tmpRowset);
                        info.setSeqSegment(sInfo);
                    }
                    if (info.isMultiOrgFirst()) {
                        tmpRowset = CodingRuleDAO.getCodingRuleMultiOrgInfo(ctx, info.getId().toString());
                        CodingRuleAppUtils.createMutiOrgInfo(ctx, info, tmpRowset);
                    }
                    first = false;
                }
                entry = new CodingRuleEntryInfo();
                entry.setId(BOSUuid.read((String)rowset.getString("EntryID")));
                entry.setSerialNumber(rowset.getInt("FSerialNumber"));
                entry.setCodeSerialNumber(1);
                entry.setCodeAttribute(rowset.getString("FCodeAttribute"));
                entry.setValueAttribute(rowset.getString("FValueAttribute"));
                entry.setAttUsingMode(rowset.getString("FAttUsingMode"));
                entry.setFormat(rowset.getString("FFormat"));
                entry.setStep(rowset.getInt("FStep"));
                entry.setLength(rowset.getInt("FLength"));
                entry.setInitial(rowset.getInt("FInitial"));
                entry.setFillSign(rowset.getString("FFillSign"));
                entry.setDescription(rowset.getString("FDescription"));
                entry.setIsSortByItem(rowset.getInt("FIsSortByItem") == 1);
                entry.setIsDisplay(rowset.getInt("FIsDisplay") == 1);
                entry.setIsSplitSign(rowset.getInt("FIsSplitSign") == 1);
                entry.setFillSignDirection(DirectionType.getEnum(rowset.getInt("FFillSignDirection")));
                entry.setInterceptLength(rowset.getInt("FInterceptLength"));
                entry.setInterceptPos(rowset.getInt("FInterceptPos"));
                entry.setInterceptDirection(DirectionType.getEnum(rowset.getInt("FInterceptDirection")));
                entry.setCodingRule(info);
                info.getCodingRuleEntrys().add(entry);
                if (rowset.getString("FAppOrgUnit") == null) continue;
                fOrgUnit = new FullOrgUnitInfo();
                fOrgUnit.setId(BOSUuid.read((String)rowset.getString("FOUID")));
                fOrgUnit.setName(rowset.getString("FName_" + ctx.getLocale().toString()));
                fOrgUnit.setNumber(rowset.getString("FOUNumber"));
                fOrgUnit.setLevel(rowset.getInt("FLevel"));
                fOrgUnit.setLongNumber(rowset.getString("FLongNumber"));
                fOrgUnit.setIsFreeze(rowset.getBoolean("FIsFreeze"));
                fOrgUnit.setIsCompanyOrgUnit(rowset.getBoolean("FIsCompanyOrgUnit"));
                fOrgUnit.setIsAdminOrgUnit(rowset.getBoolean("FIsAdminOrgUnit"));
                fOrgUnit.setIsSaleOrgUnit(rowset.getBoolean("FIsSaleOrgUnit"));
                fOrgUnit.setIsPurchaseOrgUnit(rowset.getBoolean("FIsPurchaseOrgUnit"));
                fOrgUnit.setIsStorageOrgUnit(rowset.getBoolean("FIsStorageOrgUnit"));
                fOrgUnit.setIsProfitOrgUnit(rowset.getBoolean("FIsProfitOrgUnit"));
                fOrgUnit.setIsCostOrgUnit(rowset.getBoolean("FIsCostOrgUnit"));
                fOrgUnit.setIsCU(rowset.getBoolean("FIsCU"));
                fOrgUnit.setIsUnion(rowset.getBoolean("FIsUnion"));
                info.setAppOrgUnit(fOrgUnit);
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return info;
    }

    public static SeqSegmentInfo createCodingRuleSegmentInfo(Context ctx, RowSet rowset) throws BOSException {
        boolean first = true;
        SeqSegmentInfo info = null;
        Object ec = null;
        SeqSegmentEntryInfo entry = null;
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                if (first) {
                    info = new SeqSegmentInfo();
                    info.setId(BOSUuid.read((String)rowset.getString("FID")));
                    info.setAttrName(rowset.getString("FAttrName"));
                    first = false;
                }
                entry = new SeqSegmentEntryInfo();
                entry.setId(BOSUuid.read((String)rowset.getString("bFID")));
                entry.setAttrValue(rowset.getString("bFAttrValue"));
                entry.setBeginNum(rowset.getLong("bBeginNum"));
                entry.setEndNum(rowset.getLong("bFEndNum"));
                entry.setUsedNum(rowset.getLong("bFUsedNum"));
                entry.setState(SegmentStateEnum.getEnum(rowset.getInt("bFState")));
                entry.setLinkID(rowset.getString("bFLinkID"));
                info.getEntries().add(entry);
            }
            rowset.close();
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return info;
    }

    public static void createMutiOrgInfo(Context ctx, CodingRuleInfo info, RowSet rowset) throws BOSException {
        CodingRuleMultiOrgInfo entry = null;
        FullOrgUnitInfo fOrgUnit = null;
        try {
            rowset.beforeFirst();
            while (rowset.next()) {
                entry = new CodingRuleMultiOrgInfo();
                entry.setId(BOSUuid.read((String)rowset.getString("FID")));
                entry.setCodingrule(info);
                fOrgUnit = new FullOrgUnitInfo();
                fOrgUnit.setId(BOSUuid.read((String)rowset.getString("FOUID")));
                fOrgUnit.setName(rowset.getString("FName_" + ctx.getLocale().toString()));
                fOrgUnit.setNumber(rowset.getString("FOUNumber"));
                fOrgUnit.setLevel(rowset.getInt("FLevel"));
                fOrgUnit.setLongNumber(rowset.getString("FLongNumber"));
                fOrgUnit.setIsFreeze(rowset.getBoolean("FIsFreeze"));
                fOrgUnit.setIsCompanyOrgUnit(rowset.getBoolean("FIsCompanyOrgUnit"));
                fOrgUnit.setIsAdminOrgUnit(rowset.getBoolean("FIsAdminOrgUnit"));
                fOrgUnit.setIsSaleOrgUnit(rowset.getBoolean("FIsSaleOrgUnit"));
                fOrgUnit.setIsPurchaseOrgUnit(rowset.getBoolean("FIsPurchaseOrgUnit"));
                fOrgUnit.setIsStorageOrgUnit(rowset.getBoolean("FIsStorageOrgUnit"));
                fOrgUnit.setIsProfitOrgUnit(rowset.getBoolean("FIsProfitOrgUnit"));
                fOrgUnit.setIsCostOrgUnit(rowset.getBoolean("FIsCostOrgUnit"));
                fOrgUnit.setIsCU(rowset.getBoolean("FIsCU"));
                fOrgUnit.setIsUnion(rowset.getBoolean("FIsUnion"));
                entry.setAppOrgUnit(fOrgUnit);
                entry.setOrgName(fOrgUnit.getName());
                info.getMultiOrg().add(entry);
            }
            rowset.close();
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    public static boolean isInSameTransaction(Context ctx) throws BOSException, EASBizException {
        String infoBosType = String.valueOf(ctx.get((Object)"INFOBOSTYPE"));
        String mustUseLock = ParamManager.getParamValue((Context)ctx, null, (String)"MUST_USE_LOCK");
        logger.info((Object)("\u7f16\u7801\u89c4\u5219\u662f\u5426\u548c\u4e1a\u52a1\u540c\u4e00\u4e2a\u4e8b\u52a1\u6267\u884c:" + mustUseLock + " bostype:" + infoBosType));
        return "true".equalsIgnoreCase(mustUseLock);
    }
}

