/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BaseCommonQueryAppException;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.PermissionChecker;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.app.AbstractQuerySolutionControllerBean;
import com.kingdee.eas.base.commonquery.app.QuerySolutionCacheUtils;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QuerySolutionControllerBean
extends AbstractQuerySolutionControllerBean {
    private static final Logger logger = Logger.getLogger(QuerySolutionControllerBean.class);
    private static final String commonQueryRes = "com.kingdee.eas.base.commonquery.cqResource";
    private static final String DEL_SOLUTION = "delete_solution";
    private static final String ADD_SOLUTION = "add_solution";
    private static final String UPDATE_SOLUTION = "update_solution";
    private static final String MANUAL_DEFAULT_LOGITEM = "manual_default_logitem";
    private static final String METHOD_DESC = "\u5ba2\u6237\u7aef\u64cd\u4f5c";

    @Override
    protected void _checkSameName(Context ctx, QuerySolutionInfo solutionInfo) throws BOSException, EASBizException {
        if (this._existSameName(ctx, solutionInfo)) {
            throw new BaseCommonQueryAppException(BaseCommonQueryAppException.NAME_IS_EXISTED);
        }
    }

    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        super._updatePartial(ctx, model, selector);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, (QuerySolutionInfo)model);
    }

    private void checkSolutionOwner(Context ctx, QuerySolutionInfo solutionInfo) throws BOSException, EASBizException {
        if (!ctx.getCaller().toString().equals(solutionInfo.getOwner().toString()) && !this.isHasEditOtherSolutionPerm(ctx)) {
            throw new BaseCommonQueryAppException(BaseCommonQueryAppException.IS_NOT_SOLUTION_OWNER);
        }
    }

    private boolean isHasEditOtherSolutionPerm(Context ctx) {
        return PermissionChecker.hasEditOtherCQSolutionPerm(ctx);
    }

    protected boolean _existSameName(Context ctx, QuerySolutionInfo solutionInfo) throws BOSException, EASBizException {
        String queryName = solutionInfo.getQueryObjectName();
        IObjectPK userID = ctx.getCaller();
        BOSUuid orgID = QueryUtils.getOrgID(queryName, ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = new FilterItemInfo("name", (Object)solutionInfo.getName());
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("queryObjectName", (Object)queryName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("parentUIName", (Object)solutionInfo.getParentUIName());
        filterInfo.getFilterItems().add(filterItemInfo);
        if (ShareTypeEnum.USER_LEVEL.equals((Object)solutionInfo.getShareType()) || ShareTypeEnum.USER_NOORG_LEVEL.equals((Object)solutionInfo.getShareType())) {
            FilterItemInfo userOrgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(1));
            FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
            FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
            FilterItemInfo userLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(16));
            filterInfo.getFilterItems().add(userOrgLevelFilterItem);
            filterInfo.getFilterItems().add(ownerFilterItem);
            filterInfo.getFilterItems().add(orgFilterItem);
            filterInfo.getFilterItems().add(userLevelFilterItem);
            filterInfo.getFilterItems().add(ownerFilterItem);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND ((#3 AND #4 AND #5 ) OR (#6 AND #7))");
        } else if (solutionInfo.getShareType().equals((Object)ShareTypeEnum.ORG_LEVEL)) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(solutionInfo.getShareType().getValue()));
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            FilterItemInfo orgIsNullFilterItem = new FilterItemInfo("orgID", null);
            filterInfo.getFilterItems().add(orgIsNullFilterItem);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND (#4 OR #5)");
        } else if (solutionInfo.getShareType().equals((Object)ShareTypeEnum.PUBLIC_LEVEL)) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(solutionInfo.getShareType().getValue()));
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 ");
        } else if (solutionInfo.getShareType().equals((Object)ShareTypeEnum.CU_LEVEL)) {
            filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(solutionInfo.getShareType().getValue()));
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4  ");
        }
        if (solutionInfo.getId() != null) {
            filterItemInfo = new FilterItemInfo("id", (Object)solutionInfo.getId().toString(), CompareType.NOTEQUALS);
            FilterInfo idNotFilterInfo = new FilterInfo();
            idNotFilterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.mergeFilter(idNotFilterInfo, "AND");
        }
        return this._exists(ctx, filterInfo);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model;
        this.checkSameName(ctx, solutionInfo);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, solutionInfo);
        if (solutionInfo.isIsUserDefaultSolu()) {
            this.updateOtherUserDefault(ctx, null, solutionInfo.getParentUIName(), solutionInfo.getQueryObjectName());
        }
        IObjectPK appLogId = null;
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        try {
            appLogId = appLog.writeLog(MANUAL_DEFAULT_LOGITEM, ((ObjectUuidPK)pk).getObjectType(), pk, this.getCQResource(ctx, ADD_SOLUTION) + ":" + solutionInfo.toString(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), METHOD_DESC);
        }
        catch (Exception e) {
            logger.error((Object)"writeLog error:", (Throwable)e);
        }
        super._addnew(ctx, pk, model);
        appLog.upateLogStatus(appLogId);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model;
        this.checkSameName(ctx, solutionInfo);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, solutionInfo);
        if (solutionInfo.isIsUserDefaultSolu()) {
            this.updateOtherUserDefault(ctx, null, solutionInfo.getParentUIName(), solutionInfo.getQueryObjectName());
        }
        IObjectPK appLogId = null;
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        try {
            appLogId = appLog.writeLog(MANUAL_DEFAULT_LOGITEM, solutionInfo.getBOSType(), null, this.getCQResource(ctx, ADD_SOLUTION) + ":" + solutionInfo.toString(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), METHOD_DESC);
        }
        catch (Exception e) {
            logger.error((Object)"writeLog error:", (Throwable)e);
        }
        IObjectPK addewPK = super._addnew(ctx, model);
        appLog.upateLogStatus(appLogId);
        return addewPK;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        QuerySolutionInfo solutionInfo = (QuerySolutionInfo)model;
        this.checkSameName(ctx, solutionInfo);
        this.checkSolutionOwner(ctx, solutionInfo);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, solutionInfo);
        QuerySolutionInfo oldSolutionInfo = this.getQuerySolutionInfo(ctx, pk);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, oldSolutionInfo);
        if (solutionInfo.isIsUserDefaultSolu()) {
            this.updateOtherUserDefault(ctx, StringUtils.cnulls((Object)solutionInfo.getId()), solutionInfo.getParentUIName(), solutionInfo.getQueryObjectName());
        }
        IObjectPK appLogId = null;
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        try {
            appLogId = appLog.writeLog(MANUAL_DEFAULT_LOGITEM, ((ObjectUuidPK)pk).getObjectType(), pk, this.getCQResource(ctx, UPDATE_SOLUTION) + ":" + solutionInfo.toString(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), METHOD_DESC);
        }
        catch (Exception e) {
            logger.error((Object)"writeLog error:", (Throwable)e);
        }
        super._update(ctx, pk, model);
        appLog.upateLogStatus(appLogId);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QuerySolutionInfo solutionInfo = this.getQuerySolutionInfo(ctx, pk);
        this.checkSolutionOwner(ctx, solutionInfo);
        QuerySolutionCacheUtils.removeQuerySolutionCache(ctx, solutionInfo);
        IObjectPK appLogId = null;
        IAppLog appLog = AppLogFactory.getLocalInstance((Context)ctx);
        try {
            appLogId = appLog.writeLog(MANUAL_DEFAULT_LOGITEM, ((ObjectUuidPK)pk).getObjectType(), pk, this.getCQResource(ctx, DEL_SOLUTION) + ":" + solutionInfo.toString(), MANUAL_DEFAULT_LOGITEM, ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString(), METHOD_DESC);
        }
        catch (Exception e) {
            logger.error((Object)"writeLog error:", (Throwable)e);
        }
        super._delete(ctx, pk);
        appLog.upateLogStatus(appLogId);
    }

    @Override
    protected QuerySolutionCollection _getQuerySolutions(Context ctx, String orgID, String queryName, String parentUI, ShareTypeEnum shareType) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("queryObjectName", (Object)queryName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("parentUIName", (Object)parentUI);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(shareType.getValue()));
        filterInfo.getFilterItems().add(filterItemInfo);
        if (shareType.equals((Object)ShareTypeEnum.USER_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            if (!this.isHasEditOtherSolutionPerm(ctx)) {
                filterInfo.setMaskString(" #0 AND #1 AND #2 AND (#3 OR #4) AND #5");
            } else {
                filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString(), CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("solutionType", (Object)"10", CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterInfo.setMaskString(" #0 AND #1 AND #2 AND (#3 OR #4) and (#5 OR (#6 AND #7))");
            }
        } else if (shareType.equals((Object)ShareTypeEnum.USER_NOORG_LEVEL)) {
            if (!this.isHasEditOtherSolutionPerm(ctx)) {
                filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
                filterInfo.getFilterItems().add(filterItemInfo);
                filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 ");
            } else {
                filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString(), CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("solutionType", (Object)"10", CompareType.NOTEQUALS);
                filterInfo.getFilterItems().add(filterItemInfo);
                filterInfo.setMaskString(" #0 AND #1 AND #2 AND (#3 OR (#4 AND #5)) ");
            }
        } else if (shareType.equals((Object)ShareTypeEnum.ORG_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND (#3 or #4)  ");
        } else if (shareType.equals((Object)ShareTypeEnum.PUBLIC_LEVEL)) {
            filterInfo.setMaskString(" #0 AND #1 AND #2 ");
        } else if (shareType.equals((Object)ShareTypeEnum.CU_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("orgID", null));
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND (#3 or #4)  ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection coll = entityViewInfo.getSelector();
        coll.add(new SelectorItemInfo("*"));
        coll.add(new SelectorItemInfo("dynQuery.id"));
        coll.add(new SelectorItemInfo("dynQuery.number"));
        coll.add(new SelectorItemInfo("dynQuery.name"));
        coll.add(new SelectorItemInfo("dynQuery.deletedStatus"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.*"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.id"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        coll.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        SorterItemCollection sorterCol = new SorterItemCollection();
        sorterCol.add(new SorterItemInfo("name"));
        entityViewInfo.setSorter(sorterCol);
        QuerySolutionCollection col = this.getQuerySolutionCollection(ctx, entityViewInfo);
        this.upgradeToNoOrg(ctx, col, shareType);
        return col;
    }

    private void upgradeToNoOrg(Context ctx, QuerySolutionCollection querySolutionCollection, ShareTypeEnum currentShareType) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
        SelectorItemCollection selectorCol = new SelectorItemCollection();
        selectorCol.add(new SelectorItemInfo("shareType"));
        for (int i = querySolutionCollection.size() - 1; i >= 0; --i) {
            QuerySolutionInfo temp = querySolutionCollection.get(i);
            if (!currentShareType.equals((Object)ShareTypeEnum.USER_LEVEL) || !SolutionTypeEnum.SYSTEM_SOLUTION.equals((Object)temp.getSolutionType()) || temp.getOrgID() != null) continue;
            temp.setShareType(ShareTypeEnum.USER_NOORG_LEVEL);
            iQuerySolution.updatePartial(temp, selectorCol);
            querySolutionCollection.removeObject(i);
        }
    }

    @Override
    protected String _getSameNameSolutionID(Context ctx, String orgID, String queryName, String parentUI, ShareTypeEnum shareType, String solutionName) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("queryObjectName", (Object)queryName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("parentUIName", (Object)parentUI);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(shareType.getValue()));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("name", (Object)solutionName);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (shareType.equals((Object)ShareTypeEnum.USER_LEVEL)) {
            filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 AND #5");
        } else if (shareType.equals((Object)ShareTypeEnum.USER_NOORG_LEVEL)) {
            filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 ");
        } else if (shareType.equals((Object)ShareTypeEnum.ORG_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 ");
        } else if (shareType.equals((Object)ShareTypeEnum.PUBLIC_LEVEL)) {
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3");
        } else if (shareType.equals((Object)ShareTypeEnum.CU_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IObjectPK[] objectPKs = this._getPKList(ctx, entityViewInfo.toString());
        if (objectPKs != null && objectPKs.length > 0) {
            return objectPKs[0].toString();
        }
        return null;
    }

    @Override
    protected boolean _saveDefaultSolution(Context ctx, String currentSolutionID, String parentUIName, String queryName, int rowCount, boolean isUserDefaultSolu) throws EASBizException, BOSException {
        return this._saveDefaultSolution(ctx, currentSolutionID, parentUIName, queryName, rowCount, isUserDefaultSolu, ShareTypeEnum.USER_LEVEL);
    }

    @Override
    protected IObjectValue _getOwnerSolutionByName(Context ctx, String orgID, String queryName, String parentUI, ShareTypeEnum shareType, String solutionName) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        filterItemInfo = new FilterItemInfo("queryObjectName", (Object)queryName);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("parentUIName", (Object)parentUI);
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("shareType", (Object)String.valueOf(shareType.getValue()));
        filterInfo.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("name", (Object)solutionName);
        filterInfo.getFilterItems().add(filterItemInfo);
        if (shareType.equals((Object)ShareTypeEnum.USER_LEVEL)) {
            filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 AND #5");
        } else if (shareType.equals((Object)ShareTypeEnum.USER_NOORG_LEVEL)) {
            filterItemInfo = new FilterItemInfo("owner", (Object)ctx.getCaller().toString());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 ");
        } else if (shareType.equals((Object)ShareTypeEnum.ORG_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)orgID);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 ");
        } else if (shareType.equals((Object)ShareTypeEnum.PUBLIC_LEVEL)) {
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3  ");
        } else if (shareType.equals((Object)ShareTypeEnum.CU_LEVEL)) {
            filterItemInfo = new FilterItemInfo("orgID", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4 ");
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        QuerySolutionCollection querySolutionCollection = this.getQuerySolutionCollection(ctx, entityViewInfo);
        if (querySolutionCollection.size() == 1) {
            return querySolutionCollection.getObject(0);
        }
        return null;
    }

    @Override
    protected ArrayList _getWithOutProperties(Context ctx, String entityName) throws BOSException {
        EntityObjectInfo eo;
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eoTemp = eo = metaLoader.getEntity((IMetaDataPK)new MetaDataPK(entityName));
        ArrayList<String> al = new ArrayList<String>();
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)eoTemp.getProperties());
        while (eoTemp.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)eoTemp.getBaseEntity().getProperties());
            eoTemp = eoTemp.getBaseEntity();
        }
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = properties.get(i);
            if (!(propertyInfo instanceof OwnPropertyInfo) || eo.getTable() == null) continue;
            if (propertyInfo.getMappingField() == null) {
                al.add(propertyInfo.getName());
            }
            if (!DataType.STRING.equals((Object)((OwnPropertyInfo)propertyInfo).getDataType()) || !eo.getTable().getColumnByName(propertyInfo.getMappingField().getName()).getTypeName().equals((Object)SQLType.NCLOB) && !eo.getTable().getColumnByName(propertyInfo.getMappingField().getName()).getTypeName().equals((Object)SQLType.CLOB)) continue;
            al.add(propertyInfo.getName());
        }
        return al;
    }

    private void updateOtherUserDefault(Context ctx, String currentSolutionID, String parentUIName, String queryName) throws BOSException, EASBizException {
        String orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        String userID = ctx.getCaller().toString();
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo queryFilterItem = new FilterItemInfo("queryObjectName", (Object)queryName);
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("isUserDefaultSolu", (Object)true);
        FilterItemInfo userOrgLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(1));
        FilterItemInfo ownerFilterItem = new FilterItemInfo("owner", (Object)userID);
        orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
        FilterItemInfo userLevelFilterItem = new FilterItemInfo("shareType", (Object)String.valueOf(16));
        filterInfo.getFilterItems().add(queryFilterItem);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        filterInfo.getFilterItems().add(userOrgLevelFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        filterInfo.getFilterItems().add(orgFilterItem);
        filterInfo.getFilterItems().add(userLevelFilterItem);
        filterInfo.getFilterItems().add(ownerFilterItem);
        String maskString = " #0 and #1 and #2 and ((#3 and #4 and #5) or (#6 and #7))";
        filterInfo.setMaskString(maskString);
        evi.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isUserDefaultSolu"));
        selector.add(new SelectorItemInfo("id"));
        evi.setSelector(selector);
        QuerySolutionCollection querySolutionCollection = iQuerySolution.getQuerySolutionCollection(evi);
        QuerySolutionInfo querySolutionInfoOld = null;
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
        int size = querySolutionCollection.size();
        for (int i = 0; i < size; ++i) {
            querySolutionInfoOld = querySolutionCollection.get(i);
            if (querySolutionInfoOld.getId().toString().equals(currentSolutionID)) continue;
            querySolutionInfoOld.setIsUserDefaultSolu(false);
            iQuerySolution.updatePartial(querySolutionInfoOld, updateSelector);
        }
    }

    @Override
    protected boolean _saveDefaultSolution(Context ctx, String currentSolutionID, String parentUIName, String queryName, int rowCount, boolean isUserDefaultSolu, ShareTypeEnum shareType) throws BOSException, EASBizException {
        String orgID = QueryUtils.getOrgID(queryName, ctx).toString();
        String userID = ctx.getCaller().toString();
        QuerySolutionCacheUtils.removeDefaultQuerySolutionFromCache(userID, orgID, parentUIName, queryName);
        QuerySolutionCacheUtils.removeMyQuerySolutionsFromCache(ctx, userID, orgID, parentUIName, queryName);
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance(ctx);
        QuerySolutionInfo querySolutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(currentSolutionID));
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
        updateSelector.add(new SelectorItemInfo("rowCount"));
        querySolutionInfo.setRowCount(rowCount);
        querySolutionInfo.setIsUserDefaultSolu(isUserDefaultSolu);
        iQuerySolution.updatePartial(querySolutionInfo, updateSelector);
        this.updateOtherUserDefault(ctx, currentSolutionID, parentUIName, queryName);
        return true;
    }

    private String getCQResource(Context ctx, String resName) {
        return EASCommonResource.getString((String)commonQueryRes, (String)resName, (Locale)ctx.getLocale());
    }
}

