/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.apiservice.api;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.evs.app.datapool.CompanyCollection;
import com.kingdee.eas.base.evs.app.datapool.CompanyFactory;
import com.kingdee.eas.base.evs.app.datapool.CompanyInfo;
import com.kingdee.eas.base.evs.app.datapool.DataRangeCollection;
import com.kingdee.eas.base.evs.app.datapool.DataRangeFactory;
import com.kingdee.eas.base.evs.app.datapool.DataRangeInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.sql.Timestamp;

public class DataProcessUtil {
    public static DataRangeInfo processDataRange(Context ctx, JSONObject jsonObject, CompanyInfo companyInfo) throws BOSException, EASBizException {
        String periodNumber = (String)jsonObject.get((Object)"PeriodNumber");
        String periodYear = (String)jsonObject.get((Object)"PeriodYear");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)periodNumber));
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)periodYear));
        viewInfo.setFilter(filter);
        DataRangeCollection coll = DataRangeFactory.getLocalInstance(ctx).getDataRangeCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return DataProcessUtil.newDataRange(ctx, jsonObject, companyInfo);
    }

    public static DataRangeInfo newDataRange(Context ctx, JSONObject jsonObject, CompanyInfo companyInfo) throws BOSException, EASBizException {
        String periodNumber = (String)jsonObject.get((Object)"PeriodNumber");
        String periodYear = (String)jsonObject.get((Object)"PeriodYear");
        DataRangeInfo info = new DataRangeInfo();
        info.setId(BOSUuid.create((String)"B4AA6A3C"));
        info.setCompany(companyInfo);
        info.setPeriodNumber(Integer.parseInt(periodNumber));
        info.setPeriodYear(Integer.parseInt(periodYear));
        DataRangeFactory.getLocalInstance(ctx).addnew(info);
        return info;
    }

    public static CompanyInfo processCompany(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String companyCreaditCode = (String)jsonObject.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity");
        String companyName = (String)jsonObject.get((Object)"NameOfAccountingEntity");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyCreaditCode", (Object)companyCreaditCode));
        viewInfo.setFilter(filter);
        CompanyCollection coll = CompanyFactory.getLocalInstance(ctx).getCompanyCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return DataProcessUtil.newCompany(ctx, jsonObject);
    }

    public static CompanyInfo newCompany(Context ctx, JSONObject jsonObject) throws BOSException, EASBizException {
        String companyCreaditCode = (String)jsonObject.get((Object)"UnifiedSocialCreditCodeOfAccountingEntity");
        String companyName = (String)jsonObject.get((Object)"NameOfAccountingEntity");
        CompanyInfo info = new CompanyInfo();
        info.setId(BOSUuid.create((String)"8E602146"));
        info.setCompanyCreaditCode(companyCreaditCode);
        info.setCompanyName(companyName);
        CompanyFactory.getLocalInstance(ctx).addnew(info);
        return info;
    }

    public static void fillAuditData(Context ctx, ObjectBaseInfo info) {
        if (info != null) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            info.setCreator(userInfo);
            info.setLastUpdateUser(userInfo);
            Timestamp time = new Timestamp(System.currentTimeMillis());
            info.setCreateTime(time);
            info.setLastUpdateTime(time);
            CtrlUnitInfo cuInfo = new CtrlUnitInfo();
            cuInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
            info.setCU(cuInfo);
        }
    }
}

