/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.BkerInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.BkerInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class BkerConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.FidentifyingCode,a.fCurrency,a.FtransAmount,a.FContractNumber,a.FdateOfIssue,a.FpaymentAmount,a.FisClaimed,a.FisReconciled,a.FtransToBank,a.FBillPK,a.FBillNumber,a.FInvoiceType,a.FuniqueCode,a.FUniquePK,a.FisBooked,g.FCompanyName,g.FCompanyCreaditCode,d.FVoucherId,e.FVoucherNumber,a.FileName,f.FPeriodNumber,f.FPeriodYear from T_EVS_BkerInvoiceUnit a inner join T_EVS_BkerVoucherEntryUnit d on a.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> identifyingCodes = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            identifyingCodes.add(rowSet.getString("FidentifyingCode"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.FidentifyingCode, d.FVoucherId from T_EVS_BkerInvoiceUnit a inner join T_EVS_BkerVoucherEntryUnit d on a.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.FidentifyingCode in (" + SQLUtils.getSQL(identifyingCodes) + ") and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> invoicePKSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, BkerInvoiceInfo> uniqueMap = new HashMap<String, BkerInvoiceInfo>();
        while (rowSet.next()) {
            BkerInvoiceInfo invoiceInfo = null;
            String FidentifyingCode = rowSet.getString("FidentifyingCode");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            if (invoicePKSet.contains(FidentifyingCode)) {
                if (voucherNumberSet.contains(FidentifyingCode + fVoucherNumber)) continue;
                invoiceInfo = (BkerInvoiceInfo)uniqueMap.get(FidentifyingCode);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(FidentifyingCode + fVoucherNumber);
                continue;
            }
            invoiceInfo = new BkerInvoiceInfo();
            uniqueMap.put(FidentifyingCode, invoiceInfo);
            invoicePKSet.add(FidentifyingCode);
            voucherNumberSet.add(FidentifyingCode + fVoucherNumber);
            invoiceInfo.setVoucherNumbers(rowSet.getString("FVoucherNumber"));
            invoiceInfo.setUniquePK(FidentifyingCode);
            invoiceInfo.setIdentifyingCode(FidentifyingCode);
            invoiceInfo.setCurrency(rowSet.getString("fCurrency"));
            invoiceInfo.setTransAmount(rowSet.getString("FtransAmount"));
            invoiceInfo.setContractNumber(rowSet.getString("FContractNumber"));
            invoiceInfo.setDateOfIssue(rowSet.getString("FdateOfIssue"));
            invoiceInfo.setInvoiceType(rowSet.getString("FInvoiceType"));
            invoiceInfo.setPaymentAmount(rowSet.getString("FpaymentAmount"));
            invoiceInfo.setIsClaimed(rowSet.getString("FisClaimed"));
            invoiceInfo.setIsReconciled(rowSet.getString("FisReconciled"));
            invoiceInfo.setTransToBank(rowSet.getString("FtransToBank"));
            invoiceInfo.setUniqueCode(rowSet.getString("FuniqueCode"));
            invoiceInfo.setBillId(rowSet.getString("FBillPK"));
            invoiceInfo.setFileName(rowSet.getString("FileName"));
            invoiceInfo.setIsBooked(rowSet.getString("FisBooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setUniquePK(rowSet.getString("FUniquePK"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getIdentifyingCode());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setVoucherNumbers(rowSet.getString("FVoucherNumber"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!invoicePKSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_BkerInvoice where FidentifyingCode in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_BkerInvoice where FidentifyingCode in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "bker").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, invoicePKSet);
            BkerInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

