/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.AtrInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.AtrInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.AS;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AtrInvoiceConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.fReceiptNumber,a.fisdeducted,a.FdeductTaxPeriod,a.Ffare,a.FissueParty,a.FissueDate,a.FUniquePK, c.FHasBeenBooked,g.FCompanyName,g.FCompanyCreaditCode,isnull(a.FIsRedInvoice,c.FRedInvoice) FRedInvoice,isnull(a.FHasBeenChecked,c.FHasBeenChecked) FHasBeenChecked,d.FVoucherId,e.FVoucherNumber,a.FXbrlurl,a.FXbrlname,f.FPeriodNumber,f.FPeriodYear from T_EVS_AtrInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> receiptNumbers = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            receiptNumbers.add(rowSet.getString("fReceiptNumber"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.fReceiptNumber, d.FVoucherId from T_EVS_AtrInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.fReceiptNumber in (" + SQLUtils.getSQL(receiptNumbers) + ") and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> invoicePKSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, AtrInvoiceInfo> uniqueMap = new HashMap<String, AtrInvoiceInfo>();
        while (rowSet.next()) {
            AtrInvoiceInfo invoiceInfo = null;
            String fReceiptNumber = rowSet.getString("fReceiptNumber");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            if (invoicePKSet.contains(fReceiptNumber)) {
                if (voucherNumberSet.contains(fReceiptNumber + fVoucherNumber)) continue;
                invoiceInfo = (AtrInvoiceInfo)uniqueMap.get(fReceiptNumber);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(fReceiptNumber + fVoucherNumber);
                continue;
            }
            invoiceInfo = new AtrInvoiceInfo();
            uniqueMap.put(fReceiptNumber, invoiceInfo);
            invoicePKSet.add(fReceiptNumber);
            voucherNumberSet.add(fReceiptNumber + fVoucherNumber);
            invoiceInfo.setVoucherNumbers(fVoucherNumber);
            invoiceInfo.setUniquePK(fReceiptNumber);
            invoiceInfo.setReceiptNumber(fReceiptNumber);
            String deducted = AS.valueOf(rowSet.getString("fisdeducted"));
            if (StringUtils.isEmpty((String)deducted)) {
                invoiceInfo.setIsDeducted("false");
                invoiceInfo.setDeductTaxPeriod("");
            } else {
                invoiceInfo.setIsDeducted(deducted);
                String taxDedPeriod = AS.valueOf(rowSet.getString("FdeductTaxPeriod"), rowSet.getInt("FPeriodYear") + "" + (rowSet.getInt("FPeriodNumber") < 10 ? "0" + rowSet.getInt("FPeriodNumber") : Integer.valueOf(rowSet.getInt("FPeriodNumber"))));
                invoiceInfo.setDeductTaxPeriod(taxDedPeriod);
            }
            invoiceInfo.setIsDeducted(AS.valueOf(rowSet.getString("fisdeducted"), "true"));
            invoiceInfo.setDeductTaxPeriod(AS.valueOf(rowSet.getString("FdeductTaxPeriod"), rowSet.getInt("FPeriodYear") + "" + (rowSet.getInt("FPeriodNumber") < 10 ? "0" + rowSet.getInt("FPeriodNumber") : Integer.valueOf(rowSet.getInt("FPeriodNumber")))));
            invoiceInfo.setFare(rowSet.getString("Ffare"));
            invoiceInfo.setIssueParty(rowSet.getString("FissueParty"));
            invoiceInfo.setIssueDate(rowSet.getString("FissueDate"));
            invoiceInfo.setHasBeenBooked(rowSet.getString("FHasBeenBooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setRedInvoice(rowSet.getString("FRedInvoice"));
            invoiceInfo.setHasBeenChecked(rowSet.getString("FHasBeenChecked"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getReceiptNumber());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setIssureXbrlUrl(rowSet.getString("FXbrlurl"));
            invoiceInfo.setIssureXbrlName(rowSet.getString("FXbrlname"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!invoicePKSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_AtrInvoice where fReceiptNumber in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_AtrInvoice where fReceiptNumber in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "atr").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, invoicePKSet);
            AtrInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

