/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.EinvSpclInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.EinvSpclInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class EinvSpclInvoiceConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.FUniqueCode,a.FSellerName,a.FSellerIdNum,a.FTotalAmWithoutTax,a.FTotalTaxAmount,a.FTaxInAmInFigures,a.FDateOfIssue,a.FUniquePK,a.FXbrlurl,a.FXbrlname,c.FHasBeenBooked,c.FcontractNumber,c.FMatchingState,c.FDepreciation,c.FFactoredSoldSecuritized,a.HasBeenConfirmed FHasBeenConfirmed,c.FUsageConfirmation,c.FPeriodOfUsage,c.FHasBeenPaid,c.FReceipt,c.FHasBeenTransferredOut,c.FTransferredOutAmount,isnull(a.FIsRedInvoice,c.FRedInvoice) FRedInvoice,isnull(a.FHasBeenChecked,c.FHasBeenChecked) FHasBeenChecked,g.FCompanyName,g.FCompanyCreaditCode,d.FVoucherId,e.FVoucherNumber,f.FPeriodNumber,f.FPeriodYear from T_EVS_EinvSpclInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> uniqueCodes = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            uniqueCodes.add(rowSet.getString("FUniqueCode"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.FUniqueCode, d.FVoucherId from T_EVS_EinvSpclInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.FUniqueCode in (" + SQLUtils.getSQL(uniqueCodes) + ") and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> invoicePKSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, EinvSpclInvoiceInfo> uniqueMap = new HashMap<String, EinvSpclInvoiceInfo>();
        while (rowSet.next()) {
            EinvSpclInvoiceInfo invoiceInfo = null;
            String FUniqueCodeOfInvoice = rowSet.getString("FUniqueCode");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            if (invoicePKSet.contains(FUniqueCodeOfInvoice)) {
                if (voucherNumberSet.contains(FUniqueCodeOfInvoice + fVoucherNumber)) continue;
                invoiceInfo = (EinvSpclInvoiceInfo)uniqueMap.get(FUniqueCodeOfInvoice);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(FUniqueCodeOfInvoice + fVoucherNumber);
                continue;
            }
            invoiceInfo = new EinvSpclInvoiceInfo();
            uniqueMap.put(FUniqueCodeOfInvoice, invoiceInfo);
            invoicePKSet.add(FUniqueCodeOfInvoice);
            voucherNumberSet.add(FUniqueCodeOfInvoice + fVoucherNumber);
            invoiceInfo.setVoucherNumbers(fVoucherNumber);
            invoiceInfo.setUniquePK(FUniqueCodeOfInvoice);
            invoiceInfo.setInvoiceNumber(FUniqueCodeOfInvoice);
            invoiceInfo.setSellerName(rowSet.getString("FSellerName"));
            invoiceInfo.setSellerIdNum(rowSet.getString("FSellerIdNum"));
            invoiceInfo.setMatchingState(rowSet.getString("FMatchingState"));
            invoiceInfo.setContractNumber(rowSet.getString("FcontractNumber"));
            invoiceInfo.setTotalAmWithoutTax(rowSet.getString("FTotalAmWithoutTax"));
            invoiceInfo.setTotalTaxAm(rowSet.getString("FTotalTaxAmount"));
            invoiceInfo.setTotalTaxIncludedAm(rowSet.getString("FTaxInAmInFigures"));
            invoiceInfo.setRequestTime(rowSet.getString("FDateOfIssue"));
            invoiceInfo.setDepMethods(rowSet.getString("FDepreciation"));
            invoiceInfo.setHasBeenSoldOrSer(rowSet.getString("FFactoredSoldSecuritized"));
            invoiceInfo.setHasBeenConfirmed(rowSet.getString("FHasBeenConfirmed"));
            invoiceInfo.setUsageConfirmation(rowSet.getString("FUsageConfirmation"));
            invoiceInfo.setPeriodOfUsage(rowSet.getString("FPeriodOfUsage"));
            invoiceInfo.setHasBeenPaid(rowSet.getString("FHasBeenPaid"));
            invoiceInfo.setBankEleRecNumber(rowSet.getString("FReceipt"));
            invoiceInfo.setHasBeenTransOut(rowSet.getString("FHasBeenTransferredOut"));
            invoiceInfo.setTransOutInputVat(rowSet.getString("FTransferredOutAmount"));
            invoiceInfo.setHasBeenCompleted("");
            invoiceInfo.setBeginningYearTax("");
            invoiceInfo.setEndYearTax("");
            invoiceInfo.setBeginningBasis("");
            invoiceInfo.setEndBasis("");
            invoiceInfo.setHasBeenBooked(rowSet.getString("FHasBeenBooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setRedInvoice(rowSet.getString("FRedInvoice"));
            invoiceInfo.setHasBeenChecked(rowSet.getString("FHasBeenChecked"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getInvoiceNumber());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setIssureXbrlUrl(rowSet.getString("FXbrlurl"));
            invoiceInfo.setIssureXbrlName(rowSet.getString("FXbrlname"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!invoicePKSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_EinvSpclInvoice where FInvoiceNumber in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_EinvSpclInvoice where FInvoiceNumber in (" + SQLUtils.getSQL(invoicePKSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "einv_spcl").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, invoicePKSet);
            EinvSpclInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

