/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.converter.voucher.invoice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.app.converter.voucher.AbstractVoucherDataConverter;
import com.kingdee.eas.base.evs.app.elcertificate.GpmInvoiceFactory;
import com.kingdee.eas.base.evs.app.elcertificate.GpmInvoiceInfo;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryCollection;
import com.kingdee.eas.base.evs.app.elcertificate.InvoiceVoucherEntryInfo;
import com.kingdee.eas.base.evs.app.elcertificate.helper.EleCertificatePoolHelperFactory;
import com.kingdee.eas.base.evs.util.SQLUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GpmInvoiceConverter
extends AbstractVoucherDataConverter {
    @Override
    public String getSql() {
        String sql = "select a.FeinvoiceId,a.Farchived,a.FbillDate,a.FpaidAmt,a.FUniquePK, c.FHasBeenBooked Fbooked,g.FCompanyName,g.FCompanyCreaditCode,isnull(a.FIsRedInvoice,c.FRedInvoice) FRedInvoice,isnull(a.FHasBeenChecked,c.FHasBeenChecked) FHasBeenChecked,d.FVoucherId,e.FVoucherNumber,a.FXbrlurl,a.FXbrlname,f.FPeriodNumber,f.FPeriodYear from T_EVS_GpmInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK inner join T_EVS_DataRange f on e.FDataRangeId = f.fid inner join T_EVS_Company g on g.fid = f.FCompanyId ";
        return sql;
    }

    @Override
    public Map<String, Map<String, JSONObject>> getInformationOfAccountingDocumentsTuple(Context ctx, IRowSet rowSet) throws Exception {
        ArrayList<String> einvoiceIds = new ArrayList<String>();
        ArrayList<String> vouchers = new ArrayList<String>();
        while (rowSet.next()) {
            einvoiceIds.add(rowSet.getString("FeinvoiceId"));
            vouchers.add(rowSet.getString("FVoucherId"));
        }
        String sql = "select a.FeinvoiceId, d.FVoucherId from T_EVS_GpmInvoiceUnit a inner join T_EVS_InvoiceUnitBill b on a.fid = b.fparentid inner join T_EVS_BillUnit c on b.fbillid = c.FBillPK inner join T_EVS_BillVoucherEntryUnit d on c.fid = d.fparentid inner join T_EVS_VoucherUnit e on d.FVoucherId = e.FVoucherPK where a.FeinvoiceId in (" + SQLUtils.getSQL(einvoiceIds) + ") and d.FVoucherId in (" + SQLUtils.getSQL(vouchers) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        return this.getInformationOfAccountingDocumentsTuple0(ctx, rs);
    }

    @Override
    public void saveData(Context ctx, int periodYear, int periodNumber, IRowSet rowSet, Map<String, Map<String, JSONObject>> informationOfAccountingDocumentsTuple) throws Exception {
        CoreBaseCollection collection = new CoreBaseCollection();
        String taxNumber = "";
        HashSet<String> einvoiceIdSet = new HashSet<String>();
        HashSet<String> voucherNumberSet = new HashSet<String>();
        HashMap<String, GpmInvoiceInfo> gpmMap = new HashMap<String, GpmInvoiceInfo>();
        while (rowSet.next()) {
            String einvoiceId = rowSet.getString("FeinvoiceId");
            String fVoucherNumber = rowSet.getString("FVoucherNumber");
            GpmInvoiceInfo invoiceInfo = null;
            if (einvoiceIdSet.contains(einvoiceId)) {
                if (voucherNumberSet.contains(einvoiceId + fVoucherNumber)) continue;
                invoiceInfo = (GpmInvoiceInfo)gpmMap.get(einvoiceId);
                invoiceInfo.setVoucherNumbers(invoiceInfo.getVoucherNumbers() + "," + fVoucherNumber);
                voucherNumberSet.add(einvoiceId + fVoucherNumber);
                continue;
            }
            invoiceInfo = new GpmInvoiceInfo();
            gpmMap.put(einvoiceId, invoiceInfo);
            einvoiceIdSet.add(einvoiceId);
            voucherNumberSet.add(einvoiceId + fVoucherNumber);
            invoiceInfo.setUniquePK(einvoiceId);
            invoiceInfo.setEinvoiceId(einvoiceId);
            invoiceInfo.setArchived(rowSet.getString("Farchived"));
            invoiceInfo.setBillDate(rowSet.getString("FbillDate"));
            invoiceInfo.setPaidAmt(rowSet.getString("FpaidAmt"));
            invoiceInfo.setHasBeenBooked(rowSet.getString("Fbooked"));
            invoiceInfo.setAccountName(rowSet.getString("FCompanyName"));
            String fCompanyCreaditCode = rowSet.getString("FCompanyCreaditCode");
            taxNumber = StringUtils.isEmpty((String)taxNumber) ? fCompanyCreaditCode : taxNumber;
            invoiceInfo.setCreditCode(fCompanyCreaditCode);
            invoiceInfo.setRedInvoice(rowSet.getString("FRedInvoice"));
            invoiceInfo.setHasBeenChecked(rowSet.getString("FHasBeenChecked"));
            Map<String, JSONObject> map = informationOfAccountingDocumentsTuple.get(invoiceInfo.getEinvoiceId());
            JSONArray array = new JSONArray();
            InvoiceVoucherEntryCollection voucherEntryCollection = new InvoiceVoucherEntryCollection();
            for (Map.Entry<String, JSONObject> entry : map.entrySet()) {
                InvoiceVoucherEntryInfo voucherEntryInfo = new InvoiceVoucherEntryInfo();
                voucherEntryInfo.setVoucherId(entry.getKey());
                voucherEntryCollection.add(voucherEntryInfo);
                array.add((Object)entry.getValue());
            }
            invoiceInfo.setVoucher(array.toJSONString());
            invoiceInfo.put("voucherEntry", (Object)voucherEntryCollection);
            invoiceInfo.setVoucherNumbers(fVoucherNumber);
            invoiceInfo.setIssureXbrlUrl(rowSet.getString("FXbrlurl"));
            invoiceInfo.setIssureXbrlName(rowSet.getString("FXbrlname"));
            invoiceInfo.setPeriodYear(rowSet.getInt("FPeriodYear"));
            invoiceInfo.setPeriodNumber(rowSet.getInt("FPeriodNumber"));
            collection.add((CoreBaseInfo)invoiceInfo);
        }
        if (!einvoiceIdSet.isEmpty()) {
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_InvoiceVoucherEntry where FParentID in (select fid from T_EVS_GpmInvoice where FeinvoiceId in (" + SQLUtils.getSQL(einvoiceIdSet) + ") and FPeriodYear = ? and FPeriodNumber = ?)"), (Object[])new Object[]{periodYear, periodNumber});
            DbUtil.execute((Context)ctx, (String)("delete from T_EVS_GpmInvoice where FeinvoiceId in (" + SQLUtils.getSQL(einvoiceIdSet) + ") and FPeriodYear = ? and FPeriodNumber = ?"), (Object[])new Object[]{periodYear, periodNumber});
            EleCertificatePoolHelperFactory.getInstance(ctx, "ntrev_gpm").syncExportRecord2New(ctx, collection, periodYear, periodNumber, taxNumber, einvoiceIdSet);
            GpmInvoiceFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
    }
}

