/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.app.elcertificate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.evs.app.elcertificate.AbstractEleCertificatePoolFacadeControllerBean;
import com.kingdee.eas.base.evs.app.evsservice.AssemblyEngineFacadeFactory;
import com.kingdee.eas.base.evs.util.EvsUtil;
import com.kingdee.eas.base.evs.util.FileUtil;
import com.kingdee.eas.base.evs.util.IDUtils;
import com.kingdee.eas.base.evs.util.ZipUtil;
import com.kingdee.eas.base.evs.xbrlBuild.DataPackageInfo;
import com.kingdee.eas.base.evs.xbrlBuild.EVSInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipOutputStream;

public class EleCertificatePoolFacadeControllerBean
extends AbstractEleCertificatePoolFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.evs.app.elcertificate.EleCertificatePoolFacadeControllerBean");

    @Override
    protected Map _exportVoucherDataPackage(Context ctx, IObjectValue company, int periodYear, int periodNumber, List fileTypes, List voucherIds, List standardTypes, List uniqueCodes) throws BOSException, EASBizException {
        if (standardTypes == null || standardTypes.size() == 0) {
            standardTypes = EvsUtil.getVoucherStandardTypes(ctx);
        }
        if (fileTypes == null || fileTypes.size() == 0) {
            fileTypes = new ArrayList<String>();
            fileTypes.add("receiverXbrl");
            fileTypes.add("issuerXbrl");
        }
        if (voucherIds == null || voucherIds.size() == 0) {
            voucherIds = EvsUtil.getVoucherIds(ctx, (CompanyOrgUnitInfo)company, periodYear, periodNumber);
        }
        HashMap<String, Map<String, List<EVSInfo>>> dataStandards = new HashMap();
        try {
            dataStandards = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getVoucherDataStandardsBasedInvoice((CompanyOrgUnitInfo)company, periodYear, periodNumber, fileTypes, voucherIds, standardTypes);
        }
        catch (Exception e) {
            logger.error((Object)"\u8c03\u7528 AssemblyEngineFacade#getBkrsDataStandardsBasedInvoice \u62a5\u9519\u4e86", (Throwable)e);
        }
        if (dataStandards == null || dataStandards.size() == 0) {
            logger.error((Object)"\u8c03\u7528 AssemblyEngineFacade#getDataStandardsBasedInvoice \u65e0\u6570\u636e");
            return this.getEmptyDataPackageMap((CompanyOrgUnitInfo)company, standardTypes);
        }
        return this.getDataPackageMap((CompanyOrgUnitInfo)company, dataStandards, uniqueCodes);
    }

    @Override
    protected Map _exportBkrsDataPackage(Context ctx, IObjectValue company, int year, int month, List fileTypes, List bankAccounts) throws BOSException, EASBizException {
        if (fileTypes == null || fileTypes.size() == 0) {
            fileTypes = new ArrayList<String>();
            fileTypes.add("receiverXbrl");
            fileTypes.add("issuerXbrl");
        }
        if (bankAccounts == null || bankAccounts.size() == 0) {
            bankAccounts = EvsUtil.getOrgBankAccounts(ctx, (CompanyOrgUnitInfo)company);
        }
        HashMap<String, Map<String, List<EVSInfo>>> dataStandards = new HashMap();
        try {
            dataStandards = AssemblyEngineFacadeFactory.getLocalInstance(ctx).getBkrsDataStandardsBasedInvoice((CompanyOrgUnitInfo)company, year, month, fileTypes, bankAccounts);
        }
        catch (Exception e) {
            logger.error((Object)"\u8c03\u7528 AssemblyEngineFacade#getBkrsDataStandardsBasedInvoice \u62a5\u9519\u4e86", (Throwable)e);
        }
        if (dataStandards == null || dataStandards.size() == 0) {
            logger.error((Object)"\u8c03\u7528 AssemblyEngineFacade#getBkrsDataStandardsBasedInvoice \u65e0\u6570\u636e");
            ArrayList<String> standardTypes = new ArrayList<String>();
            standardTypes.add("bkrs");
            return this.getEmptyDataPackageMap((CompanyOrgUnitInfo)company, standardTypes);
        }
        return this.getDataPackageMap((CompanyOrgUnitInfo)company, dataStandards, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getDataPackageMap(CompanyOrgUnitInfo company, Map<String, Map<String, List<EVSInfo>>> dataStandards, List uniqueCodes) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        String tempFileStoragePath = easInstanceHome + "/bin/evsTempFile/" + company.getTaxNumber() + System.currentTimeMillis() + IDUtils.getId();
        HashMap<String, DataPackageInfo> result = new HashMap<String, DataPackageInfo>();
        for (Map.Entry<String, Map<String, List<EVSInfo>>> dataStandard : dataStandards.entrySet()) {
            File tempFolder = null;
            HashSet<String> successInvoiceUniqueCode = new HashSet<String>();
            try {
                String firstLevelDirectory = dataStandard.getKey() + "_" + company.getTaxNumber() + "_" + System.currentTimeMillis();
                tempFolder = new File(tempFileStoragePath + File.separatorChar + firstLevelDirectory);
                if (!tempFolder.exists()) {
                    tempFolder.mkdirs();
                }
                this.zipInvoiceFiles(dataStandard.getValue(), tempFileStoragePath + File.separatorChar + firstLevelDirectory, dataStandard.getKey(), successInvoiceUniqueCode, uniqueCodes);
                String firstZipPackagePath = tempFileStoragePath + File.separatorChar + firstLevelDirectory + ".zip";
                ZipUtil.zipFolderExcludeSub(firstZipPackagePath, tempFolder);
                DataPackageInfo dataPackageInfo = new DataPackageInfo();
                dataPackageInfo.setFileStorePath(tempFileStoragePath);
                dataPackageInfo.setFile(new File(firstZipPackagePath));
                String fileName = "receiver_" + company.getTaxNumber() + "_" + System.currentTimeMillis() + ".zip";
                dataPackageInfo.setFileName(fileName);
                dataPackageInfo.setInvoiceUniqueCode(successInvoiceUniqueCode);
                result.put(dataStandard.getKey(), dataPackageInfo);
                FileUtil.deleteDirectory(tempFolder);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                FileUtil.deleteDirectory(tempFolder);
            }
        }
        return result;
    }

    private Map getEmptyDataPackageMap(CompanyOrgUnitInfo company, List<String> standardTypes) {
        String easInstanceHome = System.getProperty("EAS_INSTANCE_HOME");
        String tempFileStoragePath = easInstanceHome + "/bin/evsTempFile/" + company.getTaxNumber() + System.currentTimeMillis() + IDUtils.getId();
        new File(tempFileStoragePath).mkdirs();
        HashMap<String, DataPackageInfo> result = new HashMap<String, DataPackageInfo>();
        for (String standardType : standardTypes) {
            String packageName = standardType + "_" + company.getTaxNumber() + "_" + System.currentTimeMillis() + ".zip";
            ZipUtil.getEmptyPackage(packageName, tempFileStoragePath);
            DataPackageInfo dataPackageInfo = new DataPackageInfo();
            dataPackageInfo.setFileStorePath(tempFileStoragePath);
            dataPackageInfo.setFile(new File(tempFileStoragePath + File.separatorChar + packageName));
            dataPackageInfo.setFileName(packageName);
            result.put(standardType, dataPackageInfo);
        }
        return result;
    }

    private void zipInvoiceFiles(Map<String, List<EVSInfo>> fileMap, String storageDirectory, String standardTypes, Set<String> successInvoiceUniqueCode, List uniqueCodes) {
        for (Map.Entry<String, List<EVSInfo>> invoiceFiles : fileMap.entrySet()) {
            String uniqueCode = invoiceFiles.getKey().split(";")[0];
            if (uniqueCodes != null && !uniqueCodes.contains(uniqueCode)) continue;
            this.zipInvoiceFile(invoiceFiles.getValue(), storageDirectory, standardTypes, uniqueCode, successInvoiceUniqueCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipInvoiceFile(List<EVSInfo> files, String storageDirectory, String standardTypes, String uniqueCode, Set<String> successInvoiceUniqueCode) {
        if (files == null && files.size() == 0) {
            return;
        }
        ZipOutputStream zipOutputStream = null;
        InputStream inputStream = null;
        try {
            StringBuilder packageName = new StringBuilder(standardTypes + "_receiver_" + (StringUtils.isEmpty((CharSequence)files.get(0).getDateOfIssue()) ? "" : files.get(0).getDateOfIssue() + "_") + uniqueCode);
            File zipFile = new File(storageDirectory + File.separatorChar + packageName + ".zip");
            int i = 0;
            while (zipFile.exists()) {
                zipFile = new File(storageDirectory + File.separatorChar + packageName + "_" + ++i + ".zip");
            }
            zipOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(zipFile));
            zipOutputStream.setEncoding("GBK");
            for (EVSInfo evsInfo : files) {
                try {
                    inputStream = evsInfo.getFile();
                    if (inputStream == null) continue;
                    ZipUtil.addStream(evsInfo.getFileName(), evsInfo.getFile(), zipOutputStream);
                    successInvoiceUniqueCode.add(uniqueCode);
                }
                catch (Exception e) {
                    logger.error((Object)"\u6dfb\u52a0\u6587\u4ef6\u51fa\u9519\u4e86", (Throwable)e);
                    successInvoiceUniqueCode.remove(uniqueCode);
                }
                finally {
                    FileUtil.safeClose(inputStream);
                }
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(inputStream);
                FileUtil.safeClose(zipOutputStream);
                throw throwable;
            }
        }
        FileUtil.safeClose(inputStream);
        FileUtil.safeClose((Closeable)zipOutputStream);
    }
}

