/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.unitdata.pcloud.fpy;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.evs.unitdata.billData.InvoiceDoc;
import com.kingdee.eas.base.evs.unitdata.pcloud.IPiaoUnitData;
import com.kingdee.eas.base.evs.unitdata.pcloud.Invoice;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.FpSysHelper;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpSys.FpSysHelperFactory;
import com.kingdee.eas.base.evs.unitdata.pcloud.fpy.FpyDataConverterUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CyclicBarrier;
import org.apache.log4j.Logger;

public class PiaoUnitDataHelper_FPY
implements IPiaoUnitData {
    private static Logger logger = Logger.getLogger(PiaoUnitDataHelper_FPY.class);
    public static int splitCont = 5;
    public static FpSysHelper instance;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<Invoice>> getUnitData(Context ctx, Map<String, List<InvoiceDoc>> invoiceDocMap, CompanyOrgUnitInfo orgUnitInfo) throws EASBizException {
        HashMap<String, List<Invoice>> invoiceUnitMap = new HashMap<String, List<Invoice>>();
        if (invoiceDocMap == null || invoiceDocMap.size() == 0) {
            return Collections.emptyMap();
        }
        instance = FpSysHelperFactory.getInstance(ctx, "kd.fpy");
        int keySize = invoiceDocMap.size();
        double splitSize = Math.ceil((double)keySize / (double)splitCont);
        int threadCont = (int)Math.ceil((double)keySize / splitSize);
        CyclicBarrier barrier = new CyclicBarrier(threadCont, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        });
        int size = 0;
        HashMap<String, List<InvoiceDoc>> map = new HashMap<String, List<InvoiceDoc>>();
        for (Map.Entry<String, List<InvoiceDoc>> entry : invoiceDocMap.entrySet()) {
            if ((double)size < splitSize) {
                ++size;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if ((double)size != splitSize) continue;
            new Thread(new GetInvoice(barrier, ctx, map, orgUnitInfo, invoiceUnitMap)).start();
            size = 1;
            map = new HashMap();
            map.put(entry.getKey(), entry.getValue());
        }
        if (size != 0 && (double)size <= splitSize && null != invoiceDocMap) {
            new Thread(new GetInvoice(barrier, ctx, map, orgUnitInfo, invoiceUnitMap)).start();
        }
        try {
            Object object = lock;
            synchronized (object) {
                lock.wait();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return invoiceUnitMap;
    }

    static {
        lock = new Object();
    }

    class GetInvoice
    implements Runnable {
        private final Context ctx;
        private final Map<String, List<InvoiceDoc>> invoiceDocMap;
        private final CompanyOrgUnitInfo orgUnitInfo;
        private final Map<String, List<Invoice>> invoiceUnitMap;
        private final CyclicBarrier barrier;

        public GetInvoice(CyclicBarrier barrier, Context ctx, Map<String, List<InvoiceDoc>> map, CompanyOrgUnitInfo orgUnitInfo, Map<String, List<Invoice>> invoiceUnitMap) {
            this.barrier = barrier;
            this.ctx = ctx;
            this.invoiceDocMap = map;
            this.orgUnitInfo = orgUnitInfo;
            this.invoiceUnitMap = invoiceUnitMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Map.Entry<String, List<InvoiceDoc>> entry : this.invoiceDocMap.entrySet()) {
                    List<InvoiceDoc> invoiceList = entry.getValue();
                    Map<InvoiceDoc, JSONObject> invoiceInfos = instance.getInvoiceInfos(this.ctx, invoiceList, this.orgUnitInfo);
                    List<Invoice> units = FpyDataConverterUtil.converterData(this.ctx, invoiceInfos);
                    String billId = entry.getKey();
                    if (this.invoiceUnitMap.get(billId) != null) {
                        this.invoiceUnitMap.get(billId).addAll(units);
                        continue;
                    }
                    this.invoiceUnitMap.put(billId, units);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    this.barrier.await();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
    }
}

