/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.evs.util;

import com.kingdee.eas.base.evs.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtil {
    private static Logger logger = Logger.getLogger(ZipUtil.class);

    public static void addStream(String fileName, InputStream inputStream, ZipOutputStream zipOutputStream) {
        try {
            int temp = 0;
            zipOutputStream.putNextEntry(new ZipEntry(fileName));
            while ((temp = inputStream.read()) != -1) {
                zipOutputStream.write(temp);
            }
        }
        catch (Exception e) {
            logger.error((Object)"zip\u6587\u4ef6\u6dfb\u52a0\u51fa\u9519\u4e86 ", (Throwable)e);
        }
    }

    public static void addStreams(Map<String, InputStream> streamMaps, ZipOutputStream zipOutputStream) {
        for (Map.Entry<String, InputStream> streamEntry : streamMaps.entrySet()) {
            if (streamEntry.getValue() == null) continue;
            ZipUtil.addStream(streamEntry.getKey(), streamEntry.getValue(), zipOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipFolderExcludeSub(String zipName, File folder) {
        block12: {
            BufferedInputStream inputStreams = null;
            ZipOutputStream zipOutputStream = null;
            try {
                File[] files;
                byte[] bytes = new byte[1024];
                zipOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(new File(zipName)));
                for (File file1 : files = folder.listFiles()) {
                    if (!file1.isFile()) continue;
                    try {
                        int temp = -1;
                        inputStreams = new BufferedInputStream(new FileInputStream(file1));
                        zipOutputStream.putNextEntry(new ZipEntry(file1.getName()));
                        while ((temp = ((InputStream)inputStreams).read(bytes, 0, 1024)) != -1) {
                            zipOutputStream.write(bytes, 0, temp);
                        }
                        FileUtil.safeClose(inputStreams);
                    }
                    catch (Exception e) {
                        logger.error((Object)"zip\u6587\u4ef6\u6dfb\u52a0\u51fa\u9519\u4e86 ", (Throwable)e);
                    }
                    finally {
                        FileUtil.safeClose(inputStreams);
                    }
                }
                FileUtil.safeClose(inputStreams);
            }
            catch (Exception e) {
                logger.error((Object)"zip\u6587\u4ef6\u6dfb\u52a0\u51fa\u9519\u4e86 ", (Throwable)e);
                break block12;
            }
            finally {
                FileUtil.safeClose(inputStreams);
                FileUtil.safeClose(zipOutputStream);
            }
            FileUtil.safeClose((Closeable)zipOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getEmptyPackage(String packageName, String storagePath) {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream((OutputStream)new FileOutputStream(new File(storagePath + File.separatorChar + packageName)));
        }
        catch (Exception exception) {
            FileUtil.safeClose(zipOutputStream);
        }
        catch (Throwable throwable) {
            FileUtil.safeClose(zipOutputStream);
            throw throwable;
        }
        FileUtil.safeClose((Closeable)zipOutputStream);
    }
}

