/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.log;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogFactory;
import com.kingdee.eas.base.log.IAppLog;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import java.util.List;
import org.apache.log4j.Logger;

public class LogUtil {
    static Logger logger = Logger.getLogger(LogUtil.class);

    public static IObjectPK beginLog(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDetail) {
        IObjectPK pk = null;
        try {
            IAppLog appLog = LogUtil.getLogBizInterface(ctx);
            pk = appLog.writeLog(methodName, bizObjType, instancePK, instanceDetail);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
        return pk;
    }

    public static IObjectPK beginLogWithDescription(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDetail, String methodDescription) {
        IObjectPK pk = null;
        try {
            IAppLog appLog = LogUtil.getLogBizInterface(ctx);
            pk = appLog.writeLogWithDescription(methodName, bizObjType, instancePK, instanceDetail, methodDescription);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
        return pk;
    }

    public static IObjectPK beginLog(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDeatil, String logItemName) {
        IObjectPK pk = null;
        try {
            IAppLog appLog = LogUtil.getLogBizInterface(ctx);
            pk = appLog.writeLog(methodName, bizObjType, instancePK, instanceDeatil, logItemName);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
        return pk;
    }

    public static IObjectPK beginLog(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDeatil, String logItemName, String companyId) {
        IObjectPK pk = null;
        try {
            IAppLog appLog = LogUtil.getLogBizInterface(ctx);
            pk = appLog.writeLog(methodName, bizObjType, instancePK, instanceDeatil, logItemName, companyId);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
        return pk;
    }

    public static IObjectPK beginLog(Context ctx, String methodName, BOSObjectType bizObjType, IObjectPK instancePK, String instanceDeatil, String logItemName, String companyId, String methodDescription) {
        IObjectPK pk = null;
        try {
            IAppLog appLog = LogUtil.getLogBizInterface(ctx);
            pk = appLog.writeLog(methodName, bizObjType, instancePK, instanceDeatil, logItemName, companyId, methodDescription);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
        return pk;
    }

    public static void afterLog(Context ctx, IObjectPK logPK) {
        if (logPK == null) {
            return;
        }
        try {
            LogUtil.getLogBizInterface(ctx).upateLogStatus(logPK);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err: " + e.getMessage()), (Throwable)e);
        }
    }

    private static IAppLog getLogBizInterface(Context ctx) throws BOSException {
        IAppLog appLog = null;
        try {
            appLog = ctx == null ? AppLogFactory.getRemoteInstance() : AppLogFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        return appLog;
    }

    public static String[] getAdminCUs(IObjectPK userPK) throws EASBizException, BOSException {
        String[] cus = null;
        FullOrgUnitCollection orgs = null;
        orgs = PermissionFactory.getRemoteInstance().getOrgRanges(userPK);
        cus = new String[orgs.size()];
        for (int i = 0; i < cus.length; ++i) {
            cus[i] = orgs.get(i).getId().toString();
        }
        return cus;
    }

    public static boolean isBizAdmin() {
        return SysContext.getSysContext().getCurrentUserInfo().isBizAdmin();
    }

    public static String[] getDefaultFilter(IObjectPK userPK) throws EASBizException, BOSException {
        String[] cuids = null;
        List cuIDlist = null;
        cuIDlist = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType(ToolUtils.getCurrentUserPK(), OrgRangeType.MANAGE_ORG_TYPE);
        cuids = new String[cuIDlist.size()];
        for (int i = 0; i < cuids.length; ++i) {
            cuids[i] = cuIDlist.get(i).toString();
        }
        return cuids;
    }

    public static FilterInfo outerFilterInfo() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        List cuIDList = null;
        try {
            cuIDList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType(ToolUtils.getCurrentUserPK(), user.getType() == UserType.SYSTEM ? OrgRangeType.BIZ_ORG_TYPE : OrgRangeType.MANAGE_ORG_TYPE);
        }
        catch (EASBizException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        if (cuIDList == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (cuIDList.size() != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("unit.id in (");
            for (int i = 0; i < cuIDList.size() - 1; ++i) {
                sb.append("'" + cuIDList.get(i).toString() + "'").append(",");
            }
            sb.append("'").append(cuIDList.get(cuIDList.size() - 1)).append("')");
            filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("unit.id", null));
        }
        return filter;
    }

    public static FilterInfo treeFilter() {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        List cuIDList = null;
        try {
            cuIDList = OrgRangeFactory.getRemoteInstance().getOrgIdByUserAndType(ToolUtils.getCurrentUserPK(), user.getType() == UserType.SYSTEM ? OrgRangeType.BIZ_ORG_TYPE : OrgRangeType.MANAGE_ORG_TYPE);
        }
        catch (EASBizException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)("LogService Err:" + e.getMessage()), (Throwable)e);
        }
        if (cuIDList == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        if (cuIDList.size() != 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("BASEUNIT.FID in (");
            for (int i = 0; i < cuIDList.size() - 1; ++i) {
                sb.append("'" + cuIDList.get(i).toString() + "'").append(",");
            }
            sb.append("'").append(cuIDList.get(cuIDList.size() - 1)).append("')");
            filter.getFilterItems().add(new FilterItemInfo(sb.toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("BASEUNIT.FID", null));
        }
        return filter;
    }
}

