/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.multiapprove.IPassComment;
import com.kingdee.eas.base.multiapprove.PassCommentFactory;
import com.kingdee.eas.base.multiapprove.PassCommentInfo;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PassCommentMonitorUtil {
    private static final Logger logger = Logger.getLogger(PassCommentMonitorUtil.class);

    public static List<Map<String, String>> getPassCommentByAssignId(String assignId, Context ctx) {
        List<Map<String, String>> list = null;
        if (!StringUtils.isEmpty((String)assignId)) {
            try {
                IEnactmentService service = null;
                service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
                String procInstId = "";
                AssignmentInfo info = service.getAssignmentById(assignId);
                if (info != null) {
                    procInstId = info.getProcInstId();
                }
                list = PassCommentMonitorUtil.getPassCommentByProcInstId(procInstId, ctx);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    public static List<Map<String, String>> getPassCommentByProcInstId(String procInstId, Context ctx) {
        List<Map<String, String>> list = null;
        if (!StringUtils.isEmpty((String)procInstId)) {
            try {
                IPassComment pc = null;
                pc = ctx == null ? PassCommentFactory.getRemoteInstance() : PassCommentFactory.getLocalInstance(ctx);
                CoreBaseCollection coll = pc.getCollection(" where procInstId ='" + procInstId + "' order by createTime asc,updateTime asc");
                list = PassCommentMonitorUtil.convertCollectionToList(coll);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (list == null) {
            list = Collections.emptyList();
        }
        return list;
    }

    private static List<Map<String, String>> convertCollectionToList(CoreBaseCollection coll) {
        ArrayList list = null;
        if (coll != null && coll.size() > 0) {
            list = new ArrayList();
            Iterator ite = coll.iterator();
            PassCommentInfo info = null;
            HashMap<String, String> itemMap = null;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            while (ite.hasNext()) {
                info = (PassCommentInfo)ite.next();
                itemMap = new HashMap<String, String>();
                itemMap.put("id", info.getId().toString());
                itemMap.put("passId", info.getPassId());
                itemMap.put("type", info.getType());
                itemMap.put("billId", info.getBillId());
                itemMap.put("procInstId", info.getProcInstId());
                itemMap.put("Initiator", info.getInitiator());
                itemMap.put("UserID", info.getUserID());
                itemMap.put("PERSONID", info.getPersonId());
                itemMap.put("PERSONNAME", info.getPersonName());
                itemMap.put("CreateTime", info.getCreateTime() != null ? format.format(info.getCreateTime()) : "");
                itemMap.put("COMMENT_L1", StringUtils.isEmpty((String)info.getComment(new Locale("l1"))) ? "" : info.getComment(new Locale("l1")));
                itemMap.put("COMMENT_L2", StringUtils.isEmpty((String)info.getComment(new Locale("l2"))) ? "" : info.getComment(new Locale("l2")));
                itemMap.put("COMMENT_L3", StringUtils.isEmpty((String)info.getComment(new Locale("l3"))) ? "" : info.getComment(new Locale("l3")));
                itemMap.put("UPDATETIME", info.getUpdateTime() != null ? format.format(info.getUpdateTime()) : "");
                list.add(itemMap);
            }
        }
        return list;
    }

    public static boolean isAlreadyPassFeedBack(Context ctx, String passId, String userId) {
        boolean result = false;
        if (!StringUtils.isEmpty((String)passId) && !StringUtils.isEmpty((String)userId)) {
            try {
                PassCommentInfo info;
                Timestamp updateTime;
                String personId;
                IUser userService = null;
                IPassComment passService = null;
                if (ctx == null) {
                    userService = UserFactory.getRemoteInstance();
                    passService = PassCommentFactory.getRemoteInstance();
                } else {
                    userService = UserFactory.getLocalInstance((Context)ctx);
                    passService = PassCommentFactory.getLocalInstance(ctx);
                }
                UserInfo userInfo = userService.getUserInfo((IObjectPK)new ObjectStringPK(userId));
                PersonInfo personInfo = userInfo.getPerson();
                if (personInfo != null && !StringUtils.isEmpty((String)(personId = personInfo.getId().toString())) && (updateTime = (info = passService.getPassCommentInfo(" where passid='" + passId + "' and personId='" + personId + "'")).getUpdateTime()) != null) {
                    result = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public static String getAlreadyPassFeedBackCommentId(Context ctx, String passId, String userId, String msgId) {
        String commentId = null;
        if (!StringUtils.isEmpty((String)passId) && !StringUtils.isEmpty((String)userId)) {
            try {
                Timestamp msgTime;
                String sql;
                IRowSet rowSet;
                String personId;
                IUser userService = UserFactory.getLocalInstance((Context)ctx);
                UserInfo userInfo = userService.getUserInfo((IObjectPK)new ObjectStringPK(userId));
                PersonInfo personInfo = userInfo.getPerson();
                if (personInfo != null && !StringUtils.isEmpty((String)(personId = personInfo.getId().toString())) && (rowSet = DbUtil.executeQuery((Context)ctx, (String)(sql = "select fid from t_wfr_passcomment where fpassid=? and fpersonid=? and FUPDATETIME is not null and FUPDATETIME >?"), (Object[])new Object[]{passId, personId, msgTime = BMCMessageFactory.getLocalInstance((Context)ctx).getBMCMessageInfo((IObjectPK)new ObjectStringPK(msgId)).getReceiveTime()})).next()) {
                    commentId = rowSet.getString("fid");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return commentId;
    }
}

