/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.service.ormrpc.IWfFacade;
import com.kingdee.bos.workflow.service.ormrpc.WfFacadeFactory;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.IMultiApproveUIFacade;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.app.SignatureUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class MultiApproveUIFacade
implements IMultiApproveUIFacade {
    private Context ctx;

    public MultiApproveUIFacade(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map<String, Object> getInitData(Map<String, Object> params) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("isNeedDefaultOption", this.isNeedDefaultOption());
        String actDefId = (String)params.get("actDefId");
        String procDefHashValue = (String)params.get("procDefHashValue");
        boolean showAllEmptyPostActivities = this.isShowAllEmptyPostActivities(actDefId, procDefHashValue);
        data.put("isShowAllEmptyPostActivities", showAllEmptyPostActivities);
        String str = ParamManager.getParamValue((Context)this.ctx, null, (String)"isOpenMessageSendOnUI");
        data.put("isOpenMessageSendOnUI", str);
        String assignmentId = (String)params.get("assignmentId");
        String CAType = SignatureUtils.getCATypeByAssign(this.ctx, assignmentId);
        data.put("CAType", CAType);
        String billId = (String)params.get("billId");
        String className = ConfigLoader.getConfig4Server().getMultiApproveHistoryGridUIClassName(billId);
        data.put("historyUIClsName", className);
        try {
            IBillImageFacade billimage = BillImageFacadeFactory.getLocalInstance((Context)this.ctx);
            String imageState = billimage.getImageState(null, billId).getValue();
            data.put("imageState", imageState);
        }
        catch (Exception billimage) {
            // empty catch block
        }
        String actInstId = (String)params.get("actInstId");
        String tip = this.getTip(assignmentId, actInstId);
        data.put("tip", tip);
        IMultiApprove multiApprove = MultiApproveFactory.getLocalInstance(this.ctx);
        StringBuffer buffer = new StringBuffer();
        buffer.append("where");
        buffer.append(" (assignment='" + assignmentId + "')");
        String oql = buffer.toString();
        MultiApproveCollection multiApproves = multiApprove.getMultiApproveCollection(oql);
        data.put("multiApproves", (Object)multiApproves);
        String procInstId = (String)params.get("procInstId");
        boolean can = this.canAppendPreActivity(procInstId);
        data.put("canAppendPreActivity", can);
        String count = this.getAttachmentCount(billId);
        data.put("AttachmentCount", count);
        data.put("isShowAppendActivity", this.isShowAppendActivity());
        boolean b = MultiApproveUIFacade.showMultiapprovePersonPosOrOrg(this.ctx);
        data.put("showMultiapprovePersonPosOrOrg", b);
        return data;
    }

    private String getTip(String assignmentId, String actInstId) throws Exception {
        String tip = "";
        try {
            String approveTask = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"APPROVETASK", (Locale)this.ctx.getLocale());
            String node = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"NODE", (Locale)this.ctx.getLocale());
            String task = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"TASK", (Locale)this.ctx.getLocale());
            String option = EASResource.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"OPINION", (Locale)this.ctx.getLocale());
            String userID = this.ctx.getCaller().toString();
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
            Person person = svc.getPersonByUserID(userID);
            Locale local = SysContext.getSysContext().getLocale();
            String language = LocaleUtils.getShortCode((Locale)local);
            StringBuffer tStrSql = new StringBuffer();
            tStrSql.append(" select c.ftype,c.FOpinion_l2,c.fassignmentid,b.FNAME_" + language + ", c.fcurrentacinstid");
            tStrSql.append(" from t_bas_option c LEFT OUTER JOIN T_PM_user  b on c.FCREATORID  = b.FID ");
            tStrSql.append(" WHERE c.FNEXTASSIGNID=?");
            Object[] objects = new Object[]{assignmentId};
            if (actInstId != null) {
                tStrSql.append(" or (c.FACTINSTID = ? and (c.FNEXTHANDLERPERSONID= ? or c.ftype!=11) and (c.FNEXTHANDLERPERSONID= ? or c.ftype!=3)) ");
                objects = new Object[]{assignmentId, actInstId, person.getEmployeeId(), userID};
            }
            IRowSet rs = null;
            rs = DbUtil.executeQuery((Context)this.ctx, (String)tStrSql.toString(), (Object[])objects);
            if (rs != null && rs.next()) {
                String actDefName = "";
                if (!StringUtils.isEmpty((String)rs.getString(5))) {
                    ActivityInstInfo activityInfo = svc.getActivityInstByActInstId(rs.getString(5));
                    actDefName = activityInfo.getActDefName(this.ctx.getLocale());
                } else {
                    AssignmentInfo assignment = svc.getAssignmentById(rs.getString(3));
                    actDefName = assignment.getActDefName(this.ctx.getLocale());
                }
                String type = OptionType.getEnum((int)Integer.parseInt(rs.getString(1).toString())).getAlias();
                String opinion = rs.getString(2);
                if (opinion == null) {
                    opinion = "";
                }
                tip = approveTask + "[" + rs.getString(4) + "] " + node + " [" + actDefName + "] " + type + task + "\uff0c" + type + option + "\uff1a" + opinion;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tip;
    }

    private boolean isShowAllEmptyPostActivities(String actDefId, String procDefHashValue) throws Exception {
        IWfFacade facade = WfFacadeFactory.getLocalInstance((Context)this.ctx);
        return facade.isShowAllEmptyPostActivityPerformers(actDefId, procDefHashValue);
    }

    private boolean isNeedDefaultOption() {
        try {
            String value = ParamManager.getParamValue((Context)this.ctx, null, (String)"BS_MESSAGE_MASKDEFAULTOPINION");
            if ("false".equalsIgnoreCase(value)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean canAppendPreActivity(String procInstId) throws Exception {
        boolean canAppend = true;
        IEnactmentService es = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        ArrayList actIds = es.getOpenedActivityByProcInstId(procInstId);
        int length = 0;
        for (int i = 0; i < actIds.size(); ++i) {
            String actId = (String)actIds.get(i);
            ActivityInstInfo info = es.getActivityInstByActInstId(actId);
            ActivityDef actDef = es.getActDefByActInstInfo(info);
            if (actDef == null || actDef.getActivityHeader() == null || actDef.getActivityHeader().getExtendedAttributes() == null || actDef.getActivityHeader().getExtendedAttributes().get("isAppended") == null) continue;
            String isAppended = actDef.getActivityHeader().getExtendedAttributes().get("appendActivity").getValue();
            if ("true".equals(isAppended)) {
                ++length;
            }
            if (length <= 1) continue;
            canAppend = false;
            return canAppend;
        }
        return canAppend;
    }

    private boolean isShowAppendActivity() {
        try {
            String value = ParamManager.getParamValue((Context)this.ctx, null, (String)"IS_SHOW_APPENDACTIVITY");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getAttachmentCount(String billId) {
        String sql = "select count(*) num from t_bas_boattchasso where fboid='" + billId + "'";
        try {
            ISQLExecutor sqlExecutor = SQLExecutorFactory.getLocalInstance((Context)this.ctx, (String)sql);
            IRowSet rowset = sqlExecutor.executeSQL();
            while (rowset.next()) {
                if (rowset.getString("num") == null) continue;
                return rowset.getString("num").toString();
            }
            return "0";
        }
        catch (Exception e) {
            return "-1";
        }
    }

    public static boolean showMultiapprovePersonPosOrOrg(Context ctx) throws BOSException {
        return MultiApproveUIFacade.paramValueIsTrue(ctx, "showMultiapprovePersonOrg") || MultiApproveUIFacade.paramValueIsTrue(ctx, "showMultiapproveOrgFullName");
    }

    public static boolean paramValueIsTrue(Context ctx, String param) throws BOSException {
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        String result = null;
        try {
            result = ParamManager.getParamValue((Context)ctx, null, (String)param);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return result != null && result.equalsIgnoreCase("true");
    }
}

