/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.noteprint.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.reportone.data.invoke.IDataExecutor;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.RowSet;

public class BosExecutor {
    public static final String EXECUTE_SQL = "executeSql";
    private Context ctx;
    private FilterInfo defaultFilter;
    private static BosExecutor remoteInstance = new BosExecutor(null);

    public static BosExecutor getRemoteInstance() {
        return remoteInstance;
    }

    public static BosExecutor newLocalInstance(Context ctx) {
        return new BosExecutor(ctx);
    }

    protected BosExecutor(Context ctx) {
        this.ctx = ctx;
    }

    public FilterInfo getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(FilterInfo defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public Object execute(Object obj, HashMap params, IDataExecutor env) throws Exception {
        if (obj instanceof QueryInfo) {
            return this.executeQuery(((QueryInfo)obj).getFullName(), params);
        }
        if (obj instanceof EntityViewInfo) {
            return this.executeEntity(((QueryInfo)obj).getFullName(), params);
        }
        if (obj instanceof FullPath) {
            FullPath fp = (FullPath)obj;
            DataDefType type = DataDefType.fromName((String)fp.getCategory());
            if (DataDefType.BOS_QUERY == type) {
                return this.executeQuery(fp.getDots(), params);
            }
            if (DataDefType.BOS_ENTITY == type) {
                return this.executeEntity(fp.getDots(), params);
            }
        }
        return null;
    }

    public ResultSet executeQuery(String fullName, HashMap params) throws BOSException, SQLException {
        EntityViewInfo evi = this.mergeDefaultFilter((EntityViewInfo)params.get("FILTER"));
        if (this.ctx != null && params.get(EXECUTE_SQL) != null) {
            return this.executeQuerySql(fullName, evi);
        }
        return this.executeQuery(fullName, evi);
    }

    public ResultSet executeEntity(String fullName, HashMap params) throws BOSException, SQLException {
        EntityViewInfo evi = this.mergeDefaultFilter((EntityViewInfo)params.get("FILTER"));
        if (this.ctx != null && params.get(EXECUTE_SQL) != null) {
            return this.executeEntitySql(fullName, evi);
        }
        return this.executeEntity(fullName, evi);
    }

    public RowSet executeQuery(String fullName, EntityViewInfo evi) throws BOSException {
        MetaDataPK pk = new MetaDataPK(fullName);
        IQueryExecutor exec = this.ctx != null ? QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        return exec.executeQuery();
    }

    public RowSet executeEntity(String fullName, EntityViewInfo evi) throws BOSException {
        MetaDataPK pk = new MetaDataPK(fullName);
        IDataProvider exec = this.ctx != null ? EntityExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk) : EntityExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        return exec.executeQuery();
    }

    public ResultSet executeQuerySql(String fullName, EntityViewInfo evi) throws BOSException, SQLException {
        MetaDataPK pk = new MetaDataPK(fullName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
        exec.setObjectView(evi);
        String sql = exec.getSQL();
        Connection conn = EJBFactory.getQueryConnection((Context)this.ctx);
        return DBUtil.executeSql((Connection)conn, (String)sql);
    }

    public ResultSet executeEntitySql(String fullName, EntityViewInfo evi) throws BOSException, SQLException {
        MetaDataPK pk = new MetaDataPK(fullName);
        IDataProvider exec = EntityExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
        exec.setObjectView(evi);
        String sql = exec.getSQL();
        Connection conn = EJBFactory.getQueryConnection((Context)this.ctx);
        return DBUtil.executeSql((Connection)conn, (String)sql);
    }

    private EntityViewInfo mergeDefaultFilter(EntityViewInfo evi) {
        FilterInfo filter;
        FilterInfo defaultFilter = this.getDefaultFilter();
        if (defaultFilter == null) {
            return evi;
        }
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        if ((filter = evi.getFilter()) == null) {
            evi.setFilter(defaultFilter);
        } else {
            try {
                filter.mergeFilter(defaultFilter, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return evi;
    }
}

