/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.app.AbstractAuthenSchemeRoleControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.log4j.Logger;

public class AuthenSchemeRoleControllerBean
extends AbstractAuthenSchemeRoleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.AuthenSchemeRoleControllerBean");
    private int MAX_RECORD_COUNT = 8000;

    @Override
    protected void _saveChange(Context ctx, String authenSchemeId, Set addRoleSet, Set deleteRoleSet) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            this.addRole(conn, authenSchemeId, addRoleSet);
            this.deleteRole(conn, authenSchemeId, deleteRoleSet);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void deleteRole(Connection conn, String authenSchemeId, Set deleteRoleSet) throws BOSException {
        if (deleteRoleSet == null || deleteRoleSet.isEmpty()) {
            return;
        }
        PreparedStatement deleteRoleStatement = null;
        try {
            StringBuffer deleteRoleSql = new StringBuffer();
            deleteRoleSql.append("delete from t_pm_authenschemerole ").append("where fauthenschemeid = ? and froleid = ?");
            deleteRoleStatement = conn.prepareStatement(deleteRoleSql.toString());
            int count = 0;
            for (Object roleIdObj : deleteRoleSet) {
                deleteRoleStatement.setString(1, authenSchemeId);
                deleteRoleStatement.setObject(2, roleIdObj);
                deleteRoleStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                deleteRoleStatement.executeBatch();
                deleteRoleStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                deleteRoleStatement.executeBatch();
                deleteRoleStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(deleteRoleStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)deleteRoleStatement);
    }

    private void addRole(Connection conn, String authenSchemeId, Set addRoleSet) throws BOSException {
        if (addRoleSet == null || addRoleSet.isEmpty()) {
            return;
        }
        PreparedStatement addRoleStatement = null;
        try {
            StringBuffer addRoleSql = new StringBuffer();
            addRoleSql.append("insert into t_pm_authenschemerole(fid, fauthenschemeid, froleid) ").append("values(?, ?, ?)");
            addRoleStatement = conn.prepareStatement(addRoleSql.toString());
            String id = null;
            int count = 0;
            for (Object roleIdObj : addRoleSet) {
                id = BOSUuid.create((String)"8AB3D21A").toString();
                addRoleStatement.setString(1, id);
                addRoleStatement.setString(2, authenSchemeId);
                addRoleStatement.setObject(3, roleIdObj);
                addRoleStatement.addBatch();
                if (++count <= this.MAX_RECORD_COUNT) continue;
                addRoleStatement.executeBatch();
                addRoleStatement.clearBatch();
                count = 0;
            }
            if (count > 0) {
                addRoleStatement.executeBatch();
                addRoleStatement.clearBatch();
                count = 0;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(addRoleStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)addRoleStatement);
    }
}

