/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermDebugHelper;
import com.kingdee.eas.base.permission.PermDebugParam;
import com.kingdee.eas.base.permission.PermDebugResult;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemURLCollection;
import com.kingdee.eas.base.permission.PermItemURLFactory;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.PermissionManagerException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.SignatureFieldInfo;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.AbstractPermissionManagerControllerBean;
import com.kingdee.eas.base.permission.app.SignatureConfiguration;
import com.kingdee.eas.base.permission.app.util.FilterHelper;
import com.kingdee.eas.base.permission.card.DynamicCardProxy;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionManagerControllerBean
extends AbstractPermissionManagerControllerBean {
    private static Logger logger = Logger.getLogger(PermissionManagerControllerBean.class);

    @Override
    protected String _getRelatedUserSQL(Context ctx, IObjectPK orgPK, IObjectPK permItemPK) throws BOSException, EASBizException {
        assert (orgPK != null && permItemPK != null);
        IPermItem iPermItem = PermItemFactory.getLocalInstance(ctx);
        PermItemInfo permItemInfo = iPermItem.getPermItemInfo(permItemPK);
        String orgID = orgPK.toString();
        String longNumber = permItemInfo.getLongNumber();
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT UserOrgPerm.FOwner AS FID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE ( UserOrgPerm.FOrgID = '").append(orgID).append("' ").append(" OR UserOrgPerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ").append(" AND PermItem.FLongNumber = ").append("N'").append(longNumber).append("' ").append(" AND UserOrgPerm.FPermType = ").append(10).append(" ");
        sql.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
        sql.append(" UNION ALL ");
        sql.append(" SELECT UserRoleOrg.FUserID AS FID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_RolePerm RolePerm ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FOrgID = '").append(orgID).append("' ").append(" AND PermItem.FLongNumber = ").append("N'").append(longNumber).append("' ").append(" AND RolePerm.FPermType = ").append(10).append(" ");
        sql.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
        sql.append(" UNION ALL ");
        sql.append(" SELECT UserRoleOrg.FUserID AS FID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_RolePerm RolePerm ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" WHERE PermItem.FOrgRelation = ").append(-1).append(" ").append(" AND PermItem.FLongNumber = ").append("N'").append(longNumber).append("' ").append(" AND RolePerm.FPermType = ").append(10).append(" ");
        sql.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
        return sql.toString();
    }

    @Override
    protected IObjectCollection _getAllPerms(Context ctx, IObjectPK owner, IObjectPK orgPK) throws BOSException, EASBizException {
        assert (owner != null && orgPK != null);
        UserOrgPermCollection collection = new UserOrgPermCollection();
        try {
            StringBuffer buffer = new StringBuffer(600);
            String userID = owner.toString();
            String orgID = orgPK.toString();
            String aliasField = MultiLangHelper.getFieldName("FAlias", ctx.getLocale());
            Object[] params = new Object[]{userID, orgID, userID, orgID, userID, orgID};
            buffer.append(" SELECT RolePerm.FPermItemID AS FPermItemID, RolePerm.FPermType AS FPermType, ").append(" RolePerm.FRuleStructure AS FRuleStructure, RolePerm.FRuleExpr AS FRuleExpr, ").append(" PermItem.").append(aliasField).append(" AS FAlias, ").append(" PermItem.FOrgRelation AS FOrgRelation, PermItem.FIsLeaf AS FIsLeaf, ").append(" PermItem.FParentID AS FParentID,  PermItem.FObjectType AS FObjectType, PermItem.FIsApplyToF7 AS FIsApplyToF7 ").append(" FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND UserRoleOrg.FOrgID = ? ");
            String roleFilter = FilterHelper.getRoleOrgRelationFilter(ctx, orgPK, "PermItem.FOrgRelation");
            if (!StringUtils.isEmpty((String)roleFilter)) {
                buffer.append(" AND ( ").append(roleFilter).append(" ) ");
            }
            buffer.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
            buffer.append(" UNION ALL ");
            buffer.append(" SELECT RolePerm.FPermItemID AS FPermItemID, RolePerm.FPermType AS FPermType, ").append(" RolePerm.FRuleStructure AS FRuleStructure, RolePerm.FRuleExpr AS FRuleExpr, ").append(" PermItem.").append(aliasField).append(" AS FAlias, ").append(" PermItem.FOrgRelation AS FOrgRelation, PermItem.FIsLeaf AS FIsLeaf, ").append(" PermItem.FParentID AS FParentID,  PermItem.FObjectType AS FObjectType, PermItem.FIsApplyToF7 AS FIsApplyToF7 ").append(" FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = RolePerm.FPermItemID ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND UserRoleOrg.FOrgID = ? ").append(" AND PermItem.FOrgRelation = ").append(-1).append(" ");
            buffer.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
            buffer.append(" UNION ALL ");
            buffer.append(" SELECT UserOrgPerm.FPermItemID AS FPermItemID, UserOrgPerm.FPermType AS FPermType, ").append(" UserOrgPerm.FRuleStructure AS FRuleStructure, UserOrgPerm.FRuleExpr AS FRuleExpr, ").append(" PermItem.").append(aliasField).append(" AS FAlias, ").append(" PermItem.FOrgRelation AS FOrgRelation, PermItem.FIsLeaf AS FIsLeaf, ").append(" PermItem.FParentID AS FParentID,  PermItem.FObjectType AS FObjectType, PermItem.FIsApplyToF7 AS FIsApplyToF7 ").append(" FROM T_PM_UserOrgPerm UserOrgPerm ").append(" INNER JOIN T_PM_PermItem PermItem ON PermItem.FID = UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND ( UserOrgPerm.FOrgID = ? OR UserOrgPerm.FOrgID = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ) ");
            buffer.append(FilterHelper.getS1BaseDataFilter(orgPK, "PermItem.FObjectType", "PermItem.FOperationType"));
            HashMap<String, UserOrgPermInfo> mapPermItem = new HashMap<String, UserOrgPermInfo>();
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            HashSet<SimpleUserOrgPerm> retSet = new HashSet<SimpleUserOrgPerm>();
            while (rowSet.next()) {
                SimpleUserOrgPerm suop = new SimpleUserOrgPerm();
                suop.setAlias(rowSet.getString("FAlias"));
                suop.setIsApplyToF7(rowSet.getString("FIsApplyToF7"));
                suop.setIsLeaf(rowSet.getString("FIsLeaf"));
                suop.setObjectType(rowSet.getString("FObjectType"));
                suop.setOrgRelation(rowSet.getString("FOrgRelation"));
                suop.setParentID(rowSet.getString("FParentID"));
                suop.setPermItemId(rowSet.getString("FPermItemID"));
                suop.setPermType(rowSet.getString("FPermType"));
                suop.setRuleExpr(rowSet.getString("FRuleExpr"));
                suop.setRuleStructure(rowSet.getString("FRuleStructure"));
                retSet.add(suop);
            }
            for (SimpleUserOrgPerm suop : retSet) {
                UserOrgPermInfo info = new UserOrgPermInfo();
                PermItemInfo permItemInfo = new PermItemInfo();
                String permItemID = suop.getPermItemID();
                permItemInfo.setId(BOSUuid.read((String)permItemID));
                permItemInfo.setAlias(suop.getAlias());
                permItemInfo.setOrgRelation(OrgType.getEnum((int)Integer.parseInt(suop.getOrgRelation())));
                permItemInfo.setIsLeaf(suop.getIsLeaf().equals("1"));
                permItemInfo.setObjectType(suop.getObjectType());
                permItemInfo.setEnableDataPermission(suop.getIsApplyToF7().equals("1"));
                String parentID = suop.getParentID();
                if (parentID != null) {
                    PermItemInfo parent = new PermItemInfo();
                    parent.setId(BOSUuid.read((String)parentID));
                    permItemInfo.setParent(parent);
                }
                info.setPermItem(permItemInfo);
                info.setPermType(PermType.getEnum(Integer.parseInt(suop.getPermType())));
                info.setRuleExpr(suop.getRuleExpr());
                info.setRuleStructure(suop.getRuleStructure());
                if (mapPermItem.containsKey(this.getKey(info))) {
                    UserOrgPermInfo existInfo = (UserOrgPermInfo)mapPermItem.get(this.getKey(info));
                    if (StringUtils.isEmpty((String)existInfo.getRuleStructure())) {
                        existInfo.setRuleStructure(info.getRuleStructure());
                        existInfo.setRuleExpr(info.getRuleExpr());
                        continue;
                    }
                    if (StringUtils.isEmpty((String)info.getRuleStructure())) continue;
                    String roleRuleExpr = existInfo.getRuleStructure();
                    roleRuleExpr = this.rebuildRuleStructure(roleRuleExpr);
                    String userRuleExpr = info.getRuleStructure();
                    userRuleExpr = this.rebuildRuleStructure(userRuleExpr);
                    String result = RuleUtil.mergeOQL(roleRuleExpr, userRuleExpr, "OR");
                    result = StringUtils.replace((String)result, (String)"fid =", (String)"");
                    result = StringUtils.replace((String)result, (String)"'", (String)"");
                    existInfo.setRuleStructure(result);
                    continue;
                }
                mapPermItem.put(this.getKey(info), info);
                collection.add(info);
            }
        }
        catch (FetchedTooMuchRowsException e) {
            logger.error((Object)"FetchedTooMuchRowsException", (Throwable)e);
            throw new PermissionManagerException(PermissionManagerException.GET_INFO_FAIL, e);
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException is:", (Throwable)e);
            throw new PermissionManagerException(PermissionManagerException.GET_INFO_FAIL, e);
        }
        catch (BOSException e) {
            logger.error((Object)"bosError:", (Throwable)e);
            throw new PermissionManagerException(PermissionManagerException.GET_INFO_FAIL, e);
        }
        catch (ParserException e) {
            logger.error((Object)"ParserException:", (Throwable)e);
            throw new PermissionManagerException(PermissionManagerException.GET_INFO_FAIL, e);
        }
        return collection;
    }

    private String rebuildRuleStructure(String ruleStructure) {
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)ruleStructure)) {
            for (String str : StringUtils.split((String)ruleStructure, (String)" ")) {
                if (RuleUtil.isRuleID(str)) {
                    result.append(" ");
                    result.append(" fid = ' " + str + " '");
                    result.append(" ");
                    continue;
                }
                result.append(" ");
                result.append(str);
                result.append(" ");
            }
        }
        return result.toString();
    }

    private String getKey(UserOrgPermInfo userOrgPermInfo) {
        StringBuffer key = new StringBuffer();
        key.append(userOrgPermInfo.getPermItem().getId()).append("_").append(userOrgPermInfo.getPermType().getValue());
        return key.toString();
    }

    private String getAdminCUStr(Context ctx, IObjectPK sourceUserPK) throws EASBizException, BOSException {
        List ouList = OrgRangeService.getCUOrgRange(ctx, sourceUserPK);
        return ToolUtils.aryToStr(ouList, true);
    }

    @Override
    protected Map _getAccreditOrgs(Context ctx, IObjectPK ctrlUnitPK, IObjectPK sourceUserPK, IObjectPK targetUserPK) throws BOSException, EASBizException {
        assert (ctrlUnitPK != null && sourceUserPK != null && targetUserPK != null);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        StringBuffer buffer = new StringBuffer();
        Object[] params = null;
        if (Administrator.isCUAdmin(ctx, sourceUserPK)) {
            params = new Object[]{targetUserPK.toString()};
            buffer.append(" SELECT BaseUnit.FID FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_PM_OrgRange OrgRange ON OrgRange.FOrgID = BaseUnit.FID ").append(" WHERE BaseUnit.FControlUnitID  in (" + this.getAdminCUStr(ctx, sourceUserPK) + ") AND OrgRange.FUserID = ? ").append(" AND FType = ").append(10);
        } else {
            params = new Object[]{ctrlUnitPK.toString(), targetUserPK.toString(), ctrlUnitPK.toString(), sourceUserPK.toString()};
            buffer.append(" SELECT A.FID FROM ( ").append(" SELECT BaseUnit.FID FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_PM_OrgRange OrgRange ON OrgRange.FOrgID = BaseUnit.FID ").append(" WHERE BaseUnit.FControlUnitID = ? AND OrgRange.FUserID = ? ").append(" AND FType = ").append(10).append(" ) A ").append(" WHERE A.FID IN ( ").append(" SELECT BaseUnit.FID FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_PM_OrgRange OrgRange ON OrgRange.FOrgID = BaseUnit.FID ").append(" WHERE BaseUnit.FControlUnitID = ? AND OrgRange.FUserID = ? ").append(" AND FType = ").append(10).append(" )");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            while (rowSet.next()) {
                result.put(rowSet.getString("FID"), Boolean.FALSE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionManagerException(PermissionManagerException.GET_INFO_FAIL, e);
        }
        return result;
    }

    @Override
    protected Map _getUserOrgs(Context ctx, IObjectPK ctrlUnitPK, IObjectPK userPK, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Object[] params = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" SELECT BaseUnit.FID FROM T_ORG_BaseUnit BaseUnit ").append(" INNER JOIN T_PM_OrgRange OrgRange ON OrgRange.FOrgID = BaseUnit.FID ");
        if (ctrlUnitPK == null) {
            buffer.append(" WHERE OrgRange.FUserID = ? AND FType = ? ");
            params = new Object[]{userPK.toString(), new Integer(orgRangeType.getValue())};
        } else {
            buffer.append(" WHERE BaseUnit.FControlUnitID = ? AND OrgRange.FUserID = ?  AND FType = ? ");
            params = new Object[]{ctrlUnitPK.toString(), userPK.toString(), new Integer(orgRangeType.getValue())};
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
            while (rowSet.next()) {
                result.put(rowSet.getString("FID"), Boolean.FALSE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new PermissionManagerException(PermissionManagerException.GET_INFO_FAIL, e);
        }
        return result;
    }

    @Override
    protected FullOrgUnitCollection _findOrgRange(Context ctx, IObjectPK userPK, OrgRangeType bizOrgRangeType) throws BOSException, EASBizException {
        IOrgRange orgRange = OrgRangeFactory.getLocalInstance(ctx);
        OrgRangeCollection orgRangeCol = orgRange.findFullOrgCol(userPK, bizOrgRangeType);
        if (orgRangeCol == null || orgRangeCol.isEmpty()) {
            return new FullOrgUnitCollection();
        }
        List orgIdList = ToolUtils.transCol2ListByPeroperty((IObjectCollection)orgRangeCol, new IObjectCol2List(){

            @Override
            public String getList(Object obj) {
                OrgRangeInfo orgRangeInfo = (OrgRangeInfo)obj;
                return orgRangeInfo.getOrg().getId().toString();
            }
        });
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        return iFullOrgUnit.getFullOrgUnitCollection("select * where id in (" + ToolUtils.aryToStr(orgIdList, true) + ")");
    }

    @Override
    protected void _checkDynamicPwd(Context ctx, String userName, String password) throws BOSException, EASBizException {
        DynamicCardProxy proxy = new DynamicCardProxy();
        try {
            proxy.checkPwd(userName, password);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new UserException(UserException.USER_OR_PASSWORD_IS_MOT_MATCH);
        }
    }

    @Override
    protected boolean _checkPassword(Context ctx, String userNumber, String password, LoginAuthorWayEnum loginWay) throws BOSException, EASBizException {
        if (LoginAuthorWayEnum.DYNAMIC.equals((Object)loginWay)) {
            this._checkDynamicPwd(ctx, userNumber, password);
        } else if (LoginAuthorWayEnum.NORMAL.equals((Object)loginWay)) {
            UserFactory.getLocalInstance(ctx).matchPassword(userNumber, password);
        }
        return true;
    }

    @Override
    protected PermDebugResult _debugPermission(Context ctx, PermDebugParam debugPermParam) throws BOSException, EASBizException {
        return PermDebugHelper.getPermDebugResult(ctx, debugPermParam);
    }

    @Override
    protected SignatureFieldInfo _getSignatureFieldInfo(Context ctx, String bosType) throws BOSException, EASBizException {
        return SignatureConfiguration.getInstance().getSignatureFieldInfo(BOSObjectType.create((String)bosType));
    }

    @Override
    protected boolean _isIncludeAuthenPerms(Context ctx, String permIdStr) throws BOSException, EASBizException {
        String sql = "select FPermitemID from  T_PM_PermAuthentor where FPermitemID in(" + permIdStr + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (permIdStr.indexOf(",") <= 0) {
            permIdStr = permIdStr.substring(1, permIdStr.length() - 1);
            PermItemInfo permitemInfo = PermItemFactory.getLocalInstance(ctx).getPermItemInfo((IObjectPK)new ObjectUuidPK(permIdStr));
            if (!permitemInfo.isIsLeaf()) {
                sql = "select 1 from t_pm_permitem where fid=? and exists (select 1 from t_pm_permitem pm where pm.fid in(select fpermitemid from T_PM_PermAuthentor) and charindex(t_pm_permitem.flongnumber,pm.flongnumber)=1)";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{permIdStr});
                try {
                    if (rowSet.next()) {
                        return true;
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return false;
    }

    @Override
    protected boolean _isRoleIncludeAuthenPerms(Context ctx, String roleIdStr) throws BOSException, EASBizException {
        String sql = "select FPERMITEMID from T_PM_PermAuthentor pa where exists( select fpermitemid from T_PM_RolePerm rp where rp.froleid in(" + roleIdStr + ") and  pa.fpermitemid = rp.fpermitemid)";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected IObjectPK _savePermItemForSHR(Context ctx, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        PermItemURLCollection urls;
        IPermItem permItem = PermItemFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = null;
        if (permItemInfo.getId() != null) {
            pk = new ObjectUuidPK(permItemInfo.getId());
        }
        if ((urls = permItemInfo.getUrls()).size() > 0) {
            HashSet<String> urlSet = new HashSet<String>();
            for (int i = 0; i < urls.size(); ++i) {
                urlSet.add(urls.get(i).getUrl().trim());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("url", urlSet, CompareType.INCLUDE));
            if (pk != null) {
                filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString(), CompareType.NOTEQUALS));
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("url"));
            viewInfo.setFilter(filter);
            PermItemURLCollection c = PermItemURLFactory.getLocalInstance(ctx).getPermItemURLCollection(viewInfo);
            if (c != null && c.size() > 0) {
                throw new BOSException("url\u3010" + c.get(0).getUrl() + "\u3011duplicate!");
            }
        }
        if (pk != null && permItem.exists((IObjectPK)pk)) {
            String newLongNumber;
            PermItemInfo oldPermItem = permItem.getPermItemInfo((IObjectPK)pk);
            String oldLongNumber = oldPermItem.getLongNumber();
            if (!oldLongNumber.equals(newLongNumber = permItemInfo.getLongNumber())) {
                this.updatePermItemLongNumber(ctx, newLongNumber, oldLongNumber);
            }
            String oldLongIndex = oldPermItem.getLongIndex();
            String newLongIndex = permItemInfo.getLongIndex();
            if (newLongIndex != null && !newLongIndex.equals(oldLongIndex)) {
                this.updatePermItemLongIndex(ctx, newLongIndex, oldLongIndex);
            }
        }
        pk = permItem.save(permItemInfo);
        String sql = "DELETE FROM T_PM_PermDependency where FID = ? and fisUserDefined=1";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
        PermItemCollection items = permItemInfo.getDependencyItems();
        if (items != null && items.size() > 0) {
            String checkLoop = PermissionManagerControllerBean.checkLoopPermItem(ctx, permItemInfo);
            if (!StringUtils.isEmpty((String)checkLoop)) {
                throw new BOSException(checkLoop);
            }
            sql = "INSERT INTO T_PM_PermDependency (FID, FDependencyID,FIsUserDefined) VALUES (?, ? , ? )";
            PermItemInfo depItemInfo = null;
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            for (int i = 0; i < items.size(); ++i) {
                depItemInfo = items.get(i);
                paramsList.add(new Object[]{pk.toString(), depItemInfo.getId().toString(), 1});
            }
            DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        }
        return pk;
    }

    private void updatePermItemLongNumber(Context ctx, String newLongNumber, String oldLongNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_pm_permitem set flongnumber =REPLACE(flongnumber,");
        sql.append(" '").append(oldLongNumber).append("!',").append("'").append(newLongNumber).append("!')").append(" where flongnumber like '").append(oldLongNumber).append("!%'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void updatePermItemLongIndex(Context ctx, String newLongIndex, String oldLongIndex) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_pm_permitem set flongindex = CONCAT('" + newLongIndex + "',");
        sql.append("SUBSTRING(flongindex,LENGTH('" + oldLongIndex + "')+1,LENGTH(flongindex)))");
        sql.append(" where flongindex like '").append(oldLongIndex).append("!%'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected PermItemInfo _getPermItemInfoForSHR(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        PermItemInfo permItemInfo = PermItemFactory.getLocalInstance(ctx).getPermItemInfo(pk, selector);
        StringBuffer subSql = new StringBuffer();
        subSql.append("select id,alias ");
        subSql.append(" where id in(");
        subSql.append("select FDependencyID from T_PM_PermDependency where fid ='").append(pk).append("' and FIsUserDefined=1");
        subSql.append(")");
        PermItemCollection items = PermItemFactory.getLocalInstance(ctx).getPermItemCollection(subSql.toString());
        if (items != null && items.size() > 0) {
            permItemInfo.setDependencyItems(items);
        }
        return permItemInfo;
    }

    private static String checkLoopPermItem(Context ctx, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        PermItemCollection items = permItemInfo.getDependencyItems();
        if (items == null || items.size() == 0) {
            return null;
        }
        String sql = "select * FROM T_PM_PermDependency where fisUserDefined=1";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String key = null;
            String value = null;
            while (rs.next()) {
                key = rs.getString("FID");
                value = rs.getString("FDependencyID");
                if (map.containsKey(key)) {
                    value = value + "|" + (String)map.get(key);
                }
                map.put(key, value);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (map.isEmpty()) {
            return null;
        }
        PermItemInfo depItemInfo = null;
        ArrayList<String> path = null;
        for (int i = 0; i < items.size(); ++i) {
            depItemInfo = items.get(i);
            path = new ArrayList<String>();
            if (PermissionManagerControllerBean.checkLoopPermItem(permItemInfo.getId().toString(), depItemInfo.getId().toString(), map, path)) break;
        }
        if (path.size() > 0) {
            return ((Object)path).toString();
        }
        return null;
    }

    private static boolean checkLoopPermItem(String permItemid, String depItem, Map<String, String> depItemMap, List<String> path) throws BOSException, EASBizException {
        String items = depItemMap.get(depItem);
        if (items == null) {
            return false;
        }
        if (items.indexOf(permItemid) > -1) {
            path.add(permItemid);
            return true;
        }
        String[] itemArray = items.split(",");
        for (int i = 0; i < itemArray.length; ++i) {
            boolean result = PermissionManagerControllerBean.checkLoopPermItem(permItemid, itemArray[i], depItemMap, path);
            if (!result) continue;
            path.add(1, itemArray[i]);
            return true;
        }
        return false;
    }

    class SimpleUserOrgPerm {
        String permItemID = null;
        String permType = null;
        String ruleStructure = null;
        String ruleExpr = null;
        String alias = null;
        String orgRelation = null;
        String isLeaf = null;
        String parentID = null;
        String objectType = null;
        String isApplyToF7 = null;

        SimpleUserOrgPerm() {
        }

        public String getPermItemID() {
            return this.permItemID;
        }

        public void setPermItemId(String permItemID) {
            this.permItemID = permItemID;
        }

        public String getPermType() {
            return this.permType;
        }

        public void setPermType(String permType) {
            this.permType = permType;
        }

        public String getRuleStructure() {
            return this.ruleStructure;
        }

        public void setRuleStructure(String ruleStructure) {
            this.ruleStructure = ruleStructure;
        }

        public String getRuleExpr() {
            return this.ruleExpr;
        }

        public void setRuleExpr(String ruleExpr) {
            this.ruleExpr = ruleExpr;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getOrgRelation() {
            return this.orgRelation;
        }

        public void setOrgRelation(String orgRelation) {
            this.orgRelation = orgRelation;
        }

        public String getIsLeaf() {
            return this.isLeaf;
        }

        public void setIsLeaf(String isLeaf) {
            this.isLeaf = isLeaf;
        }

        public String getParentID() {
            return this.parentID;
        }

        public void setParentID(String parentID) {
            this.parentID = parentID;
        }

        public String getObjectType() {
            return this.objectType;
        }

        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String getIsApplyToF7() {
            return this.isApplyToF7;
        }

        public void setIsApplyToF7(String isApplyToF7) {
            this.isApplyToF7 = isApplyToF7;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SimpleUserOrgPerm)) {
                return false;
            }
            SimpleUserOrgPerm temp = (SimpleUserOrgPerm)obj;
            return StringUtils.cnulls((String)this.getPermItemID()).equals(StringUtils.cnulls((String)temp.getPermItemID())) && StringUtils.cnulls((String)this.getPermType()).equals(StringUtils.cnulls((String)temp.getPermType())) && StringUtils.cnulls((String)this.getRuleStructure()).equals(StringUtils.cnulls((String)temp.getRuleStructure())) && StringUtils.cnulls((String)this.getRuleExpr()).equals(StringUtils.cnulls((String)temp.getRuleExpr())) && StringUtils.cnulls((String)this.getAlias()).equals(StringUtils.cnulls((String)temp.getAlias())) && StringUtils.cnulls((String)this.getOrgRelation()).equals(StringUtils.cnulls((String)temp.getOrgRelation())) && StringUtils.cnulls((String)this.getIsLeaf()).equals(StringUtils.cnulls((String)temp.getIsLeaf())) && StringUtils.cnulls((String)this.getParentID()).equals(StringUtils.cnulls((String)temp.getParentID())) && StringUtils.cnulls((String)this.getObjectType()).equals(StringUtils.cnulls((String)temp.getObjectType())) && StringUtils.cnulls((String)this.getIsApplyToF7()).equals(StringUtils.cnulls((String)temp.getIsApplyToF7()));
        }

        public int hashCode() {
            return (StringUtils.cnulls((String)this.getPermItemID()) + StringUtils.cnulls((String)this.getPermType()) + StringUtils.cnulls((String)this.getRuleStructure()) + StringUtils.cnulls((String)this.getRuleExpr()) + StringUtils.cnulls((String)this.getAlias()) + StringUtils.cnulls((String)this.getOrgRelation()) + StringUtils.cnulls((String)this.getIsLeaf()) + StringUtils.cnulls((String)this.getParentID()) + StringUtils.cnulls((String)this.getObjectType()) + StringUtils.cnulls((String)this.getIsApplyToF7())).hashCode();
        }
    }
}

