/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.orm.template.ORMObject;
import com.kingdee.bos.rpc.RPCServerSession;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.LoginAndLogout;
import com.kingdee.eas.base.permission.IUserFindPass;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserFindPassFacadeFactory;
import com.kingdee.eas.base.permission.UserFindPassParam;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.base.permission.helper.SecurityValidatorHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserFindPass
extends ORMObject
implements IUserFindPass {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.permission.app.UserFindPass");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionFindPassResource";

    @Override
    public boolean checkCanFindPass(String dataCenter, String local, String userNumber) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(dataCenter);
        ctx.setLocale(new Locale(local));
        UserFindPassFacadeFactory.getLocalInstance(ctx).checkCanFindPass(userNumber);
        return true;
    }

    @Override
    public JSONObject sendVCode(String dataCenter, String local, String userNumber, String phoneOrEmail) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(dataCenter);
        ctx.setLocale(new Locale(local));
        return UserFindPassFacadeFactory.getLocalInstance(ctx).sendVcode(userNumber, phoneOrEmail);
    }

    @Override
    public JSONObject sendVCode(String dataCenter, String local, String userNumber, String phoneOrEmail, String clientIP) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(dataCenter);
        ctx.setLocale(new Locale(local));
        ctx.setClientHostIP(clientIP);
        ctx.setClientHostName(clientIP);
        return UserFindPassFacadeFactory.getLocalInstance(ctx).sendVcode(userNumber, phoneOrEmail);
    }

    @Override
    public String verifyVCode(UserFindPassParam params) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(params.getDataCenter());
        ctx.setLocale(new Locale(params.getLocal()));
        boolean isSuccess = false;
        isSuccess = UserFindPassFacadeFactory.getLocalInstance(ctx).verifyVCode(params);
        if (isSuccess) {
            RPCServerSession session = RPCServerSession.getCurrentSession();
            String ut = MD5Util.getMD5String((String)(params.getDataCenter() + params.getUserNumber()));
            session.putContext((Object)"ut", (Object)ut);
            session.putContext((Object)"ut_createtime", (Object)String.valueOf(System.currentTimeMillis()));
            return ut;
        }
        return null;
    }

    @Override
    public void setNewPass(UserFindPassParam params) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(params.getDataCenter());
        ctx.setLocale(new Locale(params.getLocal()));
        ctx.setClientHostName(params.getClientIp());
        ctx.setClientHostIP(params.getClientIp());
        RPCServerSession session = RPCServerSession.getCurrentSession();
        String ut = (String)session.getContext((Object)"ut");
        String ut_createtime = (String)session.getContext((Object)"ut_createtime");
        if (ut == null || ut_createtime == null || !ut.equals(params.getUt()) || !ut.equals(MD5Util.getMD5String((String)(params.getDataCenter() + params.getUserNumber()))) || System.currentTimeMillis() - Long.valueOf(ut_createtime) > 300000L) {
            throw new BOSException(EASResource.getString((String)RESOURCE, (String)"FINDPASS_UT_EMPTY", (Locale)ctx.getLocale()));
        }
        if (params.getUserNumber() == null) {
            throw new UserException(UserException.USER_NOT_EXIST);
        }
        String sql = "SELECT FID ,FNUMBER FROM T_PM_USER WHERE LOWER(FNUMBER)=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{params.getUserNumber().toLowerCase()});
        if (!rs.next()) {
            throw new UserException(UserException.USER_NOT_EXIST);
        }
        ObjectUuidPK pk = new ObjectUuidPK(rs.getString("FID"));
        ctx.setCaller((IObjectPK)pk);
        UserInfo userInfo = UserFactory.getLocalInstance(ctx).getUserInfo((IObjectPK)pk);
        userInfo.remove("orgRange");
        userInfo.setPassword(PermissionCommonUtil.encrypt(rs.getString("FNUMBER"), params.getPassword()));
        UserFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(userInfo.getId()), (IObjectValue)userInfo, true);
        session.removeContext((Object)"ut");
        session.removeContext((Object)"ut_createtime");
        this.logfindPass(ctx, params.getUserNumber());
    }

    private void logfindPass(Context ctx, String userNumber) {
        try {
            UserInfo userInfo4LoinModule = null;
            if (ctx.get((Object)"UserInfo") == null) {
                userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
                ContextUtil.setCurrentUserInfo((Context)ctx, (UserInfo)userInfo4LoinModule);
            }
            if (ContextUtil.getCurrentCtrlUnit((Context)ctx) == null) {
                if (userInfo4LoinModule == null) {
                    userInfo4LoinModule = UserInfoUtils.getUserInfo4LoinModule(ctx, userNumber);
                }
                ContextUtil.setCurrentCtrlUnit((Context)ctx, (CtrlUnitInfo)userInfo4LoinModule.getCU());
            }
            String description = ResourceBase.getString((String)RESOURCE, (String)"log_findPass", (Locale)ctx.getLocale());
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)description, (BOSObjectType)new LoginAndLogout().getType(), null, (String)description, (String)"UserLoginLog");
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] generatorOfflineQrcode(String dataCenter, String local, String userNumber) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(dataCenter);
        ctx.setLocale(new Locale(local));
        return UserFindPassFacadeFactory.getLocalInstance(ctx).generatorOfflineQrcode(userNumber, 158);
    }

    @Override
    public String getUserPwdTip(String dataCenter, String local, String userNumber) throws Exception {
        Context ctx = new Context();
        ctx.setAIS(dataCenter);
        ctx.setLocale(new Locale(local));
        return SecurityValidatorHelper.getPwdTip(ctx, userNumber);
    }
}

