/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUserOrgPerm;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermFactory;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.helper.UserRolePermHelper;
import com.kingdee.eas.base.permission.app.util.GroupLicenseUseInfoUtil;
import com.kingdee.eas.base.permission.util.PermBizHelper;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class UserPermDataTransmission
extends AbstractDataTransmission {
    private Logger logger = Logger.getLogger(UserPermDataTransmission.class);
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return UserOrgPermFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            this.logger.error((Object)"error!", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null || hsData.isEmpty()) {
            throw new IllegalArgumentException("hsData is null");
        }
        String userNumber = (String)((DataToken)hsData.get((Object)"FUserNumber")).data;
        String userName = (String)((DataToken)hsData.get((Object)"FUserName")).data;
        String orgNumber = (String)((DataToken)hsData.get((Object)"FOrgNumber")).data;
        String orgName = (String)((DataToken)hsData.get((Object)"FOrgName")).data;
        String permItemNumber = (String)((DataToken)hsData.get((Object)"FPermItemNumber")).data;
        String permItemAlias = (String)((DataToken)hsData.get((Object)"FPermItemAlias")).data;
        String permTypeStr = (String)((DataToken)hsData.get((Object)"FPermType")).data;
        String ruleStructure = (String)((DataToken)hsData.get((Object)"FRuleStructure")).data;
        String ruleExpr = (String)((DataToken)hsData.get((Object)"FRuleExpr")).data;
        String ctrlUnitNumber = (String)((DataToken)hsData.get((Object)"FCtrlUnitNumber")).data;
        try {
            String importRule;
            UserInfo userInfo = PermBizHelper.findUserInfoByNumber(ctx, userNumber);
            FullOrgUnitInfo fullOrgUnitInfo = PermBizHelper.findFullOrgUnfoByNumber(ctx, orgNumber);
            PermType permType = PermBizHelper.findPermType(permTypeStr);
            PermItemInfo permItemInfo = PermBizHelper.findPermItemInfoByNumber(ctx, permItemNumber);
            UserOrgPermInfo userOrgPermInfo = new UserOrgPermInfo();
            userOrgPermInfo.setOwner(userInfo);
            userOrgPermInfo.setPermItem(permItemInfo);
            userOrgPermInfo.setPermType(permType);
            userOrgPermInfo.setOrg(fullOrgUnitInfo);
            FullOrgUnitInfo ctrlUnitOrgInfo = PermBizHelper.findFullOrgUnfoByNumber(ctx, ctrlUnitNumber);
            CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
            ctrlUnitInfo.setId(ctrlUnitOrgInfo.getId());
            userOrgPermInfo.setCtrlUnit(ctrlUnitInfo);
            IUserOrgPerm iUserOrgPerm = UserOrgPermFactory.getLocalInstance(ctx);
            UserOrgPermCollection userOrgPermCol = iUserOrgPerm.getPermInfo(permItemInfo.getId().toString(), fullOrgUnitInfo.getId().toString(), userInfo.getId().toString(), permType);
            String sql = "select 1 from t_pm_orgrange where fuserid=? and forgid= ?";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userInfo.getId().toString(), fullOrgUnitInfo.getId().toString()});
            try {
                if (!rowSet.next()) {
                    String msg = EASResource.getString((String)RESOURCE, (String)"ORG_NUMBER1") + ":" + fullOrgUnitInfo.getNumber() + EASResource.getString((String)RESOURCE, (String)"NOT_USER_NUMBER") + " :" + userInfo.getNumber() + " " + EASResource.getString((String)RESOURCE, (String)"ORG_RANGE_IN");
                    throw new TaskExternalException(msg);
                }
            }
            catch (SQLException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new TaskExternalException(e.getMessage());
            }
            if (!userOrgPermCol.isEmpty()) {
                if (this.isSltImportUpdate()) {
                    userOrgPermInfo.setId(userOrgPermCol.get(0).getId());
                } else {
                    Object[] param = new Object[]{userNumber, userName, permItemNumber, permItemAlias, orgNumber, orgName, permType.getAlias()};
                    String msg = MessageFormat.format(EASCommonResource.getString((String)RESOURCE, (String)"userPermAlreadyExist", (Locale)ctx.getLocale()), param);
                    throw new TaskExternalException(msg);
                }
            }
            if (!StringUtils.isEmpty((String)(importRule = ParamManager.getParamValue((Context)ctx, null, (String)"PERM_IMPORT_RULE"))) && importRule.trim().equalsIgnoreCase("true")) {
                userOrgPermInfo.setRuleStructure(StringUtils.cnulls((String)ruleStructure));
                userOrgPermInfo.setRuleExpr(StringUtils.cnulls((String)ruleExpr));
            }
            return userOrgPermInfo;
        }
        catch (EASBizException e) {
            this.logger.error((Object)("bizException ! hsData is:" + hsData), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            this.logger.error((Object)("bosException !hsData is:" + hsData), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FUserNumber", StringUtils.cnulls((String)rs.getString("owner.number")));
            result.put("FUserName", StringUtils.cnulls((String)rs.getString("owner.name")));
            result.put("FOrgNumber", StringUtils.cnulls((String)rs.getString("org.number")));
            result.put("FOrgName", StringUtils.cnulls((String)rs.getString("org.name")));
            result.put("FPermItemNumber", StringUtils.cnulls((String)rs.getString("permItem.number")));
            result.put("FPermItemAlias", StringUtils.cnulls((String)rs.getString("permItem.alias")));
            result.put("FPermType", StringUtils.cnulls((String)rs.getString("permType")));
            result.put("FRuleStructure", StringUtils.cnulls((String)rs.getString("ruleStructure")));
            result.put("FRuleExpr", StringUtils.cnulls((String)rs.getString("ruleExpr")));
            result.put("FCtrlUnitNumber", StringUtils.cnulls((String)rs.getString("CU.number")));
            UserRolePermHelper helper = new UserRolePermHelper();
            helper.exportLongNumberLevel(ctx, rs, result);
        }
        catch (SQLException e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        UserOrgPermInfo orgPermInfo = (UserOrgPermInfo)coreBaseInfo;
        ArrayList<String> permitemIds = new ArrayList<String>();
        permitemIds.add(orgPermInfo.getPermItem().getId().toString());
        boolean isAssingPermitem = false;
        try {
            isAssingPermitem = GroupLicenseUseInfoUtil.assignPermitem(ctx, orgPermInfo.getUserId(), permitemIds);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        if (!isAssingPermitem) {
            throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"ASSIGN_DATA_NOTENOUGH"));
        }
        super.submit(coreBaseInfo, ctx);
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.base.permission.app.UserPermQuery";
    }
}

