/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.adapter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.base.permission.app.service.CoopOrgHelper;
import com.kingdee.eas.base.permission.app.service.multiorg.MultiOrgDataPermissionService;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class MutiOrgFilter {
    private static Logger logger = Logger.getLogger((String)MutiOrgFilter.class.getName());
    IPermissionServiceProvider iPermissionService = null;
    private EntityViewInfo retEntiryViewInfo = null;
    private BOSObjectType bosType;
    private Context context = null;

    public MutiOrgFilter(BOSObjectType bosType) {
        this.bosType = bosType;
    }

    public void initMultiOrgFilterItem(Context context, IObjectPK userPK, Collection orgCollection, String orgFieldName, String[] coopFieldName, PermItemInfo permItemInfo) throws BOSException, EASBizException {
        try {
            String ruleStr = "";
            MultiOrgDataPermissionService mpService = new MultiOrgDataPermissionService(context);
            ruleStr = mpService.getPermissionRule(userPK, orgCollection, permItemInfo.getName(), orgFieldName);
            if (CommonFilterUtil.isLikeVarEnumValue((String)ruleStr)) {
                ruleStr = CommonQueryUtil.getInnerFilterInfo((Context)context, (String)ruleStr);
            }
            this.mergFilterItems(context, orgCollection, orgFieldName, coopFieldName, ruleStr);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void mergFilterItems(Context context, Collection orgCollection, String orgFieldName, String[] coopFieldName, String ruleStr) throws BOSException, ParserException {
        FilterInfo tmpFilterInfo;
        EntityViewInfo resultEntityViewInfo = null;
        this.init(context);
        FilterInfo newFilterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)ruleStr)) {
            resultEntityViewInfo = new EntityViewInfo(ruleStr);
        }
        if (resultEntityViewInfo == null) {
            resultEntityViewInfo = new EntityViewInfo();
        }
        if (resultEntityViewInfo.getFilter() != null) {
            resultEntityViewInfo.getFilter().mergeFilter(newFilterInfo, "AND");
        } else {
            resultEntityViewInfo.setFilter(newFilterInfo);
        }
        if (coopFieldName != null && (tmpFilterInfo = this.getCoopOrgFilterInfo(coopFieldName, orgCollection)) != null) {
            resultEntityViewInfo.getFilter().mergeFilter(tmpFilterInfo, "OR");
        }
        this.retEntiryViewInfo = this.retEntiryViewInfo == null ? resultEntityViewInfo : this.mergerEntiry(this.retEntiryViewInfo, resultEntityViewInfo);
    }

    private FilterInfo getCoopOrgFilterInfo(String[] coopOrgFieldName, Collection orgCollection) {
        return CoopOrgHelper.getCoopOrgFilterInfo(coopOrgFieldName, orgCollection);
    }

    private FilterInfo getCoopOrgFilterInfo(String[] coopOrgFieldName, String curOrgIdStr) {
        if (coopOrgFieldName == null || coopOrgFieldName.length <= 0) {
            return null;
        }
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        for (int i = 0; i < coopOrgFieldName.length; ++i) {
            newFilterInfo.getFilterItems().add(new FilterItemInfo(coopOrgFieldName[i], (Object)curOrgIdStr));
            sbFormula.append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(" ").append(" or ").append(" ");
        }
        String strFormula = sbFormula.toString();
        if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
            newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
        }
        return newFilterInfo;
    }

    private EntityViewInfo mergerEntiry(EntityViewInfo mainFilter, EntityViewInfo nextEntry) throws BOSException {
        if (mainFilter == null) {
            throw new IllegalArgumentException("mainFilter is null!");
        }
        if (nextEntry == null) {
            return mainFilter;
        }
        FilterInfo mainFilterInfo = this.mergerFilter(this.transEntiry2FilterInfo(mainFilter), this.transEntiry2FilterInfo(nextEntry));
        EntityViewInfo retEntiryViewInfo = new EntityViewInfo();
        retEntiryViewInfo.setFilter(mainFilterInfo);
        return retEntiryViewInfo;
    }

    private FilterInfo transEntiry2FilterInfo(EntityViewInfo mainFilter) throws BOSException {
        try {
            ImplUtils.processEntryFilter((BOSObjectType)this.bosType, (EntityViewInfo)mainFilter, (Context)this.context);
            return mainFilter.getFilter();
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
    }

    private FilterInfo mergerFilter(FilterInfo mainFilter, FilterInfo nextFilterInfo) throws BOSException {
        return ToolUtils.mergerFilter(mainFilter, nextFilterInfo);
    }

    private void init(Context ctx) throws BOSException {
        if (this.iPermissionService == null) {
            this.iPermissionService = PermissionServiceProviderFactory.getLocalInstance(ctx);
        }
        if (this.context == null) {
            this.context = ctx;
        }
    }

    public EntityViewInfo getResFilterInfo() {
        return this.retEntiryViewInfo;
    }
}

