/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.clear.scan.invaliddata.scanunit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.permission.app.clear.common.AbstractScan;
import com.kingdee.eas.base.permission.app.clear.scan.IPermClearScanUnit;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;

public class UserOrgRangeScanUnit
extends AbstractScan
implements IPermClearScanUnit {
    private static String userOrgRangeSql = "SELECT RANGE.FUSERID ,RANGE.FORGID  FROM T_PM_ORGRANGE RANGE WHERE NOT EXISTS(SELECT 1 FROM T_ORG_BASEUNIT ORG WHERE ORG.FID  = RANGE.FORGID ) OR NOT EXISTS(SELECT 1 FROM T_PM_USER U WHERE RANGE.FUSERID = U.FID )OR NOT EXISTS(SELECT 1 FROM T_ORG_BASEUNIT ORG WHERE ORG.FID  = RANGE.FORGID )";
    private static String clearSql = "DELETE FROM T_PM_ORGRANGE where FID = ?";
    private String number = "UserOrgRange";
    private int dataCounts = 0;
    private int permCounts = 0;
    private int orgCounts = 0;
    private int roleCounts = 0;
    private int userCounts = 0;
    private boolean isClear = false;

    public UserOrgRangeScanUnit(boolean isClear) {
        this.isClear = isClear;
    }

    @Override
    public void execScaning(Context ctx) throws BOSException, SQLException {
        HashSet<String> orgIds = new HashSet<String>();
        HashSet<String> userIds = new HashSet<String>();
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(userOrgRangeSql);
            rs = statement.executeQuery();
            while (rs.next()) {
                ++this.dataCounts;
                userIds.add(rs.getString("FOWNER"));
                orgIds.add(rs.getString("FORGID"));
                this.orgCounts = orgIds.size();
                this.userCounts = userIds.size();
                if (!this.isClear) continue;
                this.clean(ctx, rs.getString("FID"));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
    }

    public void clean(Context ctx, String id) throws BOSException {
        DbUtil.execute((Context)ctx, (String)clearSql, (Object[])new Object[]{id});
    }

    @Override
    public int getScanDataCounts() {
        return this.dataCounts;
    }

    @Override
    public int getScanUsersCounts() {
        return this.userCounts;
    }

    @Override
    public int getScanRoleCounts() {
        return this.roleCounts;
    }

    @Override
    public int getScanPermCounts() {
        return this.permCounts;
    }

    @Override
    public int getScanOrgCounts() {
        return this.dataCounts;
    }
}

