/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.config;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.permission.util.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class FileReloadHelper {
    private static Logger logger = Logger.getLogger(FileReloadHelper.class);
    File timeFile = null;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public FileReloadHelper(File timeFile) {
        this.timeFile = timeFile;
    }

    public void writeNewTime(boolean isNeedReload) throws BOSException {
        FilterOutputStream bufferStream = null;
        try {
            if (!this.timeFile.exists()) {
                this.timeFile.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(this.timeFile);
            bufferStream = new BufferedOutputStream(stream);
            java.sql.Date now = new java.sql.Date(System.currentTimeMillis());
            String nowString = this.format.format(now);
            bufferStream.write(nowString.getBytes());
            bufferStream.write("\r\n".getBytes());
            bufferStream.write(new Boolean(isNeedReload).toString().getBytes());
            ((BufferedOutputStream)bufferStream).flush();
        }
        catch (IOException e) {
            logger.error((Object)LogUtil.filterLogForging("create " + this.timeFile.getName() + " error"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (bufferStream != null) {
                    bufferStream.close();
                }
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    public String[] getStringWithSpecifiedLine(int lines) throws BOSException {
        String[] retString = new String[lines];
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.timeFile)));
            int i = 0;
            do {
                retString[i] = reader.readLine();
            } while (++i < lines);
        }
        catch (IOException e) {
            logger.error((Object)LogUtil.filterLogForging("load " + this.timeFile.getName() + "  error"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return retString;
    }

    private Date getLastLoadTime(String timeString) throws BOSException, EASBizException {
        try {
            if (StringUtils.isEmpty((String)timeString)) {
                return this.format.parse("1900-01-01 00:00");
            }
            return this.format.parse(timeString.trim());
        }
        catch (ParseException e) {
            logger.error((Object)LogUtil.filterLogForging("parse " + this.timeFile.getName() + "  time  error"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public boolean isConfigFileChanged(File configFile) throws BOSException, EASBizException {
        boolean ret = false;
        if (!configFile.exists()) {
            return false;
        }
        if (!this.timeFile.exists()) {
            this.writeNewTime(false);
            return true;
        }
        String[] contentsInfile = this.getStringWithSpecifiedLine(2);
        boolean isNeedReload = Boolean.valueOf(contentsInfile[1]);
        if (isNeedReload) {
            return true;
        }
        Date lastLoadTime = this.getLastLoadTime(contentsInfile[0]);
        long lastModifyTime = configFile.lastModified();
        Date lastModifyDate = new Date(lastModifyTime);
        if (lastModifyDate.after(lastLoadTime)) {
            return true;
        }
        return ret;
    }
}

