/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.management.application.MetaDataInfo;
import com.kingdee.bos.service.permission.PermissionUtils;
import com.kingdee.bos.service.permission.metadata.BizPropertyCollection;
import com.kingdee.bos.service.permission.metadata.BizPropertyInfo;
import com.kingdee.bos.service.permission.metadata.BizRefCollection;
import com.kingdee.bos.service.permission.metadata.BizRefInfo;
import com.kingdee.bos.service.permission.metadata.DependenceCollection;
import com.kingdee.bos.service.permission.metadata.DependenceInfo;
import com.kingdee.bos.service.permission.metadata.EntityObjectRefInfo;
import com.kingdee.bos.service.permission.metadata.PermissionCtrl;
import com.kingdee.bos.service.permission.metadata.PermissionInfo;
import com.kingdee.bos.service.permission.metadata.PermissionItemCollection;
import com.kingdee.bos.service.permission.metadata.PermissionItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.OperationType;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemException;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermItemType;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.app.cache.PermItemCacheImpl;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.config.FileReloadHelper;
import com.kingdee.eas.base.permission.app.helper.PermChangeReportHelper;
import com.kingdee.eas.base.permission.app.helper.PermFileSearch;
import com.kingdee.eas.base.permission.app.helper.ServerInstancesHelper;
import com.kingdee.eas.base.permission.util.LogUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.subsystemhelper.UserCustomSubSystem;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SynchUserHelper {
    private static Logger logger = Logger.getLogger((String)SynchUserHelper.class.getName());
    private Connection con = null;
    private String metasPath = null;
    private Context context = null;
    private static final String ORG_RELATION = "orgRelation";
    private static final String ENABLE_DATA_PERMISSION = "enableDataPermission";
    private static final String ORG_TYPE = "OrgType";
    private static final String CONFIG_PATH = UserCustomSubSystem.SUBSYSTEM_EAS_PATH + File.separator + "easconfig";
    private static final String PERM_ITEM_TYPE = "permItemType";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    private static final String ERROR_PERM = "error_perm";
    private static final String REPEAT_PERM = "repeat_perm";
    private boolean isFromConsole = false;
    private boolean isOuterConn = false;

    public void release() {
        try {
            if (this.con != null && !this.isOuterConn) {
                SQLUtils.cleanup((Connection)this.con);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setFromConsole(boolean isFromConsole) {
        this.isFromConsole = isFromConsole;
    }

    public SynchUserHelper(Connection con, String metasPath) {
        this.isOuterConn = true;
        this.con = con;
        this.metasPath = metasPath;
    }

    public SynchUserHelper(Context ctx) throws BOSException {
        try {
            this.con = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.context = ctx;
    }

    private Context getContext() {
        if (this.isFromApp()) {
            return this.context;
        }
        return this.createVirtualConext(this.metasPath);
    }

    private boolean isFromApp() {
        return !this.isFromConsole;
    }

    public void backOldPermitem() throws BOSException, SQLException {
        this.createTableAndData();
    }

    private void createTableAndData() throws SQLException, BOSException {
        String queryTable = "select count(*) from KSQL_USERTABLES where KSQL_TABNAME ='T_PM_PermItem1'";
        int existTable = this.queryData(queryTable);
        if (existTable != 0) {
            String delStr = " drop table T_PM_PermItem1";
            SynchUserHelper.execute(this.con, delStr);
        }
        String createTable = "Create Table T_PM_PermItem1 ( FID VARCHAR(44)  NULL ,FNumber NVARCHAR(80)  NULL ,FOrgRelation INT ,FType INT )";
        SynchUserHelper.execute(this.con, createTable);
        createTable = " insert into T_PM_PermItem1(fid,fnumber,FOrgRelation,FType)  select fid,fnumber,FOrgRelation,FType from T_PM_PermItem ";
        SynchUserHelper.execute(this.con, createTable);
    }

    public int queryData(String sql) throws BOSException, SQLException {
        IRowSet row = SynchUserHelper.executeQuery(this.con, sql);
        if (row.next()) {
            return row.getInt(1);
        }
        return 0;
    }

    public void afterDeal() throws SQLException, BOSException, EASBizException {
        this.dealDifferentIDs();
    }

    private void dealDirtyAccreditData() throws BOSException {
        String sql = "delete FROM T_PM_UserOrgPerm  WHERE FOrgID = '11111111-1111-1111-1111-111111111111CCE7AED4' AND fpermitemid in (select fid from t_pm_permitem where forgrelation<>-1)";
        SynchUserHelper.execute(this.con, sql);
    }

    private void dealDeletePerms() throws BOSException, SQLException, EASBizException {
        Map deleteIds = this.getDeletePerms();
        if (deleteIds == null || deleteIds.isEmpty()) {
            return;
        }
        Set newKeySet = deleteIds.keySet();
        PermChangeReportHelper helper = null;
        helper = this.isFromApp() ? new PermChangeReportHelper(this.getContext()) : new PermChangeReportHelper(this.con, this.metasPath);
        helper.logChangeToReport(newKeySet);
        this.removeDeletedPermItems(newKeySet);
    }

    public void deleteRedundantPerm() throws BOSException {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("delete from t_pm_roleperm where fpermitemid not in ( select fid from t_pm_permitem)");
        sqlList.add("delete from t_pm_userorgperm where fpermitemid > '0' and not exists (select 1 from t_pm_permitem pitem where pitem.fid = t_pm_userorgperm.fpermitemid)");
        sqlList.add("delete from T_PM_SpecialDataPermEntry where fpermitemid not in ( select fid from t_pm_permitem)");
        sqlList.add("delete from T_PM_IDSecondAuthorize where FPermItem not in ( select fid from t_pm_permitem)");
        sqlList.add("delete from t_pm_userorgperm where not exists  (select 1 from t_pm_orgrange where ftype=10 and fuserid=t_pm_userorgperm.fowner  and forgid=t_pm_userorgperm.forgid) and forgid<>'11111111-1111-1111-1111-111111111111CCE7AED4' and fpermitemid not in (select fid from t_pm_permitem where forgrelation=8)");
        sqlList.add("delete from t_pm_userroleorg where not exists  (select 1 from t_pm_orgrange where ftype=10  and fuserid=t_pm_userroleorg.fuserid and forgid=t_pm_userroleorg.forgid) ");
        Collection discreteTables = ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityTables().values();
        for (String table : discreteTables) {
            String deleteDiscreteSql = "delete from " + table + " where fpermitemid not in ( select fid from t_pm_permitem)";
            sqlList.add(deleteDiscreteSql);
        }
        this.excuteAllSql(sqlList);
    }

    private void removeDeletedPermItems(Set permitemIdSet) throws BOSException, SQLException {
        String permitemIds = ToolUtils.aryToStr((Collection)permitemIdSet);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("delete from t_pm_userorgperm  where fpermitemid in (" + permitemIds + ")");
        this.excuteAllSql(sqlList);
    }

    private Map getDeletePerms() throws BOSException, SQLException {
        String delSql = "select a.fid fid from t_pm_permitem1 a join t_pm_permitem b on a.fnumber=b.fnumber  where a.forgrelation<>b.forgrelation";
        IRowSet row = SynchUserHelper.executeQuery(this.con, delSql);
        HashMap<String, String> delMap = new HashMap<String, String>();
        while (row.next()) {
            String permitemID = row.getString("fid");
            delMap.put(permitemID, permitemID);
        }
        return delMap;
    }

    private void dealDifferentIDs() throws BOSException, SQLException {
        Map allDiffIdMap = this.getDifferentPermItem();
        if (allDiffIdMap == null || allDiffIdMap.isEmpty()) {
            return;
        }
        Set newKeySet = allDiffIdMap.keySet();
        for (String newPermItemId : newKeySet) {
            String oldPermItemId;
            if (StringUtils.isEmpty((String)newPermItemId) || StringUtils.isEmpty((String)(oldPermItemId = (String)allDiffIdMap.get(newPermItemId)))) continue;
            this.updateDifferentPermItemId(oldPermItemId, newPermItemId);
        }
    }

    private Map getDifferentPermItem() throws BOSException, SQLException {
        String diffSql = "select a.fid newfid,a.fnumber, b.fid oldfid,b.fnumber from T_PM_PermItem a left join  T_PM_PermItem1 b  on a.fnumber  = b.fnumber  where b.fid is not null and a.fisleaf = 1  and a.fid != b.fid ";
        IRowSet row = SynchUserHelper.executeQuery(this.con, diffSql);
        HashMap<String, String> diffMap = new HashMap<String, String>();
        while (row.next()) {
            diffMap.put(row.getString("newfid"), row.getString("oldfid"));
        }
        return diffMap;
    }

    private void updateDifferentPermItemId(String oldId, String newId) throws SQLException, BOSException {
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add("update t_pm_roleperm set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update t_pm_userorgperm set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermBgScheme   set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermPage   set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermPortlet set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermReport \t\tset fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermRptTemplate \tset fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermBgForm \t\tset fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermBgTemplate \tset fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermDisplaySchema  set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_DiscretePermBussAnalysis  set fpermitemid = '" + newId + "' where fpermitemid = '" + oldId + "'");
        sqlList.add("update T_PM_MainMenuItem  set ffunction = '" + newId + "' where ffunction = '" + oldId + "'");
        sqlList.add("update T_PM_SpecialDataPermEntry  set FPermItemID = '" + newId + "' where FPermItemID = '" + oldId + "'");
        sqlList.add("update T_PM_IDSecondAuthorize  set FPermItem = '" + newId + "' where FPermItem = '" + oldId + "'");
        this.excuteAllSql(sqlList);
    }

    private void excuteAllSql(List sqlList) throws BOSException {
        if (sqlList == null || sqlList.isEmpty()) {
            return;
        }
        int size = sqlList.size();
        for (int i = 0; i < size; ++i) {
            SynchUserHelper.execute(this.con, (String)sqlList.get(i));
        }
    }

    public static void execute(Connection con, String sql) throws BOSException {
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            logger.error((Object)("sql 1 sql is:" + sql), (Throwable)exc);
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement);
        }
    }

    public static IRowSet executeQuery(Connection con, String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = con.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)("333 sql is:" + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement);
        return jdbcRowSet;
    }

    public Context createVirtualConext(String metasPath) {
        this.context = new Context(null, "eas", null, new Locale("L2"));
        this.context.put((Object)"METADATAPATH", (Object)metasPath);
        return this.context;
    }

    private BOSObjectType getBOSType() {
        return new PermItemInfo().getBOSType();
    }

    public void syncPermItems() throws BOSException, EASBizException {
        PermissionInfo permissionInfo = this.getPermissionInfo();
        this.synAnyPermitems(permissionInfo, true);
        this.updatePermitemEn_UsLanguage(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePermitemEn_UsLanguage(Context ctx) throws BOSException, PermItemException {
        try {
            String sql = "SELECT ml.FContent ,pi.fid FROM t_pm_permitem pi inner join  T_RES_EASResource RES   on res.FRes = pi.FALIAS_L2  LEFT OUTER JOIN T_RES_EASMultiLanRes ML ON res.fid = ml.FParentID WHERE ml.flanguageid = 'en_US' AND  pi.FALIAS_L1 <> ml.FContent";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] param = new Object[]{rs.getString(1), rs.getString(2)};
                params.add(param);
            }
            String alias = "update t_pm_permitem set FALIAS_L1=? where fid=?";
            DbUtil.executeBatch((Context)ctx, (String)alias, params);
            String sql1 = "SELECT ml.FContent ,pi.fid FROM t_pm_permitem pi inner join  T_RES_EASResource RES   on res.FRes = pi.FDESCRIPTION_L2  LEFT OUTER JOIN T_RES_EASMultiLanRes ML ON res.fid = ml.FParentID WHERE ml.flanguageid = 'en_US' AND  pi.FDESCRIPTION_L1 <> ml.FContent";
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<Object[]> params1 = new ArrayList<Object[]>();
            while (rs1.next()) {
                Object[] param = new Object[]{rs1.getString(1), rs1.getString(2)};
                params1.add(param);
            }
            String description = "update t_pm_permitem set FDESCRIPTION_L1=? where fid=?";
            DbUtil.executeBatch((Context)ctx, (String)description, params1);
        }
        catch (Exception e) {
            logger.error((Object)"Update permission item english name failed.");
            logger.error((Object)e);
        }
    }

    public void synAnyPermitems(PermissionInfo permissionInfo, boolean isFromMetaFile) throws BOSException, EASBizException, PermItemException {
        PermItemCollection collection = this.getAllPermItems(permissionInfo.getPermissionItems(), isFromMetaFile);
        Set menuUIs = this.getMenuUIs();
        PreparedStatement ps = null;
        String permItemConstant = "syncPermItemsFromConsole";
        try {
            int i;
            String testSql = "select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLongIndex' and  KSQL_COL_TABNAME='T_PM_PermItem'";
            ResultSet rowSet = this.con.createStatement().executeQuery(testSql);
            if (!rowSet.next()) {
                this.con.createStatement().execute("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIndex' and  KSQL_COL_TABNAME='T_PM_PermItem') alter table T_PM_PermItem add FIndex INT");
                this.con.createStatement().execute("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FLongIndex' and  KSQL_COL_TABNAME='T_PM_PermItem') alter table T_PM_PermItem add FLongIndex NVARCHAR(240)");
                logger.error((Object)"add index and longindex ");
            }
            this.backOldPermitem();
            ps = this.con.prepareStatement(" DELETE FROM T_PM_PermItem   where fisUserDefined=0");
            ps.executeUpdate();
            if (isFromMetaFile) {
                ps = this.con.prepareStatement(" DELETE FROM T_PM_PermDependency  where fisUserDefined=0");
                ps.executeUpdate();
            }
            Locale[] locales = MultiLangHelper.getDefinedLocales(this.getContext());
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" INSERT INTO T_PM_PermItem(FID, FNumber, FName, ");
            int length = locales.length;
            for (i = 0; i < length; ++i) {
                buffer.append(MultiLangHelper.getFieldName("FAlias", locales[i])).append(", ");
            }
            buffer.append(" FLongNumber, FObjectType, FType, FOrgRelation, FParentID, FIsLeaf, ").append(" FOperationType, FIsApplyToF7, ");
            length = locales.length;
            for (i = 0; i < length; ++i) {
                if (i == length - 1) {
                    buffer.append(MultiLangHelper.getFieldName("FDescription", locales[i])).append(" ");
                    continue;
                }
                buffer.append(MultiLangHelper.getFieldName("FDescription", locales[i])).append(", ");
            }
            buffer.append(" ,FIndex, FLongIndex ");
            buffer.append(" ) VALUES ( ").append("?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            ps = this.con.prepareStatement(buffer.toString());
            this.addPermItemBatch(this.getContext(), ps, collection);
            if (isFromMetaFile) {
                PermissionUtils.createDependence((PermissionInfo)permissionInfo);
                buffer = new StringBuffer(200);
                buffer.append(" INSERT INTO T_PM_PermDependency (FID, FDependencyID) VALUES (?, ? )");
                ps = this.con.prepareStatement(buffer.toString());
                this.addPermDependencyBatch(ps, permissionInfo.getDependences());
                ps.executeBatch();
                ps = this.con.prepareStatement(" UPDATE T_PM_MainMenuItem SET FFunction = ? WHERE TRIM(FUiClassName) = ? AND FFunction IS NULL ");
                this.addMenuPermItemBatch(ps, permissionInfo.getPermissionItems(), menuUIs);
                ps.executeBatch();
            }
            PermItemCacheImpl.clear();
            this.afterDeal();
            this.handlesAfterSyncPerms();
            Object dbType = this.getContext().get((Object)"dbType");
            try {
                if (dbType != null && "ORACLE".equalsIgnoreCase(dbType.toString())) {
                    ps = this.con.prepareStatement("/*dialect*/ analyze table t_pm_permitem compute statistics for table for all columns for all indexes");
                    ps.execute();
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                if (e.getNextException() != null) {
                    logger.error((Object)e.getNextException());
                }
                throw new PermItemException(PermItemException.SYNC_PERMITM_FAIL, e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)this.con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)this.con);
    }

    private synchronized void handlesAfterSyncPerms() {
        try {
            FileReloadHelper helper = new FileReloadHelper(this.getTimeFile(System.getProperty("eas.deploy"), "specialpermlastloadtime.txt"));
            helper.writeNewTime(true);
        }
        catch (Exception e) {
            logger.info((Object)"Error when making a record into SpecialDataLastUpdateTime File!");
        }
    }

    private File getTimeFile(String parentLocation, String fileName) {
        String timeFilePath = new StringBuffer().append(parentLocation).append(File.separator).append(fileName).toString();
        return new File(timeFilePath);
    }

    public PermissionInfo getPermissionInfo() throws BOSException {
        Context ctx = this.getContext();
        PermissionInfo permissionInfo = null;
        if (this.isFromConsole) {
            permissionInfo = this.getPermissionInfoFromFile();
        } else {
            boolean isEnablePermSubsytemFile = PermissionCommonUtil.isPermSubsystemFileEnabled(ctx);
            if (isEnablePermSubsytemFile) {
                permissionInfo = this.getPermissionInfoFromFile();
            }
        }
        if (permissionInfo == null) {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            permissionInfo = loader.getPermission();
        }
        return permissionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionInfo getPermissionInfoFromFile() {
        long startTime = System.currentTimeMillis();
        String fileName = ServerInstancesHelper.getPrimaryServerLocation() + File.separator + "userCustomPerm.permission";
        PermissionInfo permissionInfo = null;
        Properties pp = System.getProperties();
        FileInputStream fileInputStream = null;
        try {
            File permFile = new File(fileName);
            if (permFile != null && permFile.exists()) {
                fileInputStream = new FileInputStream(permFile);
                PermissionCtrl permCtrl = new PermissionCtrl(this.context);
                permissionInfo = (PermissionInfo)permCtrl.load((InputStream)fileInputStream);
            }
        }
        catch (DataAccessException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        catch (FileNotFoundException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        return permissionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermItemCollection getAllPermItems(PermissionItemCollection permissionItems, boolean isFromMetaFile) {
        PermItemInfo permItemInfo;
        int i;
        PreparedStatement ps;
        String oldRootId;
        block28: {
            oldRootId = null;
            ps = null;
            try {
                ps = this.con.prepareStatement(" select fid FROM T_PM_PermItem  where fparentid is null ");
                ResultSet rs = ps.executeQuery();
                if (!rs.next()) break block28;
                oldRootId = rs.getString("fid");
            }
            catch (Exception e1) {
                try {
                    e1.printStackTrace();
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(ps);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)ps);
            }
        }
        SQLUtils.cleanup((Statement)ps);
        PermItemCollection collection = new PermItemCollection();
        Locale[] locales = MultiLangHelper.getDefinedOriginLocales(this.getContext());
        HashMap<String, PermItemInfo> hmMap = new HashMap<String, PermItemInfo>(2000);
        IMetaDataLoader iMetaDataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        BOSObjectType bosObjectType = new PermItemInfo().getBOSType();
        int size = permissionItems.size();
        for (i = 0; i < size; ++i) {
            int j;
            PermissionItemInfo info = permissionItems.get(i);
            if (this.isInvaildPermItem(info, iMetaDataLoader)) continue;
            String groupName = StringUtils.replace((String)info.getGroupName(), (String)".", (String)"!") + "!" + info.getName();
            String ID = info.getInnerID();
            String number = info.getName();
            String name = info.getName();
            String longNumber = groupName;
            String objectType = null;
            EntityObjectRefInfo entityObjectRefInfo = info.getEntityObjectMetadataRef();
            if (entityObjectRefInfo != null && entityObjectRefInfo.getEntityMetaInfo() != null && !StringUtils.isEmpty((String)entityObjectRefInfo.getEntityMetaInfo().getFullName())) {
                EntityObjectInfo entity = iMetaDataLoader.getEntity((IMetaDataPK)new MetaDataPK(entityObjectRefInfo.getEntityMetaInfo().getFullName()));
                if (entity != null && entity.getType() != null && isFromMetaFile) {
                    objectType = entity.getType().toString();
                }
                if (!isFromMetaFile) {
                    objectType = entityObjectRefInfo.getEntityType();
                }
            }
            PermItemType type = PermItemType.BIZ_FUNCTION;
            String strPermItemType = info.getExtendedProperty(PERM_ITEM_TYPE);
            if (!StringUtils.isEmpty((String)strPermItemType)) {
                type = PermItemType.getEnum(Integer.parseInt(strPermItemType));
            }
            OrgType orgRelation = null;
            String strOrgRelation = info.getExtendedProperty(ORG_RELATION);
            if (!StringUtils.isEmpty((String)strOrgRelation)) {
                orgRelation = this.getOrgType(strOrgRelation);
            } else if (StringUtils.isEmpty(objectType)) {
                orgRelation = OrgType.NONE;
            } else {
                try {
                    EntityObjectInfo entity = iMetaDataLoader.getEntity(BOSObjectType.create((String)objectType));
                    String strOrgType = entity.getExtendedProperty(ORG_TYPE);
                    orgRelation = !StringUtils.isEmpty((String)strOrgType) ? this.getOrgType(strOrgType) : OrgType.NONE;
                }
                catch (RuntimeException e) {
                    logger.error((Object)"", (Throwable)e);
                    orgRelation = OrgType.NONE;
                }
            }
            String operationType = info.getType();
            boolean enableDataPermission = false;
            String strEnableDataPermission = info.getExtendedProperty(ENABLE_DATA_PERMISSION);
            if (!StringUtils.isEmpty((String)strEnableDataPermission)) {
                enableDataPermission = Boolean.valueOf(strEnableDataPermission);
            }
            PermItemInfo childPermItem = new PermItemInfo();
            childPermItem.setId(BOSUuid.read((String)ID));
            childPermItem.setIndex(0);
            childPermItem.setLongIndex(null);
            childPermItem.setNumber(number);
            childPermItem.setName(name);
            int length = locales.length;
            for (j = 0; j < length; ++j) {
                childPermItem.setAlias(info.getAlias(locales[j]), locales[j]);
            }
            childPermItem.setLongNumber(longNumber);
            childPermItem.setObjectType(objectType);
            childPermItem.setType(type);
            childPermItem.setOrgRelation(orgRelation);
            childPermItem.setOperationType(OperationType.getEnum(operationType));
            childPermItem.setEnableDataPermission(enableDataPermission);
            childPermItem.setParent(null);
            childPermItem.setIsLeaf(true);
            length = locales.length;
            for (j = 0; j < length; ++j) {
                childPermItem.setDescription(info.getDescription(locales[j]), locales[j]);
            }
            if (!hmMap.containsKey(longNumber)) {
                hmMap.put(longNumber, childPermItem);
            }
            collection.add(childPermItem);
            StringTokenizer tokenizerGroupName = new StringTokenizer(groupName, "!");
            String parentLongNumber = null;
            int step = 0;
            while (tokenizerGroupName.hasMoreTokens()) {
                ++step;
                String tempGroupName = tokenizerGroupName.nextToken();
                String string = parentLongNumber = parentLongNumber == null ? tempGroupName : parentLongNumber + "!" + tempGroupName;
                if (hmMap.containsKey(parentLongNumber)) continue;
                PermItemInfo parentItem = (PermItemInfo)childPermItem.clone();
                if (parentLongNumber.indexOf("!") <= 0 && oldRootId != null) {
                    parentItem.setId(BOSUuid.read((String)oldRootId));
                    parentItem.setIndex(1000);
                    parentItem.setLongIndex("1000");
                } else {
                    parentItem.setId(BOSUuid.create((BOSObjectType)bosObjectType));
                    parentItem.setIndex(0);
                    parentItem.setLongIndex(null);
                }
                if (parentLongNumber.indexOf("!") <= 0) {
                    parentItem.setIndex(1000);
                    parentItem.setLongIndex("1000");
                }
                parentItem.setNumber(tempGroupName);
                parentItem.setName(tempGroupName);
                int length2 = locales.length;
                for (int j2 = 0; j2 < length2; ++j2) {
                    if (StringUtils.isEmpty((String)info.getGroup(locales[j2]))) continue;
                    String tempGroup = StringUtils.replace((String)info.getGroup(locales[j2]), (String)".", (String)"!") + "!" + info.getName();
                    StringTokenizer tokenizerGroup = new StringTokenizer(tempGroup, "!");
                    String tempAlias = null;
                    for (int k = 0; k < step; ++k) {
                        if (!tokenizerGroup.hasMoreTokens()) continue;
                        tempAlias = tokenizerGroup.nextToken();
                    }
                    parentItem.setAlias(tempAlias, locales[j2]);
                }
                parentItem.setLongNumber(parentLongNumber);
                parentItem.setObjectType(null);
                parentItem.setType(PermItemType.INTEGRATION_FUNCTION);
                parentItem.setOrgRelation(OrgType.NONE);
                parentItem.setIsLeaf(false);
                parentItem.setOperationType(OperationType.OTHER);
                parentItem.setEnableDataPermission(false);
                if (hmMap.containsKey(parentLongNumber)) continue;
                hmMap.put(parentLongNumber, parentItem);
                collection.add(parentItem);
            }
        }
        hmMap = new HashMap(2000);
        size = collection.size();
        for (i = 0; i < size; ++i) {
            permItemInfo = collection.get(i);
            String longNumber = permItemInfo.getLongNumber();
            if (hmMap.containsKey(longNumber)) continue;
            hmMap.put(longNumber, permItemInfo);
        }
        size = collection.size();
        for (i = 0; i < size; ++i) {
            permItemInfo = collection.get(i);
            String parentLongNumber = permItemInfo.getLongNumber();
            int index = parentLongNumber.lastIndexOf("!");
            if (index == -1 || !hmMap.containsKey(parentLongNumber = parentLongNumber.substring(0, index))) continue;
            PermItemInfo parent = (PermItemInfo)hmMap.get(parentLongNumber);
            if (parentLongNumber.lastIndexOf("!") == -1) {
                permItemInfo.setLongIndex(parent.getLongIndex() + "!" + permItemInfo.getIndex());
            }
            permItemInfo.setParent(parent);
        }
        return collection;
    }

    private List getRepeatPermitemNumberList(PermItemCollection collection) {
        HashMap<String, PermItemInfo> numberPermitemMap = new HashMap<String, PermItemInfo>();
        ArrayList<String> repeatPermitemNumberList = new ArrayList<String>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            PermItemInfo info = collection.get(i);
            String number = info.getNumber();
            if (!info.isIsLeaf()) continue;
            if (numberPermitemMap.containsKey(number)) {
                repeatPermitemNumberList.add(number);
                continue;
            }
            numberPermitemMap.put(number, info);
        }
        return repeatPermitemNumberList;
    }

    private boolean isInvaildPermItemType(PermissionItemInfo info) {
        int i = -1;
        if (info.getExtendedProperty(PERM_ITEM_TYPE) == null) {
            return false;
        }
        i = Integer.parseInt(info.getExtendedProperty(PERM_ITEM_TYPE));
        Iterator iterator = PermItemType.iterator();
        while (iterator.hasNext()) {
            PermItemType permItemType = (PermItemType)((Object)iterator.next());
            if (permItemType.getValue() != i) continue;
            return false;
        }
        return true;
    }

    private PermissionItemCollection getPermissionItems() throws BOSException {
        return this.getPermissionInfo().getPermissionItems();
    }

    private boolean isInvaildPermItem(PermissionItemInfo info, IMetaDataLoader loader) {
        return StringUtils.isEmpty((String)info.getName()) || StringUtils.isEmpty((String)info.getType()) || this.isInvaildAlias(info) || StringUtils.isEmpty((String)info.getGroupName()) || this.isMismatchGroupInfo(info) || this.isInvaildOrgRelation(info, loader) || this.isInvaildPermItemType(info);
    }

    private boolean isInvaildAlias(PermissionItemInfo info) {
        return false;
    }

    private boolean isMismatchGroupInfo(PermissionItemInfo info) {
        return false;
    }

    private boolean isInvaildOrgRelation(PermissionItemInfo info, IMetaDataLoader loader) {
        String strOrgRelation = info.getExtendedProperty(ORG_RELATION);
        if (!StringUtils.isEmpty((String)strOrgRelation)) {
            return this.isInvaildOrgType(strOrgRelation);
        }
        if (info.getEntityObjectMetadataRef() == null || info.getEntityObjectMetadataRef().getEntityMetaInfo() == null) {
            return true;
        }
        try {
            EntityObjectInfo entity = loader.getEntity((IMetaDataPK)new MetaDataPK(info.getEntityObjectMetadataRef().getEntityMetaInfo().getFullName()));
            String strOrgType = entity.getExtendedProperty(ORG_TYPE);
            if (!StringUtils.isEmpty((String)strOrgType)) {
                return this.isInvaildOrgType(strOrgType);
            }
            return false;
        }
        catch (RuntimeException e) {
            logger.error((Object)e);
            return false;
        }
    }

    private boolean isInvaildOrgType(String str) {
        return this.getOrgType(str) == null;
    }

    private Map getErrorPermItems(PermissionItemCollection permissionItems) {
        HashSet<PermissionItemInfo> errorPermItems = new HashSet<PermissionItemInfo>();
        HashSet<Object> repeatPermItems = new HashSet<Object>();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        HashMap<String, PermissionItemInfo> numberPermitemMap = new HashMap<String, PermissionItemInfo>();
        int size = permissionItems.size();
        for (int i = 0; i < size; ++i) {
            PermissionItemInfo info = permissionItems.get(i);
            if (this.isInvaildPermItem(info, loader)) {
                errorPermItems.add(info);
            }
            if (numberPermitemMap.containsKey(info.getName())) {
                PermissionItemInfo existPermInfo = (PermissionItemInfo)numberPermitemMap.get(info.getName());
                if (info.getInnerID() == null || info.getInnerID().equals(existPermInfo.getInnerID())) continue;
                repeatPermItems.add(info);
                repeatPermItems.add(numberPermitemMap.get(info.getName()));
                continue;
            }
            numberPermitemMap.put(info.getName(), info);
        }
        HashMap<String, HashSet<Object>> errorPermItemsMap = new HashMap<String, HashSet<Object>>();
        errorPermItemsMap.put(ERROR_PERM, errorPermItems);
        errorPermItemsMap.put(REPEAT_PERM, repeatPermItems);
        return errorPermItemsMap;
    }

    private Map getRepetitiveMenuUIBindings(PermissionItemCollection permissionItems) throws EASBizException, BOSException {
        HashMap repetitiveMenuUIBindings = new HashMap();
        HashMap temp = new HashMap();
        Set menuUIs = this.getMenuUIs();
        int size = permissionItems.size();
        for (int i = 0; i < size; ++i) {
            PermissionItemInfo info = permissionItems.get(i);
            for (String uiClassName : this.getUIClassNames(info)) {
                Set<PermissionItemInfo> set;
                if (!menuUIs.contains(uiClassName)) continue;
                if (temp.containsKey(uiClassName)) {
                    set = (Set)temp.get(uiClassName);
                    set.add(info);
                    continue;
                }
                set = new HashSet();
                set.add(info);
                temp.put(uiClassName, set);
            }
        }
        for (Map.Entry entry : temp.entrySet()) {
            Set value = (Set)entry.getValue();
            if (value.size() <= 1) continue;
            repetitiveMenuUIBindings.put(entry.getKey(), entry.getValue());
        }
        return repetitiveMenuUIBindings;
    }

    private Map getRepetitiveResouceBindings(PermissionItemCollection permissionItems) {
        HashMap repetitiveResouceBindings = new HashMap();
        HashMap allResourceBindings = new HashMap();
        int size = permissionItems.size();
        for (int i = 0; i < size; ++i) {
            PermissionItemInfo info = permissionItems.get(i);
            BizRefCollection bizRefs = info.getBizRefs();
            if (bizRefs == null) continue;
            int size1 = bizRefs.size();
            for (int j = 0; j < size1; ++j) {
                Set<PermissionItemInfo> set;
                MetaDataInfo metaDataInfo;
                BizRefInfo bizRefInfo = bizRefs.get(j);
                if (bizRefInfo == null || (metaDataInfo = bizRefInfo.getBizMetadataInfo()) == null) continue;
                String resource = null;
                BOSObjectType objectType = BOSObjectType.create((String)metaDataInfo.getMetaDataType());
                if (MetaDataTypeList.UIOBJECT.equals((Object)objectType) || MetaDataTypeList.ENTITY.equals((Object)objectType) || MetaDataTypeList.FACADE.equals((Object)objectType)) {
                    BizPropertyCollection bizProperties = bizRefInfo.getBizPropertys();
                    int size2 = bizProperties.size();
                    for (int k = 0; k < size2; ++k) {
                        Set<PermissionItemInfo> set2;
                        BizPropertyInfo bizPropertyInfo = bizProperties.get(k);
                        if (bizPropertyInfo == null) continue;
                        resource = new StringBuffer().append(metaDataInfo.getMetaDataType()).append(":").append(metaDataInfo.getPackage()).append(".").append(metaDataInfo.getName()).append("$").append(bizPropertyInfo.getProperty()).toString();
                        if (allResourceBindings.containsKey(resource)) {
                            set2 = (Set)allResourceBindings.get(resource);
                            set2.add(info);
                            continue;
                        }
                        set2 = new HashSet();
                        set2.add(info);
                        allResourceBindings.put(resource, set2);
                    }
                    continue;
                }
                if (!MetaDataTypeList.BASEQUERY.equals((Object)objectType)) continue;
                resource = new StringBuffer().append(metaDataInfo.getMetaDataType()).append(":").append(metaDataInfo.getPackage()).append(".").append(metaDataInfo.getName()).toString();
                if (allResourceBindings.containsKey(resource)) {
                    set = (Set)allResourceBindings.get(resource);
                    set.add(info);
                    continue;
                }
                set = new HashSet();
                set.add(info);
                allResourceBindings.put(resource, set);
            }
        }
        for (Map.Entry entry : allResourceBindings.entrySet()) {
            if (((Set)entry.getValue()).size() <= 1) continue;
            repetitiveResouceBindings.put(entry.getKey(), entry.getValue());
        }
        return repetitiveResouceBindings;
    }

    private Set getMenuUIs() throws BOSException, EASBizException {
        HashSet<String> menuUIs = new HashSet<String>();
        String sql = "SELECT FUiClassName FROM T_PM_MainMenuItem";
        try {
            IRowSet rowSet = SynchUserHelper.executeQuery(this.con, sql);
            while (rowSet.next()) {
                menuUIs.add(rowSet.getString("FUiClassName"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermItemException(PermItemException.GET_PERMITEM_FAIL);
        }
        return menuUIs;
    }

    private Locale getLocale() {
        return this.getContext().getLocale();
    }

    private Set<String> getErrorPermNumSet(Map errorPermItemMap) {
        Set errorPermItems = (Set)errorPermItemMap.get(ERROR_PERM);
        Set repeatPermItems = (Set)errorPermItemMap.get(REPEAT_PERM);
        Set<String> errorPermNumSet = this.getPermNumSet(errorPermItems);
        Set<String> repeatPermNumSet = this.getPermNumSet(repeatPermItems);
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(errorPermNumSet);
        ret.addAll(repeatPermNumSet);
        return ret;
    }

    private Set<String> getPermNumSet(Set permItemSet) {
        Iterator itr = permItemSet.iterator();
        HashSet<String> ret = new HashSet<String>();
        while (itr.hasNext()) {
            PermissionItemInfo info = (PermissionItemInfo)itr.next();
            ret.add(info.getName());
        }
        return ret;
    }

    private String getPermItemErrorMsg(Map errorPermItemMap) {
        StringBuffer msg = new StringBuffer();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.getContext());
        msg.append(SEPARATOR);
        msg.append(SEPARATOR);
        msg.append("*********************************************************************************************").append(SEPARATOR);
        StringBuffer itemMsg = new StringBuffer();
        itemMsg.append(ResourceBase.getString((String)RESOURCE, (String)"errorPermItem", (Locale)this.getLocale()));
        String solution = EASCommonResource.getString((String)RESOURCE, (String)"solution", (Locale)this.getLocale());
        Set errorPermItems = (Set)errorPermItemMap.get(ERROR_PERM);
        Set<String> errorPermNumSet = this.getErrorPermNumSet(errorPermItemMap);
        Map<String, Collection<String>> permLocationMap = new PermFileSearch().search(errorPermNumSet);
        Iterator iterator = errorPermItems.iterator();
        while (iterator.hasNext()) {
            msg.append(SEPARATOR);
            msg.append(itemMsg);
            PermissionItemInfo info = (PermissionItemInfo)iterator.next();
            String groupName = info.getGroupName();
            String type = info.getType();
            if (StringUtils.isEmpty((String)info.getName())) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s name is null !").append(SEPARATOR);
                msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_name", (Locale)this.getLocale())).append(SEPARATOR);
            }
            if (StringUtils.isEmpty((String)type)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s type is null !").append(SEPARATOR);
                msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_type", (Locale)this.getLocale())).append(SEPARATOR);
            }
            if (this.isInvaildAlias(info)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s alias is null in multi-language !").append(SEPARATOR);
                msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_alias", (Locale)this.getLocale())).append(SEPARATOR);
            }
            if (StringUtils.isEmpty((String)groupName)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s groupName is null !").append(SEPARATOR);
                msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_group_name", (Locale)this.getLocale())).append(SEPARATOR);
            }
            if (this.isMismatchGroupInfo(info)) {
                int groupNameLength = groupName == null ? 0 : StringUtils.split((String)groupName, (String)".").length;
                Locale[] locales = MultiLangHelper.getSupportedOriginLocales();
                int length = locales.length;
                for (int i = 0; i < length; ++i) {
                    if (!StringUtils.isEmpty((String)info.getGroup(locales[i]))) {
                        int groupLength = StringUtils.split((String)info.getGroup(locales[i]), (String)".").length;
                        if (groupNameLength == groupLength) continue;
                        msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s group:").append(info.getGroup(locales[i])).append(" , groupName : ").append(info.getGroupName()).append("  not match in multi-language !").append(SEPARATOR);
                        msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_match_perm_group_name", (Locale)this.getLocale())).append(SEPARATOR);
                        continue;
                    }
                    msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s group:").append(info.getGroup(locales[i])).append(" , groupName : ").append(info.getGroupName()).append("  not match in multi-language !").append(SEPARATOR);
                    msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_group", (Locale)this.getLocale())).append(SEPARATOR);
                }
            }
            if (this.isInvaildOrgRelation(info, loader)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s orgRelation is isInvaild !").append(SEPARATOR);
                msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_orgRelation", (Locale)this.getLocale())).append(SEPARATOR);
            }
            if (this.isInvaildPermItemType(info)) {
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")'s permItemType is isInvaild !").append(SEPARATOR);
                msg.append(solution).append(EASCommonResource.getString((String)RESOURCE, (String)"pls_add_perm_permitemtype", (Locale)this.getLocale())).append(SEPARATOR);
            }
            msg.append(this.getLocationStr(info, permLocationMap));
        }
        Set repeatPermItems = (Set)errorPermItemMap.get(REPEAT_PERM);
        if (repeatPermItems.size() > 0) {
            msg.append("*********************************************************************************************").append(SEPARATOR);
            Iterator itr = repeatPermItems.iterator();
            while (itr.hasNext()) {
                msg.append(SEPARATOR);
                msg.append(itemMsg);
                PermissionItemInfo info = (PermissionItemInfo)itr.next();
                msg.append(info.getName()).append("(").append(info.getGroupName()).append(")").append(EASCommonResource.getString((String)RESOURCE, (String)"Perm_Number_Repeat", (Locale)this.getLocale())).append(SEPARATOR);
                msg.append(this.getLocationStr(info, permLocationMap));
            }
        }
        return msg.toString();
    }

    private String getLocationStr(PermissionItemInfo permItem, Map<String, Collection<String>> permLocationMap) {
        Collection<String> locations = permLocationMap.get(permItem.getName());
        if (locations == null) {
            logger.error((Object)("<<<<<<<<<<<<<<permitem not found:" + permItem.getAlias()));
            return "";
        }
        Iterator<String> locationItr = locations.iterator();
        if (locations.size() < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(EASResource.getString((String)RESOURCE, (String)"CLOUD_HUB_EXCEPTION"));
        while (locationItr.hasNext()) {
            sb.append(locationItr.next()).append(";");
        }
        sb.append(SEPARATOR);
        return sb.toString();
    }

    private void logRepetitiveResouceBinding(Map repetitiveResouceBindings) {
        StringBuffer msg = new StringBuffer();
        msg.append(SEPARATOR);
        msg.append("*********************************************************************************************").append(SEPARATOR);
        Iterator iterator = repetitiveResouceBindings.entrySet().iterator();
        while (iterator.hasNext()) {
            msg.append(SEPARATOR);
            Map.Entry entry = iterator.next();
            Object[] objects = new Object[]{entry.getKey()};
            msg.append(MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"resourceBindingWaring", (Locale)this.getLocale()), objects));
            Set entryValue = (Set)entry.getValue();
            if (entryValue.size() <= 1) continue;
            for (PermissionItemInfo info : entryValue) {
                msg.append(info.getName() + "(" + info.getAlias() + ") ");
            }
            msg.append(SEPARATOR);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)msg.toString());
        }
    }

    private void addMenuPermItemBatch(PreparedStatement ps, PermissionItemCollection collection, Set menuUIs) throws SQLException {
        HashMap menuPermItems = new HashMap();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            PermissionItemInfo info = collection.get(i);
            for (String uiClassName : this.getUIClassNames(info)) {
                Set<PermissionItemInfo> set;
                if (menuPermItems.containsKey(uiClassName) && menuUIs.contains(uiClassName)) {
                    set = (Set)menuPermItems.get(uiClassName);
                    set.add(info);
                    continue;
                }
                set = new HashSet<PermissionItemInfo>();
                set.add(info);
                menuPermItems.put(uiClassName, set);
            }
        }
        Set setUIClass = menuPermItems.keySet();
        for (String uiClassName : setUIClass) {
            Set setPermItem = (Set)menuPermItems.get(uiClassName);
            if (setPermItem.size() != 1) continue;
            PermissionItemInfo permissionItemInfo = (PermissionItemInfo)setPermItem.iterator().next();
            ps.setString(1, permissionItemInfo.getInnerID());
            ps.setString(2, uiClassName);
            ps.addBatch();
        }
    }

    private void addPermItemBatch(Context ctx, PreparedStatement ps, PermItemCollection permItemCollection) throws SQLException {
        Locale[] locales = MultiLangHelper.getDefinedOriginLocales(ctx);
        List repeatPermitemNumberList = this.getRepeatPermitemNumberList(permItemCollection);
        int k = 0;
        boolean flag = false;
        int MAX_DATA_ROW = 1000;
        int size = permItemCollection.size();
        for (int i = 0; i < size; ++i) {
            int j;
            PermItemInfo info = permItemCollection.get(i);
            String ID = info.getId().toString();
            int index = info.getIndex();
            String longIndex = info.getLongIndex();
            String number = info.getNumber();
            if (repeatPermitemNumberList.contains(number)) continue;
            String name = info.getName();
            String longNumber = info.getLongNumber();
            String objectType = info.getObjectType();
            PermItemType permItemType = info.getType();
            OrgType orgRelation = info.getOrgRelation();
            String parentID = info.getParent() == null ? null : info.getParent().getId().toString();
            int isLeaf = info.isIsLeaf() ? 1 : 0;
            String operationType = info.getOperationType().getValue();
            boolean enbaleDataPermission = info.isEnableDataPermission();
            ps.setString(1, ID);
            ps.setString(2, number);
            ps.setString(3, name);
            int length = locales.length;
            for (j = 0; j < length; ++j) {
                ps.setString(4 + j, info.getAlias(locales[j]));
            }
            ps.setString(4 + length, longNumber);
            ps.setString(5 + length, objectType);
            ps.setInt(6 + length, permItemType.getValue());
            ps.setInt(7 + length, orgRelation.getValue());
            ps.setString(8 + length, parentID);
            ps.setInt(9 + length, isLeaf);
            ps.setString(10 + length, operationType);
            ps.setInt(11 + length, enbaleDataPermission ? 1 : 0);
            for (j = 0; j < length; ++j) {
                ps.setString(15 + j, info.getDescription(locales[j]));
            }
            ps.setInt(15 + length, index);
            ps.setString(16 + length, longIndex);
            ps.addBatch();
            if (++k < MAX_DATA_ROW) continue;
            ps.executeBatch();
            ps.clearBatch();
            k = 0;
        }
        if (k > 0) {
            ps.executeBatch();
        }
    }

    private void addPermDependencyBatch(PreparedStatement ps, DependenceCollection depPermItems) throws SQLException {
        HashSet<String> dependencyData = new HashSet<String>();
        int size = depPermItems.size();
        for (int i = 0; i < size; ++i) {
            DependenceInfo dependenceInfo = depPermItems.get(i);
            PermissionItemCollection referingItems = null;
            try {
                referingItems = dependenceInfo.getReferingItems();
            }
            catch (Exception e) {
                PermissionItemInfo dependence = dependenceInfo.getReferedItem();
                logger.info((Object)new StringBuffer().append("dependenceInfo:").append(dependence.getGroupName()).append(dependence.getName()).append(",id:").append(dependence.getInnerID()).toString());
                logger.warn((Object)"", (Throwable)e);
                continue;
            }
            int size1 = referingItems.size();
            for (int j = 0; j < size1; ++j) {
                if (StringUtils.isEmpty((String)dependenceInfo.getReferedItem().getInnerID()) || StringUtils.isEmpty((String)referingItems.get(j).getInnerID())) continue;
                String ID = dependenceInfo.getReferedItem().getInnerID();
                String dependencyID = referingItems.get(j).getInnerID();
                String key = ID + dependencyID;
                if (dependencyData.contains(key)) continue;
                ps.setString(1, ID);
                ps.setString(2, dependencyID);
                ps.addBatch();
                dependencyData.add(key);
            }
        }
    }

    private OrgType getOrgType(String str) {
        Set orgTypeSet = OrgTypeInfoMgr.getInstance().getAllOrgType();
        for (OrgType orgType : orgTypeSet) {
            if (!orgType.getName().equalsIgnoreCase(str)) continue;
            return orgType;
        }
        return null;
    }

    private String[] getUIClassNames(PermissionItemInfo info) {
        HashSet<String> set = new HashSet<String>();
        BizRefCollection bizRefCollection = info.getBizRefs();
        if (info.getBizRefs() != null) {
            int size = bizRefCollection.size();
            for (int i = 0; i < size; ++i) {
                BizRefInfo bizRefInfo = bizRefCollection.get(i);
                MetaDataInfo metaDataInfo = bizRefInfo.getBizMetadataInfo();
                if (metaDataInfo == null) continue;
                String metaDataType = metaDataInfo.getMetaDataType();
                if (!MetaDataTypeList.UIOBJECT.toString().equals(metaDataType)) continue;
                BizPropertyCollection bizPropertyCollection = bizRefInfo.getBizPropertys();
                int size1 = bizRefCollection.size();
                for (int j = 0; j < size1; ++j) {
                    BizPropertyInfo bizPropertyInfo = bizPropertyCollection.get(j);
                    if (bizPropertyInfo == null || !"ActionOnLoad".equals(bizPropertyInfo.getProperty())) continue;
                    set.add(metaDataInfo.getFullName());
                }
            }
        }
        return set.toArray(new String[set.size()]);
    }

    public String getPermItemError() throws BOSException, EASBizException {
        PermissionItemCollection permissionItems = this.getPermissionItems();
        Map errorPermItemsMap = this.getErrorPermItems(permissionItems);
        String errorMsg = null;
        Set errorPermItemSet = (Set)errorPermItemsMap.get(ERROR_PERM);
        Set repeatPermItemSet = (Set)errorPermItemsMap.get(REPEAT_PERM);
        if (errorPermItemSet.size() > 0 || repeatPermItemSet.size() > 0) {
            errorMsg = this.getPermItemErrorMsg(errorPermItemsMap);
            logger.error((Object)LogUtil.filterLogForging(errorMsg));
        }
        return errorMsg;
    }

    private void logRepetitiveMenuUIBinding(Map repetitiveMenuUIBindings) {
        StringBuffer msg = new StringBuffer();
        msg.append(SEPARATOR);
        msg.append(SEPARATOR);
        msg.append("*********************************************************************************************").append(SEPARATOR);
        Iterator iterator = repetitiveMenuUIBindings.entrySet().iterator();
        while (iterator.hasNext()) {
            msg.append(SEPARATOR);
            Map.Entry entry = iterator.next();
            Object[] objects = new Object[]{entry.getKey()};
            msg.append(MessageFormat.format(ResourceBase.getString((String)RESOURCE, (String)"menuUIBindingWarning", (Locale)this.getLocale()), objects));
            for (PermissionItemInfo info : (Set)entry.getValue()) {
                msg.append(info.getName() + "(" + info.getAlias() + ") ");
            }
            msg.append(SEPARATOR);
        }
    }
}

