/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.UserOrgPermCollection;
import com.kingdee.eas.base.permission.UserOrgPermInfo;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserPermHelper {
    public static Logger logger = Logger.getLogger(UserPermHelper.class);
    private static long unionkeySpendTime = 0L;
    private static ThreadLocal<Map<BOSUuid, String>> lOwnerIds = new ThreadLocal();
    private static ThreadLocal<Map<BOSUuid, String>> lOrgIds = new ThreadLocal();
    private static ThreadLocal<Map<BOSUuid, String>> lPermIds = new ThreadLocal();
    private static ThreadLocal<Map<PermType, String>> lPermTypes = new ThreadLocal();

    public static UserOrgPermCollection[] getDiffUserOrgPerm(Context ctx, UserOrgPermCollection oldUOPs1, UserOrgPermCollection newUOPs) throws EASBizException, BOSException {
        int i;
        UserOrgPermCollection oldUOPs = new UserOrgPermCollection();
        oldUOPs.addCollection(oldUOPs1);
        UserPermHelper.filterNull(oldUOPs);
        UserPermHelper.filterNull(newUOPs);
        UserOrgPermCollection[] operations = new UserOrgPermCollection[3];
        Map<String, UserOrgPermInfo> oldUOPsMap = UserPermHelper.createUOPMap(oldUOPs);
        UserOrgPermCollection addUOPs = UserPermHelper.removeUserPermOrg(newUOPs, oldUOPs);
        UserOrgPermCollection delUOPs = UserPermHelper.removeUserPermOrg(oldUOPs, newUOPs);
        UserOrgPermCollection updateUOPs = UserPermHelper.getUpdateUserPermOrg(oldUOPs, newUOPs);
        addUOPs = UserPermHelper.addDepPerm(ctx, addUOPs, false);
        delUOPs = UserPermHelper.addDepPerm(ctx, delUOPs, true);
        addUOPs = UserPermHelper.removeUserPermOrg(addUOPs, delUOPs);
        for (i = 0; i < addUOPs.size(); ++i) {
            if (!oldUOPsMap.containsKey(UserPermHelper.getUniqueKey(addUOPs.get(i)))) continue;
            addUOPs.removeObject(i--);
        }
        for (i = 0; i < delUOPs.size(); ++i) {
            if (oldUOPsMap.containsKey(UserPermHelper.getUniqueKey(delUOPs.get(i)))) continue;
            delUOPs.remove(delUOPs.get(i--));
        }
        operations[0] = addUOPs;
        operations[1] = delUOPs;
        operations[2] = updateUOPs;
        UserPermHelper.transOrgTypeNone(addUOPs);
        return operations;
    }

    public static UserOrgPermCollection[] getDiffUserOrgPermWithOutAddDepPerm(Context ctx, UserOrgPermCollection oldUOPs, UserOrgPermCollection newUOPs) throws EASBizException, BOSException {
        UserOrgPermCollection[] operations = new UserOrgPermCollection[3];
        UserOrgPermCollection addUOPs = UserPermHelper.removeUserPermOrg(newUOPs, oldUOPs);
        UserOrgPermCollection delUOPs = UserPermHelper.removeUserPermOrg(oldUOPs, newUOPs);
        UserOrgPermCollection updateUOPs = UserPermHelper.getUpdateUserPermOrg(oldUOPs, newUOPs);
        operations[0] = addUOPs;
        operations[1] = delUOPs;
        operations[2] = updateUOPs;
        return operations;
    }

    public static List<String> getSingleUserPermIds(UserOrgPermCollection userorgperms) {
        HashSet<String> permitemids = new HashSet<String>();
        for (int i = 0; i < userorgperms.size(); ++i) {
            UserOrgPermInfo userOrgPermInfo = userorgperms.get(i);
            permitemids.add(userOrgPermInfo.getPermItemId());
        }
        return new ArrayList<String>(permitemids);
    }

    public static UserOrgPermCollection addDepPerm(Context context, UserOrgPermCollection userOrgPermColl, boolean isDelete) throws EASBizException, BOSException {
        int i;
        UserOrgPermCollection ret = new UserOrgPermCollection();
        HashSet<String> alreadyAddedPerm = new HashSet<String>();
        int size = userOrgPermColl.size();
        for (i = 0; i < size; ++i) {
            String key = UserPermHelper.getUniqueKey(userOrgPermColl.get(i));
            alreadyAddedPerm.add(key);
        }
        for (i = 0; i < userOrgPermColl.size(); ++i) {
            UserOrgPermInfo info = userOrgPermColl.get(i);
            ret.add(info);
            PermItemCollection depPerms = new PermItemCollection();
            depPerms = !isDelete ? (info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId()))) : (info.getPermType().equals((Object)PermType.AUTHORIZATION) || info.getPermType().equals((Object)PermType.NORMAL) ? PermissionCacheFactory.getPermItemCache(context).getBeenDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())) : PermissionCacheFactory.getPermItemCache(context).getDepPermItems(context, (IObjectPK)new ObjectUuidPK(info.getPermItem().getId())));
            if (depPerms == null) continue;
            for (int j = 0; j < depPerms.size(); ++j) {
                UserOrgPermInfo depUserOrgPermInfo = new UserOrgPermInfo();
                PermItemInfo permitem = depPerms.get(j);
                FullOrgUnitInfo org = info.getOrg();
                if (!permitem.getOrgRelation().equals((Object)OrgType.NONE) && org.getId().toString().equals("11111111-1111-1111-1111-111111111111CCE7AED4")) continue;
                depUserOrgPermInfo.setOrg(org);
                depUserOrgPermInfo.setOwner(info.getOwner());
                depUserOrgPermInfo.setPermType(info.getPermType());
                depUserOrgPermInfo.setCtrlUnit(info.getCtrlUnit());
                depUserOrgPermInfo.setPermItem(permitem);
                String key = UserPermHelper.getUniqueKey(depUserOrgPermInfo);
                if (alreadyAddedPerm.contains(key)) continue;
                alreadyAddedPerm.add(key);
                ret.add(depUserOrgPermInfo);
            }
        }
        return ret;
    }

    public static UserOrgPermCollection getUpdateUserPermOrg(UserOrgPermCollection oldUOPs, UserOrgPermCollection newUOPs) {
        UserOrgPermCollection updateUOPs = new UserOrgPermCollection();
        Map<String, UserOrgPermInfo> mapOldUOP = UserPermHelper.createUOPMap(oldUOPs);
        for (int i = 0; i < newUOPs.size(); ++i) {
            UserOrgPermInfo oldUOP;
            UserOrgPermInfo newUOP = newUOPs.get(i);
            String key = UserPermHelper.getUniqueKey(newUOP);
            if (!mapOldUOP.containsKey(key) || !UserPermHelper.isRuleChanged((oldUOP = mapOldUOP.get(key)).getRuleStructure(), newUOP.getRuleStructure())) continue;
            newUOP.setId(oldUOP.getId());
            updateUOPs.add(newUOP);
        }
        return updateUOPs;
    }

    public static UserOrgPermCollection removeUserPermOrg(UserOrgPermCollection srcUops, UserOrgPermCollection removeUops) {
        UserOrgPermCollection targetUserOrgPerms = new UserOrgPermCollection();
        Map<String, UserOrgPermInfo> removeUopsMap = UserPermHelper.createUOPMap(removeUops);
        for (int i = 0; i < srcUops.size(); ++i) {
            UserOrgPermInfo srcUop = srcUops.get(i);
            String key = UserPermHelper.getUniqueKey(srcUop);
            if (removeUopsMap.containsKey(key)) continue;
            targetUserOrgPerms.add(srcUop);
        }
        return targetUserOrgPerms;
    }

    public static void filterNull(UserOrgPermCollection uops) {
        for (int i = 0; i < uops.size(); ++i) {
            UserOrgPermInfo uop = uops.get(i);
            if (uop != null) continue;
            uops.removeObject(i--);
        }
    }

    public static String getUniqueKey(UserOrgPermInfo info) {
        PermType permType;
        String permtypeStr;
        BOSUuid permId;
        String permIdStr;
        BOSUuid orgId;
        String orgIdStr;
        BOSUuid ownerId;
        String ownerIdStr;
        long start = System.currentTimeMillis();
        String key = "";
        Map<BOSUuid, String> ownerIds = lOwnerIds.get();
        if (ownerIds == null) {
            ownerIds = new HashMap<BOSUuid, String>();
            lOwnerIds.set(ownerIds);
        }
        if ((ownerIdStr = ownerIds.get(ownerId = info.getOwner().getId())) == null) {
            ownerIdStr = ownerId.toString();
            ownerIds.put(ownerId, ownerIdStr);
        }
        key = key + ownerIdStr;
        Map<BOSUuid, String> orgIds = lOrgIds.get();
        if (orgIds == null) {
            orgIds = new HashMap<BOSUuid, String>();
            lOrgIds.set(orgIds);
        }
        if ((orgIdStr = orgIds.get(orgId = info.getOrg().getId())) == null) {
            orgIdStr = orgId.toString();
            orgIds.put(orgId, orgIdStr);
        }
        key = key + orgIdStr;
        Map<BOSUuid, String> permIds = lPermIds.get();
        if (permIds == null) {
            permIds = new HashMap<BOSUuid, String>();
            lPermIds.set(permIds);
        }
        if ((permIdStr = permIds.get(permId = info.getPermItem().getId())) == null) {
            permIdStr = permId.toString();
            permIds.put(permId, permIdStr);
        }
        key = key + permIdStr;
        Map<PermType, String> permTypes = lPermTypes.get();
        if (permTypes == null) {
            permTypes = new HashMap<PermType, String>();
            lPermTypes.set(permTypes);
        }
        if ((permtypeStr = permTypes.get((Object)(permType = info.getPermType()))) == null) {
            permtypeStr = permType.toString();
            permTypes.put(permType, permtypeStr);
        }
        key = key + permtypeStr;
        unionkeySpendTime += System.currentTimeMillis() - start;
        return key;
    }

    public static String getOrgIdStr(BOSUuid orgId) {
        String orgIdStr;
        Map<BOSUuid, String> orgIds = lOrgIds.get();
        if (orgIds == null) {
            orgIds = new HashMap<BOSUuid, String>();
            lOrgIds.set(orgIds);
        }
        if ((orgIdStr = orgIds.get(orgId)) == null) {
            orgIdStr = orgId.toString();
            orgIds.put(orgId, orgIdStr);
        }
        return orgIdStr;
    }

    public static String getPermIdStr(BOSUuid permId) {
        String permIdStr;
        Map<BOSUuid, String> permIds = lPermIds.get();
        if (permIds == null) {
            permIds = new HashMap<BOSUuid, String>();
            lPermIds.set(permIds);
        }
        if ((permIdStr = permIds.get(permId)) == null) {
            permIdStr = permId.toString();
            permIds.put(permId, permIdStr);
        }
        return permIdStr;
    }

    public static Map<String, UserOrgPermInfo> createUOPMap(UserOrgPermCollection uops) {
        HashMap<String, UserOrgPermInfo> map = new HashMap<String, UserOrgPermInfo>();
        UserOrgPermInfo uopInfo = null;
        int size = uops.size();
        for (int i = 0; i < size; ++i) {
            uopInfo = uops.get(i);
            map.put(UserPermHelper.getUniqueKey(uopInfo), uopInfo);
        }
        return map;
    }

    public static boolean isRuleChanged(String ruleA, String ruleB) {
        if (StringUtils.isEmpty((String)ruleA) || StringUtils.isEmpty((String)ruleB)) {
            return !StringUtils.isEmpty((String)ruleA) || !StringUtils.isEmpty((String)ruleB);
        }
        return !ruleA.equals(ruleB);
    }

    public static void transOrgTypeNone(UserOrgPermCollection userOrgPermColl) {
        CtrlUnitInfo sysCU = new CtrlUnitInfo();
        sysCU.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        int size = userOrgPermColl.size();
        for (int i = 0; i < size; ++i) {
            UserOrgPermInfo info = userOrgPermColl.get(i);
            if (!info.getPermItem().getOrgRelation().equals((Object)OrgType.NONE)) continue;
            info.setOrg(sysCU.castToFullOrgUnitInfo());
            info.setCtrlUnit(sysCU);
        }
    }

    public static void removeUserOrgPerms(Context ctx, UserOrgPermCollection userOrgPermColl) throws BOSException {
        String sql = "DELETE FROM T_PM_UserOrgPerm WHERE fowner = ? and (forgid=? or forgid=?) and fpermitemid = ? and fpermType = ? ";
        String noneOrgSql = "DELETE FROM T_PM_UserOrgPerm WHERE fowner = ? and fpermitemid = ? and fpermType = ? ";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> noneOrgParamsList = new ArrayList<Object[]>();
        for (int i = 0; i < userOrgPermColl.size(); ++i) {
            Object[] params;
            UserOrgPermInfo userOrgPermInfo = userOrgPermColl.get(i);
            PermItemInfo permitem = userOrgPermInfo.getPermItem();
            if (OrgType.NONE.equals((Object)permitem.getOrgRelation())) {
                params = new Object[]{userOrgPermInfo.getOwner().getId().toString(), permitem.getId().toString(), userOrgPermInfo.getPermType().getValue()};
                noneOrgParamsList.add(params);
                continue;
            }
            params = new Object[]{userOrgPermInfo.getOwner().getId().toString(), userOrgPermInfo.getOrgId(), "11111111-1111-1111-1111-111111111111CCE7AED4", userOrgPermInfo.getPermItemId(), userOrgPermInfo.getPermType().getValue()};
            paramsList.add(params);
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
        DbUtil.executeBatch((Context)ctx, (String)noneOrgSql, noneOrgParamsList);
    }
}

