/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.OtherOwnerCollection;
import com.kingdee.eas.base.permission.OtherOwnerInfo;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.SpecialDataPermEntryInfo;
import com.kingdee.eas.base.permission.SpecialDataPermInfo;
import com.kingdee.eas.base.permission.SpecialDataPermType;
import com.kingdee.eas.base.permission.SpecialPermLogicTag;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.service.AdvancedPermissionUtil;
import com.kingdee.eas.base.permission.app.service.CoopOrgHelper;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.app.service.DiscretePermissionService;
import com.kingdee.eas.base.permission.app.service.IAdvancedDataPermissionService;
import com.kingdee.eas.base.permission.app.service.IDataPermissionService;
import com.kingdee.eas.base.permission.app.service.SpecialDataPermissionHandler;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AdvancedDataPermissionService
implements IAdvancedDataPermissionService {
    private static Logger logger = Logger.getLogger(AdvancedDataPermissionService.class);
    private Context context = null;
    private IDataPermissionService dataPermissionService = null;

    public AdvancedDataPermissionService(Context context) {
        this.context = context;
        this.dataPermissionService = new DataPermissionService(context);
    }

    @Override
    public Map getPermissionRule(IObjectPK userPK, Set<String> orgPKs, String permItemName) throws BOSException, EASBizException, ParserException {
        assert (userPK != null && permItemName != null);
        Map<String, String> result = new HashMap<String, String>();
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache(this.context).getPermItem(this.context, permItemName);
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            for (String orgPK : orgPKs) {
                result.put(orgPK, " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )");
            }
            return result;
        }
        if (OrgType.NONE.equals((Object)permItemInfo.getOrgRelation())) {
            ObjectUuidPK permissionOrgPK = new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            String rule = null;
            try {
                rule = this.dataPermissionService.getPermissionRule(userPK, (IObjectPK)permissionOrgPK, permItemName);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw e;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw e;
            }
            for (String orgPK : orgPKs) {
                result.put(orgPK, rule);
            }
            return result;
        }
        result = this.getRule(userPK, orgPKs, permItemInfo);
        return result;
    }

    private Map getRule(IObjectPK userPK, Set<String> orgPKs, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        Map commonRule = this.getDataRule(userPK, orgPKs, permItemInfo);
        if (!this.isSpecialEntity(permItemInfo.getObjectType())) {
            for (Map.Entry entry : commonRule.entrySet()) {
                String orgid = (String)entry.getKey();
                String crule = (String)entry.getValue();
                if (crule == null) continue;
                EntityViewInfo oldViewInfo = new EntityViewInfo(crule);
                EntityViewInfo coopFieldViewInfo = new EntityViewInfo();
                coopFieldViewInfo.setFilter(this.getCoopFieldRule((IObjectPK)new ObjectUuidPK(orgid), permItemInfo));
                EntityViewInfo resViewInfo = RuleUtil.mergeEntityViewInfo(oldViewInfo, coopFieldViewInfo, "OR");
                if (resViewInfo == null) continue;
                result.put(orgid, resViewInfo.toString());
            }
            return result;
        }
        HashMap<String, String> specialRule = new HashMap<String, String>();
        Map cuIDMap = AdvancedPermissionUtil.getOrgUnitCUMap(this.context, orgPKs);
        Map<String, SpecialDataPermInfo> specialDataPermInfoMap = this.getSpecialDataPermInfo(cuIDMap.values(), permItemInfo);
        Iterator ite = cuIDMap.keySet().iterator();
        SpecialDataPermissionHandler specialDataPermissionHandler = new SpecialDataPermissionHandler(this.context);
        while (ite.hasNext()) {
            String orgid = (String)ite.next();
            String cuid = (String)cuIDMap.get(orgid);
            SpecialDataPermInfo specialDataPermInfo = specialDataPermInfoMap.get(cuid);
            if (specialDataPermInfo == null) continue;
            String srule = specialDataPermissionHandler.getSpecialDataPermissionRule(userPK, (IObjectPK)new ObjectUuidPK(orgid), specialDataPermInfo, permItemInfo);
            specialRule.put(orgid, srule);
        }
        for (String orgid : orgPKs) {
            String cuid = (String)cuIDMap.get(orgid);
            String crule = (String)commonRule.get(orgid);
            String srule = (String)specialRule.get(crule);
            String rule = null;
            if (!StringUtil.isEmpty((String)crule) && !StringUtil.isEmpty((String)crule)) {
                String bizPermitemlogic = specialDataPermInfoMap.get(cuid) == null ? null : specialDataPermissionHandler.getSpecialDataPermEntry(specialDataPermInfoMap.get(cuid), permItemInfo).getLogicTag().getValue();
                rule = this.mergeCommonAndSpecialRule(crule, srule, bizPermitemlogic);
            } else {
                String string = rule = StringUtil.isEmpty((String)crule) ? srule : crule;
            }
            if (rule == null) continue;
            EntityViewInfo oldViewInfo = new EntityViewInfo(rule);
            EntityViewInfo coopFieldViewInfo = new EntityViewInfo();
            coopFieldViewInfo.setFilter(this.getCoopFieldRule((IObjectPK)new ObjectUuidPK(orgid), permItemInfo));
            EntityViewInfo resViewInfo = RuleUtil.mergeEntityViewInfo(oldViewInfo, coopFieldViewInfo, "OR");
            if (resViewInfo == null) continue;
            result.put(orgid, resViewInfo.toString());
        }
        return result;
    }

    private Map<String, SpecialDataPermInfo> getSpecialDataPermInfo(Collection collection, PermItemInfo permItemInfo) throws BOSException, PermissionException {
        StringBuffer sql = new StringBuffer();
        StringBuilder cuID = new StringBuilder();
        Iterator ite = collection.iterator();
        String cuid = null;
        while (ite.hasNext()) {
            cuid = (String)ite.next();
            cuID.append("'").append(cuid).append("'").append(",");
        }
        cuID.deleteCharAt(cuID.length() - 1);
        cuid = cuID.toString();
        sql.append("SELECT SpecialDataPerm.FID ,SpecialDataPerm.FIsEnableCreatorPerm, SpecialDataPerm.FBizObjectType,SpecialDataPerm.FControlUnitID").append(" ,SpecialDataPerm.FIsEnableDirectorPerm, SpecialDataPermEntry.FPermType, SpecialDataPermEntry.FLogicTag ").append(" FROM T_PM_SpecialDataPermEntry SpecialDataPermEntry ").append(" INNER JOIN T_PM_SpecialDataPerm SpecialDataPerm ").append(" ON SpecialDataPerm.FID = SpecialDataPermEntry.FSpecialDataPermID ").append(" WHERE SpecialDataPermEntry.FPermItemID = ? AND SpecialDataPerm.FControlUnitID in (").append(cuid).append(")").append(" AND ( ( SpecialDataPerm.FIsEnableCreatorPerm = 1 AND SpecialDataPermEntry.FPermType <> ").append(0).append(" ) ").append(" OR SpecialDataPerm.FIsEnableDirectorPerm = 1 ) ");
        Object[] params = new Object[]{permItemInfo.getId().toString(), cuID};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            HashMap<String, SpecialDataPermInfo> result = new HashMap<String, SpecialDataPermInfo>();
            while (rowSet.next()) {
                if (result.containsKey(rowSet.getString("FControlUnitID"))) continue;
                SpecialDataPermInfo info = new SpecialDataPermInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setEnableCreatorPerm(rowSet.getInt("FIsEnableCreatorPerm") == 1);
                info.setEnableDirectorPerm(rowSet.getInt("FIsEnableDirectorPerm") == 1);
                String bizObjType = rowSet.getString("FBizObjectType");
                info.setBizObjectType(bizObjType);
                Map extFields = ConfigurationLoader.getInstance().getConfigurationInfo().getSpecialPositionField();
                if (extFields.containsKey(bizObjType)) {
                    info.setExtendedProperty("position-field", (String)extFields.get(bizObjType));
                }
                CtrlUnitInfo cu = new CtrlUnitInfo();
                cu.setId(BOSUuid.read((String)rowSet.getString("FControlUnitID")));
                info.setCU(cu);
                SpecialDataPermEntryInfo specialDataPermEntryInfo = new SpecialDataPermEntryInfo();
                specialDataPermEntryInfo.setPermType(SpecialDataPermType.getEnum(rowSet.getInt("FPermType")));
                specialDataPermEntryInfo.setLogicTag(SpecialPermLogicTag.getEnum(rowSet.getString("FLogicTag")));
                specialDataPermEntryInfo.setPermItem(permItemInfo);
                info.getEntries().add(specialDataPermEntryInfo);
                this.setOtherOwnerCollection(info);
                result.put(rowSet.getString("FControlUnitID"), info);
            }
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
    }

    private void setOtherOwnerCollection(SpecialDataPermInfo specialDataPermInfo) throws BOSException, PermissionException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT OtherOwner.FID,OtherOwner.FPropertyName ").append(" FROM T_PM_OtherOwner OtherOwner ").append(" INNER JOIN T_PM_SpecialDataPerm SpecialDataPerm ").append(" ON SpecialDataPerm.FID = OtherOwner.FSpecialDataPermID ").append(" WHERE SpecialDataPerm.FID = ?");
        Object[] params = new Object[]{specialDataPermInfo.getId().toString()};
        OtherOwnerCollection col = specialDataPermInfo.getOtherOwners();
        if (col == null) {
            return;
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
            while (rowSet.next()) {
                OtherOwnerInfo otherOwnerinfo = new OtherOwnerInfo();
                otherOwnerinfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                otherOwnerinfo.setPropertyName(rowSet.getString("FPropertyName"));
                otherOwnerinfo.setSpecialDataPerm(specialDataPermInfo);
                col.add(otherOwnerinfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
    }

    private boolean isSpecialEntity(String entityType) {
        return ConfigurationLoader.getInstance().getConfigurationInfo().getSpecialEntityTypes().contains(entityType);
    }

    private Map getDataRule(IObjectPK userPK, Set<String> orgPKs, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        Map commonDataRuleMap = this.getCommonDataRule(userPK, orgPKs, permItemInfo);
        for (Map.Entry entry : commonDataRuleMap.entrySet()) {
            String orgId = (String)entry.getKey();
            String commonDataRule = (String)entry.getValue();
            if (CommonFilterUtil.isLikeVarEnumValue((String)commonDataRule)) {
                commonDataRule = CommonQueryUtil.getInnerFilterInfo((Context)this.context, (String)commonDataRule);
            }
            String discreteDataRule = this.getDiscreteDataRule(userPK, (IObjectPK)new ObjectUuidPK(orgId), permItemInfo);
            commonDataRuleMap.put(orgId, RuleUtil.mergeOQL(commonDataRule, discreteDataRule, "OR"));
        }
        return commonDataRuleMap;
    }

    private Map getCommonDataRule(IObjectPK userPK, Set<String> orgPKs, PermItemInfo permItemInfo) throws BOSException, ParserException, PermissionException {
        assert (userPK != null && orgPKs != null && permItemInfo != null);
        String userID = userPK.toString();
        StringBuilder sb = new StringBuilder();
        for (String str : orgPKs) {
            sb.append("'").append(str).append("'").append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String orgIds = sb.toString();
        String permItemID = permItemInfo.getId().toString();
        Object[] params = new Object[]{userID, permItemID, new Integer(10), userID, permItemID, new Integer(10)};
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" SELECT UserOrgPerm.FOrgID,UserOrgPerm.FRuleExpr FROM T_PM_UserOrgPerm UserOrgPerm ").append(" WHERE UserOrgPerm.FOwner = ? ").append(" AND UserOrgPerm.FOrgID in (").append(orgIds).append(")").append(" AND UserOrgPerm.FPermItemID = ? ").append(" AND UserOrgPerm.FPermType = ? ").append(" AND UserOrgPerm.FRuleExpr is not null ").append(" UNION ALL ").append(" SELECT UserRoleOrg.FOrgID,RolePerm.FRuleExpr FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? ").append(" AND UserRoleOrg.FOrgID in (").append(orgIds).append(")").append(" AND RolePerm.FPermItemID = ? ").append(" AND RolePerm.FPermType = ? ").append(" AND RolePerm.FRuleExpr is not null ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.context, (String)sql.toString(), (Object[])params);
        try {
            HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
            while (rowSet.next()) {
                String orgId = rowSet.getString("FOrgID");
                String rule = rowSet.getString("FRuleExpr");
                HashSet<String> retSet = (HashSet<String>)result.get(orgId);
                if (retSet == null) {
                    retSet = new HashSet<String>();
                    result.put(orgId, retSet);
                }
                retSet.add(rule);
            }
            Iterator it = result.entrySet().iterator();
            HashMap<String, String> retern = new HashMap<String, String>();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String orgId = (String)entry.getKey();
                Set rules = (Set)entry.getValue();
                String rule = null;
                for (String ruleExpr : rules) {
                    rule = RuleUtil.mergeOQL(rule, ruleExpr, "OR");
                }
                retern.put(orgId, rule);
            }
            return retern;
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL, e);
        }
    }

    private String mergeCommonAndSpecialRule(String commonRule, String specialRule, String bizPermitemlogic) throws ParserException, BOSException, EASBizException {
        String logic = "OR";
        String globalParamLogic = ParamManager.getParamValue((Context)this.context, null, (String)"LogicOfCommonAndSpecialRule");
        globalParamLogic = StringUtils.isEmpty((String)globalParamLogic) || "1".equals(globalParamLogic) ? "OR" : "AND";
        logic = bizPermitemlogic == null || "DF".equalsIgnoreCase(bizPermitemlogic) ? globalParamLogic : bizPermitemlogic;
        return RuleUtil.mergeOQL(commonRule, specialRule, logic);
    }

    private FilterInfo getCoopFieldRule(IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException {
        String[] orgFieldStr = PermissionUtil.getBizOrgCoopPropertyName(this.context, BOSObjectType.create((String)permItemInfo.getObjectType()));
        String[] coopOrgIdList = CoopOrgHelper.appendPropID(orgFieldStr);
        ArrayList<IObjectPK> orgList = new ArrayList<IObjectPK>();
        orgList.add(orgPK);
        return CoopOrgHelper.getCoopOrgFilterInfo(coopOrgIdList, orgList);
    }

    private String getDiscreteDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (this.isDiscretePermItem(permItemInfo)) {
            DiscretePermissionService service = new DiscretePermissionService(this.context);
            String discretePermissionRule = service.getDiscretePermissionRule(userPK, orgPK, permItemInfo.getName());
            return discretePermissionRule;
        }
        return null;
    }

    private boolean isDiscretePermItem(PermItemInfo permItemInfo) {
        Set permItems = (Set)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityPermItems().get(permItemInfo.getObjectType());
        if (permItems == null) {
            return false;
        }
        return permItems.contains(permItemInfo.getName());
    }
}

