/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.service.multiorg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiOrgDataPermissionMap {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(MultiOrgDataPermissionMap.class);
    Map ruleMap = new HashMap();

    public void addRule(String orgID, String ruleExpr) {
        if (StringUtils.isEmpty((String)orgID)) {
            return;
        }
        if (this.ruleMap.get(orgID) == null) {
            this.ruleMap.put(orgID, new ArrayList());
        }
        ((List)this.ruleMap.get(orgID)).add(ruleExpr);
    }

    public String getDataPermissionRule(String orgID, String orgFieldName) throws BOSException, PermissionException {
        List rules;
        if (this.ruleMap.get(orgID) != null && this.ruleMap.get(orgID) instanceof String) {
            return (String)this.ruleMap.get(orgID);
        }
        String rule = null;
        if (this.ruleMap.size() != 0 && (rules = (List)this.ruleMap.get(orgID)) != null) {
            for (int index = 0; index < rules.size(); ++index) {
                String ruleExpr = (String)rules.get(index);
                rule = this.mergeOQL(rule, ruleExpr, "OR");
            }
        }
        rule = this.mergeOQL(rule, "where " + orgFieldName + " = '" + orgID + "' ", "AND");
        this.ruleMap.put(orgID, rule);
        return rule;
    }

    public String getDataPermissionRule(String orgFieldName) throws BOSException, PermissionException {
        if (this.ruleMap.get("total") != null) {
            return (String)this.ruleMap.get("total");
        }
        String rule = null;
        if (this.ruleMap.size() != 0) {
            rule = this.getDataPermissionRule(this.ruleMap.keySet().iterator(), orgFieldName);
        }
        this.ruleMap.put("total", rule);
        return rule;
    }

    public String getDataPermissionRule(Iterator it, String orgFieldName) throws BOSException, PermissionException {
        String rule = null;
        while (it.hasNext()) {
            String orgID = (String)it.next();
            rule = this.mergeOQL(rule, this.getDataPermissionRule(orgID, orgFieldName), "OR");
        }
        return rule;
    }

    public String getDataPermissionRule(Iterator it, String orgFieldName, String specialRule, String logic) throws BOSException, PermissionException {
        String rule = null;
        while (it.hasNext()) {
            String orgID = (String)it.next();
            rule = this.mergeOQL(rule, this.getDataPermissionRule(orgID, orgFieldName, specialRule, logic), "OR");
        }
        return rule;
    }

    public String getDataPermissionRule_new(Iterator it, String orgFieldName, String specialRule, String logic) throws BOSException, PermissionException {
        if (this.ruleMap.isEmpty()) {
            String orgIds = "";
            while (it.hasNext()) {
                String orgID = (String)it.next();
                if (StringUtils.isEmpty((String)orgIds)) {
                    orgIds = "'" + orgID + "' ";
                    continue;
                }
                orgIds = orgIds + ", '" + orgID + "' ";
            }
            if (StringUtils.isEmpty((String)specialRule)) {
                return "ids:" + orgIds;
            }
            if (!StringUtils.isEmpty((String)orgIds)) {
                return this.mergeOQL(specialRule, "where " + orgFieldName + " IN (" + orgIds + ")", "AND");
            }
            return specialRule;
        }
        String ruleSum = "";
        String orgIds = "";
        while (it.hasNext()) {
            String orgID = (String)it.next();
            String rule = null;
            List rules = (List)this.ruleMap.get(orgID);
            if (rules != null) {
                for (int index = 0; index < rules.size(); ++index) {
                    String ruleExpr = (String)rules.get(index);
                    rule = StringUtils.isEmpty(rule) ? ruleExpr : this.mergeOQL(rule, ruleExpr, "OR");
                }
                if (!StringUtils.isEmpty((String)specialRule)) {
                    rule = this.mergeOQL(rule, specialRule, logic);
                }
                rule = this.mergeOQL(rule, "where " + orgFieldName + " = '" + orgID + "' ", "AND");
            } else if (StringUtils.isEmpty((String)specialRule)) {
                orgIds = StringUtils.isEmpty((String)orgIds) ? "'" + orgID + "' " : orgIds + ", '" + orgID + "' ";
            } else {
                rule = this.mergeOQL(specialRule, "where " + orgFieldName + " = '" + orgID + "' ", "AND");
            }
            if (StringUtils.isEmpty((String)ruleSum)) {
                ruleSum = rule;
                continue;
            }
            ruleSum = this.mergeOQL(ruleSum, rule, "OR");
        }
        if (StringUtils.isEmpty((String)orgIds)) {
            return ruleSum;
        }
        if (StringUtils.isEmpty((String)ruleSum)) {
            return "ids:" + orgIds;
        }
        return this.mergeOQL(ruleSum, "where " + orgFieldName + " IN (" + orgIds + ")", "OR");
    }

    public String getDataPermissionRule(String orgID, String orgFieldName, String specialRule, String logic) throws BOSException, PermissionException {
        List rules;
        if (this.ruleMap.get(orgID) != null && this.ruleMap.get(orgID) instanceof String) {
            return (String)this.ruleMap.get(orgID);
        }
        String rule = null;
        if (this.ruleMap.size() != 0 && (rules = (List)this.ruleMap.get(orgID)) != null) {
            for (int index = 0; index < rules.size(); ++index) {
                String ruleExpr = (String)rules.get(index);
                rule = this.mergeOQL(rule, ruleExpr, "OR");
            }
        }
        rule = this.mergeOQL(rule, specialRule, logic);
        rule = this.mergeOQL(rule, "where " + orgFieldName + " = '" + orgID + "' ", "AND");
        this.ruleMap.put(orgID, rule);
        return rule;
    }

    private String mergeOQL(String dataPermRule, String rule2, String bLogic) throws BOSException, PermissionException {
        try {
            dataPermRule = RuleUtil.mergeOQL(dataPermRule, rule2, bLogic);
        }
        catch (ParserException e) {
            logger.error((Object)"", (Throwable)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, e);
        }
        return dataPermRule;
    }
}

