/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PasswordType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.util.BizObjectOrgHelper;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.CryptException;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PermissionUtil {
    private static Logger logger = Logger.getLogger(PermissionUtil.class);

    private PermissionUtil() {
    }

    public static void afterRoleAssignHandle(Context ctx) throws BOSException, EASBizException {
    }

    public static void updateMenuCache(Context ctx) throws BOSException, EASBizException {
        MainFunctionMenuFactory.getLocalInstance((Context)ctx).updateMenuCache("");
    }

    public static UserInfo getUserInfo(Context ctx, IObjectPK userPK) throws BOSException, UserException {
        if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(userPK.toString())) {
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
            userInfo.setType(UserType.SYSTEM);
            userInfo.setBizAdmin(false);
            return userInfo;
        }
        if (userPK.equals((Object)ctx.getCaller()) && ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            return ContextUtil.getCurrentUserInfo((Context)ctx);
        }
        UserInfo userInfo = new UserInfo();
        String sql = "SELECT FID, FType, FIsBizAdmin FROM T_PM_User WHERE FID = ?";
        Object[] params = new Object[]{userPK.toString()};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rowSet.next()) {
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                userInfo.setType(UserType.getEnum(rowSet.getInt("FType")));
                userInfo.setBizAdmin(rowSet.getInt("FIsBizAdmin") == 1);
                return userInfo;
            }
            throw new UserException(UserException.GET_USER_INFO_FAIL);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new UserException(UserException.GET_USER_INFO_FAIL);
        }
    }

    public static String getOrgLongNumber(Context ctx, OrgType orgType, IObjectPK orgPK) throws BOSException, EASBizException {
        String longNumber = null;
        String treeID = PermissionCacheFactory.getOrgCache(ctx).getBasicTreeID(ctx, orgType);
        String orgID = orgPK.toString();
        Object[] params = new Object[]{treeID, orgID};
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FLongNumber FROM T_ORG_Structure ").append(" WHERE\tFTreeId = ? ").append(" AND FUnitId = ? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet.next()) {
                longNumber = rowSet.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL);
        }
        return longNumber;
    }

    public static IObjectPK getPermissionOrgPK(Context context, OrgType orgType, IObjectPK orgPK, Object bizData, boolean extOrgFromCtx) throws EASBizException, BOSException {
        if (!extOrgFromCtx) {
            return orgPK;
        }
        return PermissionUtil.getPermissionOrgPK(context, orgType, orgPK, bizData);
    }

    public static IObjectPK getPermissionOrgPK(Context context, OrgType orgType, IObjectPK orgPK, Object bizData) throws EASBizException, BOSException {
        if (orgPK != null) {
            if (OrgType.NONE.equals((Object)orgType)) {
                return new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
            }
            return orgPK;
        }
        if (bizData == null) {
            return PermissionUtil.getCurrentOrgPK(context, orgType);
        }
        BOSObjectType objectType = null;
        if (bizData instanceof IObjectPK) {
            objectType = ((ObjectUuidPK)bizData).getObjectType();
        } else if (bizData instanceof IObjectValue) {
            objectType = ((IObjectValue)bizData).getBOSType();
        } else {
            throw new IllegalArgumentException("bizData is error : " + bizData);
        }
        BizObjectOrgHelper bizObjectHelper = new BizObjectOrgHelper();
        IObjectPK bizOrgPK = bizObjectHelper.getCoreBillBaseBizOrgPK(context, objectType, bizData);
        if (bizOrgPK != null) {
            return bizOrgPK;
        }
        return PermissionUtil.getCurrentOrgPK(context, orgType);
    }

    private static IObjectPK getCurrentOrgPK(Context context, OrgType orgType) {
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)context, (OrgType)orgType);
        if (orgType.equals((Object)OrgType.NONE)) {
            return new ObjectUuidPK("11111111-1111-1111-1111-111111111111CCE7AED4");
        }
        ObjectUuidPK orgPK = null;
        if (orgUnitInfo != null) {
            orgPK = new ObjectUuidPK(orgUnitInfo.getId());
        }
        return orgPK;
    }

    public static FullOrgUnitInfo getFullOrgUnitInfo(Context ctx, IObjectPK orgPK) throws BOSException, UserException {
        try {
            return FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo(orgPK);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
            throw new UserException(UserException.GET_USER_INFO_FAIL);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
            throw new UserException(UserException.GET_USER_INFO_FAIL);
        }
    }

    public static String getControlUnitID(Context context, IObjectPK orgPK) throws BOSException, EASBizException {
        if ("11111111-1111-1111-1111-111111111111CCE7AED4".equals(orgPK.toString())) {
            return ContextUtil.getCurrentCtrlUnit((Context)context).getId().toString();
        }
        String sql = "SELECT FControlUnitID FROM T_ORG_BaseUnit WHERE FID = ?";
        Object[] params = new Object[]{orgPK.toString()};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql, (Object[])params);
            if (rowSet.next()) {
                return rowSet.getString("FControlUnitID");
            }
            throw new IllegalArgumentException("getControlUnitID(): orgPK is error:" + orgPK);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL);
        }
    }

    public static Map getControlUnitMap(Context context, Collection orgs) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        String sql = "SELECT FID,FControlUnitID FROM T_ORG_BaseUnit WHERE FID in (" + ToolUtils.aryToStr(orgs) + ")";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql);
            while (rowSet.next()) {
                String cu = rowSet.getString("FControlUnitID");
                String id = rowSet.getString("FID");
                if (StringUtils.isEmpty((String)id)) continue;
                if (result.get(cu) == null) {
                    result.put(cu, new ArrayList());
                }
                List orgInSameCU = (List)result.get(cu);
                orgInSameCU.add(id);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.GET_INFO_FAIL);
        }
        return result;
    }

    public static String encrypt(String userID, String password) throws EASBizException {
        return PermissionUtils.encrypt(userID, password);
    }

    public static String encrypt(String userID, String password, PasswordType type) throws EASBizException {
        return PermissionUtils.encrypt(userID, password, type);
    }

    public static String decrypt(String userNumber, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return null;
        }
        try {
            return CryptoTean.decrypt((String)userNumber, (String)password);
        }
        catch (CryptException e) {
            logger.error((Object)"decrypt", (Throwable)e);
            throw new UserException(UserException.ENCRYPT_FAIL);
        }
    }

    public static boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        String oldPassword;
        String string = oldPassword = userInfo.getPassword() == null ? "" : userInfo.getPassword();
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)oldPassword);
        }
        if (oldPassword.length() == 24) {
            return PermissionUtil.encrypt(userInfo.getId().toString(), password, PasswordType.MD5).equals(oldPassword);
        }
        return PermissionUtil.encrypt(userInfo.getId().toString(), password, userInfo.getPasswordType()).equals(oldPassword);
    }

    public static String getBizOrgPropertyName(Context ctx, BOSObjectType type) throws EASBizException {
        Object proName = PermissionUtil.getOrgPropertyName(ctx, type, "getBizOrgPropertyName");
        if (proName == null) {
            return "CU";
        }
        return (String)proName;
    }

    public static Object getOrgPropertyName(Context ctx, BOSObjectType type, String proName) throws EASBizException {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
        String className = entity.getObjectValueClass();
        try {
            Class<?> clazz = Class.forName(className);
            Method getBizOrgPropertyNameMethod = clazz.getMethod(proName, new Class[0]);
            if (getBizOrgPropertyNameMethod == null) {
                return null;
            }
            return getBizOrgPropertyNameMethod.invoke(clazz.newInstance(), new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public static String[] getBizOrgCoopPropertyName(Context ctx, BOSObjectType type) throws EASBizException {
        Object proName = PermissionUtil.getOrgPropertyName(ctx, type, "getCooperatedOrgName");
        return (String[])proName;
    }

    public static List<String> getPkIds(List objs) {
        ArrayList<String> pks = new ArrayList<String>();
        for (Object obj : objs) {
            if (obj instanceof ObjectBaseInfo) {
                ObjectBaseInfo info = (ObjectBaseInfo)obj;
                pks.add(info.getId().toString());
                continue;
            }
            pks.add(obj.toString());
        }
        return pks;
    }

    public static List<IObjectPK> toIObjectPKs(List objs) throws BOSException {
        ArrayList<IObjectPK> pks = new ArrayList<IObjectPK>();
        for (Object obj : objs) {
            String info;
            if (obj instanceof String) {
                info = (String)obj;
                pks.add((IObjectPK)new ObjectStringPK(info));
                continue;
            }
            if (obj instanceof IObjectPK) {
                pks.add((IObjectPK)obj);
                continue;
            }
            if (obj instanceof ObjectBaseInfo) {
                info = (ObjectBaseInfo)obj;
                pks.add((IObjectPK)new ObjectUuidPK(info.getId()));
                continue;
            }
            throw new BOSException("object Type is error!");
        }
        return pks;
    }
}

