/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.permission.mutex;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.util.Uuid;
import java.util.Locale;

public class SynMutex {
    private static final String RESOURCE = "com.kingdee.eas.base.permission.PermissionResource";
    IMutexServiceControl iMutex = null;
    MutexParameter quest = null;

    private MutexParameter getMutexParam(IObjectPK userPK) {
        MutexParameter param = new MutexParameter();
        String viewName = EASCommonResource.getString((String)RESOURCE, (String)"synMutexLock", (Locale)ContextUtils.getLocaleFromEnv());
        param.setMutexName(viewName);
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        param.setRequestId(Uuid.create());
        param.setActionName(viewName);
        param.setUserID(BOSUuid.read((String)userPK.toString()));
        return param;
    }

    public SynMutex(IObjectPK userPK) {
        this(null, userPK);
    }

    public SynMutex(Context ctx, IObjectPK userPK) {
        if (ctx != null) {
            try {
                this.iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
        } else {
            this.iMutex = MutexServiceControlFactory.getRemoteInstance();
        }
        this.quest = this.getMutexParam(userPK);
    }

    public boolean request() {
        return this.iMutex.requestMutex2(this.quest);
    }

    public void release() {
        this.iMutex.releaseMutex(this.quest.getRequestId());
    }
}

