/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.risk.app.AbstractRiskDumpFacadeControllerBean;
import com.kingdee.eas.base.wssc.util.SafeFilterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RiskDumpFacadeControllerBean
extends AbstractRiskDumpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskDumpFacadeControllerBean");
    private int days = 90;
    private int batchsize = 500;

    @Override
    protected void _risklogDumpProcess(Context ctx) throws BOSException, EASBizException {
        String clearDirtyLogSql = "DELETE FROM T_RIS_RiskRecordHIS WHERE exists (select 1 from T_RIS_RiskRecord rdp where rdp.fid = fid)";
        String insertSql = "INSERT INTO T_RIS_RiskRecordHIS SELECT * FROM T_RIS_RiskRecord WHERE DATEDIFF(Day,FCreateTime,GETDATE()) >= " + this.days;
        String deleteSql = "DELETE FROM T_RIS_RiskRecord WHERE DATEDIFF(Day,FCreateTime,GETDATE()) >= " + this.days;
        this.dumpData(ctx, clearDirtyLogSql, insertSql, deleteSql);
    }

    private void dumpData(Context ctx, String clearDirtyLogSql, String insertSql, String deleteSql) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this.clearDirtyLogDataBatch(cn, clearDirtyLogSql);
            this.transferWLogDataBatch(cn, insertSql, deleteSql);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDirtyLogDataBatch(Connection cn, String sql) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = cn.prepareStatement(sql);
            ps.execute();
        }
        finally {
            SafeFilterUtils.safeClose((PreparedStatement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferWLogDataBatch(Connection cn, String insertSql, String deleteSql) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = cn.prepareStatement(insertSql);
            ps.execute();
            ps = cn.prepareStatement(deleteSql);
            ps.execute();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            SafeFilterUtils.safeClose((PreparedStatement)ps);
        }
    }
}

