/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.cache;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.risk.RiskConfigCollection;
import com.kingdee.eas.base.risk.RiskConfigFactory;
import com.kingdee.eas.base.risk.RiskConfigInfo;
import com.kingdee.eas.base.risk.cache.RiskCacheManager;
import com.kingdee.eas.base.risk.cache.RiskModelCache;
import com.kingdee.eas.base.risk.service.wfEngine.RiskServiceAdapter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskConfigUtils {
    private static Logger logger = Logger.getLogger(RiskConfigUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties loadCache(Context ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("LoadRiskConfig ctx is null");
        }
        Properties properties = null;
        Properties cfgMap = null;
        Object cacheObj = RiskCacheManager.getValue("risk_system_properties");
        if (cacheObj != null) {
            cfgMap = (Properties)cacheObj;
        } else {
            logger.error((Object)"[risk_system_properties]");
            cfgMap = new Properties();
        }
        String dbId = ctx.getAIS();
        if (StringUtils.isEmpty((CharSequence)dbId)) {
            throw new IllegalArgumentException("ctx[" + ctx + "]ctx getAIS isEmpty");
        }
        properties = (Properties)cfgMap.get(dbId);
        if (null != properties) return properties;
        properties = new Properties();
        Class<RiskConfigUtils> clazz = RiskConfigUtils.class;
        synchronized (RiskConfigUtils.class) {
            logger.error((Object)"RiskConfigUtils synchronized to load config ");
            try {
                RiskConfigCollection coll = RiskConfigFactory.getLocalInstance(ctx).getRiskConfigCollection();
                if (coll != null && !coll.isEmpty()) {
                    for (int i = 0; i < coll.size(); ++i) {
                        RiskConfigInfo configInfo = coll.get(i);
                        if (!StringUtils.isEmpty((CharSequence)configInfo.getKey()) && !StringUtils.isEmpty((CharSequence)configInfo.getValue())) {
                            properties.put(configInfo.getKey(), configInfo.getValue());
                            continue;
                        }
                        logger.error((Object)("load riskConfig keyIsNull or valueIsNull;RiskConfigInfo:" + configInfo.getId().toString()));
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("getRiskConfigCollection Exception" + e);
            }
            try {
                StringBuffer buffer = new StringBuffer();
                Set<Object> set = properties.keySet();
                Iterator<Object> it = set.iterator();
                while (it.hasNext()) {
                    String key = it.next().toString();
                    buffer.append("{key:" + key + "--value:" + properties.get(key) + "}");
                }
                logger.error((Object)("risk config cache[" + buffer.toString() + "]"));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            cfgMap.put(dbId, properties);
            RiskCacheManager.put("risk_system_properties", cfgMap);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return properties;
        }
    }

    public static String getCache(Context ctx, String key) {
        Properties properties = RiskConfigUtils.loadCache(ctx);
        return (String)properties.get(key);
    }

    public static void clearConfigCache() {
        RiskCacheManager.clearCache("risk_system_properties");
    }

    public static void initConfigCache(Context ctx) {
        RiskConfigUtils.clearConfigCache();
        RiskConfigUtils.loadCache(ctx);
    }

    public static synchronized void clearCache(Context ctx) {
        RiskCacheManager.clearCache();
        RiskConfigUtils.initCache(ctx);
    }

    public static synchronized void initCache(Context ctx) {
        RiskServiceAdapter.initCacheSet(ctx);
        RiskConfigUtils.initConfigCache(ctx);
        RiskModelCache.clearRiskModelCache(ctx);
    }

    public static synchronized void clearAdapterCache(Context ctx) {
        RiskCacheManager.clearCache("risk_service_adapter_cache");
        RiskServiceAdapter.initCacheSet(ctx);
    }

    public static synchronized void clearRiskModelCache(Context ctx) {
        RiskModelCache.clearRiskModelCache(ctx);
    }

    public static List<String> getUipkAction(Context ctx, String uipk) {
        return RiskModelCache.getUipkAction(ctx, uipk);
    }

    public static boolean existUipkAction(Context ctx, String uipk, String action) {
        return RiskModelCache.existUipkAction(ctx, uipk, action);
    }

    public static boolean existUipk(Context ctx, String uipk) {
        return RiskModelCache.existUipk(ctx, uipk);
    }

    public static boolean existFunction(Context ctx, BOSObjectType bosType, IMetaDataPK metaDataPK) {
        return RiskModelCache.existFunction(ctx, bosType, metaDataPK);
    }

    public static boolean existROBOT(Context ctx, BOSObjectType metaBosType, String method) {
        return RiskModelCache.existROBOT(ctx, metaBosType, method);
    }

    public static boolean need2Saved2DB(Context ctx) {
        if (StringUtils.isNotEmpty((CharSequence)RiskConfigUtils.getCache(ctx, "savedBizdataDB"))) {
            return "true".equalsIgnoreCase(RiskConfigUtils.getCache(ctx, "savedBizdataDB"));
        }
        return false;
    }
}

