/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.condit;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.risk.ExecValueType;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.service.business.IModelService;
import com.kingdee.eas.base.risk.service.business.ResultMsg;
import com.kingdee.eas.base.risk.service.common.DataSnapshotUtil;
import com.kingdee.eas.base.risk.service.condit.IModelConditInterface;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.util.NumericExceptionSubItem;
import org.apache.log4j.Logger;

public abstract class AbsClazzStrategy
implements IModelConditInterface {
    private static Logger logger = Logger.getLogger(AbsClazzStrategy.class);
    protected Context ctx;
    protected RiskParam param;
    protected RiskModelInfo riskModelInfo;

    public Object match() throws RiskException {
        String clazz = this.getClazz();
        String bizObjId = this.getBizObjId();
        NumericExceptionSubItem except = this.getException();
        Object instance = null;
        try {
            Class<?> aClass = Class.forName(clazz);
            instance = aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e, (Throwable)e);
            DataSnapshotUtil.writeErrLog(this.ctx, this.param, bizObjId, e);
            throw new RiskException(except, new Object[]{"[ClassNotFoundException]"});
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e, (Throwable)e);
            DataSnapshotUtil.writeErrLog(this.ctx, this.param, bizObjId, e);
            throw new RiskException(except, new Object[]{"[IllegalAccessException]"});
        }
        catch (InstantiationException e) {
            logger.error((Object)e, (Throwable)e);
            DataSnapshotUtil.writeErrLog(this.ctx, this.param, bizObjId, e);
            throw new RiskException(except, new Object[]{"[InstantiationException]"});
        }
        if (!(instance instanceof IModelService)) {
            String message = "[" + clazz + " not extends IModelService]";
            DataSnapshotUtil.writeErrLog(this.ctx, this.param, bizObjId, new Exception(message));
            throw new RiskException(except, new Object[]{message});
        }
        try {
            IModelService iService = instance;
            ResultMsg check = iService.check(this.ctx, this.riskModelInfo, this.param.getModel(), new Object[0]);
            DataSnapshotUtil.writeExecData(this.ctx, this.param, bizObjId, "", ExecValueType.OV, JSONObject.toJSONString(check.getDataMap(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
            if (check != null && check.getShowDataList() != null && check.getShowDataList().size() > 0) {
                this.param.getShowDataMap().put(this.riskModelInfo.getId().toString(), check.getShowDataList());
            }
            return check.result;
        }
        catch (Exception e) {
            DataSnapshotUtil.writeErrLog(this.ctx, this.param, bizObjId, e);
            throw new RiskException(except, new Object[]{"[check exception]"});
        }
    }

    protected abstract NumericExceptionSubItem getException();

    protected String getBizObjId() {
        return this.riskModelInfo.getId().toString();
    }

    protected abstract String getClazz();
}

