/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.condit;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.service.common.DataSnapshotUtil;
import com.kingdee.eas.base.risk.service.common.SqlCheck;
import com.kingdee.eas.base.risk.service.condit.IModelConditInterface;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbsSqlStrategy
implements IModelConditInterface {
    private static Logger logger = Logger.getLogger(AbsSqlStrategy.class);
    protected Context ctx;
    protected RiskParam param;
    protected RiskModelInfo riskModelInfo;

    public Object match() throws RiskException {
        boolean result = false;
        String sql = this.getExecuteSQL();
        String bizObjId = this.getBizObjId();
        try {
            SqlCheck.checkSQLValid(this.ctx, sql);
            Object id = this.param.getModel().get("id");
            if (id == null) {
                logger.error((Object)("riskModelInfo--id:" + bizObjId + ",model id is ,replaceAll ? to ''"));
                sql = sql.replaceAll("\\?", " '' ");
            } else {
                sql = sql.replaceAll("\\?", " '" + id.toString() + "' ");
            }
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            if (rs.next()) {
                String col = rs.getString(1);
                if (StringUtils.isEmpty((CharSequence)col)) {
                    col = "0";
                    logger.error((Object)("riskModelInfo--id:" + bizObjId + ",result is null,default 0"));
                }
                result = Integer.parseInt(col) > 0;
            } else {
                logger.error((Object)("riskModelInfo--id:" + bizObjId + ",result size=0,return false"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            DataSnapshotUtil.writeErrLog(this.ctx, this.param, bizObjId, e);
            throw new RiskException(new NumericExceptionSubItem("00", e.getMessage()));
        }
        return result;
    }

    protected String getBizObjId() {
        return this.riskModelInfo.getId().toString();
    }

    protected abstract String getExecuteSQL();
}

