/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.paySafe;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.app.paySafe.RBShowFieldEntryCollection;
import com.kingdee.eas.base.risk.app.paySafe.RBShowFieldEntryInfo;
import com.kingdee.eas.base.risk.app.paySafe.RBTargetBillFilterCollection;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillCollection;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillEntryCollection;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillFactory;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillInfo;
import com.kingdee.eas.base.risk.service.business.IModelService;
import com.kingdee.eas.base.risk.service.business.ResultMsg;
import com.kingdee.eas.base.risk.service.common.BillModelUitls;
import com.kingdee.eas.base.risk.service.common.EngineUtils;
import com.kingdee.eas.base.risk.service.condit.PaySafeFilerRule;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.showdata.OnlyTextInfo;
import com.kingdee.eas.base.risk.service.showdata.ShowDataInfo;
import com.kingdee.eas.base.risk.tools.sqlTools.SqlFormatUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckRepeatBill
implements IModelService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.service.paySafe.CheckRepeatBill");

    @Override
    public ResultMsg check(Context ctx, RiskModelInfo modelInfo, IObjectValue billModelInfo, Object ... args) {
        ArrayList<ShowDataInfo> showDataList = new ArrayList<ShowDataInfo>();
        try {
            Object[] bosTypeAndBillIds = this.getSrcBosTypeAndDetBillIds(ctx, billModelInfo);
            if (bosTypeAndBillIds.length == 0) {
                return this.concretResult("\u5355\u4e00\u5355\u636e\uff0c\u65e0\u9700\u6821\u9a8c", false, showDataList);
            }
            Set billIds = (Set)bosTypeAndBillIds[1];
            RepeatBillInfo repeatBillInfo = modelInfo.getRepeatBill();
            if (repeatBillInfo == null) {
                String srcBosType = (String)bosTypeAndBillIds[0];
                RepeatBillCollection repeatBillCon = RepeatBillFactory.getLocalInstance(ctx).getRepeatBillCollection("select billType.number,entry.*,targetFilter.*,showFiledEntry.* where targetBill.billBosType = '" + billModelInfo.getBOSType().toString() + "' and srcBill.billBosType = '" + srcBosType + "'");
                if (repeatBillCon.isEmpty()) {
                    return this.concretResult("\u5355\u636e\u672a\u914d\u7f6e\u9632\u91cd\u89c4\u5219", false, showDataList);
                }
                repeatBillInfo = repeatBillCon.get(0);
            }
            String messageForTest = "";
            messageForTest = messageForTest + "billids:" + billIds.size();
            IObjectCollection billsValue = this.getBillsValue(ctx, repeatBillInfo, billIds, billModelInfo.getBOSType().toString());
            messageForTest = messageForTest + ";billsValue:" + billsValue.size();
            this.filterBill(ctx, repeatBillInfo, billsValue);
            messageForTest = messageForTest + ";afterbillsValue:" + billsValue.size();
            boolean result = this.getCompareResult(billsValue, repeatBillInfo, billModelInfo, showDataList);
            messageForTest = messageForTest + (String)billModelInfo.get("messageForTest");
            if (messageForTest.length() > 2000) {
                messageForTest = messageForTest.substring(0, 2000);
            }
            if (result) {
                return this.concretResult("\u5b58\u5728\u91cd\u590d\u5355\u636e" + messageForTest, true, showDataList);
            }
            return this.concretResult("\u65e0\u91cd\u590d\u5355\u636e" + messageForTest, false, showDataList);
        }
        catch (Exception e) {
            logger.error((Object)"\u9632\u91cd\u62a5\u9519", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean getCompareResult(IObjectCollection billsValue, RepeatBillInfo repeatBillInfo, IObjectValue billModelInfo, List<ShowDataInfo> showDataList) throws RiskException {
        HashMap<String, String> numbersAndTypes = this.getRepeatFieldNumbersAndTypes(repeatBillInfo.getEntry());
        Set<String> compareFields = numbersAndTypes.keySet();
        String messageForTest = "inner";
        boolean result = false;
        for (int i = 0; i < billsValue.size(); ++i) {
            boolean flag = true;
            IObjectValue object = billsValue.getObject(i);
            for (String field : compareFields) {
                Object srcValue = BillModelUitls.modelGetVal(object, field);
                Object currentBillValue = BillModelUitls.modelGetVal(billModelInfo, field);
                if (srcValue == null && currentBillValue == null) continue;
                if (srcValue != null && currentBillValue != null) {
                    if ("BigDecimal".equals(numbersAndTypes.get(field))) {
                        BigDecimal current;
                        BigDecimal src = srcValue instanceof BigDecimal ? (BigDecimal)srcValue : new BigDecimal(String.valueOf(srcValue));
                        if (src.compareTo(current = currentBillValue instanceof BigDecimal ? (BigDecimal)currentBillValue : new BigDecimal(String.valueOf(currentBillValue))) == 0) continue;
                        flag = false;
                        messageForTest = messageForTest + src + ":" + current + "\u3002";
                        break;
                    }
                    if (srcValue.equals(currentBillValue)) continue;
                    messageForTest = messageForTest + srcValue + ":" + currentBillValue + "\u3002";
                    flag = false;
                    break;
                }
                flag = false;
                break;
            }
            if (!flag) continue;
            result = true;
            this.putDataToShowDataList(showDataList, repeatBillInfo.getShowFiledEntry(), object);
        }
        billModelInfo.put("messageForTest", (Object)messageForTest);
        return result;
    }

    private String toUpperCaseFirst(String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    private Object getValueFormat(Object dyValue, String key) {
        try {
            SimpleDateFormat format;
            Method method2;
            Class<?> cls = dyValue.getClass();
            String fieldKey = this.toUpperCaseFirst(key);
            try {
                method2 = cls.getMethod("get" + fieldKey, new Class[0]);
                Object enumDyValue = method2.invoke(dyValue, new Object[0]);
                if (enumDyValue instanceof Enum) {
                    cls = enumDyValue.getClass();
                    method2 = cls.getMethod("getAlias", new Class[0]);
                    dyValue = method2.invoke(enumDyValue, new Object[0]);
                    return dyValue;
                }
            }
            catch (Exception method2) {
                // empty catch block
            }
            try {
                method2 = cls.getMethod("is" + fieldKey, new Class[0]);
                Object booleanDyValue = method2.invoke(dyValue, new Object[0]);
                if (booleanDyValue instanceof Boolean) {
                    return (Boolean)booleanDyValue;
                }
            }
            catch (Exception method3) {
                // empty catch block
            }
            method2 = cls.getMethod("get", String.class);
            dyValue = method2.invoke(dyValue, key);
            if (dyValue instanceof Enum) {
                cls = dyValue.getClass();
                method2 = cls.getMethod("getAlias", new Class[0]);
                dyValue = method2.invoke(dyValue, new Object[0]);
                return dyValue;
            }
            if (dyValue instanceof Timestamp) {
                format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return format.format(dyValue);
            }
            if (dyValue instanceof Date) {
                format = new SimpleDateFormat("yyyy-MM-dd");
                return format.format(dyValue);
            }
            if (dyValue instanceof String) {
                dyValue = dyValue != null ? ((String)dyValue).trim() : dyValue;
            }
            return dyValue;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private void putDataToShowDataList(List<ShowDataInfo> showDataList, RBShowFieldEntryCollection showFieldEntry, IObjectValue object) {
        for (int i = 0; i < showFieldEntry.size(); ++i) {
            try {
                RBShowFieldEntryInfo info = showFieldEntry.get(i);
                ArrayList<Object> showValues = new ArrayList<Object>();
                Object item = this.getValueFormat(object, info.getFieldNumber());
                showValues.add(item);
                OnlyTextInfo onlyTextInfo = new OnlyTextInfo();
                onlyTextInfo.setShowName(info.getFieldName());
                onlyTextInfo.setShowNumber(info.getFieldNumber());
                onlyTextInfo.setShowValue(showValues);
                showDataList.add(onlyTextInfo);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"\u5c55\u793a\u5b57\u6bb5\u53d6\u503c\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void filterBill(Context ctx, RepeatBillInfo repeatBillInfo, IObjectCollection billsValue) throws RiskException {
        if (repeatBillInfo.getTargetFilter().size() > 0) {
            RiskParam riskParam = new RiskParam();
            RiskModelInfo riskModelInfo = new RiskModelInfo();
            riskModelInfo.put("modelRuleEntry", (Object)repeatBillInfo.getTargetFilter());
            for (int i = billsValue.size() - 1; i >= 0; --i) {
                riskParam.setModel(billsValue.getObject(i));
                PaySafeFilerRule paySafeFilerRule = new PaySafeFilerRule(ctx, riskParam, riskModelInfo);
                if (!((Boolean)paySafeFilerRule.match()).booleanValue()) continue;
                billsValue.removeObject(i);
            }
        }
    }

    private HashMap<String, String> getRepeatFieldNumbersAndTypes(RepeatBillEntryCollection entry) {
        HashMap<String, String> numberAndType = new HashMap<String, String>();
        for (int i = 0; i < entry.size(); ++i) {
            Map map = EngineUtils.jsonTOMap(entry.get(i).getField());
            Map propMap = (Map)map.get("propMap");
            numberAndType.put((String)propMap.get("number"), (String)propMap.get("type"));
        }
        return numberAndType;
    }

    private Object[] getSrcBosTypeAndDetBillIds(Context ctx, IObjectValue billModelInfo) throws BOSException, SQLException {
        Set riskSrcBillIds = billModelInfo.get("riskSrcBillIds") == null ? null : (Set)billModelInfo.get("riskSrcBillIds");
        String billid = billModelInfo.get("id").toString();
        String sql = "";
        sql = riskSrcBillIds != null && !riskSrcBillIds.isEmpty() ? "SELECT FSRCENTITYID,FDESTOBJECTID  FROM T_BOT_RELATION where  FSRCOBJECTID in" + SqlFormatUtils.set2Sql(riskSrcBillIds) : "SELECT FSRCENTITYID,FDESTOBJECTID  FROM T_BOT_RELATION where  FSRCOBJECTID in (SELECT top 1 FSRCOBJECTID FROM T_BOT_RELATION where FDESTOBJECTID = '" + billid + "')";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> result = new HashSet<String>();
        String bosType = "";
        while (rowSet.next()) {
            String id = rowSet.getString(2);
            if (id.equals(billid)) continue;
            result.add(id);
            bosType = rowSet.getString(1);
        }
        if (StringUtils.isEmpty((String)bosType)) {
            return new Object[0];
        }
        return new Object[]{bosType, result};
    }

    private IObjectCollection getBillsValue(Context ctx, RepeatBillInfo repeatBillInfo, Set<String> billIds, String bosType) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIds, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        RepeatBillEntryCollection entry = repeatBillInfo.getEntry();
        SelectorItemCollection sicSrc = new SelectorItemCollection();
        for (int i = 0; i < entry.size(); ++i) {
            this.putSelectorToSIC(entry.get(i).getField(), sicSrc);
        }
        RBTargetBillFilterCollection targetFilter = repeatBillInfo.getTargetFilter();
        for (int i = 0; i < targetFilter.size(); ++i) {
            this.putSelectorToSIC(targetFilter.get(i).getCompareField(), sicSrc);
            this.putSelectorToSIC(targetFilter.get(i).getCompareValue(), sicSrc);
        }
        RBShowFieldEntryCollection showFiledEntry = repeatBillInfo.getShowFiledEntry();
        for (int i = 0; i < showFiledEntry.size(); ++i) {
            this.putSelectorToSIC(showFiledEntry.get(i).getField(), sicSrc);
        }
        view.setSelector(sicSrc);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection srcCollection = iDynamicObject.getCollection(new BOSObjectType(bosType), view);
        return srcCollection;
    }

    private void putSelectorToSIC(String Field2, SelectorItemCollection sic) {
        if (Field2 != null && (Field2.indexOf("propMapArr") != -1 || Field2.indexOf("propMap") != -1)) {
            Map map = EngineUtils.jsonTOMap(Field2);
            if (map.get("propMapArr") != null) {
                List propMapArr = (List)map.get("propMapArr");
                for (int j = 0; j < propMapArr.size(); ++j) {
                    sic.add(new SelectorItemInfo((String)((Map)propMapArr.get(j)).get("number")));
                }
            } else if (map.get("propMap") != null) {
                Map propMap = (Map)map.get("propMap");
                sic.add(new SelectorItemInfo((String)propMap.get("number")));
            }
        }
    }

    private ResultMsg concretResult(String msg, boolean result, List<ShowDataInfo> showDataList) {
        ResultMsg builder = ResultMsg.builder();
        Map<String, String> dataMap = builder.getDataMap();
        dataMap.put(ResultMsg.DEFKEY[0], msg);
        dataMap.put(ResultMsg.DEFKEY[1], this.getClass().getName());
        builder.setResult(result).setDataMap(dataMap);
        builder.setShowDataList(showDataList);
        return builder;
    }
}

