/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.org;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OrgUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.tools.org.OrgUtils");

    public static List<IObjectValue> getChildOrg(Context ctx, Set<String> parentOrgIds, OrgType orgType, boolean includeParentIds) throws BOSException, SQLException {
        OrgTreeCollection coll = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("where type = " + orgType.getValue());
        String orgTypeId = "";
        if (coll.size() > 0) {
            OrgTreeInfo orgTreeInfo = coll.get(0);
            orgTypeId = orgTreeInfo.getId().toString();
        }
        LinkedList<IObjectValue> parentOrgs = new LinkedList<IObjectValue>();
        HashSet<String> ids = new HashSet<String>();
        for (String parentId : parentOrgIds) {
            OrgUtils.getChildByOrgType(ctx, parentOrgs, parentId, orgTypeId, includeParentIds, ids);
        }
        return parentOrgs;
    }

    private static void getChildByOrgType(Context ctx, List<IObjectValue> parents, String orgId, String orgTypeId, boolean includeParentIds, Set<String> remDup) throws BOSException, SQLException {
        OrgStructureCollection orgStructureColl;
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            return;
        }
        String sql = "SELECT flongnumber FROM T_ORG_Structure WHERE FUnitID = ? AND FTreeID = ?";
        String longnumber = null;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgId, orgTypeId});
        if (rs.next()) {
            longnumber = rs.getString(1);
        }
        if (!StringUtils.isEmpty(longnumber) && !StringUtils.isEmpty((CharSequence)orgTypeId) && (orgStructureColl = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select id,longNumber,tree.id,unit.id,unit.name,unit.number where longNumber like '" + longnumber + "%' and tree.id = '" + orgTypeId + "'")).size() > 0) {
            for (int i = 0; i < orgStructureColl.size(); ++i) {
                FullOrgUnitInfo unit = orgStructureColl.get(i).getUnit();
                String infoId = unit.getId().toString();
                if (!includeParentIds && orgId.equals(infoId) || remDup.contains(infoId)) continue;
                remDup.add(infoId);
                parents.add((IObjectValue)unit);
            }
        }
    }

    public static void getParentsByOrgType(Context ctx, Set<String> parents, String orgId, String orgTypeId) {
        String sql;
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            return;
        }
        Object[] objects = null;
        if (StringUtils.isEmpty((CharSequence)orgTypeId)) {
            sql = "SELECT FParentID FROM T_ORG_BaseUnit WHERE FID = ?";
            objects = new Object[]{orgId};
        } else {
            sql = "SELECT FParentID FROM T_ORG_Structure WHERE FUnitID = ? AND FTreeID = ? ";
            objects = new Object[]{orgId, orgTypeId};
        }
        String parentId = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])objects);
            if (rs.next()) {
                parentId = rs.getString(1);
            }
            if (!StringUtils.isEmpty(parentId)) {
                if (!StringUtils.isEmpty((CharSequence)orgTypeId)) {
                    OrgStructureCollection orgStructureColl = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("where id = '" + parentId + "'");
                    if (orgStructureColl.size() > 0) {
                        parentId = orgStructureColl.get(0).getUnit().getId().toString();
                    }
                    if (StringUtils.isEmpty((CharSequence)parentId)) {
                        return;
                    }
                }
                parents.add(parentId);
                OrgUtils.getParentsByOrgType(ctx, parents, parentId, orgTypeId);
            }
            return;
        }
        catch (Exception e) {
            logger.error((Object)"getParentIDs error", (Throwable)e);
            return;
        }
    }
}

