/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.tools.smecloud.apigw.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.constant.HttpMethod;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.gwclient.ApigwClient;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiRequest;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApiResult;
import com.kingdee.eas.base.risk.tools.smecloud.apigw.model.ApigwConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApiGwForAuth2Util {
    static Pattern pattern = Pattern.compile("^(https|http)");

    public static String invokeApiGw(String host, String path, String clientId, String clientSecret, Map<String, Object> params) throws Exception {
        Matcher matcher;
        ApigwConfig config = new ApigwConfig();
        config.setClientID(clientId);
        config.setClientSecret(clientSecret);
        ApigwClient apigwClient = ApigwClient.getInstance();
        apigwClient.init(config);
        String scheme = "";
        if (host.startsWith("http") && (matcher = pattern.matcher(host)).find()) {
            scheme = matcher.group(0);
            host = host.substring(scheme.length() + 3);
        }
        ApiRequest request = new ApiRequest(HttpMethod.POST_BODY, host, path);
        request.setScheme(scheme);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        request.addHeaders(headers);
        byte[] bytes = JSONObject.toJSONBytes(params, (SerializerFeature[])new SerializerFeature[0]);
        request.setBodyJson(bytes);
        ApiResult result = ApigwClient.getInstance().send(request);
        if (result.getHttpCode() == 200) {
            return result.getBody();
        }
        throw new Exception("\u8c03\u7528\u4e91\u5e73\u53f0\u63a5\u53e3\u5931\u8d25\uff1a" + host + path + "\uff1bHTTPSTATUS\uff1a" + result.getHttpCode());
    }
}

