/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.base.security.app.CommonBCryptCASolution;
import com.kingdee.eas.base.security.app.IServerCASolution;
import com.kingdee.eas.base.security.app.ItrusCASolution;
import com.kingdee.eas.base.security.util.PermissionParameterConfigUtil;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class SmartPayCASolutionFactory {
    private static Logger logger = Logger.getLogger(SmartPayCASolutionFactory.class);
    private static IServerCASolution solution;
    private static Properties properties;

    public static IServerCASolution getCASolution(String className) {
        Class<?> clz = null;
        try {
            clz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("className " + className + " is invalid, can not find it."));
        }
        if (clz == null) {
            return null;
        }
        if (!IServerCASolution.class.isAssignableFrom(clz)) {
            logger.error((Object)("class must implement the interface IServerCASolution, class: " + clz));
        }
        IServerCASolution solution = null;
        try {
            solution = (IServerCASolution)clz.newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)("init class error, class: " + clz));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("illegal access of class, class: " + clz));
        }
        return solution;
    }

    public static IServerCASolution getCASolution() throws BOSException {
        String clazz;
        if (solution != null) {
            return solution;
        }
        SmartPayCASolutionFactory.ensurePropertiesInited();
        boolean smartPayEnabled = Boolean.parseBoolean(SmartPayCASolutionFactory.toString(properties.get("smartpay.sign.enable")));
        if (!smartPayEnabled) {
            logger.error((Object)"smartpaysign is not enabled");
            return null;
        }
        String supporter = SmartPayCASolutionFactory.toString(properties.get("smartpay.sign.supporter"));
        if (!StringUtils.isEmpty((CharSequence)supporter)) {
            if ("itrus".equals(supporter)) {
                solution = new ItrusCASolution();
            } else if ("normal".equals(supporter)) {
                solution = new CommonBCryptCASolution();
            } else {
                throw new BOSException("invalid smartpay supporter, supporter: " + supporter);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(clazz = SmartPayCASolutionFactory.toString(properties.get("smartpay.sign.className"))))) {
            IServerCASolution _solution = SmartPayCASolutionFactory.getCASolution(clazz);
            if (_solution == null) {
                throw new BOSException("get smartpay supporter by className failed, class: " + clazz);
            }
            solution = _solution;
        }
        if (solution == null) {
            throw new BOSException("can not find the supporter or any classname, both of them are empty.");
        }
        return solution;
    }

    private static void ensurePropertiesInited() throws BOSException {
        if (properties != null) {
            return;
        }
        try {
            properties = PermissionParameterConfigUtil.getSmartPaySignConfig();
        }
        catch (IOException e) {
            logger.error((Object)"get smartpaySign config error.", (Throwable)e);
            throw new BOSException("please make sure server/properties/SmartPaySignConfig.properties exists.");
        }
    }

    private static String toString(Object obj) {
        return obj != null ? obj.toString() : "";
    }
}

