/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.machinecode;

import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.Map;

public class MachineCodeConfigUtil {
    private static final String FILE_NAME = "config.xml";
    private static final String UIFRAME_ITEM = "uiframe";
    private static final String SYS_LOGIN_ITEM = "sysloginlistener";
    private static final String MACHINE_LISTENER = "com.kingdee.eas.base.permission.client.plugin.MachineRegisterLoginListener";

    public static final XMLConfiguration loadConfigFile() {
        File file = new File(MachineCodeConfigUtil.getConfigFileFullPath());
        if (file.exists()) {
            return MachineCodeConfigUtil.loadConfigFile(file);
        }
        return null;
    }

    public static final XMLConfiguration loadConfigFile(File file) {
        XMLConfiguration config = null;
        if (file != null && file.exists()) {
            config = XMLConfiguration.getInstance((File)file);
        }
        return config;
    }

    private static String getConfigFileFullPath() {
        String easHome = System.getProperty("EAS_HOME");
        StringBuffer filePath = new StringBuffer(easHome);
        filePath.append(File.separator);
        filePath.append("server");
        filePath.append(File.separator);
        filePath.append("deploy");
        filePath.append(File.separator);
        filePath.append("fileserver.ear");
        filePath.append(File.separator);
        filePath.append("easWebClient");
        filePath.append(File.separator);
        filePath.append("deploy");
        filePath.append(File.separator);
        filePath.append("client");
        filePath.append(File.separator);
        filePath.append(FILE_NAME);
        return filePath.toString();
    }

    public static final void addMachineRegisterLoginListener() {
        int maxKey;
        ConfigurationItem SysloginItem;
        XMLConfiguration config = MachineCodeConfigUtil.loadConfigFile();
        ConfigurationItem uiframeItem = config.getConfigItem(UIFRAME_ITEM);
        if (uiframeItem != null && (SysloginItem = uiframeItem.getChild(SYS_LOGIN_ITEM)) != null && (maxKey = MachineCodeConfigUtil.findMachineListener(SysloginItem)) > 0) {
            SysloginItem.setProperty(String.valueOf(++maxKey), MACHINE_LISTENER);
            config.store();
        }
    }

    private static int findMachineListener(ConfigurationItem configItem) {
        Map itemMap = configItem.getProperties();
        int maxKey = 1;
        if (itemMap != null && itemMap.size() > 0) {
            for (String key : itemMap.keySet()) {
                if (MACHINE_LISTENER.equals(itemMap.get(key))) {
                    maxKey = 0;
                    break;
                }
                int keyValue = Integer.parseInt(key.trim());
                if (keyValue <= maxKey) continue;
                maxKey = keyValue;
            }
        }
        return maxKey;
    }

    public static final void storeMachineCodeAuthState(XMLConfiguration config, boolean isEnableAuth) {
        ConfigurationItem configItem = config.getConfigItem("MachineCodeConfig");
        if (configItem == null) {
            configItem = new ConfigurationItem("MachineCodeConfig");
        }
        configItem.setProperty("enableMachineCode", String.valueOf(isEnableAuth));
        config.store();
    }

    public static final boolean getMachineCodeAuthState(XMLConfiguration config) {
        ConfigurationItem configItem = MachineCodeConfigUtil.getConfigItem(config);
        String enableMachineCode = configItem.getProperty("enableMachineCode");
        if (StringUtils.isEmpty((String)enableMachineCode)) {
            return false;
        }
        return Boolean.valueOf(configItem.getProperty("enableMachineCode"));
    }

    private static ConfigurationItem getConfigItem(XMLConfiguration config) {
        ConfigurationItem configItem = config.getConfigItem("MachineCodeConfig");
        if (configItem == null) {
            configItem = new ConfigurationItem("MachineCodeConfig");
            String param = "false";
            try {
                param = ParamManager.getParamValue((Context)ContextUtils.getContextFromSessionNoException(), null, (String)"isMachineRegisterEnabled");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            configItem.setProperty("enableMachineCode", Boolean.valueOf(param).toString());
            config.addConfigItem(configItem);
            config.store();
        }
        return configItem;
    }
}

