/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.usbkey;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.CryptException;
import com.kingdee.eas.base.permission.UsbKeyException;
import com.kingdee.eas.base.security.ISecurityAuthParamManager;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKIServerAndClientExtFactory;
import com.kingdee.eas.base.security.provider.client.IPKIClientExt2Provider;
import com.kingdee.eas.base.security.usbkey.UsbkeyConfigInfo;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class USBKeyInitFactory {
    protected static final Logger logger = Logger.getLogger(USBKeyInitFactory.class);
    private static ISecurityAuthParamManager iSecurityAuthParamManager = null;
    private static UsbkeyConfigInfo usbkeyConfigInfo = null;
    public static String pwd = null;
    private static IPKIClientExt2Provider ipkiClientExt2Provider = null;
    private static USBKeyInitFactory instance = null;

    private USBKeyInitFactory() {
    }

    public static USBKeyInitFactory getInstance() {
        if (instance == null) {
            instance = new USBKeyInitFactory();
        }
        return instance;
    }

    public static IPKIClientExt2Provider getUsbKey() throws UsbKeyException {
        if (ipkiClientExt2Provider == null) {
            ipkiClientExt2Provider = PKIServerAndClientExtFactory.getClientExtProvider();
        }
        return ipkiClientExt2Provider;
    }

    public static IPKIClientExt2Provider getNewUsbKey() throws UsbKeyException {
        ipkiClientExt2Provider = PKIServerAndClientExtFactory.getClientExtProvider();
        return ipkiClientExt2Provider;
    }

    public static UsbkeyConfigInfo getUSBkeyConfigInfo() throws BOSException {
        if (usbkeyConfigInfo == null) {
            usbkeyConfigInfo = iSecurityAuthParamManager.getUsbkeyConfigInfo();
        }
        return usbkeyConfigInfo;
    }

    public static String getUsbKeyNumber(IPKIClientExt2Provider ipkiProvider) throws UsbKeyException, CryptException {
        String usbKeyNumber = null;
        try {
            usbKeyNumber = new String(ipkiProvider.getUserID(), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        logger.info((Object)("USBKeyFactory getUsbKeyNumber:" + usbKeyNumber));
        return usbKeyNumber;
    }

    public static boolean updateCert(IPKIClientExt2Provider clientPK, String userName) {
        byte[] cert = null;
        try {
            cert = clientPK.exportCertificate();
        }
        catch (Exception e) {
            logger.error((Object)"CAIdentity getCert failure");
        }
        if (cert == null) {
            logger.warn((Object)"EASSignHelper exportCertificate-----cert is null");
        } else {
            IPKIServerExtProvider serverProvider = PKIServerAndClientExtFactory.getServerExtProvider();
            serverProvider.cacheSignInfo(userName, cert);
        }
        return true;
    }

    public static String getPwd() {
        return pwd;
    }

    public static void setPwd(String pwd) {
        USBKeyInitFactory.pwd = pwd;
    }

    private static void debugInfo(String debugInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)debugInfo);
        }
    }
}

