/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider.app;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.security.CertificateStatusEnum;
import com.kingdee.eas.base.security.EASCertificateFactory;
import com.kingdee.eas.base.security.EASCertificateInfo;
import com.kingdee.eas.base.security.IEASCertificate;
import com.kingdee.eas.base.security.provider.IPKISignInfoCache;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.log4j.Logger;

public class PKISignInfoCache
extends AbstractBOSObject
implements IPKISignInfoCache {
    private static final Logger logger = Logger.getLogger(PKISignInfoCache.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"PKIS");
    private static PKISignInfoCache cache = null;
    private static byte[] cacheUpdateCert = null;
    private static String cacheUpdateUserName = null;
    private static byte[] cacheQueryCert = null;
    private static String cacheQueryUserName = null;

    private PKISignInfoCache() {
    }

    public static PKISignInfoCache getInstance() {
        if (cache == null) {
            cache = new PKISignInfoCache();
        }
        return cache;
    }

    @Override
    public void cacheSignInfo(String userName, byte[] cert) {
        if (userName != null && cert != null) {
            if (cacheUpdateUserName.equals(userName)) {
                if (!cacheUpdateCert.equals(cert)) {
                    cacheUpdateCert = cert;
                    this.putSignInfo(this.getContext(), userName, cert);
                }
            } else {
                cacheUpdateUserName = userName;
                cacheUpdateCert = cert;
                this.putSignInfo(this.getContext(), userName, cert);
            }
            try {
                logger.info((Object)("cacheSignInfo userCert=" + new String(cert, "utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            logger.info((Object)("cacheSignInfo did nothing userNumber=" + userName + "::userCert=" + cert));
        }
    }

    public void putSignInfo(Context ctx, String userNumber, byte[] cert) {
        logger.info((Object)("PKISignInfoCache putSignInfo: userNumber=" + userNumber));
        try {
            IEASCertificate iEASCertificate = EASCertificateFactory.getLocalInstance((Context)ctx);
            EASCertificateInfo easCertificateInfo = null;
            try {
                easCertificateInfo = (EASCertificateInfo)iEASCertificate.getValue("select * where user.number='" + userNumber + "'");
            }
            catch (ObjectNotFoundException on) {
                logger.error((Object)("putSignInfo ObjectNotFoundException" + on.getMessage()));
                easCertificateInfo = null;
            }
            if (easCertificateInfo == null) {
                EASCertificateInfo newEASCertificateInfo = this.createNewEASCertificateInfo(ctx, userNumber, cert);
                iEASCertificate.addnew((CoreBaseInfo)newEASCertificateInfo);
                logger.info((Object)"PKISignInfoCache putSignInfo: create new EASCertificateInfo finish.");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    private EASCertificateInfo createNewEASCertificateInfo(Context ctx, String userNumber, byte[] cert) throws BOSException, EASBizException {
        logger.info((Object)"PKISignInfoCache putSignInfo: create new EASCertificateInfo start.");
        EASCertificateInfo newEASCertificateInfo = new EASCertificateInfo();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        newEASCertificateInfo.setUser(iUser.getUser(userNumber));
        newEASCertificateInfo.setCertificate(cert);
        newEASCertificateInfo.setValidDate(new Date());
        newEASCertificateInfo.setInvalidDate(new Date());
        newEASCertificateInfo.setStatus(CertificateStatusEnum.VALID);
        newEASCertificateInfo.setNumber("fake number");
        return newEASCertificateInfo;
    }

    @Override
    public byte[] getCert(Context ctx, String userNumber) {
        if (cacheQueryUserName != null && cacheQueryUserName.equals(userNumber) && cacheQueryCert != null) {
            logger.debug((Object)("PKISignInfoCache getcacheQueryCert: userNumber=" + userNumber + " and cacheQueryCert" + cacheQueryCert));
            return cacheQueryCert;
        }
        logger.info((Object)("PKISignInfoCache getCert: userNumber=" + userNumber));
        cacheQueryCert = this.getCertForByte(userNumber, ctx);
        cacheQueryUserName = userNumber;
        return cacheQueryCert;
    }

    public byte[] getCertForByte(String userNumber, Context ctx) {
        IEASCertificate certificate = null;
        byte[] cert = null;
        try {
            certificate = EASCertificateFactory.getLocalInstance((Context)ctx);
            String oql = "select * where user.number='" + userNumber + "'";
            EASCertificateInfo info = certificate.getEASCertificateInfo(oql);
            cert = info.getCertificate();
            if (cert == null) {
                logger.error((Object)"get Certificate is null");
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get IEASCertificate failure", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"get IEASCertificate failure", (Throwable)e);
        }
        return cert;
    }

    @Override
    public void clearCache() {
        cacheQueryCert = null;
        cacheQueryUserName = null;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }
}

