/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.security.provider.app.imp;

import com.itrus.pki.rsa.iTrusRSAAPI;
import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.service.helper.UsbKey4LoginInfo;
import com.kingdee.eas.base.security.SecurityAuthParamManagerFactory;
import com.kingdee.eas.base.security.provider.IPKIServerExtProvider;
import com.kingdee.eas.base.security.provider.PKIServerAndClientExtFactory;
import com.kingdee.eas.base.security.provider.app.PKISignInfoCache;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Base64Encoder;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class ITrusServerProvider
extends AbstractBOSObject
implements IPKIServerExtProvider {
    private static Logger logger = Logger.getLogger(ITrusServerProvider.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"SERVERPROVIDE");
    private iTrusRSAAPI itrus = null;
    private boolean isGetCertFromRAServe = false;

    public ITrusServerProvider() {
        this.registerInterface(IPKIServerExtProvider.class, this);
        this.init();
    }

    public ITrusServerProvider(Context ctx) {
        super(ctx);
        this.registerInterface(IPKIServerExtProvider.class, this);
    }

    public void init() {
        String easHome = System.getProperty("EAS_HOME");
        if (easHome == null || "".equals(easHome)) {
            logger.error((Object)"[CA configPath] EAS_HOME property is null.");
        }
        String configPath = easHome + "/server/properties";
        logger.info((Object)("[CA configPath] configPath is:" + configPath));
        try {
            Constructor con = iTrusRSAAPI.class.getConstructor(String.class);
            this.itrus = (iTrusRSAAPI)con.newInstance(configPath);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)"iTrusRSAAPI newInstance() error:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"iTrusRSAAPI newInstance(configPath) error:", (Throwable)e);
        }
    }

    @Override
    public byte[] exportCertificate(byte[] userID) throws Exception {
        try {
            Method method = this.itrus.getClass().getDeclaredMethod("exportCertificate", String.class);
            return (byte[])method.invoke((Object)this.itrus, new String(userID, "UTF-8"));
        }
        catch (NoSuchMethodException e) {
            logger.info((Object)"exportCertificate error:", (Throwable)e);
            Method method = this.itrus.getClass().getDeclaredMethod("exportCertificate", byte[].class);
            return (byte[])method.invoke((Object)this.itrus, new Object[]{userID});
        }
    }

    @Override
    public byte[] MessageDecrypt(String pfxFilePath, String password, String keyAlias, byte[] encryptBuf) {
        return this.itrus.MessageDecrypt(pfxFilePath, password, keyAlias, encryptBuf);
    }

    @Override
    public byte[] MessageEncrypt(X509Certificate encryptCert, byte[] sourceMsg) {
        return this.itrus.MessageEncrypt(encryptCert, sourceMsg);
    }

    @Override
    public byte[] MessageEncrypt(Certificate encryptCert, byte[] sourceMsg) {
        return this.itrus.MessageEncrypt((X509Certificate)encryptCert, sourceMsg);
    }

    @Override
    public int verifyUser(byte[] userCert) {
        try {
            if (this.itrus == null) {
                this.init();
            }
            if (this.itrus == null) {
                throw new NullPointerException("\u9a8c\u8bc1\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u5931\u8d25\uff0c\u83b7\u53d6\u5230\u7684itrus\u5b9e\u4f8b\u4e3a\u7a7a");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(userCert);
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "TopSM");
            if (bais.available() > 0) {
                X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(bais);
                logger.error((Object)("serialNo:" + (x509Cert != null ? x509Cert.getSerialNumber() : "NULL")));
                return this.itrus.verifyCert(x509Cert);
            }
        }
        catch (CertificateException e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        catch (NoSuchProviderException e) {
            logger.error((Object)e.getMessage(), e.getCause());
        }
        return -1;
    }

    @Override
    public int verify(byte[] plaintext, byte[] signature, Certificate cert) throws Exception {
        logger.info((Object)"ITrusServerProvider verfiy statrt!");
        byte[] signInfo = Base64Encoder.base64ToByteArray((String)new String(signature));
        int rst = this.itrus.verify(plaintext, signInfo, (X509Certificate)cert);
        logger.info((Object)("ITrusServerProvider verfiy rst=" + rst));
        if (rst == 201) {
            logger.info((Object)"ITrusServerProvider verfiy rst 201 to 0.");
            return 0;
        }
        return rst;
    }

    @Override
    public int verify(Context ctx, byte[] plaintext, byte[] signature, String userNumber) {
        if (ctx == null) {
            ctx = this.getContext();
        }
        try {
            this.isGetCertFromRAServe = SecurityAuthParamManagerFactory.getLocalInstance((Context)ctx).isGetCertFromRAServe();
        }
        catch (BOSException e1) {
            logger.error((Object)"verify signature error(get parameter isGetCertFromRAServe):", (Throwable)e1);
        }
        if (this.isGetCertFromRAServe) {
            String serialNumber = "";
            try {
                UsbKey4LoginInfo usbKeyLoginInfo = (UsbKey4LoginInfo)ctx.get((Object)"USBKEY_LOGIN");
                if (usbKeyLoginInfo != null && usbKeyLoginInfo.getUsbKeyNo() != null) {
                    serialNumber = usbKeyLoginInfo.getUsbKeyNo();
                } else {
                    String sql = "select FSERIALNO from t_pm_usbkey where fid=(select FUSBKEYID from t_pm_usbkeyusermap where fuserid=(select FID from t_pm_user where FNumber=?))";
                    Object[] params = new Object[]{userNumber};
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                    if (rowSet.next()) {
                        serialNumber = rowSet.getString(1);
                    }
                }
                return this.verify(plaintext, signature, serialNumber, null, ctx);
            }
            catch (Exception e) {
                logger.error((Object)"verify signature error(cert from RA Server):", (Throwable)e);
                return -1;
            }
        }
        byte[] cert = PKISignInfoCache.getInstance().getCert(ctx, userNumber);
        if (cert != null) {
            try {
                Certificate newCert = PKIServerAndClientExtFactory.getServerExtProvider(ctx).transCert(cert);
                return this.verify(plaintext, signature, newCert);
            }
            catch (Exception e) {
                logger.error((Object)"transCert or verify error.", (Throwable)e);
            }
        } else {
            logger.error((Object)("get cert from db, and cert is null, please check it, userNumber: " + userNumber));
        }
        return -1;
    }

    @Override
    public int verify(byte[] plaintext, byte[] signature, String serialNumber, String userNumber, Context ctx) throws Exception {
        if ((serialNumber == null || serialNumber.length() <= 0) && userNumber != null) {
            String sql = "select FSERIALNO from t_pm_usbkey where fid=(select FUSBKEYID from t_pm_usbkeyusermap where fuserid=(select FID from t_pm_user where FNumber=?))";
            Object[] params = new Object[]{userNumber};
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rowSet.next()) {
                serialNumber = rowSet.getString(1);
            }
        } else {
            logger.error((Object)"oh no, serialNumber and userNumber is null.");
        }
        logger.warn((Object)"ITrusServerProvider verfiy statrt get cert from RA Server!");
        byte[] signInfo = Base64Encoder.base64ToByteArray((String)new String(signature));
        int rst = this.itrus.verify(serialNumber, plaintext, signInfo);
        logger.info((Object)("ITrusServerProvider verfiy rst=" + rst));
        if (rst == 201) {
            logger.info((Object)"ITrusServerProvider verfiy rst 201 to 0.");
            return 0;
        }
        return rst;
    }

    @Override
    public int verifyCert(Certificate userCert) {
        return 0;
    }

    @Override
    public Certificate transCert(byte[] cert) {
        return this.itrus.getX509CertificateFormBytes(cert);
    }

    @Override
    public void cacheSignInfo(String userNumber, byte[] cert) {
        PKISignInfoCache.getInstance().cacheSignInfo(userNumber, cert);
    }

    private void debugInfo(String msgInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)msgInfo);
        }
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }
}

