/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.ssc.BillImageMapCollection;
import com.kingdee.eas.base.ssc.BillImageMapFactory;
import com.kingdee.eas.base.ssc.BillImageMapInfo;
import com.kingdee.eas.base.ssc.IBillImageMap;
import com.kingdee.eas.base.ssc.ImageStateEnum;
import com.kingdee.eas.base.ssc.app.AbstractBillImageFacadeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class BillImageFacadeControllerBean
extends AbstractBillImageFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.BillImageFacadeControllerBean");

    @Override
    protected String _genImageNumber(Context ctx, String bosType, String billID) throws BOSException {
        String imageNumber = null;
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        try {
            billImageMapInfo = new BillImageMapInfo();
            billImageMapInfo.setBosType(bosType);
            billImageMapInfo.setBillID(billID);
            imageNumber = this.generateImageNumber(ctx, bosType, billID);
            billImageMapInfo.setImageNumber(imageNumber);
            billImageMapInfo.setImageState(ImageStateEnum.NO_IMAGE);
            billImageMap.addnew((CoreBaseInfo)billImageMapInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return imageNumber;
    }

    private String generateImageNumber(Context ctx, String bosType, String billID) throws BOSException {
        String imageNumber = null;
        String imagePrefix = "KD";
        String billTypeCode = null;
        String billNumber = null;
        billTypeCode = "4A44F49F".equals(bosType) ? "BA" : ("C57003BC".equals(bosType) ? "TA" : ("30BD2798".equals(bosType) ? "DA" : ("48DA3A71".equals(bosType) ? "AP" : ("D001019A".equals(bosType) ? "PR" : ("40284E81".equals(bosType) ? "PB" : ("FC910EF3".equals(bosType) ? "AR" : ("FA44FD5B".equals(bosType) ? "RB" : "")))))));
        BOSObjectType type = BOSObjectType.create((String)bosType);
        try {
            IObjectValue billValue = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)new ObjectUuidPK(billID));
            if (billValue != null && billValue.get("number") != null) {
                billNumber = billValue.get("number").toString();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        imageNumber = imagePrefix + billTypeCode + billNumber;
        return imageNumber;
    }

    @Override
    protected String _getImageNumber(Context ctx, String bosType, String billID) throws BOSException {
        String imageNumber = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            imageNumber = this._genImageNumber(ctx, bosType, billID);
        } else {
            billImageMapInfo = billImageMapCollection.get(0);
            imageNumber = billImageMapInfo.getImageNumber();
        }
        return imageNumber;
    }

    @Override
    protected boolean _updateImageState(Context ctx, String bosType, String billID, ImageStateEnum imageState) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        billImageMapInfo.setImageState(imageState);
        try {
            billImageMap.update((IObjectPK)new ObjectUuidPK(billImageMapInfo.getId()), (CoreBaseInfo)billImageMapInfo);
            return true;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ImageStateEnum _getImageState(Context ctx, String bosType, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        return billImageMapInfo.getImageState();
    }

    @Override
    protected String _getImageURL(Context ctx, String bosType, String billID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        return billImageMapInfo.getImageURL();
    }

    @Override
    protected String _updateImageURL(Context ctx, String bosType, String billID) throws BOSException {
        String imageURL = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = "bosType: " + bosType + ", billID: " + billID + " not exist.";
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        billImageMapInfo = billImageMapCollection.get(0);
        String string = billImageMapInfo.getImageNumber();
        return imageURL;
    }
}

