/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.ssc.BussAttrFunctionFactory;
import com.kingdee.eas.base.ssc.BussAttrFunctionInfo;
import com.kingdee.eas.base.ssc.BussFunDecisionFactory;
import com.kingdee.eas.base.ssc.BussFunDecisionInfo;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.BussinessFunctionScope;
import com.kingdee.eas.base.ssc.DecisionItemInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.app.AbstractBussFunDecisionFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BussFunDecisionFacadeControllerBean
extends AbstractBussFunDecisionFacadeControllerBean {
    private static final long serialVersionUID = 7529415551134254978L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.BussFunDecisionFacadeControllerBean");

    @Override
    protected List _assignedDecision(Context ctx, String functionId, String bussAttrId) throws BOSException, EASBizException {
        StringBuffer assignedSQL = new StringBuffer();
        assignedSQL.append("select di.fid, di.fname_l2 name,bfd.fisDefault,di.fvalue").append(" from T_SSC_BussAttrFunction bf left join  T_SSC_BussFunDecision bfd on bf.fid=bfd.FFunctionIdID").append(" left join T_SSC_DecisionItem di on bfd.FDecisionIdID=di.fid").append(" where bf.fid= ? and (bf.FScope=0 or  bfd.FBussAttridID= ? ) and di.fid is not null").append(" and  bfd.fshareCenterId= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)assignedSQL.toString(), (Object[])new Object[]{functionId, bussAttrId, ShareCenterUtils.getShareCenterIdByCtx(ctx)});
        ArrayList ret = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, String> m = new HashMap<String, String>();
                String id = rs.getString("fid");
                String name = rs.getString("name");
                int isDefault = rs.getInt("fisDefault");
                int value = rs.getInt("fvalue");
                m.put("id", id);
                m.put("name", name);
                m.put("pId", "0");
                m.put("value", String.valueOf(value));
                if (isDefault == 1) {
                    m.put("checked", "true");
                }
                m.put("isDefault", "" + isDefault);
                ret.add(m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    protected List _canAssignDecision(Context ctx, String functionId, String bussAttrId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(500);
        sql.append("select t.fid, t.fname_l2 name ").append(" from T_SSC_DecisionItem t").append(" where not exists (").append("\tselect 1 ").append("\tfrom T_SSC_BussAttrFunction bf left join  T_SSC_BussFunDecision bfd on bf.fid=bfd.FFunctionIdID").append("\t\tleft join T_SSC_DecisionItem di on bfd.FDecisionIdID=di.fid").append("\twhere bf.fid= ? and  (bf.FScope=0 or bfd.FBussAttridID= ?) and di.fid is not null and t.fid=di.fid ").append(" and  bfd.fshareCenterId= ? )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{functionId, bussAttrId, ShareCenterUtils.getShareCenterIdByCtx(ctx)});
        ArrayList ret = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, String> m = new HashMap<String, String>();
                String id = rs.getString("fid");
                String name = rs.getString("name");
                m.put("id", id);
                m.put("name", name);
                m.put("pId", "0");
                ret.add(m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    protected Map _rescope(Context ctx, String bussAttrId, String functionId, String decisionIds) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)functionId)) {
            return null;
        }
        BussAttrFunctionInfo srcFun = BussAttrFunctionFactory.getLocalInstance(ctx).getBussAttrFunctionInfo((IObjectPK)new ObjectStringPK(functionId));
        boolean isGlobleFun = false;
        if (srcFun == null) {
            return null;
        }
        if (srcFun.getScope() == BussinessFunctionScope.Globle) {
            isGlobleFun = true;
        }
        String[] decIds = decisionIds.split(",");
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("functionId", (Object)functionId);
        if (!isGlobleFun) {
            if (StringUtils.isEmpty((String)bussAttrId)) {
                return null;
            }
            filter.appendFilterItem("bussAttrid", (Object)bussAttrId);
        }
        filter.appendFilterItem("shareCenterId", (Object)ShareCenterUtils.getShareCenterIdByCtx(ctx));
        BussFunDecisionFactory.getLocalInstance(ctx).delete(filter);
        if (!StringUtils.isEmpty((String)decisionIds)) {
            CoreBaseCollection colls = this._genBussFunDecColls(ctx, bussAttrId, functionId, decIds);
            BussFunDecisionFactory.getLocalInstance(ctx).addnewBatchData(colls);
        }
        return null;
    }

    private CoreBaseCollection _genBussFunDecColls(Context ctx, String bussAttrId, String functionId, String[] decIds) throws SSCException {
        CoreBaseCollection colls = new CoreBaseCollection();
        BussinessAttributeInfo busInfo = new BussinessAttributeInfo();
        if (!StringUtils.isEmpty((String)bussAttrId)) {
            busInfo.setId(BOSUuid.read((String)bussAttrId));
        }
        BussAttrFunctionInfo funInfo = new BussAttrFunctionInfo();
        funInfo.setId(BOSUuid.read((String)functionId));
        for (int i = 0; i < decIds.length; ++i) {
            String decId = decIds[i].split("_")[0];
            BussFunDecisionInfo info = new BussFunDecisionInfo();
            DecisionItemInfo decInfo = new DecisionItemInfo();
            decInfo.setId(BOSUuid.read((String)decId));
            info.setDecisionId(decInfo);
            info.setBussAttrid(busInfo);
            info.setFunctionId(funInfo);
            try {
                info.setShareCenterId(ShareCenterUtils.getShareCenterIdByCtx(ctx));
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            info.setIsDefault("1".equals(decIds[i].split("_")[1]));
            colls.add((CoreBaseInfo)info);
        }
        return colls;
    }

    @Override
    protected List _assignedDecisionByFunNo(Context ctx, String funNo, String bussAttrId) throws BOSException, EASBizException {
        StringBuffer assignedSQL = new StringBuffer();
        assignedSQL.append("select di.fid, di.fname_l2 name,bfd.fisDefault, di.fvalue ").append(" from T_SSC_BussAttrFunction bf left join  T_SSC_BussFunDecision bfd on bf.fid=bfd.FFunctionIdID").append(" left join T_SSC_DecisionItem di on bfd.FDecisionIdID=di.fid").append(" where bf.fnumber= ? and  bfd.FBussAttridID= ? and di.fid is not null and bfd.fshareCenterId= ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)assignedSQL.toString(), (Object[])new Object[]{funNo, bussAttrId, ShareCenterUtils.getShareCenterIdByCtx(ctx)});
        ArrayList ret = new ArrayList();
        try {
            while (rs.next()) {
                HashMap<String, String> m = new HashMap<String, String>();
                String id = rs.getString("fid");
                String name = rs.getString("name");
                int value = rs.getInt("fvalue");
                int isDefault = rs.getInt("fisDefault");
                m.put("id", id);
                m.put("name", name);
                m.put("value", String.valueOf(value));
                m.put("pId", "0");
                if (isDefault == 1) {
                    m.put("checked", "true");
                }
                m.put("isDefault", "" + isDefault);
                ret.add(m);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    @Override
    protected boolean _updateDefault(Context ctx, String bussAttrId, String functionId, String decisionId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bussAttrId) || StringUtils.isEmpty((String)functionId) || StringUtils.isEmpty((String)decisionId)) {
            return false;
        }
        String unDefSQL = "update T_SSC_BussFunDecision set fisDefault=0 where FBussAttridID='" + bussAttrId + "' and FFunctionIdID='" + functionId + "' and fshareCenterId='" + ShareCenterUtils.getShareCenterIdByCtx(ctx) + "'";
        DbUtil.execute((Context)ctx, (String)unDefSQL);
        String defRowSQL = "select fid from T_SSC_BussFunDecision where FBussAttridID='" + bussAttrId + "' and FFunctionIdID='" + functionId + "' and FDecisionIdID='" + decisionId + "' and fshareCenterId='" + ShareCenterUtils.getShareCenterIdByCtx(ctx) + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)defRowSQL);
        try {
            String fid = null;
            if (rs.next()) {
                fid = rs.getString("fid");
                String setDefSql = "update T_SSC_BussFunDecision set fisDefault=1 where FBussAttridID='" + bussAttrId + "' and FFunctionIdID='" + functionId + "' and FDecisionIdID='" + decisionId + "' and fshareCenterId='" + ShareCenterUtils.getShareCenterIdByCtx(ctx) + "'";
                DbUtil.execute((Context)ctx, (String)setDefSql);
            } else {
                BussinessAttributeInfo busInfo = new BussinessAttributeInfo();
                busInfo.setId(BOSUuid.read((String)bussAttrId));
                BussAttrFunctionInfo funInfo = new BussAttrFunctionInfo();
                funInfo.setId(BOSUuid.read((String)functionId));
                BussFunDecisionInfo info = new BussFunDecisionInfo();
                DecisionItemInfo decInfo = new DecisionItemInfo();
                decInfo.setId(BOSUuid.read((String)decisionId));
                info.setDecisionId(decInfo);
                info.setBussAttrid(busInfo);
                info.setFunctionId(funInfo);
                info.setIsDefault(true);
                info.setShareCenterId(ShareCenterUtils.getShareCenterIdByCtx(ctx));
                BussFunDecisionFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

