/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.ssc.CheckDimensionSourceEnum;
import com.kingdee.eas.base.ssc.CheckScheduleCollection;
import com.kingdee.eas.base.ssc.CheckScheduleFactory;
import com.kingdee.eas.base.ssc.CheckScheduleInfo;
import com.kingdee.eas.base.ssc.CheckSchemeInfo;
import com.kingdee.eas.base.ssc.SSCException;
import com.kingdee.eas.base.ssc.SampleLibraryCollection;
import com.kingdee.eas.base.ssc.SampleLibraryFactory;
import com.kingdee.eas.base.ssc.app.AbstractCheckSchemeControllerBean;
import com.kingdee.eas.base.ssc.app.CheckSchemeTimeType;
import com.kingdee.eas.base.ssc.app.checkscheme.CheckDimensionCollection;
import com.kingdee.eas.base.ssc.app.checkscheme.CheckDimensionInfo;
import com.kingdee.eas.base.ssc.tool.ShareCenterUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.NumericExceptionSubItem;
import org.apache.log4j.Logger;

public class CheckSchemeControllerBean
extends AbstractCheckSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CheckSchemeControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String modelID = pk.toString();
        EntityViewInfo SampleLibraryview = new EntityViewInfo();
        FilterInfo Samplefilter = new FilterInfo();
        Samplefilter.getFilterItems().add(new FilterItemInfo("checkScheme.id", (Object)modelID));
        SampleLibraryview.setFilter(Samplefilter);
        SampleLibraryCollection SampleLibraryCollect = SampleLibraryFactory.getLocalInstance(ctx).getSampleLibraryCollection(SampleLibraryview);
        if (SampleLibraryCollect.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("001", "\u5df2\u751f\u6210\u6837\u672c\u5e93\u7684\u65b9\u6848\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean flag = mutexService.requestObjIDForUpdate(modelID, ctx.getUserName());
        if (!flag) {
            throw new EASBizException(new NumericExceptionSubItem("001", "\u65b9\u6848\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u4f7f\u7528,\u4e0d\u80fd\u5220\u9664\uff01"));
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        CheckScheduleInfo ckScheduleInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkScheme.id", (Object)modelID));
        view.setFilter(filter);
        CheckScheduleCollection checkScheduleCollection = CheckScheduleFactory.getLocalInstance(ctx).getCheckScheduleCollection(view);
        if (checkScheduleCollection.size() > 0 && (ckScheduleInfo = checkScheduleCollection.get(0)) != null) {
            CheckScheduleFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(ckScheduleInfo.getId()));
            if (ckScheduleInfo.getJobDefID() != null) {
                service.removeJobProcessDef(ckScheduleInfo.getJobDefID());
            }
        }
        super._delete(ctx, pk);
        mutexService.releaseObjIDForUpdate(modelID);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckSchemeInfo dataBase = this.setCheckSchemeInfo(ctx, (CheckSchemeInfo)model);
        dataBase.setShareCenterId(ShareCenterUtils.getShareCenterIdByCtx(ctx));
        if (!CheckSchemeTimeType.between.equals((Object)dataBase.getCheckSchemeTimeType())) {
            dataBase.setBeginCheckRangeTime(null);
            dataBase.setEndCheckRangeTime(null);
        }
        this._checkNameDup(ctx, (IObjectValue)dataBase);
        this._checkNumberDup(ctx, (IObjectValue)dataBase);
        return super._submit(ctx, (IObjectValue)dataBase);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckSchemeInfo dataBase = this.setCheckSchemeInfo(ctx, (CheckSchemeInfo)model);
        dataBase.setShareCenterId(ShareCenterUtils.getShareCenterIdByCtx(ctx));
        if (!CheckSchemeTimeType.between.equals((Object)dataBase.getCheckSchemeTimeType())) {
            dataBase.setBeginCheckRangeTime(null);
            dataBase.setEndCheckRangeTime(null);
        }
        this._checkNameDup(ctx, (IObjectValue)dataBase);
        this._checkNumberDup(ctx, (IObjectValue)dataBase);
        try {
            logger.error((Object)("CheckSchemeControllerBean&&&&save:" + JSONUtils.convertObjectToJson((Context)ctx, (Object)dataBase)));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return super._save(ctx, (IObjectValue)dataBase);
    }

    private CheckSchemeInfo setCheckSchemeInfo(Context ctx, CheckSchemeInfo model) throws BOSException, SSCException {
        model.setShareCenterId(ShareCenterUtils.getShareCenterIdByCtx(ctx));
        if (!CheckSchemeTimeType.between.equals((Object)model.getCheckSchemeTimeType())) {
            model.setBeginCheckRangeTime(null);
            model.setEndCheckRangeTime(null);
        }
        CheckDimensionCollection checkDimension = model.getCheckDimension();
        for (int i = 0; i < checkDimension.size(); ++i) {
            CheckDimensionInfo checkDimensionInfo = checkDimension.get(i);
            if ("0".equals(checkDimensionInfo.getProperty())) {
                checkDimensionInfo.setPropertyName("\u6309\u5355\u636e\u603b\u6570\u62bd\u6837");
                checkDimensionInfo.setPropertySource(CheckDimensionSourceEnum.preparedValue);
                continue;
            }
            if (!"1".equals(checkDimensionInfo.getProperty())) continue;
            checkDimensionInfo.setPropertyName("\u6309\u7ec4\u7ec7\u5355\u636e\u6570\u62bd\u6837");
            checkDimensionInfo.setPropertySource(CheckDimensionSourceEnum.preparedValue);
        }
        return model;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckSchemeInfo checkSchemeInfo = (CheckSchemeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("name", (Object)checkSchemeInfo.getName(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("checkType", (Object)checkSchemeInfo.getCheckType().getValue(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (checkSchemeInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)checkSchemeInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (checkSchemeInfo.getShareCenterId() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)checkSchemeInfo.getShareCenterId());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String name = this._getPropertyAlias(ctx, checkSchemeInfo, "name") + " : " + checkSchemeInfo.getName();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{name});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CheckSchemeInfo checkSchemeInfo = (CheckSchemeInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)checkSchemeInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("checkType", (Object)checkSchemeInfo.getCheckType().getValue(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (checkSchemeInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)checkSchemeInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (checkSchemeInfo.getShareCenterId() != null) {
            filterItem = new FilterItemInfo("shareCenterId", (Object)checkSchemeInfo.getShareCenterId());
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, checkSchemeInfo, "number") + " : " + checkSchemeInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }
}

