/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.ssc.CommandQueueFactory;
import com.kingdee.eas.base.ssc.CommandQueueInfo;
import com.kingdee.eas.base.ssc.CommandQueueState;
import com.kingdee.eas.base.ssc.ICommandQueue;
import com.kingdee.eas.base.ssc.app.AbstractCommandQueueFacadeControllerBean;
import com.kingdee.eas.base.ssc.tool.H;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CommandQueueFacadeControllerBean
extends AbstractCommandQueueFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.ssc.app.CommandQueueFacadeControllerBean");

    @Override
    protected Map _sendCommand(Context ctx, String command, String params) throws BOSException, EASBizException {
        Calendar end = Calendar.getInstance();
        end.add(13, 10);
        String id = this.addCommand(ctx, command, params);
        this.clearCommand(ctx);
        ICommandQueue icq = CommandQueueFactory.getLocalInstance(ctx);
        while (!end.before(Calendar.getInstance())) {
            if (icq.exists("where commandState = 'DONE' and id = '" + id + "'")) {
                CommandQueueInfo info = icq.getCommandQueueInfo(H.PK(id));
                String result = info.getResult();
                HashMap ret = new HashMap();
                if (H.isEmpty(result)) {
                    ret.put("success", true);
                    ret.put("message", "");
                    HashMap<String, String> data = new HashMap<String, String>();
                    data.put("type", "TEXT");
                    data.put("content", "\u64cd\u4f5c\u5b8c\u6210!");
                    ret.put("data", data);
                } else {
                    ret = JSONUtils.convertJsonToObject((Context)ctx, (String)result);
                }
                return ret;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }
        String msg = "\u64cd\u4f5c\u8d85\u65f6!";
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("success", false);
        ret.put("message", msg);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("type", "TEXT");
        data.put("content", msg);
        ret.put("data", data);
        this.writeResult(ctx, id, false, msg);
        return ret;
    }

    @Override
    protected String _addCommand(Context ctx, String command, String params) throws BOSException, EASBizException {
        ICommandQueue icq = CommandQueueFactory.getLocalInstance(ctx);
        CommandQueueInfo info = new CommandQueueInfo();
        Timestamp timeStamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
        info.setCreateTime(timeStamp);
        info.setUserId(ctx.getCaller().toString());
        info.setCommand(command);
        info.setParams(params);
        info.setCommandState(CommandQueueState.Ready);
        return icq.addnew(info).toString();
    }

    @Override
    protected boolean _clearCommand(Context ctx) throws BOSException, EASBizException {
        ICommandQueue icq = CommandQueueFactory.getLocalInstance(ctx);
        String sql = "update T_SSC_CommandQueue set FCommandState = ? where FCommandState = ? and FCreateTime < ?";
        Object[] params = new Object[3];
        params[0] = "DISABLED";
        params[1] = "DONE";
        Calendar c = Calendar.getInstance();
        c.add(6, -1);
        params[2] = new Timestamp(c.getTimeInMillis());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        icq.delete("where commandState = 'DISABLED'");
        return true;
    }

    @Override
    protected CommandQueueInfo _getCommand(Context ctx, String userId) throws BOSException, EASBizException {
        ICommandQueue icq = CommandQueueFactory.getLocalInstance(ctx);
        String sql = "select fid from T_SSC_CommandQueue where FUserId = ? and FCommandState = ? order by FCreateTime";
        Object[] params = new Object[]{userId, "READY"};
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (rowSet.next()) {
                String id = rowSet.getString(1);
                CommandQueueInfo info = icq.getCommandQueueInfo(H.PK(id));
                return info;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return null;
    }

    @Override
    protected boolean _writeResult(Context ctx, String commandId, boolean isSuccess, String msg) throws BOSException, EASBizException {
        return this._writeResult(ctx, commandId, isSuccess, msg, "TEXT");
    }

    @Override
    protected boolean _writeResult(Context ctx, String commandId, boolean isSuccess, String msg, String type) throws BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", isSuccess);
        result.put("message", msg);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("type", type);
        data.put("content", msg);
        result.put("data", data);
        ICommandQueue icq = CommandQueueFactory.getLocalInstance(ctx);
        try {
            CommandQueueInfo info = icq.getCommandQueueInfo(H.PK(commandId));
            info.setResult(JSONUtils.convertObjectToJson((Context)ctx, result));
            info.setCommandState(CommandQueueState.Done);
            icq.update(H.PK(info.getId()), info);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
        return true;
    }

    public class ReturnType {
        public static final String TEXT = "TEXT";
        public static final String URL = "URL";
        public static final String DATE = "DATE";
        public static final String SELECTS = "SELECTS";
        public static final String RICHTEXT = "RICHTEXT";
        public static final String COMFIRM = "COMFIRM";
    }
}

